/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.StackPane;

public class RadioButtonSkin
extends LabeledSkinBase<RadioButton, ButtonBehavior<RadioButton>> {
    private StackPane radio = RadioButtonSkin.createRadio();

    public RadioButtonSkin(RadioButton radioButton) {
        super(radioButton, new ButtonBehavior<RadioButton>(radioButton));
        this.updateChildren();
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.getChildren().add(this.radio);
        }
    }

    private static StackPane createRadio() {
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().setAll((String[])new String[]{"radio"});
        stackPane.setSnapToPixel(false);
        StackPane stackPane2 = new StackPane();
        stackPane2.getStyleClass().setAll((String[])new String[]{"dot"});
        stackPane.getChildren().clear();
        stackPane.getChildren().addAll((Node[])new Node[]{stackPane2});
        return stackPane;
    }

    @Override
    protected double computePrefWidth(double d) {
        return super.computePrefWidth(d) + this.snapSize(this.radio.prefWidth(-1.0));
    }

    @Override
    protected double computePrefHeight(double d) {
        return Math.max(this.snapSize(super.computePrefHeight(d - this.radio.prefWidth(-1.0))), this.getInsets().getTop() + this.radio.prefHeight(-1.0) + this.getInsets().getBottom());
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double d = this.getWidth() - insets.getLeft() - insets.getRight();
        double d2 = this.getHeight() - insets.getTop() - insets.getBottom();
        double d3 = this.radio.prefWidth(-1.0);
        double d4 = this.radio.prefHeight(-1.0);
        double d5 = Math.min(this.prefWidth(-1.0) - d3, d - this.snapSize(d3));
        double d6 = Math.min(this.prefHeight(d5), d2);
        double d7 = Math.max(d4, d6);
        double d8 = Utils.computeXOffset(d, d5 + d3, ((RadioButton)this.getSkinnable()).getAlignment().getHpos()) + insets.getLeft();
        double d9 = Utils.computeYOffset(d2, d7, ((RadioButton)this.getSkinnable()).getAlignment().getVpos()) + insets.getTop();
        this.layoutLabelInArea(d8 + d3, d9, d5, d7, Pos.CENTER_LEFT);
        this.radio.resize(this.snapSize(d3), this.snapSize(d4));
        this.positionInArea(this.radio, d8, d9, d3, d7, this.getBaselineOffset(), HPos.CENTER, VPos.CENTER);
    }
}

