/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import java.util.WeakHashMap;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class TableCellBehavior
extends CellBehaviorBase<TableCell> {
    private static final WeakHashMap<TableView, TablePosition> map = new WeakHashMap();
    private boolean latePress = false;
    private final boolean isEmbedded = PlatformUtil.isEmbedded();
    private boolean wasSelected = false;

    static TablePosition getAnchor(TableView tableView) {
        TableView.TableViewFocusModel tableViewFocusModel = tableView.getFocusModel();
        if (tableViewFocusModel == null) {
            return null;
        }
        return TableCellBehavior.hasAnchor(tableView) ? map.get(tableView) : tableViewFocusModel.getFocusedCell();
    }

    static void setAnchor(TableView tableView, TablePosition tablePosition) {
        if (tableView != null && tablePosition == null) {
            map.remove(tableView);
        } else {
            map.put(tableView, tablePosition);
        }
    }

    static boolean hasAnchor(TableView tableView) {
        return map.containsKey(tableView) && map.get(tableView) != null;
    }

    public TableCellBehavior(TableCell tableCell) {
        super(tableCell);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = ((TableCell)this.getControl()).isSelected();
        if (((TableCell)this.getControl()).isSelected()) {
            this.latePress = true;
            return;
        }
        this.doSelect(mouseEvent);
        if (this.isEmbedded && bl) {
            this.wasSelected = ((TableCell)this.getControl()).isSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent);
        }
        this.wasSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.latePress = false;
        if (this.isEmbedded && !this.wasSelected && ((TableCell)this.getControl()).isSelected()) {
            ((TableCell)this.getControl()).getTableView().getSelectionModel().clearSelection(((TableCell)this.getControl()).getIndex());
        }
    }

    private void doSelect(MouseEvent mouseEvent) {
        MouseButton mouseButton;
        TableCell tableCell = (TableCell)this.getControl();
        if (!tableCell.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        TableView tableView = tableCell.getTableView();
        if (tableView == null) {
            return;
        }
        ObservableList observableList = tableView.getItems();
        if (observableList == null || tableCell.getIndex() >= observableList.size()) {
            return;
        }
        TableView.TableViewSelectionModel tableViewSelectionModel = tableView.getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        boolean bl = !tableViewSelectionModel.isCellSelectionEnabled() ? tableCell.getTableRow().isSelected() : tableCell.isSelected();
        int n = tableCell.getIndex();
        int n2 = this.getColumn();
        TableColumn tableColumn = ((TableCell)this.getControl()).getTableColumn();
        TableView.TableViewFocusModel tableViewFocusModel = tableView.getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!map.containsKey(tableView)) {
                TableCellBehavior.setAnchor(tableView, tableViewFocusModel.getFocusedCell());
            }
        } else {
            map.remove(tableView);
        }
        if ((mouseButton = mouseEvent.getButton()) == MouseButton.PRIMARY || mouseButton == MouseButton.SECONDARY && !bl) {
            if (tableViewSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
                this.simpleSelect(mouseEvent);
            } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
                if (bl) {
                    tableViewSelectionModel.clearSelection(n, tableColumn);
                    tableViewFocusModel.focus(n, tableColumn);
                } else {
                    tableViewSelectionModel.select(n, tableColumn);
                }
            } else if (mouseEvent.isShiftDown()) {
                TablePosition tablePosition = map.containsKey(tableView) ? map.get(tableView) : tableViewFocusModel.getFocusedCell();
                int n3 = Math.min(tablePosition.getRow(), n);
                int n4 = Math.max(tablePosition.getRow(), n);
                int n5 = Math.min(tablePosition.getColumn(), n2);
                int n6 = Math.max(tablePosition.getColumn(), n2);
                tableViewSelectionModel.clearSelection();
                if (tableViewSelectionModel.isCellSelectionEnabled()) {
                    for (int i = n3; i <= n4; ++i) {
                        for (int j = n5; j <= n6; ++j) {
                            tableViewSelectionModel.select(i, tableView.getVisibleLeafColumn(j));
                        }
                    }
                } else {
                    tableViewSelectionModel.selectRange(n3, n4 + 1);
                }
                tableViewFocusModel.focus(new TablePosition(tableView, n, tableColumn));
            } else {
                this.simpleSelect(mouseEvent);
            }
        }
    }

    private void simpleSelect(MouseEvent mouseEvent) {
        TableView tableView = ((TableCell)this.getControl()).getTableView();
        TableView.TableViewSelectionModel tableViewSelectionModel = tableView.getSelectionModel();
        int n = ((TableCell)this.getControl()).getIndex();
        boolean bl = tableViewSelectionModel.isSelected(n, ((TableCell)this.getControl()).getTableColumn());
        tableView.getSelectionModel().clearAndSelect(n, ((TableCell)this.getControl()).getTableColumn());
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            if (mouseEvent.getClickCount() == 1 && bl) {
                tableView.edit(n, ((TableCell)this.getControl()).getTableColumn());
            } else if (mouseEvent.getClickCount() == 1) {
                tableView.edit(-1, null);
            } else if (mouseEvent.getClickCount() == 2 && ((TableCell)this.getControl()).isEditable()) {
                tableView.edit(n, ((TableCell)this.getControl()).getTableColumn());
            }
        }
    }

    private int getColumn() {
        if (((TableCell)this.getControl()).getTableView().getSelectionModel().isCellSelectionEnabled()) {
            TableColumn tableColumn = ((TableCell)this.getControl()).getTableColumn();
            TableView tableView = ((TableCell)this.getControl()).getTableView();
            if (tableView == null || tableColumn == null) {
                return -1;
            }
            return tableView.getVisibleLeafColumns().indexOf(tableColumn);
        }
        return -1;
    }
}

