/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.x11;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.x11.X11CommonDialogs;
import com.sun.glass.ui.x11.X11Cursor;
import com.sun.glass.ui.x11.X11Pixels;
import com.sun.glass.ui.x11.X11Screen;
import com.sun.glass.ui.x11.X11Timer;
import com.sun.glass.ui.x11.X11View;
import com.sun.glass.ui.x11.X11Window;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X11Application
extends Application {
    Menu windowMenu;
    Menu editMenu;
    Menu fileMenu;
    long display = 0L;

    protected static void initLibrary() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Application.loadNativeLibrary("glass-x11");
                return null;
            }
        });
    }

    private native void _runLoop(String[] var1, Launchable var2, long var3, int var5, long var6);

    @Override
    protected void runLoop(final String[] args, final Launchable launchable) {
        Thread toolkitThread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread th = new Thread(new Runnable(){

                    public void run() {
                        int screen = -1;
                        long visualID = 0L;
                        Map ds = X11Application.getDeviceDetails();
                        if (ds != null) {
                            Object value = ds.get("XDisplay");
                            if (value != null) {
                                X11Application.this.display = (Long)value;
                            }
                            if ((value = ds.get("XVisualID")) != null) {
                                visualID = (Long)value;
                            }
                            if ((value = ds.get("XScreenID")) != null) {
                                screen = (Integer)value;
                            }
                        }
                        X11Application.this._runLoop(args, launchable, X11Application.this.display, screen, visualID);
                    }
                }, "X11NativeRunloopThread");
                return th;
            }
        });
        this.setEventThread(toolkitThread);
        toolkitThread.start();
    }

    native void _terminate(boolean var1);

    @Override
    protected void finishTerminating() {
        Thread toolkitThread = this.getEventThread();
        if (toolkitThread != null) {
            this._terminate(Thread.currentThread().equals(toolkitThread));
            this.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    protected Object _enterNestedEventLoop() {
        return null;
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
    }

    @Override
    public void installDefaultMenus(MenuBar menubar) {
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new X11Window(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        return new X11Window(parent);
    }

    @Override
    public View createView(Pen pen) {
        return new X11View(pen);
    }

    @Override
    public Cursor createCursor(int type) {
        return new X11Cursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new X11Cursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
        X11Cursor.setVisible_impl(visible);
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return X11Cursor.getBestSize_impl(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new X11Pixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new X11Pixels(width, height, data);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return X11Pixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        throw new UnsupportedOperationException("not implmented");
    }

    @Override
    protected Screen staticScreen_getDeepestScreen() {
        return X11Screen.getDeepestScreen_impl();
    }

    @Override
    protected Screen staticScreen_getMainScreen() {
        return X11Screen.getMainScreen_impl();
    }

    @Override
    protected Screen staticScreen_getScreenForLocation(int x, int y) {
        return X11Screen.getScreenForLocation_impl(x, y);
    }

    @Override
    protected Screen staticScreen_getScreenForPtr(long screenPtr) {
        return X11Screen.getScreenForPtr_impl(screenPtr);
    }

    @Override
    protected List<Screen> staticScreen_getScreens() {
        return X11Screen.getScreens_impl();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new X11Timer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return X11Timer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return X11Timer.getMaxPeriod_impl();
    }

    @Override
    protected String[] staticCommonDialogs_showFileChooser(Window owner, String folder, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters) {
        return X11CommonDialogs.showFileChooser_impl(folder, title, type, multipleMode, extensionFilters);
    }

    @Override
    protected String staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return X11CommonDialogs.showFolderChooser_impl();
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return X11View.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return X11View.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return X11View.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    @Override
    protected native void _invokeLater(Runnable var1);

    @Override
    protected native void _postOnEventQueue(Runnable var1);

    @Override
    public boolean supportsTransparentWindows() {
        return true;
    }
}

