/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

final class DeepListener
extends WeakReference<FileChangeListener>
implements FileChangeListener,
Runnable,
Callable<Boolean> {
    private static final Logger LOG = Logger.getLogger(DeepListener.class.getName());
    private final File path;
    private FileObject watching;
    private boolean removed;
    private final Callable<Boolean> stop;
    private static List<DeepListener> keep = new ArrayList<DeepListener>();
    private Set<FileEvent> delivered = Collections.synchronizedSet(new WeakSet());

    DeepListener(FileChangeListener fileChangeListener, File file, Callable<Boolean> callable) {
        super(fileChangeListener, Utilities.activeReferenceQueue());
        this.path = file;
        this.stop = callable;
        keep.add(this);
    }

    final void init() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, null, new Throwable("listening to " + this.path));
        }
        this.relisten();
    }

    @Override
    public void run() {
        FileObject fileObject = FileUtil.toFileObject(this.path);
        if (fileObject != null) {
            fileObject.removeRecursiveListener(this);
        }
        this.removed = true;
        keep.remove(this);
    }

    private synchronized void relisten() {
        FileObject fileObject = FileUtil.toFileObject(this.path);
        if (fileObject == this.watching) {
            return;
        }
        if (this.watching != null) {
            this.watching.removeRecursiveListener(this);
            this.watching = null;
        }
        if (fileObject != null) {
            this.watching = fileObject;
            fileObject.addRecursiveListener(this);
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.fileRenamed(fileRenameEvent, false);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent, boolean bl) {
        this.relisten();
        FileChangeListener fileChangeListener = this.get(fileRenameEvent, bl);
        if (fileChangeListener == null) {
            return;
        }
        fileChangeListener.fileRenamed(fileRenameEvent);
    }

    @Override
    public void fileFolderCreated(FileEvent fileEvent) {
        this.relisten();
        this.fileFolderCreated(fileEvent, false);
    }

    public void fileFolderCreated(FileEvent fileEvent, boolean bl) {
        this.relisten();
        FileChangeListener fileChangeListener = this.get(fileEvent, bl);
        if (fileChangeListener == null) {
            return;
        }
        fileChangeListener.fileFolderCreated(fileEvent);
    }

    @Override
    public void fileDeleted(FileEvent fileEvent) {
        this.fileDeleted(fileEvent, false);
    }

    public void fileDeleted(FileEvent fileEvent, boolean bl) {
        this.relisten();
        FileChangeListener fileChangeListener = this.get(fileEvent, bl);
        if (fileChangeListener == null) {
            return;
        }
        fileChangeListener.fileDeleted(fileEvent);
    }

    @Override
    public void fileDataCreated(FileEvent fileEvent) {
        this.fileDataCreated(fileEvent, false);
    }

    public void fileDataCreated(FileEvent fileEvent, boolean bl) {
        this.relisten();
        FileChangeListener fileChangeListener = this.get(fileEvent, bl);
        if (fileChangeListener == null) {
            return;
        }
        fileChangeListener.fileDataCreated(fileEvent);
    }

    @Override
    public void fileChanged(FileEvent fileEvent) {
        this.fileChanged(fileEvent, false);
    }

    public void fileChanged(FileEvent fileEvent, boolean bl) {
        FileChangeListener fileChangeListener = this.get(fileEvent, bl);
        if (fileChangeListener == null) {
            return;
        }
        fileChangeListener.fileChanged(fileEvent);
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        FileChangeListener fileChangeListener = this.get(fileAttributeEvent, false);
        if (fileChangeListener == null) {
            return;
        }
        fileChangeListener.fileAttributeChanged(fileAttributeEvent);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DeepListener deepListener = (DeepListener)object;
        if (!(this.path == deepListener.path || this.path != null && this.path.equals(deepListener.path))) {
            return false;
        }
        FileChangeListener fileChangeListener = (FileChangeListener)this.get();
        return fileChangeListener == deepListener.get() || fileChangeListener != null && fileChangeListener.equals(deepListener.get());
    }

    public int hashCode() {
        FileChangeListener fileChangeListener = (FileChangeListener)this.get();
        int n = 7;
        n = 11 * n + (fileChangeListener != null ? fileChangeListener.hashCode() : 0);
        return n;
    }

    private FileChangeListener get(FileEvent fileEvent, boolean bl) {
        if (this.removed) {
            return null;
        }
        if (bl && fileEvent.getFile() != fileEvent.getSource()) {
            return null;
        }
        if (!this.delivered.add(fileEvent)) {
            return null;
        }
        return (FileChangeListener)this.get();
    }

    @Override
    public Boolean call() throws Exception {
        return this.stop != null ? this.stop.call() : null;
    }
}

