/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.ConnectionReplyInterface;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.Reply;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class NetConnectionReply
extends Reply
implements ConnectionReplyInterface {
    private static MessageUtil msgutil_ = SqlException.getMessageUtil();

    NetConnectionReply(NetAgent netAgent, int n) {
        super(netAgent, n);
    }

    void readExchangeServerAttributes(Connection connection) throws SqlException {
        this.startSameIdChainParse();
        this.parseEXCSATreply((NetConnection)connection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void verifyConnectReply(int n) throws SqlException {
        if (this.peekCodePoint() != n) {
            this.parseConnectError();
            return;
        }
        this.readLengthAndCodePoint();
        this.skipBytes();
        if (n == 8705) {
            int n2 = this.peekCodePoint();
            if (n2 == -2) {
                return;
            }
            this.parseTypdefsOrMgrlvlovrs();
            NetSqlca netSqlca = this.parseSQLCARD(null);
            this.netAgent_.netConnection_.completeSqlca(netSqlca);
        }
    }

    void parseConnectError() throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4624: {
                this.parseMGRLVLRM();
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void readDummyExchangeServerAttributes(Connection connection) throws SqlException {
        this.startSameIdChainParse();
        this.parseDummyEXCSATreply((NetConnection)connection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readAccessSecurity(Connection connection, int n) throws SqlException {
        this.startSameIdChainParse();
        this.parseACCSECreply((NetConnection)connection, n);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readSecurityCheck(Connection connection) throws SqlException {
        this.startSameIdChainParse();
        this.parseSECCHKreply((NetConnection)connection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readAccessDatabase(Connection connection) throws SqlException {
        this.startSameIdChainParse();
        this.parseACCRDBreply((NetConnection)connection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    public void readCommitSubstitute(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseDummyEXCSATreply((NetConnection)connectionCallbackInterface);
        this.endOfSameIdChainData();
    }

    public void readLocalCommit(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseRDBCMMreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
    }

    public void readLocalRollback(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseRDBRLLBCKreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
    }

    public void readLocalXAStart(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    public void readLocalXACommit(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    public void readLocalXARollback(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    protected void readXaStartUnitOfWork(NetConnection netConnection) throws DisconnectException {
    }

    protected int readXaEndUnitOfWork(NetConnection netConnection) throws DisconnectException {
        return 0;
    }

    protected int readXaPrepare(NetConnection netConnection) throws DisconnectException {
        return 0;
    }

    protected void readXaCommit(NetConnection netConnection) throws DisconnectException {
    }

    protected int readXaRollback(NetConnection netConnection) throws DisconnectException {
        return 0;
    }

    protected void readXaRecover(NetConnection netConnection) throws DisconnectException {
    }

    protected void readXaForget(NetConnection netConnection) throws DisconnectException {
    }

    private void parseRDBCMMreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        int n = this.parseTypdefsOrMgrlvlovrs();
        this.parseENDUOWRM(connectionCallbackInterface);
        n = this.parseTypdefsOrMgrlvlovrs();
        if (n == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            connectionCallbackInterface.completeSqlca(netSqlca);
        } else {
            this.parseCommitError(connectionCallbackInterface);
        }
    }

    private void parseRDBRLLBCKreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        int n = this.parseTypdefsOrMgrlvlovrs();
        this.parseENDUOWRM(connectionCallbackInterface);
        n = this.parseTypdefsOrMgrlvlovrs();
        if (n == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            connectionCallbackInterface.completeSqlca(netSqlca);
        } else {
            this.parseRollbackError();
        }
    }

    private void parseEXCSATreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 5187) {
            this.parseExchangeServerAttributesError();
            return;
        }
        this.parseEXCSATRD(netConnection);
    }

    private void parseDummyEXCSATreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 5187) {
            this.parseExchangeServerAttributesError();
            return;
        }
        this.parseDummyEXCSATRD(netConnection);
    }

    private void parseACCSECreply(NetConnection netConnection, int n) throws DisconnectException {
        int n2 = this.peekCodePoint();
        if (n2 != 5292) {
            this.parseAccessSecurityError(netConnection);
            return;
        }
        this.parseACCSECRD(netConnection, n);
        this.netAgent_.exceptionConvertingRdbnam = null;
        n2 = this.peekCodePoint();
        if (n2 == -2) {
            return;
        }
    }

    private void parseSECCHKreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 4633) {
            this.parseSecurityCheckError(netConnection);
            return;
        }
        this.parseSECCHKRM(netConnection);
        if (this.peekCodePoint() == 4572) {
            boolean bl = false;
            byte[] byArray = this.parseSECTKN(false);
        }
    }

    private void parseACCRDBreply(NetConnection netConnection) throws DisconnectException {
        int n = this.peekCodePoint();
        if (n != 8705) {
            this.parseAccessRdbError(netConnection);
            return;
        }
        this.parseACCRDBRM(netConnection);
        this.parseInitialPBSD(netConnection);
        n = this.peekCodePoint();
        if (n == -2) {
            return;
        }
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        netConnection.completeSqlca(netSqlca);
    }

    protected int parseTypdefsOrMgrlvlovrs() throws DisconnectException {
        int n;
        boolean bl = false;
        while (true) {
            if ((n = this.peekCodePoint()) == 47) {
                if (!bl) {
                    this.netAgent_.targetTypdef_ = (Typdef)this.netAgent_.targetTypdef_.clone();
                    bl = true;
                }
                this.parseTYPDEFNAM();
                continue;
            }
            if (n != 53) break;
            if (!bl) {
                this.netAgent_.targetTypdef_ = (Typdef)this.netAgent_.targetTypdef_.clone();
                bl = true;
            }
            this.parseTYPDEFOVR();
        }
        return n;
    }

    protected void parseCommitError(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(connectionCallbackInterface, null);
                connectionCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseRollbackError() throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseExchangeServerAttributesError() throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4624: {
                this.parseMGRLVLRM();
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseAccessSecurityError(NetConnection netConnection) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseSecurityCheckError(NetConnection netConnection) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseAccessRdbError(NetConnection netConnection) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8711: {
                this.parseRDBACCRM();
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            case 8907: {
                this.parseRDBATHRM(netConnection);
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseCommonError(int n) throws DisconnectException {
        switch (n) {
            case 4688: {
                this.parseCMDNSPRM();
                break;
            }
            case 4677: {
                this.parsePRCCNVRM();
                break;
            }
            case 4684: {
                this.parseSYNTAXRM();
                break;
            }
            case 4690: {
                this.parseVALNSPRM();
                break;
            }
            default: {
                this.doObjnsprmSemantics(n);
            }
        }
    }

    NetSqlca parseAbnormalEndUow(ConnectionCallbackInterface connectionCallbackInterface, UnitOfWorkListener unitOfWorkListener) throws DisconnectException {
        NetSqlca netSqlca;
        this.parseABNUOWRM();
        if (this.peekCodePoint() != 9224) {
            this.parseTypdefsOrMgrlvlovrs();
        }
        if (ExceptionUtil.getSeverityFromIdentifier((netSqlca = this.parseSQLCARD(null)).getSqlState()) > 20000 || unitOfWorkListener == null) {
            connectionCallbackInterface.completeAbnormalUnitOfWork();
        } else {
            connectionCallbackInterface.completeAbnormalUnitOfWork(unitOfWorkListener);
        }
        return netSqlca;
    }

    NetSqlca parseAbnormalEndUow(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        return this.parseAbnormalEndUow(statementCallbackInterface.getConnectionCallbackInterface(), statementCallbackInterface);
    }

    NetSqlca parseAbnormalEndUow(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        return this.parseAbnormalEndUow(resultSetCallbackInterface.getConnectionCallbackInterface(), resultSetCallbackInterface);
    }

    void parseRdbAccessFailed(NetConnection netConnection) throws DisconnectException {
        this.parseRDBAFLRM();
        if (this.peekCodePoint() == 47) {
            this.parseTYPDEFNAM();
            this.parseTYPDEFOVR();
        } else {
            this.parseTYPDEFOVR();
            this.parseTYPDEFNAM();
        }
        NetSqlca netSqlca = this.parseSQLCARD(null);
        if (netSqlca.getSqlErrmc() == null) {
            netConnection.setConnectionNull(true);
        } else {
            netConnection.completeSqlca(netSqlca);
        }
    }

    private void parseSECCHKRM(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        byte[] byArray = null;
        this.parseLengthAndMatchCodePoint(4633);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl4 = false;
            if (n3 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SEVERE);
                n3 = this.peekCodePoint();
            }
            if (n3 == 4516) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                n2 = this.parseSECCHKCD();
                n3 = this.peekCodePoint();
            }
            if (n3 == 4572) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                byArray = this.parseSECTKN(true);
                n3 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        netConnection.securityCheckComplete(n, n2);
    }

    private void parseACCRDBRM(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        byte[] byArray = null;
        boolean bl7 = false;
        String string2 = null;
        this.parseLengthAndMatchCodePoint(8705);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl8 = false;
            if (n2 == 4425) {
                bl8 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_WARNING);
                n2 = this.peekCodePoint();
            }
            if (n2 == 4398) {
                bl8 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parsePRDID(false);
                n2 = this.peekCodePoint();
            }
            if (n2 == 47) {
                bl8 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                this.parseTYPDEFNAM();
                n2 = this.peekCodePoint();
            }
            if (n2 == 53) {
                bl8 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                this.parseTYPDEFOVR();
                n2 = this.peekCodePoint();
            }
            if (n2 == 4512) {
                bl8 = true;
                bl7 = this.checkAndGetReceivedFlag(bl7);
                string2 = this.parseUSRID(true);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8501) {
                bl8 = true;
                bl6 = this.checkAndGetReceivedFlag(bl6);
                byArray = this.parseCRRTKN(false);
                n2 = this.peekCodePoint();
            }
            if (bl8) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2, bl3, bl4);
        netConnection.rdbAccessed(n, string, bl6, byArray);
    }

    void parseENDUOWRM(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8716);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl4 = false;
            if (n3 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_WARNING);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8469) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                n2 = this.parseUOWDSP();
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
        if (n2 == 1) {
            connectionCallbackInterface.completeLocalCommit();
        } else {
            connectionCallbackInterface.completeLocalRollback();
        }
    }

    protected void parseCMDCHKRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(4692);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (n2 == 4444) {
                bl3 = true;
                this.parseLengthAndMatchCodePoint(4444);
                this.skipBytes();
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl);
        this.netAgent_.setSvrcod(n);
        NetSqlca netSqlca = this.parseSQLCARD(null);
        this.netAgent_.netConnection_.completeSqlca(netSqlca);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J123"), (Throwable)new SqlException(this.agent_.logWriter_, netSqlca)));
    }

    void parseRDBNACRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8708);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J122")));
    }

    private void parseRDBNFNRM(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8721);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08004.C.2"), (Object)netConnection.databaseName_));
    }

    private void parseRDBATHRM(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8907);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
        this.netAgent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil_.getTextMessage("J121")));
    }

    protected void parseSYNTAXRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        String string = null;
        boolean bl4 = false;
        int n3 = 0;
        this.parseLengthAndMatchCodePoint(4684);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl5 = false;
            if (n4 == 4425) {
                bl5 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n4 = this.peekCodePoint();
            }
            if (n4 == 4426) {
                bl5 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                n2 = this.parseSYNERRCD();
                n4 = this.peekCodePoint();
            }
            if (n4 == 8464) {
                bl5 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                string = this.parseRDBNAM(true);
                n4 = this.peekCodePoint();
            }
            if (n4 == 12) {
                bl5 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                n3 = this.parseCODPNT();
                n4 = this.peekCodePoint();
            }
            if (bl5) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
        this.doSyntaxrmSemantics(n3);
    }

    private void parseRDBACCRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8711);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J124")));
    }

    private void parseRDBAFLRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8730);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
    }

    protected void parseVALNSPRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        int n2 = 0;
        this.parseLengthAndMatchCodePoint(4690);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl4 = false;
            if (n3 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (n3 == 12) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n2 = this.parseCODPNT();
                n3 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl3);
        this.netAgent_.setSvrcod(n);
        this.doValnsprmSemantics(n2, "\"\"");
    }

    protected void parsePRCCNVRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        int n2 = 0;
        this.parseLengthAndMatchCodePoint(4677);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl4 = false;
            if (n3 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_SESDMG);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (n3 == 4415) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n2 = this.parsePRCCNVCD();
                n3 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl3);
        this.netAgent_.setSvrcod(n);
        this.doPrccnvrmSemantics(4677);
    }

    void parseOBJNSPRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        int n2 = 0;
        this.parseLengthAndMatchCodePoint(4691);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl4 = false;
            if (n3 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_SEVERE);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (n3 == 12) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n2 = this.parseCODPNT();
                n3 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl3);
        this.netAgent_.setSvrcod(n);
        this.doObjnsprmSemantics(n2);
    }

    private void parseMGRLVLRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int[] nArray = null;
        int[] nArray2 = null;
        this.parseLengthAndMatchCodePoint(4624);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 5124) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                this.parseLengthAndMatchCodePoint(5124);
                int n3 = this.getDdmLength();
                if (n3 == 0 || n3 % 7 != 0) {
                    this.doSyntaxrmSemantics(CodePoint.SYNERRCD_OBJ_LEN_NOT_ALLOWED);
                }
                int n4 = n3 / 7;
                nArray = new int[n4];
                nArray2 = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = this.parseCODPNTDR();
                    nArray2[i] = this.parseMGRLVLN();
                }
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
        this.doMgrlvlrmSemantics(nArray, nArray2);
    }

    protected void parseCMDNSPRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        Object var6_6 = null;
        boolean bl4 = false;
        int n2 = 0;
        this.parseLengthAndMatchCodePoint(4688);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl5 = false;
            if (n3 == 4425) {
                bl5 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl5 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (n3 == 12) {
                bl5 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                n2 = this.parseCODPNT();
                n3 = this.peekCodePoint();
            }
            if (bl5) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl4);
        this.netAgent_.setSvrcod(n);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58014.C"), (Object)Integer.toHexString(n2)));
    }

    void parseABNUOWRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8717);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
    }

    private void parseEXCSATRD(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        boolean bl4 = false;
        String string3 = null;
        boolean bl5 = false;
        String string4 = null;
        this.parseLengthAndMatchCodePoint(5187);
        this.pushLengthOnCollectionStack();
        int n = this.peekCodePoint();
        while (n != -1) {
            boolean bl6 = false;
            if (n == 4446) {
                bl6 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                string = this.parseEXTNAM();
                n = this.peekCodePoint();
            }
            if (n == 5124) {
                bl6 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                this.parseMGRLVLLS(netConnection);
                n = this.peekCodePoint();
            }
            if (n == 4423) {
                bl6 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                string2 = this.parseSRVCLSNM();
                n = this.peekCodePoint();
            }
            if (n == 4461) {
                bl6 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                string3 = this.parseSRVNAM();
                n = this.peekCodePoint();
            }
            if (n == 4442) {
                bl6 = true;
                bl5 = this.checkAndGetReceivedFlag(bl5);
                string4 = this.parseSRVRLSLV();
                n = this.peekCodePoint();
            }
            if (bl6) continue;
            this.doPrmnsprmSemantics(n);
        }
        this.popCollectionStack();
        netConnection.setServerAttributeData(string, string2, string3, string4);
    }

    private void parseDummyEXCSATRD(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        boolean bl4 = false;
        String string3 = null;
        boolean bl5 = false;
        String string4 = null;
        this.parseLengthAndMatchCodePoint(5187);
        this.pushLengthOnCollectionStack();
        int n = this.peekCodePoint();
        while (n != -1) {
            boolean bl6 = false;
            if (n == 4446) {
                bl6 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                string = this.parseEXTNAM();
                n = this.peekCodePoint();
            }
            if (n == 5124) {
                bl6 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                this.parseMGRLVLLS(netConnection);
                n = this.peekCodePoint();
            }
            if (n == 4423) {
                bl6 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                string2 = this.parseSRVCLSNM();
                n = this.peekCodePoint();
            }
            if (n == 4461) {
                bl6 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                string3 = this.parseSRVNAM();
                n = this.peekCodePoint();
            }
            if (n == 4442) {
                bl6 = true;
                bl5 = this.checkAndGetReceivedFlag(bl5);
                string4 = this.parseSRVRLSLV();
                n = this.peekCodePoint();
            }
            if (bl6) continue;
            this.doPrmnsprmSemantics(n);
        }
        this.popCollectionStack();
    }

    private void parseACCSECRD(NetConnection netConnection, int n) throws DisconnectException {
        boolean bl = false;
        int[] nArray = null;
        boolean bl2 = false;
        byte[] byArray = null;
        boolean bl3 = false;
        int n2 = 0;
        this.parseLengthAndMatchCodePoint(5292);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl4 = false;
            if (n3 == 4514) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                nArray = this.parseSECMEC();
                n3 = this.peekCodePoint();
            }
            if (n3 == 4572) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                byArray = this.parseSECTKN(false);
                n3 = this.peekCodePoint();
            }
            if (n3 == 4516) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n2 = this.parseSECCHKCD();
                n3 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl);
        netConnection.setAccessSecurityData(n2, n, nArray, bl2, byArray);
        if (netConnection.serverSupportsUtf8Ccsid()) {
            netConnection.netAgent_.switchToUtf8CcsidMgr();
        } else {
            netConnection.netAgent_.switchToEbcdicMgr();
        }
    }

    void parseTYPDEFNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(47);
        this.netAgent_.targetTypdef_.setTypdefnam(this.readString());
    }

    void parseTYPDEFOVR() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(53);
        this.pushLengthOnCollectionStack();
        int n = this.peekCodePoint();
        while (n != -1) {
            boolean bl = false;
            if (n == 4508) {
                bl = true;
                this.netAgent_.targetTypdef_.setCcsidSbc(this.parseCCSIDSBC());
                n = this.peekCodePoint();
            }
            if (n == 4509) {
                bl = true;
                this.netAgent_.targetTypdef_.setCcsidDbc(this.parseCCSIDDBC());
                n = this.peekCodePoint();
            }
            if (n == 4510) {
                bl = true;
                this.netAgent_.targetTypdef_.setCcsidMbc(this.parseCCSIDMBC());
                n = this.peekCodePoint();
            }
            if (bl) continue;
            this.doPrmnsprmSemantics(n);
        }
        this.popCollectionStack();
    }

    int parseSYNCCRD(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        return 0;
    }

    protected int parseXARETVAL() throws DisconnectException {
        return 0;
    }

    protected byte parseSYNCTYPE() throws DisconnectException {
        return 0;
    }

    protected int parseSYNCCTLreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        if (this.peekCodePoint() == 49152) {
            this.parsePBSD();
        }
        return 0;
    }

    void parseSYNCCTLError(int n) throws DisconnectException {
        switch (n) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4677: {
                this.parsePRCCNVRM();
                break;
            }
            case 4684: {
                this.parseSYNTAXRM();
                break;
            }
            case 4690: {
                this.parseVALNSPRM();
                break;
            }
            default: {
                this.doObjnsprmSemantics(n);
            }
        }
    }

    private void parseMGRLVLLS(NetConnection netConnection) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(5124);
        int n = this.getDdmLength();
        if (n == 0 || n % 4 != 0) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_OBJ_LEN_NOT_ALLOWED);
        }
        int n2 = n / 4;
        block12: for (int i = 0; i < n2; ++i) {
            int n3 = this.parseCODPNTDR();
            int n4 = this.parseMGRLVLN();
            switch (n3) {
                case 5123: {
                    if (n4 < 3 || n4 > netConnection.targetAgent_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetAgent_ = n4;
                    continue block12;
                }
                case 5236: {
                    if (n4 < 5 || n4 > netConnection.targetCmntcpip_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetCmntcpip_ = n4;
                    continue block12;
                }
                case 9231: {
                    if (n4 < 3 || n4 > netConnection.targetRdb_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetRdb_ = n4;
                    continue block12;
                }
                case 5184: {
                    if (n4 < 5 || n4 > netConnection.targetSecmgr_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetSecmgr_ = n4;
                    continue block12;
                }
                case 9223: {
                    if (n4 < 4 || n4 > this.netAgent_.targetSqlam_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    this.netAgent_.orignalTargetSqlam_ = n4;
                    continue block12;
                }
                case 5188: {
                    if (n4 < 3 || n4 > netConnection.targetCmnappc_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetCmnappc_ = n4;
                    continue block12;
                }
                case 7169: {
                    if (n4 != 0 && n4 < 7 || n4 > netConnection.targetXamgr_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetXamgr_ = n4;
                    continue block12;
                }
                case 5312: {
                    if (n4 != 0 && n4 < 5 || n4 > netConnection.targetSyncptmgr_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetSyncptmgr_ = n4;
                    continue block12;
                }
                case 7176: {
                    if (n4 < 0 || n4 > netConnection.targetUnicodemgr_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetUnicodemgr_ = n4;
                    continue block12;
                }
                case 5313: {
                    if (n4 != 0 && n4 < 5 || n4 > netConnection.targetRsyncmgr_) {
                        this.doMgrlvlrmSemantics(n3, n4);
                    }
                    netConnection.targetRsyncmgr_ = n4;
                    continue block12;
                }
                default: {
                    this.doMgrlvlrmSemantics(n3, n4);
                }
            }
        }
    }

    protected String parseEXTNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4446);
        return this.readString();
    }

    protected String parseSRVCLSNM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4423);
        return this.readString();
    }

    protected String parseSRVNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4461);
        return this.readString();
    }

    protected String parseSRVRLSLV() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4442);
        return this.readString();
    }

    protected int parseMGRLVLN() throws DisconnectException {
        return this.readUnsignedShort();
    }

    protected int[] parseSECMEC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4514);
        return this.readUnsignedShortList();
    }

    protected byte[] parseSECTKN(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4572);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    protected int parseSECCHKCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4516);
        int n = this.readUnsignedByte();
        if (n < 0 || n > 21) {
            this.doValnsprmSemantics(4516, n);
        }
        return n;
    }

    protected String parsePRDID(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4398);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    protected String parseUSRID(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4512);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    protected int parseCODPNTDR() throws DisconnectException {
        return this.readUnsignedShort();
    }

    protected byte[] parseCRRTKN(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8501);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    protected int parseUOWDSP() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8469);
        int n = this.readUnsignedByte();
        if (n != 1 && n != 2) {
            this.doValnsprmSemantics(8469, n);
        }
        return n;
    }

    protected String parseRDBNAM(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8464);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    protected int parseXIDCNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6406);
        return this.readUnsignedShort();
    }

    protected Xid parseXID() throws DisconnectException {
        return null;
    }

    protected Hashtable parseIndoubtList() throws DisconnectException {
        return null;
    }

    protected int parseSYNERRCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4426);
        int n = this.readUnsignedByte();
        if (n < 1 || n > 29) {
            this.doValnsprmSemantics(4426, n);
        }
        return n;
    }

    protected int parseCODPNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(12);
        return this.parseCODPNTDR();
    }

    protected int parsePRCCNVCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4415);
        int n = this.readUnsignedByte();
        if (n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6 && n != 16 && n != 17 && n != 18 && n != 19 && n != 21) {
            this.doValnsprmSemantics(4415, n);
        }
        return n;
    }

    protected int parseCCSIDSBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4508);
        return this.readUnsignedShort();
    }

    protected int parseCCSIDMBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4510);
        return this.readUnsignedShort();
    }

    protected int parseCCSIDDBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4509);
        return this.readUnsignedShort();
    }

    protected int parseSVRCOD(int n, int n2) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4425);
        int n3 = this.readUnsignedShort();
        if (n3 != CodePoint.SVRCOD_INFO && n3 != CodePoint.SVRCOD_WARNING && n3 != CodePoint.SVRCOD_ERROR && n3 != CodePoint.SVRCOD_SEVERE && n3 != CodePoint.SVRCOD_ACCDMG && n3 != CodePoint.SVRCOD_PRMDMG && n3 != CodePoint.SVRCOD_SESDMG) {
            this.doValnsprmSemantics(4425, n3);
        }
        if (n3 < n || n3 > n2) {
            this.doValnsprmSemantics(4425, n3);
        }
        return n3;
    }

    protected int parseFastSVRCOD(int n, int n2) throws DisconnectException {
        this.matchCodePoint(4425);
        int n3 = this.readFastUnsignedShort();
        if (n3 != CodePoint.SVRCOD_INFO && n3 != CodePoint.SVRCOD_WARNING && n3 != CodePoint.SVRCOD_ERROR && n3 != CodePoint.SVRCOD_SEVERE && n3 != CodePoint.SVRCOD_ACCDMG && n3 != CodePoint.SVRCOD_PRMDMG && n3 != CodePoint.SVRCOD_SESDMG) {
            this.doValnsprmSemantics(4425, n3);
        }
        if (n3 < n || n3 > n2) {
            this.doValnsprmSemantics(4425, n3);
        }
        return n3;
    }

    protected NetSqlca parseSQLCARD(Sqlca[] sqlcaArray) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9224);
        int n = this.getDdmLength();
        this.ensureBLayerDataInBuffer(n);
        NetSqlca netSqlca = this.parseSQLCARDrow(sqlcaArray);
        this.adjustLengths(this.getDdmLength());
        return netSqlca;
    }

    NetSqlca parseSQLCARDrow(Sqlca[] sqlcaArray) throws DisconnectException {
        return this.parseSQLCAGRP(sqlcaArray);
    }

    int parseSQLNUMROW() throws DisconnectException {
        return this.parseSQLNUMGRP();
    }

    int parseFastSQLNUMROW() throws DisconnectException {
        return this.parseFastSQLNUMGRP();
    }

    private int parseSQLNUMGRP() throws DisconnectException {
        return this.readShort();
    }

    private int parseFastSQLNUMGRP() throws DisconnectException {
        return this.readFastShort();
    }

    private NetSqlca parseSQLCAGRP(Sqlca[] sqlcaArray) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return null;
        }
        int n = this.readFastInt();
        byte[] byArray = this.readFastBytes(5);
        byte[] byArray2 = this.readFastBytes(8);
        NetSqlca netSqlca = null;
        try {
            netSqlca = new NetSqlca((Connection)this.netAgent_.netConnection_, n, byArray, byArray2);
        }
        catch (SqlException sqlException) {
            throw new DisconnectException((Agent)this.netAgent_, sqlException);
        }
        this.parseSQLCAXGRP(netSqlca);
        if (this.netAgent_.targetSqlam_ >= 7) {
            netSqlca.setRowsetRowCount(this.parseSQLDIAGGRP(sqlcaArray));
        }
        return netSqlca;
    }

    private void parseSQLCAXGRP(NetSqlca netSqlca) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            netSqlca.setContainsSqlcax(false);
            return;
        }
        if (this.netAgent_.targetSqlam_ < 7) {
            this.skipFastBytes(18);
        }
        int[] nArray = new int[6];
        this.readFastIntArray(nArray);
        byte[] byArray = this.readFastBytes(11);
        if (this.netAgent_.targetSqlam_ >= 7) {
            this.parseFastVCS();
        }
        int n = 0;
        byte[] byArray2 = this.readFastLDBytes();
        if (byArray2 != null) {
            n = this.netAgent_.targetTypdef_.getCcsidMbc();
            this.skipFastBytes(2);
        } else {
            byArray2 = this.readFastLDBytes();
            n = this.netAgent_.targetTypdef_.getCcsidSbc();
        }
        netSqlca.setSqlerrd(nArray);
        netSqlca.setSqlwarnBytes(byArray);
        netSqlca.setSqlerrmcBytes(byArray2, n);
    }

    private long parseSQLDIAGGRP(Sqlca[] sqlcaArray) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return 0L;
        }
        long l = this.parseSQLDIAGSTT(sqlcaArray);
        this.parseSQLDIAGCI(sqlcaArray);
        this.parseSQLDIAGCN();
        return l;
    }

    protected String parseFastVCS() throws DisconnectException {
        return this.readFastString(this.readFastUnsignedShort(), this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
    }

    protected boolean checkAndGetReceivedFlag(boolean bl) throws DisconnectException {
        if (bl) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DUP_OBJ_PRESENT);
        }
        return true;
    }

    protected void checkRequiredObjects(boolean bl) throws DisconnectException {
        if (!bl) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean bl, boolean bl2) throws DisconnectException {
        if (!bl || !bl2) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean bl, boolean bl2, boolean bl3) throws DisconnectException {
        if (!(bl && bl2 && bl3)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws DisconnectException {
        if (!(bl && bl2 && bl3 && bl4)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws DisconnectException {
        if (!(bl && bl2 && bl3 && bl4 && bl5 && bl6)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws DisconnectException {
        if (!(bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void doObjnsprmSemantics(int n) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58015.C"), (Object)Integer.toHexString(n)));
    }

    protected void doPrmnsprmSemantics(int n) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58016.C"), (Object)Integer.toHexString(n)));
    }

    void doValnsprmSemantics(int n, int n2) throws DisconnectException {
        this.doValnsprmSemantics(n, Integer.toString(n2));
    }

    void doValnsprmSemantics(int n, String string) throws DisconnectException {
        if (n == 5242) {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("58017.C"), Integer.toHexString(n)));
            return;
        }
        if (n == 4508 || n == 4509 || n == 4510) {
            int n2 = 0;
            switch (n) {
                case 4508: {
                    n2 = this.netAgent_.typdef_.getCcsidSbc();
                    break;
                }
                case 4509: {
                    n2 = this.netAgent_.typdef_.getCcsidDbc();
                    break;
                }
                case 4510: {
                    n2 = this.netAgent_.typdef_.getCcsidSbc();
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("57017.C"), (Object)new Integer(n2), (Object)string));
            return;
        }
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58017.C"), (Object)Integer.toHexString(n)));
    }

    void doDtamchrmSemantics() throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J125")));
    }

    private void doMgrlvlrmSemantics(String string, String string2) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58010.C"), (Object)string, (Object)string2));
    }

    private void doMgrlvlrmSemantics(int n, int n2) throws DisconnectException {
        this.doMgrlvlrmSemantics("0x" + Integer.toHexString(n), "0x" + Integer.toHexString(n2));
    }

    private void doMgrlvlrmSemantics(int[] nArray, int[] nArray2) throws DisconnectException {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("0x");
            stringBuffer.append(nArray[i]);
            stringBuffer2.append("0x");
            stringBuffer2.append(nArray2[i]);
            if (i == n - 1) continue;
            stringBuffer.append(",");
            stringBuffer2.append(",");
        }
        this.doMgrlvlrmSemantics(stringBuffer.toString(), stringBuffer2.toString());
    }

    protected void doPrccnvrmSemantics(int n) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J126", Integer.toHexString(n))));
    }

    void parseSQLDCTOKS() throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        int n = this.parseFastSQLNUMROW();
        for (int i = 0; i < n; ++i) {
            this.parseSQLTOKROW();
        }
    }

    private void parseSQLDIAGCI(Sqlca[] sqlcaArray) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        int n = this.parseFastSQLNUMROW();
        if (n == 0) {
            this.resetRowsetSqlca(sqlcaArray, 0);
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = this.parseSQLDCROW(sqlcaArray, n2);
        }
        this.resetRowsetSqlca(sqlcaArray, n2 + 1);
    }

    private void parseSQLDIAGCN() throws DisconnectException {
        if (this.readUnsignedByte() == 255) {
            return;
        }
        int n = this.parseFastSQLNUMROW();
        for (int i = 0; i < n; ++i) {
            this.parseSQLCNROW();
        }
    }

    private void parseSQLCNROW() throws DisconnectException {
        this.parseSQLCNGRP();
    }

    private int parseSQLDCROW(Sqlca[] sqlcaArray, int n) throws DisconnectException {
        return this.parseSQLDCGRP(sqlcaArray, n);
    }

    private void parseSQLTOKROW() throws DisconnectException {
        this.parseSQLTOKGRP();
    }

    private void parseSQLTOKGRP() throws DisconnectException {
        this.skipFastNVCMorNVCS();
    }

    private long parseSQLDIAGSTT(Sqlca[] sqlcaArray) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return 0L;
        }
        int n = this.readFastInt();
        int n2 = this.readFastInt();
        int n3 = this.readFastInt();
        this.skipFastBytes(16);
        long l = this.readFastLong();
        this.skipFastBytes(24);
        return l;
    }

    private void parseSQLCNGRP() throws DisconnectException {
        this.skipBytes(18);
        String string = this.parseFastVCS();
        String string2 = this.parseFastVCS();
        String string3 = this.parseFastVCS();
    }

    private int parseSQLDCGRP(Sqlca[] sqlcaArray, int n) throws DisconnectException {
        int n2 = this.readFastInt();
        String string = this.readFastString(5, "UTF8");
        int n3 = this.readFastInt();
        int n4 = this.readFastInt();
        int n5 = (int)this.readFastLong();
        if (n2 == 20237) {
            sqlcaArray[0] = new NetSqlca((Connection)this.netAgent_.netConnection_, n2, string, null);
        } else if (sqlcaArray[n5] != null) {
            sqlcaArray[n5].resetRowsetSqlca(this.netAgent_.netConnection_, n2, string, null);
        } else {
            sqlcaArray[n5] = new NetSqlca((Connection)this.netAgent_.netConnection_, n2, string, null);
        }
        for (int i = n + 1; i < n5; ++i) {
            sqlcaArray[i] = null;
        }
        this.skipFastBytes(47);
        String string2 = this.parseFastVCS();
        this.parseSQLDCTOKS();
        String string3 = this.parseFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseSQLDCXGRP();
        return n5;
    }

    private void parseSQLDCXGRP() throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        String string = this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
    }

    private String parseFastNVCMorNVCS() throws DisconnectException {
        String string = null;
        int n = 0;
        int n2 = 0;
        if (this.readFastUnsignedByte() != 255) {
            n = this.readFastUnsignedShort();
            if (n > 0) {
                string = this.readFastString(n, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            }
            if (this.readFastUnsignedByte() != 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.20")));
            }
        } else if (this.readFastUnsignedByte() != 255 && (n2 = this.readFastUnsignedShort()) > 0) {
            string = this.readFastString(n2, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return string;
    }

    private void skipFastNVCMorNVCS() throws DisconnectException {
        int n = 0;
        int n2 = 0;
        if (this.readFastUnsignedByte() != 255) {
            n = this.readFastUnsignedShort();
            if (n > 0) {
                this.skipFastBytes(n);
            }
            if (this.readFastUnsignedByte() != 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.20")));
            }
        } else if (this.readFastUnsignedByte() != 255 && (n2 = this.readFastUnsignedShort()) > 0) {
            this.skipFastBytes(n2);
        }
    }

    void resetRowsetSqlca(Sqlca[] sqlcaArray, int n) {
        int n2 = sqlcaArray == null ? 0 : sqlcaArray.length;
        for (int i = n; i < n2; ++i) {
            sqlcaArray[i] = null;
        }
    }

    protected void parseInitialPBSD(Connection connection) throws DisconnectException {
        if (this.peekCodePoint() != 49152) {
            return;
        }
        this.parseLengthAndMatchCodePoint(49152);
        int n = this.peekCodePoint();
        while (n != -2) {
            this.parseLengthAndMatchCodePoint(n);
            switch (n) {
                case 49153: {
                    this.netAgent_.netConnection_.completeInitialPiggyBackIsolation(this.readUnsignedByte());
                    break;
                }
                case 49154: {
                    this.netAgent_.netConnection_.completeInitialPiggyBackSchema(this.readString(this.getDdmLength(), "UTF-8"));
                    break;
                }
                default: {
                    this.parseCommonError(n);
                }
            }
            n = this.peekCodePoint();
        }
    }

    protected void parsePBSD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(49152);
        int n = this.peekCodePoint();
        while (n != -2) {
            this.parseLengthAndMatchCodePoint(n);
            switch (n) {
                case 49153: {
                    this.netAgent_.netConnection_.completePiggyBackIsolation(this.readUnsignedByte());
                    break;
                }
                case 49154: {
                    this.netAgent_.netConnection_.completePiggyBackSchema(this.readString(this.getDdmLength(), "UTF-8"));
                    break;
                }
                default: {
                    this.parseCommonError(n);
                }
            }
            n = this.peekCodePoint();
        }
    }
}

