/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class JarSigningData {
    private CodeSigner[] signers;
    private Map signerMap;
    private Map codeSourceCache;
    private Certificate[] certificates;
    private Map signerMapCert;
    private Map codeSourceCertCache;
    private final boolean hasOnlySignedEntries;
    private final boolean hasSingleCodeSource;
    private final boolean hasMissingSignedEntries;
    private static int[] emptySignerIndices = new int[0];

    JarSigningData(boolean bl, boolean bl2, boolean bl3) {
        this.hasOnlySignedEntries = bl;
        this.hasSingleCodeSource = bl2;
        this.hasMissingSignedEntries = bl3;
    }

    static JarSigningData create(JarVerifier jarVerifier) {
        List list;
        JarSigningData jarSigningData = new JarSigningData(jarVerifier.hasOnlySignedEntries(), jarVerifier.hasSingleCodeSource(), jarVerifier.hasMissingSignedEntries());
        List list2 = jarVerifier.getSignerCerts();
        if (!list2.isEmpty()) {
            jarSigningData.certificates = list2.toArray(new Certificate[list2.size()]);
            jarSigningData.signerMapCert = jarVerifier.getSignerMapCert();
            jarSigningData.codeSourceCertCache = jarVerifier.getCodeSourceCertCache();
        }
        if (!(list = jarVerifier.getSignersCS()).isEmpty()) {
            CodeSigner[] codeSignerArray = new CodeSigner[list.size()];
            jarSigningData.signers = list.toArray(codeSignerArray);
            jarSigningData.signerMap = jarVerifier.getSignerMap();
            jarSigningData.codeSourceCache = jarVerifier.getCodeSourceCache();
        }
        Trace.println("Create from verifier: " + jarSigningData, TraceLevel.CACHE);
        return jarSigningData;
    }

    void updateCertInfo(Certificate[] certificateArray, Map map, Map map2) {
        this.certificates = certificateArray;
        this.signerMapCert = map;
        this.codeSourceCertCache = map2;
    }

    void updateSignerInfo(CodeSigner[] codeSignerArray, Map map, Map map2) {
        this.signers = codeSignerArray;
        this.signerMap = map;
        this.codeSourceCache = map2;
    }

    boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    synchronized Map getCertificateMap() {
        return this.signerMapCert;
    }

    synchronized Map getSignerMap() {
        if (Config.isJavaVersionAtLeast15()) {
            return this.signerMap;
        }
        return this.signerMapCert;
    }

    synchronized Map getCodeSourceCache() {
        if (Config.isJavaVersionAtLeast15()) {
            return this.codeSourceCache;
        }
        return this.codeSourceCertCache;
    }

    synchronized boolean matchStrictSingleSigning(CodeSource[] codeSourceArray) {
        if (!this.hasStrictSingleSigning()) {
            return false;
        }
        if (codeSourceArray == null || codeSourceArray.length != 1 || codeSourceArray[0] == null) {
            return false;
        }
        CodeSource codeSource = codeSourceArray[0];
        Map map = this.getSignerMap();
        int[] nArray = map != null ? map.get(null) : null;
        Map map2 = this.getCodeSourceCache();
        CodeSource codeSource2 = map2 != null ? map2.get(nArray) : null;
        return codeSource.equals(codeSource2);
    }

    synchronized Map getCodeSourceCertCache() {
        return this.codeSourceCertCache;
    }

    public synchronized CodeSigner[] getCodeSigners() {
        return this.signers;
    }

    public synchronized Certificate[] getCertificates() {
        return this.certificates;
    }

    synchronized CodeSource[] getCodeSources(URL uRL) {
        CodeSource[] codeSourceArray;
        Collection collection;
        Map map = this.getCodeSourceCache();
        Collection collection2 = collection = map != null ? map.values() : null;
        if (collection != null) {
            int n = collection.size();
            if (this.hasOnlySignedEntries) {
                codeSourceArray = collection.toArray(new CodeSource[n]);
            } else {
                codeSourceArray = collection.toArray(new CodeSource[n + 1]);
                codeSourceArray[n] = JarSigningData.getUnsignedCS(uRL);
            }
        } else {
            codeSourceArray = new CodeSource[]{JarSigningData.getUnsignedCS(uRL)};
        }
        return codeSourceArray;
    }

    synchronized CodeSource getCodeSource(URL uRL, String string) {
        Map map;
        int[] nArray = this.getSignerIndices(string);
        if (nArray != null && (map = this.getCodeSourceCache()) != null) {
            return (CodeSource)map.get(nArray);
        }
        return JarSigningData.getUnsignedCS(uRL);
    }

    private int[] findMatchingSignerIndices(CodeSource codeSource) {
        Map map = this.getCodeSourceCache();
        if (map == null) {
            return emptySignerIndices;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            CodeSource codeSource2;
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof CodeSource) || (codeSource2 = (CodeSource)entry.getValue()) == null || !codeSource2.equals(codeSource)) continue;
            return (int[])entry.getKey();
        }
        if (codeSource.getCodeSigners() == null) {
            return emptySignerIndices;
        }
        return null;
    }

    private int[] getSignerIndices(String string) {
        if (this.signerMap == null || this.signerMap.isEmpty()) {
            return null;
        }
        if (this.hasStrictSingleSigning()) {
            if (!JarUtil.isSigningRelated(string) && !string.endsWith("/")) {
                return (int[])this.signerMap.get(null);
            }
            return null;
        }
        return (int[])this.signerMap.get(string);
    }

    synchronized CodeSigner[] getCodeSigners(String string) {
        int[] nArray = this.getSignerIndices(string);
        CodeSigner[] codeSignerArray = null;
        if (this.signers != null && nArray != null) {
            codeSignerArray = new CodeSigner[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                if (this.signers == null) continue;
                codeSignerArray[i] = this.signers[nArray[i]];
            }
        }
        return codeSignerArray;
    }

    synchronized Certificate[] getCertificates(String string) {
        int[] nArray = this.getSignerIndices(string);
        if (this.signers != null && nArray != null) {
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.addAll(this.signers[nArray[i]].getSignerCertPath().getCertificates());
            }
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        return null;
    }

    synchronized Certificate[] getCertificates14(String string) {
        int[] nArray = this.getCertIndices(string);
        Certificate[] certificateArray = null;
        if (this.certificates != null && nArray != null) {
            certificateArray = new Certificate[this.certificates.length];
            for (int i = 0; i < this.certificates.length; ++i) {
                certificateArray[i] = this.certificates[nArray[i]];
            }
        }
        return certificateArray;
    }

    private synchronized int[] getCertIndices(String string) {
        Map map = this.getCertificateMap();
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (this.hasStrictSingleSigning()) {
            if (!JarUtil.isSigningRelated(string) && !string.endsWith("/")) {
                return (int[])map.get(null);
            }
            return null;
        }
        return (int[])map.get(string);
    }

    synchronized boolean collectEntryNamesBySigners(CodeSource[] codeSourceArray, List list) {
        Object object;
        boolean bl = false;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(codeSourceArray.length);
        for (int i = 0; i < codeSourceArray.length; ++i) {
            object = this.findMatchingSignerIndices(codeSourceArray[i]);
            if (object == null) continue;
            if (((int[])object).length > 0) {
                arrayList.add((int[])object);
                continue;
            }
            bl = true;
        }
        if (this.signerMap != null) {
            Iterator iterator = this.signerMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (arrayList.contains(this.signerMap.get(object))) {
                    list.add(object);
                    continue;
                }
                Trace.println("collectEntryNamesBySigners: unmatched entry " + (String)object, TraceLevel.CACHE);
            }
        }
        return bl;
    }

    private static CodeSource getUnsignedCS(URL uRL) {
        return new CodeSource(uRL, (Certificate[])null);
    }

    public String toString() {
        return "JarSigningData{hasOnlySignedEntries=" + this.hasOnlySignedEntries + ", hasSingleCodeSource=" + this.hasSingleCodeSource + ", hasMissingSignedEntries=" + this.hasMissingSignedEntries + '}';
    }
}

