/*
 * Decompiled with CFR 0.152.
 */
package com.sun.applet2.preloader.event;

import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.net.URL;

public class DownloadEvent
extends PreloaderEvent {
    public static final int DOWNLOADING = 0;
    public static final int VERIFYING = 1;
    public static final int PATCHING = 2;
    private long completed;
    private long total;
    private int percent;
    private URL url;
    private String version;
    private String resourceLabel;
    private int downloadtype;
    protected boolean isStart = false;
    protected boolean isComplete = false;
    protected boolean isExplicit = false;
    private final String[] types = new String[]{"load", "verify", "patch"};

    public DownloadEvent(int n, URL uRL, String string, String string2, long l, long l2, int n2) {
        super(3);
        this.downloadtype = n;
        this.url = uRL;
        this.version = string;
        this.resourceLabel = string2;
        this.completed = l;
        this.total = l2;
        this.percent = n2;
    }

    public void normalize(int n) {
        if (n >= 100 || this.percent >= 100) {
            this.percent = 100;
            return;
        }
        if (n < 0) {
            Trace.println("warning: progress baseline could not be negative!", TraceLevel.PRELOADER);
            return;
        }
        if (this.percent < n) {
            Trace.println("warning: progress baseline above the progress value! " + this.percent + " < " + n, TraceLevel.PRELOADER);
            this.percent = 0;
            return;
        }
        this.percent = 100 * (this.percent - n) / (100 - n);
        if (this.percent == 0) {
            this.percent = 1;
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getResourceLabel() {
        return this.resourceLabel;
    }

    public int getDownloadType() {
        return this.downloadtype;
    }

    public long getCompletedCount() {
        return this.completed;
    }

    public long getTotalCount() {
        return this.total;
    }

    public int getOverallPercentage() {
        return this.percent;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isExplicit() {
        return this.isExplicit;
    }

    public void sendExplicitEvent(boolean bl) {
        this.isExplicit = bl;
    }

    public String toString() {
        return "DownloadEvent[type=" + this.types[this.downloadtype] + ",loaded=" + this.getCompletedCount() + ", total=" + this.getTotalCount() + ", percent=" + this.getOverallPercentage() + "]";
    }
}

