/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class StringEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
    private boolean editable = true;
    private String instructions = null;
    private boolean oneline = false;
    private boolean customEd = true;
    private PropertyEnv env;
    private String nullValue;

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public String getAsText() {
        Object object = this.getValue();
        if (object != null) {
            return object.toString();
        }
        return this.nullValue != null ? this.nullValue : NbBundle.getMessage(StringEditor.class, (String)"CTL_NullValue");
    }

    @Override
    public void setAsText(String string) {
        if ("null".equals(string) && this.getValue() == null) {
            return;
        }
        if (this.nullValue != null && this.nullValue.equals(string)) {
            this.setValue(null);
            return;
        }
        this.setValue(string);
    }

    @Override
    public String getJavaInitializationString() {
        String string = (String)this.getValue();
        return "\"" + StringEditor.toAscii(string) + "\"";
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    @Override
    public Component getCustomEditor() {
        Object object = this.getValue();
        String string = "";
        if (object != null) {
            string = object instanceof String ? (String)object : object.toString();
        }
        return new StringCustomEditor(string, this.isEditable(), this.oneline, this.instructions, this, this.env);
    }

    private static String toAscii(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 6);
        char[] cArray = string.toCharArray();
        block9: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        stringBuilder.append(c);
                        continue block9;
                    }
                    stringBuilder.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        this.readEnv(propertyEnv.getFeatureDescriptor());
    }

    void readEnv(FeatureDescriptor featureDescriptor) {
        Object object;
        if (featureDescriptor instanceof Node.Property) {
            object = (Node.Property)featureDescriptor;
            this.editable = object.canWrite();
            this.instructions = (String)object.getValue("instructions");
            this.oneline = Boolean.TRUE.equals(object.getValue("oneline"));
            boolean bl = this.customEd = !Boolean.TRUE.equals(object.getValue("suppressCustomEditor"));
        }
        this.nullValue = Boolean.TRUE.equals(object = featureDescriptor.getValue("nullValue")) ? NbBundle.getMessage(StringEditor.class, (String)"CTL_NullValue") : (object instanceof String ? (String)object : null);
    }
}

