/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class NbSheet
extends TopComponent {
    private static final Logger LOG = Logger.getLogger(NbSheet.class.getName());
    private static final String PROP_LONGER_DISPLAY_NAME = "longerDisplayName";
    static final long serialVersionUID = 7807519514644165460L;
    private static NbSheet sharedSheet;
    private final transient Listener listener;
    private final transient SheetNodesListener snListener;
    boolean global;
    private PropertySheet propertySheet;
    private Node[] nodes = new Node[0];
    private static MessageFormat globalPropertiesFormat;
    private static MessageFormat localPropertiesFormat;

    public NbSheet() {
        this(false);
    }

    public NbSheet(boolean bl) {
        this.global = bl;
        this.propertySheet = new PropertySheet();
        this.putClientProperty("NamingType", "BothOnlyCompName");
        this.setLayout(new BorderLayout());
        this.add((Component)this.propertySheet, "Center");
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/core/windows/resources/properties.gif", (boolean)true));
        this.updateTitle();
        this.putClientProperty("SlidingName", NbBundle.getMessage(NbSheet.class, (String)"CTL_PropertiesWindow"));
        this.listener = new Listener();
        this.snListener = new SheetNodesListener();
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(NbSheet.class).getString("ACSN_PropertiesSheet"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NbSheet.class).getString("ACSD_PropertiesSheet"));
        this.setActivatedNodes(null);
    }

    public static NbSheet findDefault() {
        if (sharedSheet == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("properties");
            if (topComponent != null) {
                if (topComponent instanceof NbSheet) {
                    sharedSheet = (NbSheet)topComponent;
                } else {
                    IllegalStateException illegalStateException = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + NbSheet.class.getName() + " Returned:" + topComponent.getClass().getName());
                    Logger.getLogger(NbSheet.class.getName()).log(Level.WARNING, null, illegalStateException);
                    NbSheet.getDefault();
                }
            } else {
                NbSheet.getDefault();
            }
        }
        return sharedSheet;
    }

    protected String preferredID() {
        return "properties";
    }

    public static NbSheet getDefault() {
        if (sharedSheet == null) {
            sharedSheet = new NbSheet(true);
        }
        return sharedSheet;
    }

    public int getPersistenceType() {
        return 0;
    }

    public HelpCtx getHelpCtx() {
        return this.global ? ExplorerUtils.getHelpCtx((Node[])this.nodes, (HelpCtx)new HelpCtx(NbSheet.class)) : null;
    }

    @Deprecated
    public void requestFocus() {
        super.requestFocus();
        this.propertySheet.requestFocus();
    }

    @Deprecated
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.propertySheet.requestFocusInWindow();
    }

    public void open() {
        super.open();
        if (this.global) {
            SwingUtilities.invokeLater(this.listener);
        }
    }

    protected void updateTitle() {
        Object[] objectArray;
        Mode mode = WindowManager.getDefault().findMode((TopComponent)this);
        String string = null;
        ArrayList<Node> arrayList = new ArrayList<Node>(Arrays.asList(this.nodes));
        Node node = null;
        if (!arrayList.isEmpty()) {
            node = (Node)arrayList.get(0);
        }
        if (node == null) {
            string = "";
        } else {
            string = node.getDisplayName();
            objectArray = node.getValue(PROP_LONGER_DISPLAY_NAME);
            if (objectArray instanceof String) {
                string = (String)objectArray;
            }
        }
        objectArray = new Object[]{arrayList.size(), string};
        if (mode != null && "properties".equals(mode.getName())) {
            if (globalPropertiesFormat == null) {
                globalPropertiesFormat = new MessageFormat(NbBundle.getMessage(NbSheet.class, (String)"CTL_FMT_GlobalProperties"));
            }
            this.setName(globalPropertiesFormat.format(objectArray));
        } else {
            if (localPropertiesFormat == null) {
                localPropertiesFormat = new MessageFormat(NbBundle.getMessage(NbSheet.class, (String)"CTL_FMT_LocalProperties"));
            }
            this.setName(localPropertiesFormat.format(objectArray));
        }
        this.setToolTipText(this.getName());
    }

    public void setNodes(Node[] nodeArray) {
        this.setNodes(nodeArray, true, "setNodes");
    }

    final void setNodes(Node[] nodeArray, boolean bl, String string) {
        LOG.log(Level.FINE, "setNodes({0}, {1}, {2})", new Object[]{Arrays.asList(nodeArray), bl, string});
        this.nodes = nodeArray;
        this.propertySheet.setNodes(nodeArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbSheet.this.updateTitle();
            }
        });
        if (bl) {
            this.snListener.detach();
            this.snListener.attach(nodeArray);
        }
        LOG.log(Level.FINE, "finished setNodes({0}, {1}, {2})", new Object[]{Arrays.asList(nodeArray), bl, string});
    }

    final Node[] getNodes() {
        return this.nodes;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.global) {
            objectOutput.writeObject(null);
        } else {
            Node.Handle[] handleArray = NodeOp.toHandles((Node[])this.nodes);
            objectOutput.writeObject(handleArray);
        }
        objectOutput.writeBoolean(this.global);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(objectInput);
        }
        catch (SafeException safeException) {
            // empty catch block
        }
        Object object = objectInput.readObject();
        if (object instanceof NbMarshalledObject || object instanceof ExplorerManager) {
            this.global = (Boolean)objectInput.readObject();
        } else {
            Node[] nodeArray;
            if (object == null) {
                nodeArray = TopComponent.getRegistry().getActivatedNodes();
            } else {
                Node.Handle[] handleArray = (Node.Handle[])object;
                try {
                    nodeArray = NodeOp.fromHandles((Node.Handle[])handleArray);
                }
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getBundle(NbSheet.class).getString("EXC_CannotLoadNodes"));
                    Logger.getLogger(NbSheet.class.getName()).log(Level.WARNING, null, iOException);
                    nodeArray = new Node[]{};
                }
            }
            this.global = objectInput.readBoolean();
            this.setNodes(nodeArray, true, "readExternal");
        }
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.global) {
            return NbSheet.getDefault();
        }
        if (this.nodes == null || this.nodes.length <= 0) {
            return null;
        }
        return this;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.global) {
            return new Replacer();
        }
        return super.writeReplace();
    }

    private void updateGlobalListening(boolean bl) {
        if (this.global) {
            if (bl) {
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.listener);
            } else {
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.listener);
            }
        }
    }

    protected void componentOpened() {
        this.updateGlobalListening(true);
    }

    protected void componentClosed() {
        this.updateGlobalListening(false);
        this.setNodes(new Node[0], true, "componentClosed");
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        if (Utilities.isMac()) {
            this.propertySheet.firePropertyChange("MACOSX", true, false);
        }
    }

    static {
        globalPropertiesFormat = null;
        localPropertiesFormat = null;
    }

    private class SheetNodesListener
    extends NodeAdapter
    implements Runnable {
        private HashMap<Node, NodeListener> listenerMap;
        private HashMap<Node, PropertyChangeListener> pListenerMap;

        SheetNodesListener() {
        }

        public void nodeDestroyed(final NodeEvent nodeEvent) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    SheetNodesListener.this.handleNodeDestroyed(nodeEvent);
                }
            });
        }

        final void handleNodeDestroyed(NodeEvent nodeEvent) {
            assert (EventQueue.isDispatchThread());
            Node node = nodeEvent.getNode();
            NodeListener nodeListener = this.listenerMap.get(node);
            PropertyChangeListener propertyChangeListener = this.pListenerMap.get(node);
            node.removeNodeListener(nodeListener);
            node.removePropertyChangeListener(propertyChangeListener);
            this.listenerMap.remove(node);
            this.pListenerMap.remove(node);
            if (this.listenerMap.isEmpty() && !NbSheet.this.global) {
                NbSheet.this.close();
            } else {
                NbSheet.this.setNodes(this.listenerMap.keySet().toArray(new Node[this.listenerMap.size()]), false, "handleNodeDestroyed");
            }
        }

        public void attach(Node[] nodeArray) {
            assert (EventQueue.isDispatchThread());
            this.listenerMap = new HashMap(nodeArray.length * 2);
            this.pListenerMap = new HashMap(nodeArray.length * 2);
            NodeListener nodeListener = null;
            PropertyChangeListener propertyChangeListener = null;
            for (Node node : nodeArray) {
                nodeListener = NodeOp.weakNodeListener((NodeListener)this, (Object)node);
                propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)((Object)this), (Object)node);
                this.listenerMap.put(node, nodeListener);
                this.pListenerMap.put(node, propertyChangeListener);
                node.addNodeListener(nodeListener);
                node.addPropertyChangeListener(propertyChangeListener);
            }
        }

        public void detach() {
            assert (EventQueue.isDispatchThread());
            if (this.listenerMap == null) {
                return;
            }
            for (Map.Entry<Node, NodeListener> entry : this.listenerMap.entrySet()) {
                entry.getKey().removeNodeListener(entry.getValue());
            }
            for (Map.Entry<Node, Object> entry : this.pListenerMap.entrySet()) {
                entry.getKey().removePropertyChangeListener((PropertyChangeListener)entry.getValue());
            }
            this.listenerMap = null;
            this.pListenerMap = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            assert (EventQueue.isDispatchThread());
            NbSheet.this.updateTitle();
        }
    }

    private class Listener
    implements Runnable,
    PropertyChangeListener {
        Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("activatedNodes".equals(propertyChangeEvent.getPropertyName())) {
                this.activate();
            }
        }

        @Override
        public void run() {
            this.activate();
        }

        public void activate() {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
            LOG.log(Level.FINE, "Active component {0}", topComponent);
            NbSheet.this.setNodes(nodeArray, true, "activate");
        }
    }

    private static final class Replacer
    implements Serializable {
        static final long serialVersionUID = -7897067133215740572L;

        Replacer() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NbSheet.getDefault();
        }
    }
}

