/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.ui.ResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.utils.FloatSorter;
import org.netbeans.lib.profiler.utils.IntSorter;
import org.netbeans.lib.profiler.utils.LongSorter;
import org.netbeans.lib.profiler.utils.StringSorter;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class MemoryResultsPanel
extends ResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String DEFAULT_FILTER_HINT = messages.getString("MemoryResultsPanel_DefaultFilterHint");
    private static final String STARTS_WITH_FILTER_NAME = messages.getString("MemoryResultsPanel_StartsWithFilterName");
    private static final String CONTAINS_FILTER_NAME = messages.getString("MemoryResultsPanel_ContainsFilterName");
    private static final String ENDS_WITH_FILTER_NAME = messages.getString("MemoryResultsPanel_EndsWithFilterName");
    private static final String REGEXP_FILTER_NAME = messages.getString("MemoryResultsPanel_RegExpFilterName");
    protected ArrayList filteredToFullIndexes;
    protected CustomBarCellRenderer barRenderer;
    protected ExtendedTableModel resTableModel;
    protected FilterComponent filterComponent;
    protected JButton cornerButton;
    protected JExtendedTable resTable;
    protected JPopupMenu headerPopup;
    protected JScrollPane jScrollPane;
    protected MemoryResUserActionsHandler actionsHandler;
    protected String filterString = "";
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected Class[] columnTypes;
    protected int[] columnWidths;
    protected int[] sortedClassIds;
    protected String[] sortedClassNames;
    protected boolean registeredMouseListenerWithResTable;
    protected boolean sortOrder;
    protected double valueFilterValue = 0.0;
    protected int clickedLine;
    protected int filterType = 20;
    protected int nDisplayedItems;
    protected int nInfoLines;
    protected int nTrackedItems;
    protected int selectedClassId;
    protected int sortBy;
    protected long maxValue;
    protected long totalAllocations;

    public MemoryResultsPanel(MemoryResUserActionsHandler memoryResUserActionsHandler) {
        this.actionsHandler = memoryResUserActionsHandler;
        this.filteredToFullIndexes = new ArrayList();
        this.headerPopup = new JPopupMenu();
        this.jScrollPane = this.createScrollPaneVerticalScrollBarAlways();
        this.jScrollPane.setCorner("UPPER_RIGHT_CORNER", this.createHeaderPopupCornerButton(this.headerPopup));
        this.initFilterPanel();
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (this.resTable == null) {
            return null;
        }
        if (bl) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public void setFindString(String string) {
        this.resTable.setFindParameters(string, 0);
    }

    public String getFindString() {
        return this.resTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.resTable.isFindStringDefined();
    }

    public boolean findFirst() {
        return this.resTable.findFirst();
    }

    public boolean findNext() {
        return this.resTable.findNext();
    }

    public boolean findPrevious() {
        return this.resTable.findPrevious();
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void prepareResults() {
        final JExtendedTable jExtendedTable = this.getResultsTable();
        this.resTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.resTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryResultsPanel.this.performDefaultAction(MemoryResultsPanel.this.selectedClassId);
            }
        });
        this.jScrollPane.setViewportView(jExtendedTable);
        this.jScrollPane.getViewport().setBackground(jExtendedTable.getBackground());
        if (!this.registeredMouseListenerWithResTable) {
            this.jScrollPane.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    jExtendedTable.mouseWheelMoved(mouseWheelEvent);
                }
            });
            jExtendedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = jExtendedTable.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    MemoryResultsPanel.this.selectedClassId = MemoryResultsPanel.this.sortedClassIds[(Integer)MemoryResultsPanel.this.filteredToFullIndexes.get(n)];
                }
            });
            jExtendedTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = jExtendedTable.getSelectedRow()) != -1) {
                        MemoryResultsPanel.this.selectedClassId = MemoryResultsPanel.this.sortedClassIds[(Integer)MemoryResultsPanel.this.filteredToFullIndexes.get(n)];
                        Rectangle rectangle = jExtendedTable.getCellRect(n, 0, false);
                        JPopupMenu jPopupMenu = MemoryResultsPanel.this.getPopupMenu();
                        if (jPopupMenu != null) {
                            jPopupMenu.show(keyEvent.getComponent(), rectangle.x + jExtendedTable.getSize().width > 50 ? 50 : 5, rectangle.y);
                        }
                    }
                }
            });
            jExtendedTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getModifiers() == 4 && (n = jExtendedTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
                        jExtendedTable.setRowSelectionInterval(n, n);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    MemoryResultsPanel.this.clickedLine = jExtendedTable.rowAtPoint(mouseEvent.getPoint());
                    if (MemoryResultsPanel.this.clickedLine != -1) {
                        MemoryResultsPanel.this.resTable.getSelectionModel().setSelectionInterval(MemoryResultsPanel.this.clickedLine, MemoryResultsPanel.this.clickedLine);
                        MemoryResultsPanel.this.selectedClassId = MemoryResultsPanel.this.sortedClassIds[(Integer)MemoryResultsPanel.this.filteredToFullIndexes.get(MemoryResultsPanel.this.clickedLine)];
                        if (mouseEvent.getModifiers() == 4) {
                            JPopupMenu jPopupMenu = MemoryResultsPanel.this.getPopupMenu();
                            if (jPopupMenu != null) {
                                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
                            MemoryResultsPanel.this.performDefaultAction(MemoryResultsPanel.this.selectedClassId);
                        }
                    }
                }
            });
            this.registeredMouseListenerWithResTable = true;
        }
    }

    @Override
    public void requestFocus() {
        if (this.resTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemoryResultsPanel.this.resTable.requestFocus();
                }
            });
        }
    }

    public void reset() {
        this.jScrollPane.setViewportView(null);
    }

    public void updateValueFilter(double d) {
        this.valueFilterValue = d / 3.0;
        this.createFilteredIndexes();
        this.resTable.invalidate();
        this.jScrollPane.revalidate();
        this.resTable.repaint();
    }

    protected abstract String getClassName(int var1);

    protected abstract String[] getClassNames();

    protected abstract JPopupMenu getPopupMenu();

    protected abstract JExtendedTable getResultsTable();

    protected void createFilteredIndexes() {
        this.filteredToFullIndexes.clear();
        for (int i = 0; i < this.nInfoLines; ++i) {
            if (!this.passesFilters(i) || !this.passesValueFilter(i)) continue;
            this.filteredToFullIndexes.add(i);
        }
        this.nDisplayedItems = this.filteredToFullIndexes.size();
    }

    protected final void doCreateClassNamesFromScratch() {
        String[] stringArray = this.getClassNames();
        if (this.sortedClassNames == null || this.sortedClassNames.length < stringArray.length) {
            this.sortedClassNames = new String[stringArray.length];
            this.sortedClassIds = new int[stringArray.length];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.sortedClassNames[i] = StringUtils.userFormClassName((String)stringArray[i]);
            this.sortedClassIds[i] = i;
        }
    }

    protected void initDataUponResultsFetch() {
        if (this.barRenderer != null) {
            this.barRenderer.setMaximum(this.maxValue);
        }
        this.doCreateClassNamesFromScratch();
    }

    protected boolean passesValueFilter(int n) {
        return true;
    }

    protected abstract void performDefaultAction(int var1);

    protected void showSourceForClass(int n) {
        if (n < 0) {
            return;
        }
        String string = this.getClassName(n);
        string = string.replace("[", "");
        string = string.replace("/", ".");
        this.actionsHandler.showSourceForMethod(string, null, null);
    }

    protected int sortResults(final int[] nArray, final int[][] nArray2, final long[][] lArray, final float[][] fArray, int n, int n2, boolean bl) {
        final int n3 = nArray2 != null ? nArray2.length : 0;
        final int n4 = lArray != null ? lArray.length : 0;
        final int n5 = fArray != null ? fArray.length : 0;
        new IntSorter(nArray, n, n2){

            protected void swap(int n, int n2) {
                if (nArray[n] != nArray[n2]) {
                    int n32;
                    super.swap(n, n2);
                    String string = MemoryResultsPanel.this.sortedClassNames[n];
                    MemoryResultsPanel.this.sortedClassNames[n] = MemoryResultsPanel.this.sortedClassNames[n2];
                    MemoryResultsPanel.this.sortedClassNames[n2] = string;
                    int n42 = MemoryResultsPanel.this.sortedClassIds[n];
                    MemoryResultsPanel.this.sortedClassIds[n] = MemoryResultsPanel.this.sortedClassIds[n2];
                    MemoryResultsPanel.this.sortedClassIds[n2] = n42;
                    for (n32 = 0; n32 < n3; ++n32) {
                        n42 = nArray2[n32][n];
                        nArray2[n32][n] = nArray2[n32][n2];
                        nArray2[n32][n2] = n42;
                    }
                    for (n32 = 0; n32 < n4; ++n32) {
                        long l = lArray[n32][n];
                        lArray[n32][n] = lArray[n32][n2];
                        lArray[n32][n2] = l;
                    }
                    for (n32 = 0; n32 < n5; ++n32) {
                        float f = fArray[n32][n];
                        fArray[n32][n] = fArray[n32][n2];
                        fArray[n32][n2] = f;
                    }
                }
            }
        }.sort(this.sortOrder);
        n2 = n + n2;
        return n2;
    }

    protected int sortResults(final long[] lArray, final int[][] nArray, final long[][] lArray2, final float[][] fArray, int n, int n2, boolean bl) {
        final int n3 = nArray != null ? nArray.length : 0;
        final int n4 = lArray2 != null ? lArray2.length : 0;
        final int n5 = fArray != null ? fArray.length : 0;
        new LongSorter(lArray, n, n2){

            protected void swap(int n, int n2) {
                if (lArray[n] != lArray[n2]) {
                    int n32;
                    super.swap(n, n2);
                    String string = MemoryResultsPanel.this.sortedClassNames[n];
                    MemoryResultsPanel.this.sortedClassNames[n] = MemoryResultsPanel.this.sortedClassNames[n2];
                    MemoryResultsPanel.this.sortedClassNames[n2] = string;
                    int n42 = MemoryResultsPanel.this.sortedClassIds[n];
                    MemoryResultsPanel.this.sortedClassIds[n] = MemoryResultsPanel.this.sortedClassIds[n2];
                    MemoryResultsPanel.this.sortedClassIds[n2] = n42;
                    for (n32 = 0; n32 < n3; ++n32) {
                        n42 = nArray[n32][n];
                        nArray[n32][n] = nArray[n32][n2];
                        nArray[n32][n2] = n42;
                    }
                    for (n32 = 0; n32 < n4; ++n32) {
                        long l = lArray2[n32][n];
                        lArray2[n32][n] = lArray2[n32][n2];
                        lArray2[n32][n2] = l;
                    }
                    for (n32 = 0; n32 < n5; ++n32) {
                        float f = fArray[n32][n];
                        fArray[n32][n] = fArray[n32][n2];
                        fArray[n32][n2] = f;
                    }
                }
            }
        }.sort(this.sortOrder);
        n2 = n + n2;
        return n2;
    }

    protected int sortResults(final float[] fArray, final int[][] nArray, final long[][] lArray, int n, int n2, boolean bl) {
        final int n3 = nArray != null ? nArray.length : 0;
        final int n4 = lArray != null ? lArray.length : 0;
        new FloatSorter(fArray, n, n2){

            protected void swap(int n, int n2) {
                if (fArray[n] != fArray[n2]) {
                    int n32;
                    super.swap(n, n2);
                    String string = MemoryResultsPanel.this.sortedClassNames[n];
                    MemoryResultsPanel.this.sortedClassNames[n] = MemoryResultsPanel.this.sortedClassNames[n2];
                    MemoryResultsPanel.this.sortedClassNames[n2] = string;
                    int n42 = MemoryResultsPanel.this.sortedClassIds[n];
                    MemoryResultsPanel.this.sortedClassIds[n] = MemoryResultsPanel.this.sortedClassIds[n2];
                    MemoryResultsPanel.this.sortedClassIds[n2] = n42;
                    for (n32 = 0; n32 < n3; ++n32) {
                        n42 = nArray[n32][n];
                        nArray[n32][n] = nArray[n32][n2];
                        nArray[n32][n2] = n42;
                    }
                    for (n32 = 0; n32 < n4; ++n32) {
                        long l = lArray[n32][n];
                        lArray[n32][n] = lArray[n32][n2];
                        lArray[n32][n2] = l;
                    }
                }
            }
        }.sort(this.sortOrder);
        n2 = n + n2;
        return n2;
    }

    protected int sortResultsByClassName(final int[][] nArray, final long[][] lArray, final float[][] fArray, int n, boolean bl) {
        int n2;
        if (n == 0) {
            return 0;
        }
        final int n3 = nArray != null ? nArray.length : 0;
        final int n4 = lArray != null ? lArray.length : 0;
        int n5 = n2 = fArray != null ? fArray.length : 0;
        if (bl) {
            int n6 = 0;
            for (int i = n - 1; n6 < i; ++n6, --i) {
                int n7;
                while (nArray[0][i] == 0 && i > n6) {
                    --i;
                }
                if (i <= n6) break;
                while (nArray[0][n6] != 0 && n6 < i) {
                    ++n6;
                }
                if (n6 >= i) break;
                String string = this.sortedClassNames[n6];
                this.sortedClassNames[n6] = this.sortedClassNames[i];
                this.sortedClassNames[i] = string;
                int n8 = this.sortedClassIds[n6];
                this.sortedClassIds[n6] = this.sortedClassIds[i];
                this.sortedClassIds[i] = n8;
                for (n7 = 0; n7 < n3; ++n7) {
                    n8 = nArray[n7][n6];
                    nArray[n7][n6] = nArray[n7][i];
                    nArray[n7][i] = n8;
                }
                for (n7 = 0; n7 < n4; ++n7) {
                    long l = lArray[n7][n6];
                    lArray[n7][n6] = lArray[n7][i];
                    lArray[n7][i] = l;
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    float f = fArray[n7][n6];
                    fArray[n7][n6] = fArray[n7][i];
                    fArray[n7][i] = f;
                }
            }
            if (nArray[0][n = n6] != 0) {
                ++n;
            }
        }
        new StringSorter(this.sortedClassNames, 0, n){

            protected void swap(int n, int n22) {
                int n32;
                super.swap(n, n22);
                int n42 = MemoryResultsPanel.this.sortedClassIds[n];
                MemoryResultsPanel.this.sortedClassIds[n] = MemoryResultsPanel.this.sortedClassIds[n22];
                MemoryResultsPanel.this.sortedClassIds[n22] = n42;
                for (n32 = 0; n32 < n3; ++n32) {
                    n42 = nArray[n32][n];
                    nArray[n32][n] = nArray[n32][n22];
                    nArray[n32][n22] = n42;
                }
                for (n32 = 0; n32 < n4; ++n32) {
                    long l = lArray[n32][n];
                    lArray[n32][n] = lArray[n32][n22];
                    lArray[n32][n22] = l;
                }
                for (n32 = 0; n32 < n2; ++n32) {
                    float f = fArray[n32][n];
                    fArray[n32][n] = fArray[n32][n22];
                    fArray[n32][n22] = f;
                }
            }
        }.sort(this.sortOrder);
        return n;
    }

    protected boolean truncateZeroItems() {
        return true;
    }

    private void initFilterPanel() {
        this.filterComponent = new FilterComponent();
        this.filterComponent.setEmptyFilterText(DEFAULT_FILTER_HINT);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterStartsWith"), STARTS_WITH_FILTER_NAME, 10);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterContains"), CONTAINS_FILTER_NAME, 20);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterEndsWith"), ENDS_WITH_FILTER_NAME, 30);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterRegExp"), REGEXP_FILTER_NAME, 50);
        this.filterComponent.setFilterValues(this.filterString, this.filterType);
        this.filterComponent.addFilterListener(new FilterComponent.FilterListener(){

            @Override
            public void filterChanged() {
                String string = null;
                int n = MemoryResultsPanel.this.resTable.getSelectedRow();
                if (n != -1) {
                    string = (String)MemoryResultsPanel.this.resTable.getValueAt(n, 0);
                }
                MemoryResultsPanel.this.filterString = MemoryResultsPanel.this.filterComponent.getFilterString();
                MemoryResultsPanel.this.filterType = MemoryResultsPanel.this.filterComponent.getFilterType();
                MemoryResultsPanel.this.createFilteredIndexes();
                MemoryResultsPanel.this.resTable.invalidate();
                MemoryResultsPanel.this.jScrollPane.revalidate();
                MemoryResultsPanel.this.resTable.repaint();
                if (string != null) {
                    MemoryResultsPanel.this.resTable.selectRowByContents(string, 0, true);
                }
            }
        });
        this.add((Component)this.filterComponent, "South");
    }

    private boolean passesFilter(int n, String string) {
        String string2 = this.sortedClassNames[n];
        if ("".equals(string)) {
            return true;
        }
        switch (this.filterType) {
            case 10: {
                return string2.regionMatches(true, 0, string, 0, string.length());
            }
            case 20: {
                return string2.toLowerCase().indexOf(string.toLowerCase()) != -1;
            }
            case 30: {
                return string2.regionMatches(true, string2.length() - string.length(), string, 0, string.length());
            }
            case 40: {
                return string2.equalsIgnoreCase(string);
            }
            case 50: {
                return string2.matches(string);
            }
        }
        return false;
    }

    private boolean passesFilters(int n) {
        if (this.filterType == 0) {
            return true;
        }
        String[] stringArray = FilterComponent.getFilterStrings(this.filterString);
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.passesFilter(n, stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

