/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.SimpleLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.CompoundXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.DecimalXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemMarker;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;

public final class ThreadsGraphPanel
extends GraphPanel {
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final boolean smallPanel;

    public static ThreadsGraphPanel createBigPanel(VMTelemetryModels vMTelemetryModels) {
        return new ThreadsGraphPanel(vMTelemetryModels, false, null);
    }

    public static ThreadsGraphPanel createSmallPanel(VMTelemetryModels vMTelemetryModels, Action action) {
        return new ThreadsGraphPanel(vMTelemetryModels, true, action);
    }

    private ThreadsGraphPanel(VMTelemetryModels vMTelemetryModels, boolean bl, Action action) {
        this.models = vMTelemetryModels;
        this.smallPanel = bl;
        this.initComponents(action);
        vMTelemetryModels.getDataManager().addDataListener(new DataManagerListener(){

            public void dataChanged() {
                ThreadsGraphPanel.this.updateData();
            }

            public void dataReset() {
                ThreadsGraphPanel.this.resetData();
            }
        });
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    private void updateData() {
        VMTelemetryDataManager vMTelemetryDataManager;
        long[] lArray;
        if (this.smallPanel && this.chart.fitsWidth() && (lArray = vMTelemetryDataManager.timeStamps)[(vMTelemetryDataManager = this.models.getDataManager()).getItemCount() - 1] - lArray[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 3L));
    }

    private void initComponents(final Action action) {
        PaintersModel paintersModel = this.createThreadsPaintersModel();
        this.chart = this.createChart(this.models.threadsItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        AxisComponent axisComponent = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.threadsItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 5, 2);
        SynchronousXYItem synchronousXYItem = this.models.threadsItemsModel().getItem(0);
        XYItemPainter xYItemPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem);
        SimpleLongMarksPainter simpleLongMarksPainter = new SimpleLongMarksPainter();
        simpleLongMarksPainter.setForeground(GraphsUI.THREADS_PAINTER_LINE_COLOR);
        AxisComponent axisComponent2 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)synchronousXYItem, xYItemPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)simpleLongMarksPainter, 7, 2);
        SynchronousXYItem synchronousXYItem2 = this.models.threadsItemsModel().getItem(1);
        XYItemPainter xYItemPainter2 = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem2);
        SimpleLongMarksPainter simpleLongMarksPainter2 = new SimpleLongMarksPainter();
        simpleLongMarksPainter2.setForeground(GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR);
        AxisComponent axisComponent3 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)synchronousXYItem2, xYItemPainter2, this.chart.getChartContext(), 1), (AxisMarksPainter)simpleLongMarksPainter2, 3, 0);
        JPanel jPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        jPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, GraphsUI.CHART_BACKGROUND_COLOR));
        jPanel.add((Component)((Object)this.chart), new Integer[]{0});
        jPanel.add((Component)axisComponent, new Integer[]{5, 4, 6});
        jPanel.add((Component)axisComponent2, new Integer[]{7, 6});
        jPanel.add((Component)axisComponent3, new Integer[]{3, 4});
        if (this.smallPanel) {
            this.chart.setMouseZoomingEnabled(false);
            this.chart.getSelectionModel().setHoverMode(100);
            JLabel jLabel = new JLabel(GraphsUI.THREADS_NAME, new ColorIcon(GraphsUI.THREADS_PAINTER_LINE_COLOR, null, 8, 8), 10);
            jLabel.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JLabel jLabel2 = new JLabel(GraphsUI.LOADED_CLASSES_NAME, new ColorIcon(GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR, null, 8, 8), 10);
            jLabel2.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 1));
            jPanel2.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            jPanel2.setBorder(new LineBorder(GraphsUI.SMALL_LEGEND_BORDER_COLOR, 1));
            jPanel2.add(jLabel);
            jPanel2.add(jLabel2);
            JPanel jPanel3 = new JPanel(new FlowLayout(1));
            jPanel3.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            jPanel3.add(jPanel2);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel3, "South");
            this.chart.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                        action.actionPerformed(null);
                    }
                }
            });
            this.chartActions = new Action[0];
        } else {
            ProfilerXYTooltipPainter profilerXYTooltipPainter = new ProfilerXYTooltipPainter(2.1f, GraphsUI.TOOLTIP_OVERLAY_LINE_COLOR, GraphsUI.TOOLTIP_OVERLAY_FILL_COLOR, this.getTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, profilerXYTooltipPainter));
            JScrollBar jScrollBar = new JScrollBar(0);
            this.chart.attachHorizontalScrollBar(jScrollBar);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(new BevelBorder(1));
            jPanel4.add((Component)jPanel, "Center");
            jPanel4.add((Component)jScrollBar, "South");
            JLabel jLabel = new JLabel(GraphsUI.THREADS_NAME, new ColorIcon(GraphsUI.THREADS_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel jLabel3 = new JLabel(GraphsUI.LOADED_CLASSES_NAME, new ColorIcon(GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel jPanel5 = new JPanel(new FlowLayout(4, 10, 10));
            jPanel5.add(jLabel);
            jPanel5.add(jLabel3);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel4, "Center");
            this.add((Component)jPanel5, "South");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long l) {
                return GraphPanel.DATE_FORMATTER.format(new Date(l));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.THREADS_NAME;
                    }
                    case 1: {
                        return GraphsUI.LOADED_CLASSES_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.THREADS_PAINTER_LINE_COLOR;
                    }
                    case 1: {
                        return GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int n, long l) {
                return GraphPanel.INT_FORMATTER.format(l);
            }

            @Override
            public String getRowUnits(int n, long l) {
                return "";
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int n) {
                return ThreadsGraphPanel.this.getMaxValueString(this.getRowName(n));
            }

            @Override
            public Color getExtraRowColor(int n) {
                return this.getRowColor(n);
            }

            @Override
            public String getExtraRowValue(int n) {
                SynchronousXYItem synchronousXYItem = ThreadsGraphPanel.this.models.threadsItemsModel().getItem(n);
                return GraphPanel.INT_FORMATTER.format(synchronousXYItem.getMaxYValue());
            }

            @Override
            public String getExtraRowUnits(int n) {
                return this.getRowUnits(n, -1L);
            }
        };
    }

    private PaintersModel createThreadsPaintersModel() {
        SynchronousXYItemPainter synchronousXYItemPainter = SynchronousXYItemPainter.absolutePainter((float)3.0f, (Color)GraphsUI.THREADS_PAINTER_LINE_COLOR, (Color)GraphsUI.THREADS_PAINTER_FILL_COLOR);
        SynchronousXYItemMarker synchronousXYItemMarker = SynchronousXYItemMarker.absolutePainter((int)5, (float)0.75f, (Color)GraphsUI.THREADS_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.THREADS_MARKER_LINE2_COLOR, (Color)GraphsUI.THREADS_MARKER_FILL_COLOR);
        CompoundXYItemPainter compoundXYItemPainter = new CompoundXYItemPainter((XYItemPainter)synchronousXYItemPainter, (XYItemPainter)synchronousXYItemMarker);
        SynchronousXYItemPainter synchronousXYItemPainter2 = SynchronousXYItemPainter.relativePainter((float)3.0f, (Color)GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR, (Color)GraphsUI.LOADED_CLASSES_PAINTER_FILL_COLOR, (int)10);
        SynchronousXYItemMarker synchronousXYItemMarker2 = SynchronousXYItemMarker.relativePainter((int)5, (float)0.75f, (Color)GraphsUI.LOADED_CLASSES_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.LOADED_CLASSES_MARKER_LINE2_COLOR, (Color)GraphsUI.LOADED_CLASSES_MARKER_FILL_COLOR, (int)10);
        CompoundXYItemPainter compoundXYItemPainter2 = new CompoundXYItemPainter((XYItemPainter)synchronousXYItemPainter2, (XYItemPainter)synchronousXYItemMarker2);
        SynchronousXYItemsModel synchronousXYItemsModel = this.models.threadsItemsModel();
        PaintersModel.Default default_ = new PaintersModel.Default(new ChartItem[]{synchronousXYItemsModel.getItem(0), synchronousXYItemsModel.getItem(1)}, (ItemPainter[])new XYItemPainter[]{compoundXYItemPainter, compoundXYItemPainter2});
        return default_;
    }
}

