/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.outline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.CheckRenderDataProvider;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.RenderDataProvider;

public class DefaultOutlineCellRenderer
extends DefaultTableCellRenderer {
    private static int expansionHandleWidth = 0;
    private static int expansionHandleHeight = 0;
    private boolean expanded = false;
    private boolean leaf = true;
    private boolean showHandle = true;
    private int nestingDepth = 0;
    private final JCheckBox theCheckBox;
    private final CellRendererPane fakeCellRendererPane;
    private JCheckBox checkBox;
    private Reference<RenderDataProvider> lastRendererRef = new WeakReference<Object>(null);
    private Reference<Object> lastRenderedValueRef = new WeakReference<Object>(null);
    private static final Border expansionBorder = new ExpansionHandleBorder();
    private static final Class htmlRendererClass = DefaultOutlineCellRenderer.useSwingHtmlRendering() ? null : HtmlRenderer.getDelegate();
    private final HtmlRenderer.Renderer htmlRenderer = htmlRendererClass != null ? HtmlRenderer.access$100(htmlRendererClass) : null;
    private final boolean swingRendering = this.htmlRenderer == null;

    private static boolean useSwingHtmlRendering() {
        try {
            return Boolean.getBoolean("nb.useSwingHtmlRendering");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public DefaultOutlineCellRenderer() {
        this.theCheckBox = new JCheckBox();
        this.theCheckBox.setSize(this.theCheckBox.getPreferredSize());
        this.theCheckBox.setBorderPainted(false);
        this.theCheckBox.setOpaque(false);
        this.fakeCellRendererPane = new CellRendererPane();
        this.fakeCellRendererPane.add(this.theCheckBox);
    }

    @Override
    public final void setBorder(Border border) {
        if (!this.swingRendering) {
            super.setBorder(border);
            return;
        }
        if (border == expansionBorder) {
            super.setBorder(border);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(border, expansionBorder));
        }
    }

    @Override
    protected void setValue(Object object) {
        if (this.swingRendering) {
            super.setValue(object);
        }
    }

    private static Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    private static Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    private static Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    static Icon getExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    static Icon getCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    static int getNestingWidth() {
        return DefaultOutlineCellRenderer.getExpansionHandleWidth();
    }

    static int getExpansionHandleWidth() {
        if (expansionHandleWidth == 0) {
            expansionHandleWidth = DefaultOutlineCellRenderer.getExpandedIcon().getIconWidth();
        }
        return expansionHandleWidth;
    }

    static int getExpansionHandleHeight() {
        if (expansionHandleHeight == 0) {
            expansionHandleHeight = DefaultOutlineCellRenderer.getExpandedIcon().getIconHeight();
        }
        return expansionHandleHeight;
    }

    private void setNestingDepth(int n) {
        this.nestingDepth = n;
    }

    private void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    private void setLeaf(boolean bl) {
        this.leaf = bl;
    }

    private void setShowHandle(boolean bl) {
        this.showHandle = bl;
    }

    private void setCheckBox(JCheckBox jCheckBox) {
        this.checkBox = jCheckBox;
    }

    private boolean isLeaf() {
        return this.leaf;
    }

    private boolean isExpanded() {
        return this.expanded;
    }

    private boolean isShowHandle() {
        return this.showHandle;
    }

    private int getNestingDepth() {
        return this.nestingDepth;
    }

    private JCheckBox getCheckBox() {
        return this.checkBox;
    }

    int getTheCheckBoxWidth() {
        return this.theCheckBox.getSize().width;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Outline outline;
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        JLabel jLabel = null;
        if (!this.swingRendering) {
            jLabel = (JLabel)this.htmlRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        if ((outline = (Outline)jTable).isTreeColumnIndex(n2)) {
            int n3;
            object2 = outline.getLayoutCache();
            n = outline.convertRowIndexToModel(n);
            boolean bl3 = outline.getOutlineModel().isLeaf(object);
            this.setLeaf(bl3);
            this.setShowHandle(true);
            TreePath treePath = ((AbstractLayoutCache)object2).getPathForRow(n);
            boolean bl4 = ((AbstractLayoutCache)object2).isExpanded(treePath);
            this.setExpanded(bl4);
            int n4 = treePath == null ? 0 : (n3 = treePath.getPathCount() - (outline.isRootVisible() ? 1 : 2));
            if (n3 < 0) {
                n3 = 0;
            }
            this.setNestingDepth(n3);
            RenderDataProvider renderDataProvider = outline.getRenderDataProvider();
            Icon icon = null;
            if (renderDataProvider != null && object != null) {
                CheckRenderDataProvider checkRenderDataProvider;
                String string = renderDataProvider.getDisplayName(object);
                if (string != null) {
                    if (renderDataProvider.isHtmlDisplayName(object) && !string.startsWith("<html") && !string.startsWith("<HTML")) {
                        if (this.swingRendering) {
                            this.setText("<html>" + string.replaceAll(" ", "&nbsp;") + "</html>");
                        } else {
                            jLabel.setText("<html>" + string.replaceAll(" ", "&nbsp;") + "</html>");
                        }
                    } else if (this.swingRendering) {
                        this.setText(string);
                    } else {
                        jLabel.setText(string);
                    }
                }
                this.lastRendererRef = new WeakReference<RenderDataProvider>(renderDataProvider);
                this.lastRenderedValueRef = new WeakReference<Object>(object);
                Color color = renderDataProvider.getBackground(object);
                Color color2 = renderDataProvider.getForeground(object);
                if (color != null && !bl) {
                    if (this.swingRendering) {
                        this.setBackground(color);
                    } else {
                        jLabel.setBackground(color);
                    }
                } else if (this.swingRendering) {
                    this.setBackground(bl ? outline.getSelectionBackground() : outline.getBackground());
                } else {
                    jLabel.setBackground(bl ? outline.getSelectionBackground() : outline.getBackground());
                }
                if (color2 != null && !bl) {
                    if (this.swingRendering) {
                        this.setForeground(color2);
                    } else {
                        jLabel.setForeground(color2);
                    }
                } else if (this.swingRendering) {
                    this.setForeground(bl ? outline.getSelectionForeground() : outline.getForeground());
                } else {
                    jLabel.setForeground(bl ? outline.getSelectionForeground() : outline.getForeground());
                }
                icon = renderDataProvider.getIcon(object);
                JCheckBox jCheckBox = null;
                if (renderDataProvider instanceof CheckRenderDataProvider && (checkRenderDataProvider = (CheckRenderDataProvider)renderDataProvider).isCheckable(object)) {
                    jCheckBox = this.theCheckBox;
                    Boolean bl5 = checkRenderDataProvider.isSelected(object);
                    jCheckBox.setSelected(!Boolean.FALSE.equals(bl5));
                    jCheckBox.getModel().setArmed(bl5 == null);
                    jCheckBox.getModel().setPressed(bl5 == null);
                    jCheckBox.setEnabled(checkRenderDataProvider.isCheckEnabled(object));
                    jCheckBox.setBackground(this.getBackground());
                }
                this.setCheckBox(jCheckBox);
            }
            if (icon == null) {
                icon = !bl3 ? (bl4 ? DefaultOutlineCellRenderer.getDefaultOpenIcon() : DefaultOutlineCellRenderer.getDefaultClosedIcon()) : DefaultOutlineCellRenderer.getDefaultLeafIcon();
            }
            if (this.swingRendering) {
                this.setIcon(icon);
            } else {
                jLabel.setIcon(icon);
            }
        } else {
            if (this.swingRendering) {
                this.setIcon(null);
            } else {
                jLabel.setIcon(null);
            }
            this.setShowHandle(false);
        }
        if (this.swingRendering) {
            return this;
        }
        object2 = this.getBorder();
        if (object2 == null) {
            jLabel.setBorder(expansionBorder);
        } else {
            jLabel.setBorder(BorderFactory.createCompoundBorder((Border)object2, expansionBorder));
        }
        jLabel.setOpaque(true);
        jLabel.putClientProperty(DefaultOutlineCellRenderer.class, this);
        return jLabel;
    }

    @Override
    public String getToolTipText() {
        String string;
        RenderDataProvider renderDataProvider = this.lastRendererRef.get();
        Object object = this.lastRenderedValueRef.get();
        if (renderDataProvider != null && object != null && (string = renderDataProvider.getTooltipText(object)) != null && (string = string.trim()).length() > 0) {
            return string;
        }
        return super.getToolTipText();
    }

    private static final class HtmlRenderer {
        private static final String HTML_RENDERER_CLASS = "org.openide.awt.HtmlRenderer";

        private HtmlRenderer() {
        }

        static Class getDelegate() {
            Class<?> clazz;
            try {
                clazz = ClassLoader.getSystemClassLoader().loadClass(HTML_RENDERER_CLASS);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(HTML_RENDERER_CLASS);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    try {
                        Class<?> clazz2 = ClassLoader.getSystemClassLoader().loadClass("org.openide.util.Lookup");
                        try {
                            Object object = clazz2.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
                            ClassLoader classLoader = (ClassLoader)clazz2.getMethod("lookup", Class.class).invoke(object, ClassLoader.class);
                            if (classLoader == null) {
                                return null;
                            }
                            clazz = classLoader.loadClass(HTML_RENDERER_CLASS);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                            return null;
                        }
                        catch (SecurityException securityException) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                            return null;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                            return null;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                            return null;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                            return null;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        return null;
                    }
                    catch (SecurityException securityException) {
                        return null;
                    }
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
            catch (SecurityException securityException) {
                return null;
            }
            return clazz;
        }

        private static Renderer createRenderer(Class clazz) {
            try {
                Method method = clazz.getMethod("createRenderer", new Class[0]);
                return new Renderer(method.invoke(null, new Object[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
                return null;
            }
            catch (SecurityException securityException) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, securityException);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, invocationTargetException);
                return null;
            }
        }

        static /* synthetic */ Renderer access$100(Class clazz) {
            return HtmlRenderer.createRenderer(clazz);
        }

        private static class Renderer {
            private Object renderer;
            private Method getTableCellRendererComponent;

            private Renderer(Object object) throws NoSuchMethodException {
                this.renderer = object;
                this.getTableCellRendererComponent = TableCellRenderer.class.getMethod("getTableCellRendererComponent", JTable.class, Object.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE);
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                try {
                    return (Component)this.getTableCellRendererComponent.invoke(this.renderer, jTable, object, bl, bl2, n, n2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                    throw new IllegalStateException(illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                    throw new IllegalStateException(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(DefaultOutlineCellRenderer.class.getName()).log(Level.SEVERE, null, invocationTargetException);
                    throw new IllegalStateException(invocationTargetException);
                }
            }
        }
    }

    private static class ExpansionHandleBorder
    implements Border {
        private static final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());
        private Insets insets = new Insets(0, 0, 0, 0);
        private static JLabel lExpandedIcon = null;
        private static JLabel lCollapsedIcon = null;

        private ExpansionHandleBorder() {
            if (isGtk) {
                lExpandedIcon = new JLabel(DefaultOutlineCellRenderer.getExpandedIcon(), 11);
                lCollapsedIcon = new JLabel(DefaultOutlineCellRenderer.getCollapsedIcon(), 11);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)((JComponent)component).getClientProperty(DefaultOutlineCellRenderer.class);
            if (defaultOutlineCellRenderer == null) {
                defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)component;
            }
            if (defaultOutlineCellRenderer.isShowHandle()) {
                this.insets.left = DefaultOutlineCellRenderer.getExpansionHandleWidth() + defaultOutlineCellRenderer.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            } else {
                this.insets.left = 1;
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            }
            if (defaultOutlineCellRenderer.getCheckBox() != null) {
                this.insets.left += ((DefaultOutlineCellRenderer)defaultOutlineCellRenderer).getCheckBox().getSize().width;
            }
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Object object;
            int n5;
            Object object2;
            DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)((JComponent)component).getClientProperty(DefaultOutlineCellRenderer.class);
            if (defaultOutlineCellRenderer == null) {
                defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)component;
            }
            if (defaultOutlineCellRenderer.isShowHandle() && !defaultOutlineCellRenderer.isLeaf()) {
                object2 = defaultOutlineCellRenderer.isExpanded() ? DefaultOutlineCellRenderer.getExpandedIcon() : DefaultOutlineCellRenderer.getCollapsedIcon();
                int n6 = defaultOutlineCellRenderer.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                n5 = object2.getIconHeight() < n4 ? n4 / 2 - object2.getIconHeight() / 2 : 0;
                if (isGtk) {
                    object = defaultOutlineCellRenderer.isExpanded() ? lExpandedIcon : lCollapsedIcon;
                    ((Component)object).setSize(Math.max(DefaultOutlineCellRenderer.getExpansionHandleWidth(), n6 + DefaultOutlineCellRenderer.getExpansionHandleWidth()), n4);
                    ((JComponent)object).paint(graphics);
                } else {
                    object2.paintIcon(component, graphics, n6, n5);
                }
            }
            if ((object2 = defaultOutlineCellRenderer.getCheckBox()) != null) {
                n5 = DefaultOutlineCellRenderer.getExpansionHandleWidth() + defaultOutlineCellRenderer.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                Dimension dimension = ((Component)object2).getSize();
                object = graphics.create(n5, 0, dimension.width, dimension.height);
                ((JComponent)object2).paint((Graphics)object);
            }
        }
    }
}

