/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Image;
import java.io.CharConversionException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.ColorHighlighter;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

public class UnitDetails
extends DetailsPanel {
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitDetails");
    private RequestProcessor.Task unitDetailsTask = null;
    static final RequestProcessor UNIT_DETAILS_PROCESSOR = new RequestProcessor("unit-details-processor", 1, true);

    public UnitDetails() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UnitDetails"));
    }

    public void setUnit(Unit unit) {
        this.setUnit(unit, null);
    }

    public void setUnit(final Unit unit, Action action) {
        if (this.unitDetailsTask != null && !this.unitDetailsTask.isFinished()) {
            this.unitDetailsTask.cancel();
        }
        if (unit == null) {
            this.getDetails().setText("<i>" + UnitDetails.getBundle("UnitDetails_Category_NoDescription") + "</i>");
            this.setTitle(null);
        } else {
            try {
                this.setTitle(XMLUtil.toElementContent((String)unit.getDisplayName()));
            }
            catch (CharConversionException charConversionException) {
                this.err.log(Level.INFO, null, charConversionException);
                return;
            }
            this.setActionListener(action);
            this.setUnitText(unit, this.getUnitText(unit, false));
            if (unit instanceof Unit.Update) {
                this.unitDetailsTask = UNIT_DETAILS_PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final StringBuilder stringBuilder = UnitDetails.this.getUnitText(unit, true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UnitDetails.this.setUnitText(unit, stringBuilder);
                            }
                        });
                    }
                });
            }
        }
    }

    private void buildUnitText(Unit unit, StringBuilder stringBuilder, boolean bl) {
        Object object;
        Object object2;
        if (unit instanceof Unit.Available) {
            object2 = (Unit.Available)unit;
            object = ((Unit.Available)object2).getSourceIcon();
            Object object3 = ((Image)object).getProperty("url", null);
            String string = ((Unit.Available)object2).getSourceDescription();
            stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
            if (object3 instanceof URL) {
                stringBuilder.append("<td><img src=\"" + object3 + "\"></img></td>");
            }
            stringBuilder.append("<td></td>");
            stringBuilder.append("<td>&nbsp;&nbsp;</td>");
            stringBuilder.append("<td><b>" + string + "</b></td>");
            stringBuilder.append("</tr></table><br>");
        }
        if (Utilities.modulesOnly() || Utilities.showExtendedDescription()) {
            stringBuilder.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_CodeName") + "</b>" + unit.updateUnit.getCodeName());
            stringBuilder.append("<br>");
        }
        object2 = null;
        if (unit instanceof Unit.Update) {
            object = (Unit.Update)unit;
            stringBuilder.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_InstalledVersion") + "</b>" + ((Unit.Update)object).getInstalledVersion() + "<br>");
            stringBuilder.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_AvailableVersion") + "</b>" + ((Unit.Update)object).getAvailableVersion() + "<br>");
            object2 = this.getDependencies((Unit.Update)object, bl);
        } else {
            stringBuilder.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Version") + "</b>" + unit.getDisplayVersion() + "<br>");
        }
        if (unit.getAuthor() != null && unit.getAuthor().length() > 0) {
            stringBuilder.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Author") + "</b>" + unit.getAuthor() + "<br>");
        }
        if (unit.getDisplayDate() != null && unit.getDisplayDate().length() > 0) {
            stringBuilder.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Date") + "</b>" + unit.getDisplayDate() + "<br>");
        }
        stringBuilder.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Source") + "</b>" + unit.getSource() + "<br>");
        if (unit.getHomepage() != null && unit.getHomepage().length() > 0) {
            stringBuilder.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Homepage") + "</b><a href=\"" + unit.getHomepage() + "\">" + unit.getHomepage() + "</a><br>");
        }
        if (unit.getNotification() != null && unit.getNotification().length() > 0) {
            stringBuilder.append("<br><h3>" + UnitDetails.getBundle("UnitDetails_Plugin_Notification") + "</h3>");
            stringBuilder.append("<font color=\"red\">");
            stringBuilder.append(unit.getNotification());
            stringBuilder.append("</font><br>");
        }
        if (unit.getDescription() != null && unit.getDescription().length() > 0) {
            stringBuilder.append("<br><h3>" + UnitDetails.getBundle("UnitDetails_Plugin_Description") + "</h3>");
            object = unit.getDescription();
            if (((String)object).toLowerCase().startsWith("<html>")) {
                stringBuilder.append(((String)object).substring(6));
            } else {
                stringBuilder.append((String)object);
            }
        }
        if (object2 != null && ((String)object2).length() > 0) {
            stringBuilder.append("<br><br><h4>" + UnitDetails.getBundle("Unit_InternalUpdates_Title") + "</h4>");
            stringBuilder.append((String)object2);
        }
    }

    private void setUnitText(Unit unit, StringBuilder stringBuilder) {
        this.getDetails().setText(stringBuilder.toString());
        this.setUnitHighlighing(unit);
    }

    private StringBuilder getUnitText(Unit unit, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            try {
                this.buildUnitText(unit, stringBuilder, bl);
            }
            catch (IllegalStateException illegalStateException) {
                if (n > 100) {
                    throw illegalStateException;
                }
                Unit.log.log(Level.INFO, "Can't compute getUnitText for " + unit, illegalStateException);
                ++n;
                continue;
            }
            break;
        }
        return stringBuilder;
    }

    private void setUnitHighlighing(Unit unit) {
        Color color = Color.YELLOW;
        ColorHighlighter colorHighlighter = new ColorHighlighter(this.getDetails(), color);
        int n = colorHighlighter.highlight(unit.getFilter());
        this.getDetails().setCaretPosition(n > 0 ? n : 0);
    }

    private String getDependencies(Unit.Update update, boolean bl) {
        Iterator iterator;
        Object object2;
        Object object3;
        if (!bl) {
            return "<i>" + UnitDetails.getBundle("UnitDetails_Plugin_Collecting_Dependencies") + "</i><br>";
        }
        Unit.Update update2 = update;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (!(update2 instanceof Unit.InternalUpdate)) {
            Set set;
            Object object;
            object3 = OperationContainer.createForUpdate();
            try {
                object3.add(update2.updateUnit, update.getRelevantElement());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("Unit: " + update2));
                Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("Unit.updateUnit: " + update2.updateUnit));
                Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("Unit.getRelevantElement(): " + update.getRelevantElement()));
                throw illegalArgumentException;
            }
            object2 = new LinkedHashSet();
            iterator = object3.listAll();
            Iterator object7 = iterator.iterator();
            while (object7.hasNext()) {
                object = (OperationContainer.OperationInfo)object7.next();
                set = object.getRequiredElements();
                for (Object object4 : set) {
                    if (object4.getUpdateUnit().getInstalled() == null || object4.getUpdateUnit().isPending()) continue;
                    object2.add(object4);
                }
            }
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                object = (OperationContainer.OperationInfo)iterator2.next();
                if (object.getUpdateUnit().equals((Object)update2.updateUnit) || object.getUpdateUnit().isPending()) continue;
                object2.add(object.getUpdateElement());
            }
            if (object2.size() != 0) {
                OperationContainer.OperationInfo operationInfo;
                Object object52;
                Object object4;
                ArrayList<Set> arrayList = new ArrayList<Set>();
                object = object2.iterator();
                while (object.hasNext()) {
                    set = (UpdateElement)object.next();
                    if (!set.getUpdateUnit().getType().equals((Object)UpdateManager.TYPE.KIT_MODULE)) continue;
                    arrayList.add(set);
                }
                object = OperationContainer.createForUpdate();
                set = OperationContainer.createForInstall();
                ArrayList arrayList2 = new ArrayList();
                for (Object object52 : arrayList) {
                    if (object.canBeAdded(object52.getUpdateUnit(), (UpdateElement)object52)) {
                        arrayList2.add(object.add((UpdateElement)object52));
                        continue;
                    }
                    if (!set.canBeAdded(object52.getUpdateUnit(), (UpdateElement)object52)) continue;
                    arrayList2.add(set.add((UpdateElement)object52));
                }
                object4 = new ArrayList();
                object52 = arrayList2.iterator();
                while (object52.hasNext()) {
                    operationInfo = (OperationContainer.OperationInfo)object52.next();
                    Set set2 = operationInfo.getRequiredElements();
                    for (UpdateElement updateElement : set2) {
                        if (object4.contains(updateElement)) continue;
                        object4.add(updateElement);
                    }
                }
                object52 = object2.iterator();
                while (object52.hasNext()) {
                    operationInfo = (UpdateElement)object52.next();
                    if (object4.contains(operationInfo) || operationInfo.getUpdateUnit().getType().equals((Object)UpdateManager.TYPE.KIT_MODULE)) continue;
                    hashSet.add(operationInfo);
                }
            }
        } else {
            object3 = (Unit.InternalUpdate)update2;
            object2 = OperationContainer.createForUpdate();
            for (UpdateUnit updateUnit : ((Unit.InternalUpdate)object3).getUpdateUnits()) {
                object2.add((UpdateElement)updateUnit.getAvailableUpdates().get(0));
            }
            for (OperationContainer.OperationInfo operationInfo : object2.listAll()) {
                hashSet.add(operationInfo.getUpdateElement());
                for (Set set : operationInfo.getRequiredElements()) {
                    if (set.getUpdateUnit().getInstalled() == null || set.getUpdateUnit().isPending()) continue;
                    hashSet.add(set);
                }
            }
        }
        object3 = new StringBuilder();
        try {
            object2 = new TreeSet<UpdateElement>(new Comparator<UpdateElement>(){

                @Override
                public int compare(UpdateElement updateElement, UpdateElement updateElement2) {
                    return updateElement.getDisplayName().compareTo(updateElement2.getDisplayName());
                }
            });
            object2.addAll(hashSet);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                UpdateElement updateElement = (UpdateElement)iterator.next();
                this.appendInternalUpdates((StringBuilder)object3, updateElement);
            }
        }
        catch (Exception exception) {
            this.err.log(Level.INFO, "Exception", exception);
        }
        return ((StringBuilder)object3).toString();
    }

    private void appendInternalUpdates(StringBuilder stringBuilder, UpdateElement updateElement) {
        stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
        stringBuilder.append(updateElement.getDisplayName());
        if (updateElement.getUpdateUnit().getInstalled() != null) {
            stringBuilder.append(" [" + updateElement.getUpdateUnit().getInstalled().getSpecificationVersion() + "->");
        } else {
            stringBuilder.append(" <span color=\"red\">" + UnitDetails.getBundle("UnitDetails_New_Internal_Update_Mark") + "</span> [");
        }
        stringBuilder.append(((UpdateElement)updateElement.getUpdateUnit().getAvailableUpdates().get(0)).getSpecificationVersion());
        stringBuilder.append("]<br>");
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(UnitDetails.class, (String)string);
    }
}

