/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.NativeMediaManager;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.ListIterator;

public class MediaUtils {
    public static final int MAX_FILE_SIGNATURE_LENGTH = 22;
    static final String NATIVE_MEDIA_ERROR_FORMAT = "Internal media error: %d";
    static final String NATIVE_MEDIA_WARNING_FORMAT = "Internal media warning: %d";
    public static final String CONTENT_TYPE_AIFF = "audio/x-aiff";
    public static final String CONTENT_TYPE_MP3 = "audio/mp3";
    public static final String CONTENT_TYPE_MPA = "audio/mpeg";
    public static final String CONTENT_TYPE_WAV = "audio/x-wav";
    public static final String CONTENT_TYPE_JFX = "video/x-javafx";
    public static final String CONTENT_TYPE_FLV = "video/x-flv";
    public static final String CONTENT_TYPE_MP4 = "video/mp4";
    public static final String CONTENT_TYPE_M4A = "audio/x-m4a";
    public static final String CONTENT_TYPE_M4V = "video/x-m4v";
    private static final String CONTENT_TYPE_M3U8 = "application/vnd.apple.mpegurl";
    private static final String CONTENT_TYPE_M3U = "audio/mpegurl";
    private static final String FILE_TYPE_AIF = "aif";
    private static final String FILE_TYPE_AIFF = "aiff";
    private static final String FILE_TYPE_FLV = "flv";
    private static final String FILE_TYPE_FXM = "fxm";
    private static final String FILE_TYPE_MPA = "mp3";
    private static final String FILE_TYPE_WAV = "wav";
    private static final String FILE_TYPE_MP4 = "mp4";
    private static final String FILE_TYPE_M4A = "m4a";
    private static final String FILE_TYPE_M4V = "m4v";
    private static final String FILE_TYPE_M3U8 = "m3u8";
    private static final String FILE_TYPE_M3U = "m3u";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String fileSignatureToContentType(byte[] buf) throws MediaException {
        String contentType = "application/octet-stream";
        if (buf.length < 22) {
            return contentType;
        }
        if ((buf[0] & 0xFF) == 70 && (buf[1] & 0xFF) == 76 && (buf[2] & 0xFF) == 86) {
            return CONTENT_TYPE_JFX;
        }
        if (((buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF) == 1380533830 && ((buf[8] & 0xFF) << 24 | (buf[9] & 0xFF) << 16 | (buf[10] & 0xFF) << 8 | buf[11] & 0xFF) == 1463899717 && ((buf[12] & 0xFF) << 24 | (buf[13] & 0xFF) << 16 | (buf[14] & 0xFF) << 8 | buf[15] & 0xFF) == 1718449184) {
            if ((buf[20] & 0xFF) == 1) {
                if ((buf[21] & 0xFF) == 0) return CONTENT_TYPE_WAV;
            }
            if ((buf[20] & 0xFF) != 3) throw new MediaException("Compressed WAVE is not supported!");
            if ((buf[21] & 0xFF) != 0) throw new MediaException("Compressed WAVE is not supported!");
            return CONTENT_TYPE_WAV;
        }
        if (((buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF) == 1380533830 && ((buf[8] & 0xFF) << 24 | (buf[9] & 0xFF) << 16 | (buf[10] & 0xFF) << 8 | buf[11] & 0xFF) == 1463899717) {
            return CONTENT_TYPE_WAV;
        }
        if (((buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF) == 1179603533 && ((buf[8] & 0xFF) << 24 | (buf[9] & 0xFF) << 16 | (buf[10] & 0xFF) << 8 | buf[11] & 0xFF) == 1095321158 && ((buf[12] & 0xFF) << 24 | (buf[13] & 0xFF) << 16 | (buf[14] & 0xFF) << 8 | buf[15] & 0xFF) == 1129270605) {
            return CONTENT_TYPE_AIFF;
        }
        if ((buf[0] & 0xFF) == 73 && (buf[1] & 0xFF) == 68 && (buf[2] & 0xFF) == 51) {
            return CONTENT_TYPE_MPA;
        }
        if ((buf[0] & 0xFF) == 255 && (buf[1] & 0xE0) == 224 && (buf[2] & 0x18) != 1 && (buf[3] & 6) != 0) {
            return CONTENT_TYPE_MPA;
        }
        if (((buf[4] & 0xFF) << 24 | (buf[5] & 0xFF) << 16 | (buf[6] & 0xFF) << 8 | buf[7] & 0xFF) != 1718909296) throw new MediaException("Unrecognized file signature!");
        if ((buf[8] & 0xFF) == 77 && (buf[9] & 0xFF) == 52 && (buf[10] & 0xFF) == 65 && (buf[11] & 0xFF) == 32) {
            return CONTENT_TYPE_M4A;
        }
        if ((buf[8] & 0xFF) == 77 && (buf[9] & 0xFF) == 52 && (buf[10] & 0xFF) == 86 && (buf[11] & 0xFF) == 32) {
            return CONTENT_TYPE_M4V;
        }
        if ((buf[8] & 0xFF) == 109 && (buf[9] & 0xFF) == 112 && (buf[10] & 0xFF) == 52 && (buf[11] & 0xFF) == 50) {
            return CONTENT_TYPE_MP4;
        }
        if ((buf[8] & 0xFF) == 105 && (buf[9] & 0xFF) == 115 && (buf[10] & 0xFF) == 111 && (buf[11] & 0xFF) == 109) {
            return CONTENT_TYPE_MP4;
        }
        if ((buf[8] & 0xFF) != 77) return contentType;
        if ((buf[9] & 0xFF) != 80) return contentType;
        if ((buf[10] & 0xFF) != 52) return contentType;
        if ((buf[11] & 0xFF) != 32) return contentType;
        return CONTENT_TYPE_MP4;
    }

    public static String filenameToContentType(String filename) {
        String contentType = "application/octet-stream";
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex != -1) {
            String extension = filename.toLowerCase().substring(dotIndex + 1);
            if (extension.equals(FILE_TYPE_AIF) || extension.equals(FILE_TYPE_AIFF)) {
                contentType = CONTENT_TYPE_AIFF;
            } else if (extension.equals(FILE_TYPE_FLV) || extension.equals(FILE_TYPE_FXM)) {
                contentType = CONTENT_TYPE_JFX;
            } else if (extension.equals(FILE_TYPE_MPA)) {
                contentType = CONTENT_TYPE_MPA;
            } else if (extension.equals(FILE_TYPE_WAV)) {
                contentType = CONTENT_TYPE_WAV;
            } else if (extension.equals(FILE_TYPE_MP4)) {
                contentType = CONTENT_TYPE_MP4;
            } else if (extension.equals(FILE_TYPE_M4A)) {
                contentType = CONTENT_TYPE_M4A;
            } else if (extension.equals(FILE_TYPE_M4V)) {
                contentType = CONTENT_TYPE_M4V;
            } else if (extension.equals(FILE_TYPE_M3U8)) {
                contentType = CONTENT_TYPE_M3U8;
            } else if (extension.equals(FILE_TYPE_M3U)) {
                contentType = CONTENT_TYPE_M3U;
            }
        }
        return contentType;
    }

    public static void warning(Object source, String message) {
        if (source != null & message != null) {
            Logger.logMsg(3, source.getClass().getName() + ": " + message);
        }
    }

    public static void error(Object source, int errCode, String message, Throwable cause) {
        List<WeakReference<MediaErrorListener>> listeners;
        StackTraceElement[] stackTrace;
        if (cause != null && (stackTrace = cause.getStackTrace()) != null && stackTrace.length > 0) {
            StackTraceElement trace = stackTrace[0];
            Logger.logMsg(4, trace.getClassName(), trace.getMethodName(), "( " + trace.getLineNumber() + ") " + message);
        }
        if (!(listeners = NativeMediaManager.getDefaultInstance().getMediaErrorListeners()).isEmpty()) {
            ListIterator<WeakReference<MediaErrorListener>> it = listeners.listIterator();
            while (it.hasNext()) {
                MediaErrorListener l = (MediaErrorListener)it.next().get();
                if (l != null) {
                    l.onError(source, errCode, message);
                    continue;
                }
                it.remove();
            }
        } else {
            MediaException e = cause instanceof MediaException ? (MediaException)cause : new MediaException(message, cause);
            throw e;
        }
    }

    public static void nativeWarning(Object source, int warningCode, String warningMessage) {
        String message = String.format(NATIVE_MEDIA_WARNING_FORMAT, warningCode);
        if (warningMessage != null) {
            message = message + ": " + warningMessage;
        }
        Logger.logMsg(3, message);
    }

    public static void nativeError(Object source, MediaError error) {
        Logger.logMsg(4, error.description());
        List<WeakReference<MediaErrorListener>> listeners = NativeMediaManager.getDefaultInstance().getMediaErrorListeners();
        if (!listeners.isEmpty()) {
            ListIterator<WeakReference<MediaErrorListener>> it = listeners.listIterator();
            while (it.hasNext()) {
                MediaErrorListener l = (MediaErrorListener)it.next().get();
                if (l != null) {
                    l.onError(source, error.code(), error.description());
                    continue;
                }
                it.remove();
            }
        } else {
            throw new MediaException(error.description(), null, error);
        }
    }
}

