/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.packager.bundlers.LinuxAppBundler;
import com.sun.javafx.tools.packager.bundlers.LinuxDebBundler;
import com.sun.javafx.tools.packager.bundlers.LinuxRPMBundler;
import com.sun.javafx.tools.packager.bundlers.MacAppBundler;
import com.sun.javafx.tools.packager.bundlers.MacDMGBundler;
import com.sun.javafx.tools.packager.bundlers.WinAppBundler;
import com.sun.javafx.tools.packager.bundlers.WinExeBundler;
import com.sun.javafx.tools.packager.bundlers.WinMsiBundler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Bundler {
    protected File buildRoot = null;
    protected File imagesRoot = null;
    protected boolean verbose = false;
    public static final String BUNDLER_PREFIX = "package/";
    private static final List<Bundler> knownBundlers = new LinkedList<Bundler>();
    protected Class baseResourceLoader = null;

    public void setVerbose(boolean m) {
        this.verbose = m;
    }

    private static File getTempDir(String prefix) throws IOException {
        File dir = File.createTempFile(prefix, ".fxbundler");
        dir.delete();
        dir.mkdirs();
        return dir;
    }

    protected void setBuildRoot(File dir) {
        this.buildRoot = dir;
        this.imagesRoot = new File(dir, "images");
        this.imagesRoot.mkdirs();
    }

    public static List<Bundler> get(BundleParams p, boolean verbose) {
        LinkedList<Bundler> result = new LinkedList<Bundler>();
        File buildDir = null;
        try {
            buildDir = Bundler.getTempDir("build");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Log.verbose("Looking for bundlers for type=" + p.type.toString() + " format=" + (p.bundleFormat != null ? p.bundleFormat : "any"));
        for (Bundler b : knownBundlers) {
            if (verbose) {
                b.setVerbose(true);
            }
            try {
                if (!b.validate(p)) continue;
                b.setBuildRoot(buildDir);
                result.add(b);
            }
            catch (UnsupportedPlatformException e) {
                Log.debug("  Skip [" + b.toString() + "] as not supporting current platform");
            }
            catch (ConfigException ee) {
                Log.info("  Skip [" + b.toString() + "] due to [" + ee.getMessage() + "]");
                if (ee.getAdvice() == null) continue;
                Log.verbose("   [" + ee.getAdvice() + "]");
            }
        }
        return result;
    }

    abstract boolean validate(BundleParams var1) throws UnsupportedPlatformException, ConfigException;

    public abstract boolean bundle(BundleParams var1, File var2);

    void testRuntime(BundleParams p, String file) throws ConfigException {
        if (p.runtime == null) {
            throw new ConfigException("No Java Runtime to embed!", "Specify location of JDK to use.");
        }
        Set<String> rfiles = p.runtime.getIncludedFiles();
        if (!rfiles.contains(file)) {
            throw new ConfigException("Java Runtime does not include " + file, "Make sure ant is using Oracle JDK 7u6 or later.");
        }
    }

    protected void fetchResource(String publicName, String category, String defaultName, File result) throws IOException {
        URL u = this.locateResource(publicName, category, defaultName);
        if (u != null) {
            IOUtils.copyFromURL(u, result);
        } else if (this.verbose) {
            Log.info("Using default package resource " + (category == null ? "" : "[" + category + "] ") + "(add " + publicName + " to the class path to customize)");
        }
    }

    protected void fetchResource(String publicName, String category, File defaultFile, File result) throws IOException {
        URL u = this.locateResource(publicName, category, null);
        if (u != null) {
            IOUtils.copyFromURL(u, result);
        } else {
            IOUtils.copyFile(defaultFile, result);
            if (this.verbose) {
                Log.info("   Using custom package resource " + (category == null ? "" : "[" + category + "] ") + "(loaded from file " + defaultFile.getAbsoluteFile() + ")");
            }
        }
    }

    private URL locateResource(String publicName, String category, String defaultName) throws IOException {
        URL u = null;
        boolean custom = false;
        if (publicName != null) {
            u = this.baseResourceLoader.getClassLoader().getResource(publicName);
            boolean bl = custom = u != null;
        }
        if (u == null && defaultName != null) {
            u = this.baseResourceLoader.getResource(defaultName);
        }
        String msg = null;
        if (custom) {
            msg = "  Using custom package resource " + (category == null ? "" : "[" + category + "] ") + "(loaded from " + publicName + " on class path)";
        } else if (u != null) {
            msg = "  Using default package resource " + (category == null ? "" : "[" + category + "] ") + "(add " + publicName + " to the class path to customize)";
        }
        if (this.verbose && u != null) {
            Log.info(msg);
        }
        return u;
    }

    protected String preprocessTextResource(String publicName, String category, String defaultName, Map<String, String> pairs) throws IOException {
        URL u = this.locateResource(publicName, category, defaultName);
        InputStream inp = u.openStream();
        if (inp == null) {
            throw new RuntimeException("Jar corrupt? No " + defaultName + " resource!");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inp.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        String result = new String(baos.toByteArray());
        for (Map.Entry<String, String> e : pairs.entrySet()) {
            if (e.getValue() == null) continue;
            result = result.replace(e.getKey(), e.getValue());
        }
        return result;
    }

    static {
        knownBundlers.add(new WinAppBundler());
        knownBundlers.add(new MacAppBundler());
        knownBundlers.add(new WinMsiBundler());
        knownBundlers.add(new WinExeBundler());
        knownBundlers.add(new MacDMGBundler());
        knownBundlers.add(new LinuxAppBundler());
        knownBundlers.add(new LinuxRPMBundler());
        knownBundlers.add(new LinuxDebBundler());
    }

    public static class ConfigException
    extends Exception {
        String advice = null;

        public ConfigException(String msg, String advice) {
            super(msg);
            this.advice = advice;
        }

        public String getAdvice() {
            return this.advice;
        }
    }

    public static class UnsupportedPlatformException
    extends Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BundleType {
        NONE,
        IMAGE,
        INSTALLER,
        ALL;

    }
}

