/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private transient SharedKeyWeakHashMap<E, Boolean> m;
    private transient Set<E> s;
    private static final Object PRESENT = new Boolean(true);
    private final float loadFactor;
    private static final long serialVersionUID = 2454657854757543876L;

    public WeakSet(int n, float f) {
        this.m = new SharedKeyWeakHashMap(n, f);
        this.loadFactor = f;
        this.s = this.m.keySet();
    }

    public WeakSet(int n) {
        this(n, 0.75f);
    }

    public WeakSet() {
        this(16, 0.75f);
    }

    public WeakSet(Collection<? extends E> collection) {
        this(Math.max((int)((float)collection.size() / 0.75f) + 1, 16), 0.75f);
        this.addAll(collection);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    @Override
    public boolean remove(Object object) {
        return this.m.remove(object) == PRESENT;
    }

    public void resize(int n) {
        if (this.isEmpty()) {
            this.m.resize(n);
        }
    }

    @Override
    public boolean add(E e) {
        boolean[] blArray = new boolean[]{false};
        ((SharedKeyWeakHashMap)this.m).putIfAbsent(e, blArray);
        return blArray[0];
    }

    @Override
    public Iterator<E> iterator() {
        return this.s.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.s.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.s.toArray(TArray);
    }

    @Override
    public String toString() {
        return this.s.toString();
    }

    @Override
    public int hashCode() {
        return ((Object)this.s).hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || ((Object)this.s).equals(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.s.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.s.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.s.retainAll(collection);
    }

    public E putIfAbsent(E e) {
        return (E)((SharedKeyWeakHashMap)this.m).putIfAbsent(e, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.toArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        this.m = new SharedKeyWeakHashMap(objectArray.length, this.loadFactor);
        for (Object object : objectArray) {
            ((SharedKeyWeakHashMap)this.m).putIfAbsent(object, null);
        }
        this.s = this.m.keySet();
    }

    public Object clone() {
        try {
            WeakSet weakSet = (WeakSet)super.clone();
            weakSet.m = new SharedKeyWeakHashMap(this.size(), this.loadFactor);
            weakSet.s = weakSet.m.keySet();
            weakSet.addAll(this);
            return weakSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("base class doesn't support clone", cloneNotSupportedException);
        }
    }

    private static final class SharedKeyWeakHashMap<K, V>
    extends AbstractMap<K, V>
    implements Map<K, V> {
        private static final int DEFAULT_INITIAL_CAPACITY = 16;
        private static final int MAXIMUM_CAPACITY = 0x40000000;
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private Entry<K, V>[] table;
        private int size;
        private int threshold;
        private final float loadFactor;
        private final ReferenceQueue<K> queue = new ReferenceQueue();
        private volatile int modCount;
        private static final Object NULL_KEY = new Object();
        private transient Set<Map.Entry<K, V>> entrySet = null;
        private volatile transient Set<K> keySet = null;
        private volatile transient Collection<V> values = null;

        public SharedKeyWeakHashMap(int n, float f) {
            int n2;
            if (n < 0) {
                throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
            }
            if (n > 0x40000000) {
                n = 0x40000000;
            }
            if (f <= 0.0f || Float.isNaN(f)) {
                throw new IllegalArgumentException("Illegal Load factor: " + f);
            }
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
            this.table = new Entry[n2];
            this.loadFactor = f;
            this.threshold = (int)((float)n2 * f);
        }

        public SharedKeyWeakHashMap(int n) {
            this(n, 0.75f);
        }

        public SharedKeyWeakHashMap() {
            this.loadFactor = 0.75f;
            this.threshold = 16;
            this.table = new Entry[16];
        }

        public SharedKeyWeakHashMap(Map<? extends K, ? extends V> map) {
            this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
            this.putAll(map);
        }

        private static Object maskNull(Object object) {
            return object == null ? NULL_KEY : object;
        }

        private static <K> K unmaskNull(Object object) {
            return (K)(object == NULL_KEY ? null : object);
        }

        static boolean eq(Object object, Object object2) {
            return object == object2 || object.equals(object2);
        }

        static int indexFor(int n, int n2) {
            return n & n2 - 1;
        }

        private void expungeStaleEntries() {
            Entry entry;
            block0: while ((entry = (Entry)this.queue.poll()) != null) {
                Entry entry2;
                int n = entry.hash;
                int n2 = SharedKeyWeakHashMap.indexFor(n, this.table.length);
                Entry entry3 = entry2 = this.table[n2];
                while (entry3 != null) {
                    Entry entry4 = entry3.next;
                    if (entry3 == entry) {
                        if (entry2 == entry) {
                            this.table[n2] = entry4;
                        } else {
                            entry2.next = entry4;
                        }
                        entry.next = null;
                        --this.size;
                        continue block0;
                    }
                    entry2 = entry3;
                    entry3 = entry4;
                }
            }
        }

        private Entry<K, V>[] getTable() {
            this.expungeStaleEntries();
            return this.table;
        }

        @Override
        public int size() {
            if (this.size == 0) {
                return 0;
            }
            this.expungeStaleEntries();
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public V get(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.getEntry(object) != null;
        }

        Entry<K, V> getEntry(Object object) {
            Object object2 = SharedKeyWeakHashMap.maskNull(object);
            int n = SharedKeyWeakHashMap.hash(object2.hashCode());
            Entry<K, V>[] entryArray = this.getTable();
            int n2 = SharedKeyWeakHashMap.indexFor(n, entryArray.length);
            Entry entry = entryArray[n2];
            while (!(entry == null || entry.hash == n && SharedKeyWeakHashMap.eq(object2, entry.get()))) {
                entry = entry.next;
            }
            return entry;
        }

        @Override
        public V put(K k, V v) {
            throw new UnsupportedOperationException("use putIfAbsent instead");
        }

        void resize(int n) {
            Entry[] entryArray = this.getTable();
            int n2 = entryArray.length;
            if (n2 == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            Entry[] entryArray2 = new Entry[n];
            this.transfer(entryArray, entryArray2);
            this.table = entryArray2;
            if (this.size >= this.threshold / 2) {
                this.threshold = (int)((float)n * this.loadFactor);
            } else {
                this.expungeStaleEntries();
                this.transfer(entryArray2, entryArray);
                this.table = entryArray;
            }
        }

        private void transfer(Entry[] entryArray, Entry[] entryArray2) {
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry = entryArray[i];
                entryArray[i] = null;
                while (entry != null) {
                    Entry entry2 = entry.next;
                    Object t = entry.get();
                    if (t == null) {
                        entry.next = null;
                        --this.size;
                    } else {
                        int n = SharedKeyWeakHashMap.indexFor(entry.hash, entryArray2.length);
                        entry.next = entryArray2[n];
                        entryArray2[n] = entry;
                    }
                    entry = entry2;
                }
            }
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            int n = map.size();
            if (n == 0) {
                return;
            }
            if (n > this.threshold) {
                int n2;
                int n3 = (int)((float)n / this.loadFactor + 1.0f);
                if (n3 > 0x40000000) {
                    n3 = 0x40000000;
                }
                for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
                }
                if (n2 > this.table.length) {
                    this.resize(n2);
                }
            }
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.putIfAbsent(entry.getKey(), null);
            }
        }

        @Override
        public V remove(Object object) {
            Entry entry;
            Object object2 = SharedKeyWeakHashMap.maskNull(object);
            int n = SharedKeyWeakHashMap.hash(object2.hashCode());
            Entry<K, V>[] entryArray = this.getTable();
            int n2 = SharedKeyWeakHashMap.indexFor(n, entryArray.length);
            Entry entry2 = entry = entryArray[n2];
            while (entry2 != null) {
                Entry entry3 = entry2.next;
                if (n == entry2.hash && SharedKeyWeakHashMap.eq(object2, entry2.get())) {
                    ++this.modCount;
                    --this.size;
                    if (entry == entry2) {
                        entryArray[n2] = entry3;
                    } else {
                        entry.next = entry3;
                    }
                    return (V)PRESENT;
                }
                entry = entry2;
                entry2 = entry3;
            }
            return null;
        }

        Entry<K, V> removeMapping(Object object) {
            Entry entry;
            if (!(object instanceof Map.Entry)) {
                return null;
            }
            Entry<K, V>[] entryArray = this.getTable();
            Map.Entry entry2 = (Map.Entry)object;
            Object object2 = SharedKeyWeakHashMap.maskNull(entry2.getKey());
            int n = SharedKeyWeakHashMap.hash(object2.hashCode());
            int n2 = SharedKeyWeakHashMap.indexFor(n, entryArray.length);
            Entry entry3 = entry = entryArray[n2];
            while (entry3 != null) {
                Entry entry4 = entry3.next;
                if (n == entry3.hash && entry3.equals(entry2)) {
                    ++this.modCount;
                    --this.size;
                    if (entry == entry3) {
                        entryArray[n2] = entry4;
                    } else {
                        entry.next = entry4;
                    }
                    return entry3;
                }
                entry = entry3;
                entry3 = entry4;
            }
            return null;
        }

        @Override
        public void clear() {
            while (this.queue.poll() != null) {
            }
            ++this.modCount;
            Entry<K, V>[] entryArray = this.table;
            for (int i = 0; i < entryArray.length; ++i) {
                entryArray[i] = null;
            }
            this.size = 0;
            while (this.queue.poll() != null) {
            }
        }

        @Override
        public boolean containsValue(Object object) {
            if (object == null) {
                return this.containsNullValue();
            }
            return false;
        }

        private boolean containsNullValue() {
            Entry<K, V>[] entryArray = this.getTable();
            int n = entryArray.length;
            while (n-- > 0) {
                Entry<K, V> entry = entryArray[n];
                if (entry == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<K> keySet() {
            KeySet keySet = this.keySet;
            return keySet != null ? keySet : (this.keySet = new KeySet());
        }

        @Override
        public Collection<V> values() {
            Values values = this.values;
            return values != null ? values : (this.values = new Values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            EntrySet entrySet = this.entrySet;
            return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
        }

        static int hash(int n) {
            n ^= n >>> 20 ^ n >>> 12;
            return n ^ n >>> 7 ^ n >>> 4;
        }

        @Override
        private K putIfAbsent(K k, boolean[] blArray) {
            Object object = SharedKeyWeakHashMap.maskNull(k);
            int n = SharedKeyWeakHashMap.hash(object.hashCode());
            Entry<K, V>[] entryArray = this.getTable();
            int n2 = SharedKeyWeakHashMap.indexFor(n, entryArray.length);
            Entry<K, V> entry = entryArray[n2];
            while (entry != null) {
                Object t;
                if (((Entry)entry).hash == n && SharedKeyWeakHashMap.eq(object, t = entry.get())) {
                    return SharedKeyWeakHashMap.unmaskNull(t);
                }
                entry = ((Entry)entry).next;
            }
            ++this.modCount;
            entry = entryArray[n2];
            entryArray[n2] = new Entry<Object, V>(object, this.queue, n, entry);
            if (++this.size >= this.threshold) {
                this.resize(entryArray.length * 2);
            }
            if (blArray != null) {
                blArray[0] = true;
            }
            return SharedKeyWeakHashMap.unmaskNull(object);
        }

        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = SharedKeyWeakHashMap.this.getEntry(entry.getKey());
                return entry2 != null && entry2.equals(entry);
            }

            @Override
            public boolean remove(Object object) {
                return SharedKeyWeakHashMap.this.removeMapping(object) != null;
            }

            @Override
            public int size() {
                return SharedKeyWeakHashMap.this.size();
            }

            @Override
            public void clear() {
                SharedKeyWeakHashMap.this.clear();
            }

            private List<Map.Entry<K, V>> deepCopy() {
                ArrayList arrayList = new ArrayList(this.size());
                for (Map.Entry entry : this) {
                    arrayList.add(new SimpleEntry(entry));
                }
                return arrayList;
            }

            @Override
            public Object[] toArray() {
                return this.deepCopy().toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return this.deepCopy().toArray(TArray);
            }
        }

        private final class Values
        extends AbstractCollection<V> {
            private Values() {
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return SharedKeyWeakHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return SharedKeyWeakHashMap.this.containsValue(object);
            }

            @Override
            public void clear() {
                SharedKeyWeakHashMap.this.clear();
            }
        }

        private final class KeySet
        extends AbstractSet<K> {
            private KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return SharedKeyWeakHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return SharedKeyWeakHashMap.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                if (SharedKeyWeakHashMap.this.containsKey(object)) {
                    SharedKeyWeakHashMap.this.remove(object);
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                SharedKeyWeakHashMap.this.clear();
            }
        }

        private final class EntryIterator
        extends HashIterator<Map.Entry<K, V>> {
            private EntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }
        }

        private final class KeyIterator
        extends HashIterator<K> {
            private KeyIterator() {
            }

            @Override
            public K next() {
                return this.nextEntry().getKey();
            }
        }

        private final class ValueIterator
        extends HashIterator<V> {
            private ValueIterator() {
            }

            @Override
            public V next() {
                this.nextEntry();
                return null;
            }
        }

        private abstract class HashIterator<T>
        implements Iterator<T> {
            private int index;
            private Entry<K, V> entry = null;
            private Entry<K, V> lastReturned = null;
            private int expectedModCount = SharedKeyWeakHashMap.access$500(SharedKeyWeakHashMap.this);
            private Object nextKey = null;
            private Object currentKey = null;

            HashIterator() {
                this.index = SharedKeyWeakHashMap.this.size() != 0 ? SharedKeyWeakHashMap.this.table.length : 0;
            }

            @Override
            public boolean hasNext() {
                Entry[] entryArray = SharedKeyWeakHashMap.this.table;
                while (this.nextKey == null) {
                    Entry entry = this.entry;
                    int n = this.index;
                    while (entry == null && n > 0) {
                        entry = entryArray[--n];
                    }
                    this.entry = entry;
                    this.index = n;
                    if (entry == null) {
                        this.currentKey = null;
                        return false;
                    }
                    this.nextKey = entry.get();
                    if (this.nextKey != null) continue;
                    this.entry = this.entry.next;
                }
                return true;
            }

            protected Entry<K, V> nextEntry() {
                if (SharedKeyWeakHashMap.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.nextKey == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.entry;
                this.entry = this.entry.next;
                this.currentKey = this.nextKey;
                this.nextKey = null;
                return this.lastReturned;
            }

            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (SharedKeyWeakHashMap.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                SharedKeyWeakHashMap.this.remove(this.currentKey);
                this.expectedModCount = SharedKeyWeakHashMap.this.modCount;
                this.lastReturned = null;
                this.currentKey = null;
            }
        }

        private static final class SimpleEntry<K, V>
        implements Map.Entry<K, V>,
        Serializable {
            private static final long serialVersionUID = -8499721149061103585L;
            private final K key;

            public SimpleEntry(K k) {
                this.key = k;
            }

            public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
                this.key = entry.getKey();
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return null;
            }

            @Override
            public V setValue(V v) {
                return null;
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return SharedKeyWeakHashMap.eq(this.key, entry.getKey());
            }

            @Override
            public int hashCode() {
                return this.key == null ? 0 : this.key.hashCode();
            }

            public String toString() {
                return "" + this.key;
            }
        }

        private static final class Entry<K, V>
        extends WeakReference<K>
        implements Map.Entry<K, V> {
            private final int hash;
            private Entry<K, V> next;

            Entry(K k, ReferenceQueue<K> referenceQueue, int n, Entry<K, V> entry) {
                super(k, referenceQueue);
                this.hash = n;
                this.next = entry;
            }

            @Override
            public K getKey() {
                return (K)SharedKeyWeakHashMap.unmaskNull(this.get());
            }

            @Override
            public V getValue() {
                return null;
            }

            @Override
            public V setValue(V v) {
                return null;
            }

            @Override
            public boolean equals(Object object) {
                Object k;
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                K k2 = this.getKey();
                return k2 == (k = entry.getKey()) || k2 != null && k2.equals(k);
            }

            @Override
            public int hashCode() {
                K k = this.getKey();
                return k == null ? 0 : k.hashCode();
            }

            public String toString() {
                return "" + this.getKey();
            }
        }
    }
}

