/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.SSLException;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.JsseJce;

final class CipherSuiteList {
    private final Collection<CipherSuite> cipherSuites;
    private String[] suiteNames;
    private volatile Boolean containsEC;

    CipherSuiteList(Collection<CipherSuite> collection) {
        this.cipherSuites = collection;
    }

    CipherSuiteList(CipherSuite cipherSuite) {
        this.cipherSuites = new ArrayList<CipherSuite>(1);
        this.cipherSuites.add(cipherSuite);
    }

    CipherSuiteList(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("CipherSuites may not be null");
        }
        this.cipherSuites = new ArrayList<CipherSuite>(stringArray.length);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CipherSuite cipherSuite = CipherSuite.valueOf(string);
            if (!cipherSuite.isAvailable()) {
                if (!bl) {
                    CipherSuiteList.clearAvailableCache();
                    bl = true;
                }
                if (!cipherSuite.isAvailable()) {
                    throw new IllegalArgumentException("Cannot support " + string + " with currently installed providers");
                }
            }
            this.cipherSuites.add(cipherSuite);
        }
    }

    CipherSuiteList(HandshakeInStream handshakeInStream) throws IOException {
        byte[] byArray = handshakeInStream.getBytes16();
        if ((byArray.length & 1) != 0) {
            throw new SSLException("Invalid ClientHello message");
        }
        this.cipherSuites = new ArrayList<CipherSuite>(byArray.length >> 1);
        for (int i = 0; i < byArray.length; i += 2) {
            this.cipherSuites.add(CipherSuite.valueOf(byArray[i], byArray[i + 1]));
        }
    }

    boolean contains(CipherSuite cipherSuite) {
        return this.cipherSuites.contains(cipherSuite);
    }

    boolean containsEC() {
        if (this.containsEC == null) {
            for (CipherSuite cipherSuite : this.cipherSuites) {
                switch (cipherSuite.keyExchange) {
                    case K_ECDH_ECDSA: 
                    case K_ECDH_RSA: 
                    case K_ECDHE_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDH_ANON: {
                        this.containsEC = true;
                        return true;
                    }
                }
            }
            this.containsEC = false;
        }
        return this.containsEC;
    }

    Iterator<CipherSuite> iterator() {
        return this.cipherSuites.iterator();
    }

    Collection<CipherSuite> collection() {
        return this.cipherSuites;
    }

    int size() {
        return this.cipherSuites.size();
    }

    synchronized String[] toStringArray() {
        if (this.suiteNames == null) {
            this.suiteNames = new String[this.cipherSuites.size()];
            int n = 0;
            for (CipherSuite cipherSuite : this.cipherSuites) {
                this.suiteNames[n++] = cipherSuite.name;
            }
        }
        return (String[])this.suiteNames.clone();
    }

    public String toString() {
        return this.cipherSuites.toString();
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        byte[] byArray = new byte[this.cipherSuites.size() * 2];
        int n = 0;
        for (CipherSuite cipherSuite : this.cipherSuites) {
            byArray[n] = (byte)(cipherSuite.id >> 8);
            byArray[n + 1] = (byte)cipherSuite.id;
            n += 2;
        }
        handshakeOutStream.putBytes16(byArray);
    }

    static synchronized void clearAvailableCache() {
        CipherSuite.BulkCipher.clearAvailableCache();
        JsseJce.clearEcAvailable();
    }
}

