/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;
import sun.jvm.hotspot.asm.sparc.V9InstructionDecoder;

class V9ReadDecoder
extends InstructionDecoder
implements V9InstructionDecoder {
    V9ReadDecoder() {
    }

    @Override
    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCV9InstructionFactory v9factory = (SPARCV9InstructionFactory)factory;
        SPARCInstruction instr = null;
        int specialRegNum = V9ReadDecoder.getSourceRegister1(instruction);
        if (specialRegNum == 1 || specialRegNum > 6 && specialRegNum < 15) {
            instr = v9factory.newIllegalInstruction(instruction);
        } else {
            int rdNum = V9ReadDecoder.getDestinationRegister(instruction);
            if (specialRegNum == 15) {
                boolean iBit;
                instr = rdNum == 0 ? ((iBit = V9ReadDecoder.isIBitSet(instruction)) ? v9factory.newV9MembarInstruction((instruction & 0xF) >>> 0, (instruction & 0x70) >>> 4) : v9factory.newStbarInstruction()) : v9factory.newIllegalInstruction(instruction);
            } else {
                int asrRegNum = -1;
                if (specialRegNum > 15) {
                    asrRegNum = specialRegNum;
                    specialRegNum = 7;
                }
                SPARCRegister rd = SPARCRegisters.getRegister(rdNum);
                instr = v9factory.newV9ReadInstruction(specialRegNum, asrRegNum, rd);
            }
        }
        return instr;
    }
}

