/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;

public class ResourceResolver {
    static Logger log = Logger.getLogger(ResourceResolver.class.getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    static boolean allThreadSafeInList = true;
    protected ResourceResolverSpi _resolverSpi = null;

    private ResourceResolver(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (ResourceResolverSpi)Class.forName(string).newInstance();
    }

    public ResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this._resolverSpi = resourceResolverSpi;
    }

    public static final ResourceResolver getInstance(Attr attr, String string) throws ResourceResolverException {
        int n = _resolverVector.size();
        for (int i = 0; i < n; ++i) {
            ResourceResolver resourceResolver = (ResourceResolver)_resolverVector.get(i);
            ResourceResolver resourceResolver2 = null;
            try {
                resourceResolver2 = allThreadSafeInList || resourceResolver._resolverSpi.engineIsThreadSafe() ? resourceResolver : new ResourceResolver((ResourceResolverSpi)resourceResolver._resolverSpi.getClass().newInstance());
            }
            catch (InstantiationException instantiationException) {
                throw new ResourceResolverException("", instantiationException, attr, string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ResourceResolverException("", illegalAccessException, attr, string);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "check resolvability by class " + resourceResolver._resolverSpi.getClass().getName());
            }
            if (resourceResolver == null || !resourceResolver2.canResolve(attr, string)) continue;
            if (i != 0) {
                List list = (List)((ArrayList)_resolverVector).clone();
                list.remove(i);
                list.add(0, resourceResolver);
                _resolverVector = list;
            }
            return resourceResolver2;
        }
        Object[] objectArray = new Object[]{attr != null ? attr.getNodeValue() : "null", string};
        throw new ResourceResolverException("utils.resolver.noClass", objectArray, attr, string);
    }

    public static final ResourceResolver getInstance(Attr attr, String string, List list) throws ResourceResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I was asked to create a ResourceResolver and got " + (list == null ? 0 : list.size()));
            log.log(Level.FINE, " extra resolvers to my existing " + _resolverVector.size() + " system-wide resolvers");
        }
        int n = 0;
        if (list != null && (n = list.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                ResourceResolver resourceResolver = (ResourceResolver)list.get(i);
                if (resourceResolver == null) continue;
                String string2 = resourceResolver._resolverSpi.getClass().getName();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "check resolvability by class " + string2);
                }
                if (!resourceResolver.canResolve(attr, string)) continue;
                return resourceResolver;
            }
        }
        return ResourceResolver.getInstance(attr, string);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string) {
        ResourceResolver.register(string, false);
    }

    public static void registerAtStart(String string) {
        ResourceResolver.register(string, true);
    }

    private static void register(String string, boolean bl) {
        try {
            ResourceResolver resourceResolver = new ResourceResolver(string);
            if (bl) {
                _resolverVector.add(0, resourceResolver);
                log.log(Level.FINE, "registered resolver");
            } else {
                _resolverVector.add(resourceResolver);
            }
            if (!resourceResolver._resolverSpi.engineIsThreadSafe()) {
                allThreadSafeInList = false;
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error loading resolver " + string + " disabling it");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            log.log(Level.WARNING, "Error loading resolver " + string + " disabling it");
        }
    }

    public static XMLSignatureInput resolveStatic(Attr attr, String string) throws ResourceResolverException {
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
        return resourceResolver.resolve(attr, string);
    }

    public XMLSignatureInput resolve(Attr attr, String string) throws ResourceResolverException {
        return this._resolverSpi.engineResolve(attr, string);
    }

    public void setProperty(String string, String string2) {
        this._resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this._resolverSpi.engineGetProperty(string);
    }

    public void addProperties(Map map) {
        this._resolverSpi.engineAddProperies(map);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string) {
        return this._resolverSpi.understandsProperty(string);
    }

    private boolean canResolve(Attr attr, String string) {
        return this._resolverSpi.engineCanResolve(attr, string);
    }
}

