/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.util.Arrays;
import java.util.Date;
import org.netbeans.beaninfo.editors.ExPropertyEditorSupport;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class IntEditor
extends ExPropertyEditorSupport {
    public static final String KEYS = "stringKeys";
    public static final String VALS = "intValues";
    public static final String CODE_VALS = "codeValues";
    String[] keys = null;
    String[] code = null;
    int[] values = null;

    @Override
    protected void attachEnvImpl(PropertyEnv propertyEnv) {
        this.keys = (String[])propertyEnv.getFeatureDescriptor().getValue(KEYS);
        this.values = (int[])propertyEnv.getFeatureDescriptor().getValue(VALS);
        this.code = (String[])propertyEnv.getFeatureDescriptor().getValue(CODE_VALS);
    }

    @Override
    protected void validateEnv(PropertyEnv propertyEnv) {
        boolean bl;
        boolean bl2 = bl = this.keys == null && this.values == null && this.code == null;
        if (!bl) {
            boolean bl3 = bl = this.keys != null && this.values != null;
            if (!bl) {
                throw new ExPropertyEditorSupport.EnvException("You must specify both an array of keys and an array of values if you specify one. Keys=" + IntEditor.arrToStr(this.keys) + " Values=" + IntEditor.arrToStr(this.values));
            }
            boolean bl4 = bl = this.keys.length == this.values.length;
            if (bl) {
                boolean bl5 = bl = this.keys.length > 0 && this.values.length > 0;
            }
            if (!bl) {
                throw new ExPropertyEditorSupport.EnvException("The arrays of keys and values must have the same length and the length must be > 0. keys.length =" + this.keys.length + " values.length=" + this.values.length + " Keys=" + IntEditor.arrToStr(this.keys) + " Values=" + IntEditor.arrToStr(this.values));
            }
            if (this.code != null) {
                boolean bl6 = bl = this.code.length == this.keys.length;
                if (bl) {
                    boolean bl7 = bl = this.code.length > 0;
                }
                if (!bl) {
                    throw new ExPropertyEditorSupport.EnvException("The arrays of keys and values and codes must all have the same length, > 0. keys.length =" + this.keys.length + " values.length=" + this.values.length + " Code.length=" + this.code.length + " Keys=" + IntEditor.arrToStr(this.keys) + " Values=" + IntEditor.arrToStr(this.values) + " Code=" + IntEditor.arrToStr(this.code));
                }
            }
        }
    }

    private static final String arrToStr(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 3);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getAsText() {
        Integer n = (Integer)this.getValue();
        if (n == null) return NbBundle.getMessage(IntEditor.class, (String)"NULL");
        if (this.keys == null) return this.getValue().toString();
        int n2 = n;
        int n3 = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != n2) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) throw new IllegalArgumentException("This property editor uses a set of keyed values, and the current value, " + n + ", is not specified.");
        return this.keys[(Integer)super.getValue()];
    }

    private void doSetAsText(String string) {
        try {
            this.setValue(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = NbBundle.getMessage(IntEditor.class, (String)"EXC_ILLEGAL_VALUE_TEXT") + string;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            UIExceptions.annotateUser(illegalArgumentException, string2, string2, numberFormatException, new Date());
            throw illegalArgumentException;
        }
    }

    @Override
    public void setAsText(String string) {
        string = string.trim();
        if (this.keys == null) {
            this.doSetAsText(string);
        } else {
            int n = Arrays.asList(this.keys).indexOf(string);
            if (n == -1 || n > this.values.length - 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(NbBundle.getMessage(IntEditor.class, (String)"EXC_ILLEGAL_STRING_TEXT_FIRST"));
                stringBuilder.append(string);
                stringBuilder.append(NbBundle.getMessage(IntEditor.class, (String)"EXC_ILLEGAL_STRING_TEXT_SECOND"));
                stringBuilder.append(IntEditor.arrToStr(this.keys));
                String string2 = stringBuilder.toString();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                UIExceptions.annotateUser(illegalArgumentException, string2, string2, illegalArgumentException, new Date());
                throw illegalArgumentException;
            }
            this.setValue(n);
        }
    }

    @Override
    public Object getValue() {
        Integer n = (Integer)super.getValue();
        if (this.values != null) {
            n = this.values[n];
        }
        return n;
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof Integer) && object != null) {
            throw new IllegalArgumentException("Argument to IntEditor.setValue() must be Integer, but was " + object.getClass().getName() + "(=" + object.toString() + ")");
        }
        super.setValue(object);
    }

    @Override
    public String[] getTags() {
        return this.keys;
    }

    @Override
    public String getJavaInitializationString() {
        String string = this.code == null ? this.getValue().toString() : this.code[(Integer)this.getValue()];
        return string;
    }
}

