/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public abstract class PrestimeCPUCCTNode
implements CCTNode,
Cloneable {
    private static final String SELF_TIME_STRING;
    private static final String FROM_MSG;
    protected static final char MASK_SELF_TIME_NODE = '\u0001';
    protected static final char MASK_CONTEXT_CALLS_NODE = '\u0002';
    protected static final char MASK_THREAD_NODE = '\u0004';
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_TIME_0 = 2;
    public static final int SORT_BY_TIME_1 = 3;
    public static final int SORT_BY_INVOCATIONS = 4;
    protected CPUCCTContainer container;
    protected PrestimeCPUCCTNode parent;
    protected PrestimeCPUCCTNode[] children;
    protected char flags;

    protected PrestimeCPUCCTNode() {
    }

    protected PrestimeCPUCCTNode(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode prestimeCPUCCTNode) {
        this.container = cPUCCTContainer;
        this.parent = prestimeCPUCCTNode;
    }

    @Override
    public abstract CCTNode getChild(int var1);

    @Override
    public abstract CCTNode[] getChildren();

    public CPUCCTContainer getContainer() {
        return this.container;
    }

    public void setContextCallsNode() {
        this.flags = (char)2;
    }

    public boolean isContextCallsNode() {
        return (this.flags & 2) != 0;
    }

    public String[] getMethodClassNameAndSig() {
        if (!this.isThreadNode()) {
            return this.container.getMethodClassNameAndSig(this.getMethodId());
        }
        return new String[]{this.container.getThreadName(), "", ""};
    }

    public abstract int getMethodId();

    public abstract int getNCalls();

    @Override
    public abstract int getNChildren();

    public String getNodeName() {
        if (this.isSelfTimeNode()) {
            return SELF_TIME_STRING;
        }
        if (this.isThreadNode()) {
            return this.container.getThreadName();
        }
        int n = this.getMethodId();
        String[] stringArray = this.container.getMethodClassNameAndSig(n);
        String string = MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(stringArray[0], stringArray[1], stringArray[2]).toFormatted();
        if (this.isContextCallsNode()) {
            return MessageFormat.format(FROM_MSG, string);
        }
        return string;
    }

    @Override
    public CCTNode getParent() {
        return this.parent;
    }

    public abstract long getSleepTime0();

    public abstract int getThreadId();

    public void setSelfTimeNode() {
        this.flags = '\u0001';
    }

    public boolean isSelfTimeNode() {
        return (this.flags & '\u0001') != 0;
    }

    public void setThreadNode() {
        this.flags = (char)4;
    }

    public boolean isThreadNode() {
        return (this.flags & 4) != 0;
    }

    public abstract long getTotalTime0();

    public abstract float getTotalTime0InPerCent();

    public abstract long getTotalTime1();

    public abstract float getTotalTime1InPerCent();

    public abstract long getWaitTime0();

    @Override
    public int getIndexOfChild(Object object) {
        for (int i = 0; i < this.children.length; ++i) {
            if ((PrestimeCPUCCTNode)object != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public abstract void sortChildren(int var1, boolean var2);

    public String toString() {
        return this.getNodeName();
    }

    protected void doSortChildren(int n, boolean bl) {
        int n2 = this.children.length;
        for (int i = 0; i < n2; ++i) {
            this.children[i].sortChildren(n, bl);
        }
        if (n2 > 1) {
            switch (n) {
                case 1: {
                    this.sortChildrenByName(bl);
                    break;
                }
                case 2: {
                    this.sortChildrenByTime0(bl);
                    break;
                }
                case 3: {
                    this.sortChildrenByTime1(bl);
                    break;
                }
                case 4: {
                    this.sortChildrenByInvocations(bl);
                }
            }
        }
    }

    protected void sortChildrenByInvocations(boolean bl) {
        int n = this.children.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.children[i].getNCalls();
        }
        this.sortInts(nArray, bl);
    }

    protected void sortChildrenByName(boolean bl) {
        int n = this.children.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.children[i].getNodeName();
        }
        this.sortStrings(stringArray, bl);
    }

    protected void sortChildrenByTime0(boolean bl) {
        int n = this.children.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.children[i].getTotalTime0();
        }
        this.sortLongs(lArray, bl);
    }

    protected void sortChildrenByTime1(boolean bl) {
        int n = this.children.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.children[i].getTotalTime1();
        }
        this.sortLongs(lArray, bl);
    }

    protected void sortInts(int[] nArray, boolean bl) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0 && (!bl ? nArray[j - 1] < nArray[j] : nArray[j - 1] > nArray[j]); --j) {
                int n2 = nArray[j];
                nArray[j] = nArray[j - 1];
                nArray[j - 1] = n2;
                PrestimeCPUCCTNode prestimeCPUCCTNode = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = prestimeCPUCCTNode;
            }
        }
    }

    protected void sortLongs(long[] lArray, boolean bl) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0 && (!bl ? lArray[j - 1] < lArray[j] : lArray[j - 1] > lArray[j]); --j) {
                long l = lArray[j];
                lArray[j] = lArray[j - 1];
                lArray[j - 1] = l;
                PrestimeCPUCCTNode prestimeCPUCCTNode = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = prestimeCPUCCTNode;
            }
        }
    }

    protected void sortStrings(String[] stringArray, boolean bl) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0 && (!bl ? stringArray[j - 1].compareTo(stringArray[j]) < 0 : stringArray[j - 1].compareTo(stringArray[j]) > 0); --j) {
                String string = stringArray[j];
                stringArray[j] = stringArray[j - 1];
                stringArray[j - 1] = string;
                PrestimeCPUCCTNode prestimeCPUCCTNode = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = prestimeCPUCCTNode;
            }
        }
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle");
        SELF_TIME_STRING = resourceBundle.getString("PrestimeCPUCCTNode_SelfTimeString");
        FROM_MSG = resourceBundle.getString("PrestimeCPUCCTNode_FromMsg");
    }
}

