/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;

class DominatorTree {
    private static final int BUFFER_SIZE = 8192;
    private HprofHeap heap;
    private LongBuffer multipleParents;
    private LongBuffer revertedMultipleParents;
    private LongBuffer currentMultipleParents;
    private Map map;
    private Set dirtySet = Collections.EMPTY_SET;
    private Map nearestGCRootCache = new NearestGCRootCache(400000);

    DominatorTree(HprofHeap hprofHeap, LongBuffer longBuffer) {
        this.heap = hprofHeap;
        this.currentMultipleParents = this.multipleParents = longBuffer;
        this.map = new HashMap(longBuffer.getSize());
        try {
            this.revertedMultipleParents = longBuffer.revertBuffer();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getLocalizedMessage(), iOException);
        }
    }

    synchronized void computeDominators() {
        boolean bl = true;
        try {
            boolean bl2;
            do {
                this.currentMultipleParents.rewind();
                bl2 = !bl;
                bl = this.computeOneLevel(bl2);
                this.switchParents();
            } while (bl || !bl2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deleteBuffers();
        this.nearestGCRootCache = null;
        this.dirtySet = Collections.EMPTY_SET;
    }

    private boolean computeOneLevel(boolean bl) throws IOException {
        long l;
        boolean bl2 = false;
        HashSet<Long> hashSet = new HashSet<Long>(this.map.size() / 10);
        while ((l = this.readLong()) != 0L) {
            Long l2 = new Long(l);
            Long l3 = (Long)this.map.get(l2);
            if (l3 != null && (l3 == 0L || !bl && !this.dirtySet.contains(l3))) continue;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(l);
            List list = entry.getReferences();
            Iterator iterator = list.iterator();
            Long l4 = (Long)iterator.next();
            boolean bl3 = false;
            while (iterator.hasNext() && l4 != 0L) {
                Long l5 = (Long)iterator.next();
                l4 = this.intersect(l4, l5);
            }
            if (l3 == null) {
                this.map.put(l2, l4);
                hashSet.add(l4);
                bl2 = true;
                continue;
            }
            if (l3.longValue() == l4.longValue()) continue;
            hashSet.add(l3);
            hashSet.add(l4);
            this.map.put(l2, l4);
            bl2 = true;
        }
        this.dirtySet = hashSet;
        return bl2;
    }

    private void deleteBuffers() {
        this.multipleParents.delete();
        this.revertedMultipleParents.delete();
    }

    private long readLong() throws IOException {
        return this.currentMultipleParents.readLong();
    }

    long getIdomId(long l, LongMap.Entry entry) {
        Long l2 = (Long)this.map.get(new Long(l));
        if (l2 != null) {
            return l2;
        }
        if (entry == null) {
            entry = this.heap.idToOffsetMap.get(l);
        }
        return entry.getNearestGCRootPointer();
    }

    private Long getNearestGCRootPointer(Long l) {
        Long l2 = (Long)this.nearestGCRootCache.get(l);
        if (l2 != null) {
            return l2;
        }
        LongMap.Entry entry = this.heap.idToOffsetMap.get(l);
        Long l3 = entry.getNearestGCRootPointer();
        this.nearestGCRootCache.put(l, l3);
        return l3;
    }

    private Long getIdomId(Long l) {
        Long l2 = (Long)this.map.get(l);
        if (l2 != null) {
            return l2;
        }
        return this.getNearestGCRootPointer(l);
    }

    private Long intersect(Long l, Long l2) {
        if (l.longValue() == l2.longValue()) {
            return l;
        }
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        HashSet<Long> hashSet = new HashSet<Long>(200);
        HashSet<Long> hashSet2 = new HashSet<Long>(200);
        Long l3 = l;
        Long l4 = l2;
        hashSet.add(l3);
        hashSet2.add(l4);
        while (true) {
            if (l3 != 0L) {
                if (hashSet2.contains(l3 = this.getIdomId(l3))) {
                    return l3;
                }
                hashSet.add(l3);
            }
            if (l4 == 0L) continue;
            if (hashSet.contains(l4 = this.getIdomId(l4))) {
                return l4;
            }
            hashSet2.add(l4);
        }
    }

    private void switchParents() {
        this.currentMultipleParents = this.currentMultipleParents == this.revertedMultipleParents ? this.multipleParents : this.revertedMultipleParents;
    }

    private static final class NearestGCRootCache
    extends LinkedHashMap {
        private final int maxSize;

        private NearestGCRootCache(int n) {
            super(n, 0.75f, true);
            this.maxSize = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.maxSize;
        }
    }
}

