/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.openide.awt.CloseButtonFactory;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

final class CloseButtonTabbedPane
extends JTabbedPane
implements PropertyChangeListener {
    private Image closeTabImage;
    private Image closeTabPressedImage;
    private Image closeTabMouseOverImage;
    static final String PROP_CLOSE = "close";
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private static final boolean HTML_TABS_BROKEN = CloseButtonTabbedPane.htmlTabsBroken();
    private final Pattern removeHtmlTags = HTML_TABS_BROKEN ? Pattern.compile("\\<.*?\\>") : null;

    CloseButtonTabbedPane() {
        this.addMouseListener(new MouseAdapter(){
            int lastIdx = -1;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    this.lastIdx = CloseButtonTabbedPane.this.getUI().tabForCoordinate(CloseButtonTabbedPane.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    int n = CloseButtonTabbedPane.this.getUI().tabForCoordinate(CloseButtonTabbedPane.this, mouseEvent.getX(), mouseEvent.getY());
                    if (n >= 0) {
                        Component component = CloseButtonTabbedPane.this.getComponentAt(n);
                        if (n == this.lastIdx && component != null && !CloseButtonTabbedPane.this.hideCloseButton(component)) {
                            CloseButtonTabbedPane.this.fireCloseRequest(component);
                        }
                    }
                    this.lastIdx = -1;
                }
            }
        });
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
        this.setTabLayoutPolicy(1);
    }

    private Component sel() {
        Component component = this.getSelectedComponent();
        return component == null ? this : component;
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        component.addPropertyChangeListener("noCloseButton", this);
        if (!this.hideCloseButton(component)) {
            this.setTabComponentAt(n, new ButtonTab());
        }
        if (string != null) {
            this.setTitleAt(n, string);
        }
        this.validate();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get("navigatePageUp");
        if (null != action && !(action instanceof MyNavigateAction)) {
            actionMap.put("navigatePageUp", new MyNavigateAction(action));
        }
        if (null != (action = actionMap.get("navigatePageDown")) && !(action instanceof MyNavigateAction)) {
            actionMap.put("navigatePageDown", new MyNavigateAction(action));
        }
    }

    @Override
    public void removeTabAt(int n) {
        Component component = this.getComponentAt(n);
        component.removePropertyChangeListener("noCloseButton", this);
        super.removeTabAt(n);
    }

    private static boolean htmlTabsBroken() {
        String string = System.getProperty("java.version");
        for (int i = 14; i < 18; ++i) {
            if (!string.startsWith("1.6.0_" + i)) continue;
            return true;
        }
        return string.startsWith("1.6.0") && CloseButtonTabbedPane.isAquaLaF();
    }

    @Override
    public void setTitleAt(int n, String string) {
        if (string == null) {
            super.setTitleAt(n, null);
            return;
        }
        if (this.removeHtmlTags != null && string.startsWith("<html>")) {
            string = this.removeHtmlTags.matcher(string).replaceAll("");
            string = string.replace("&nbsp;", "");
        }
        super.setTitleAt(n, string);
    }

    private Component findTabAt(int n) {
        int n2 = -1;
        for (Component component : this.getComponents()) {
            if (component instanceof UIResource || ++n2 != n) continue;
            return component;
        }
        return null;
    }

    private boolean hideCloseButton(Component component) {
        Object object;
        return component != null && component instanceof JComponent && (object = ((JComponent)component).getClientProperty("noCloseButton")) != null && object instanceof Boolean && (Boolean)object != false;
    }

    private Rectangle getCloseButtonBoundsAt(int n) {
        Component component = this.findTabAt(n);
        if (this.hideCloseButton(component)) {
            return null;
        }
        Rectangle rectangle = this.getBoundsAt(n);
        if (rectangle == null) {
            return null;
        }
        rectangle = new Rectangle(rectangle);
        CloseButtonTabbedPane.fixGetBoundsAt(rectangle);
        Dimension dimension = this.getSize();
        if (rectangle.x + rectangle.width >= dimension.width || rectangle.y + rectangle.height >= dimension.height) {
            return null;
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        if ((this.isWindowsVistaLaF() || this.isWindowsXPLaF() || this.isWindowsLaF()) && n == this.getSelectedIndex()) {
            rectangle.x -= 3;
            rectangle.y -= 2;
        } else if (this.isWindowsXPLaF() || this.isWindowsLaF() || CloseButtonTabbedPane.isAquaLaF()) {
            rectangle.x -= 2;
        } else if (this.isGTKLaF() && n == this.getSelectedIndex()) {
            --rectangle.x;
            rectangle.y -= 2;
        }
        if (n == this.getTabCount() - 1) {
            if (this.isMetalLaF()) {
                --rectangle.x;
            } else if (CloseButtonTabbedPane.isAquaLaF()) {
                rectangle.x -= 3;
            }
        }
        return new Rectangle(rectangle.x + rectangle.width - 13, rectangle.y + rectangle.height / 2 - 5, 12, 12);
    }

    private boolean isWindowsVistaLaF() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private boolean isWindowsXPLaF() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return this.isWindowsLaF() && bl != null && bl != false;
    }

    private boolean isWindowsLaF() {
        String string = UIManager.getLookAndFeel().getID();
        return string.endsWith("Windows");
    }

    private static boolean isAquaLaF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private boolean isMetalLaF() {
        String string = UIManager.getLookAndFeel().getID();
        return "Metal".equals(string);
    }

    private boolean isGTKLaF() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private void setPressedCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.pressedCloseButtonIndex == n) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            JComponent jComponent;
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            if ((jComponent = this._getJComponentAt(this.pressedCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.pressedCloseButtonIndex, jComponent.getToolTipText());
            }
        }
        this.pressedCloseButtonIndex = n;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.mouseOverCloseButtonIndex == n) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            JComponent jComponent;
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            if ((jComponent = this._getJComponentAt(this.mouseOverCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.mouseOverCloseButtonIndex, jComponent.getToolTipText());
            }
        }
        this.mouseOverCloseButtonIndex = n;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private JComponent _getJComponentAt(int n) {
        Component component = this.getComponentAt(n);
        return component instanceof JComponent ? (JComponent)component : null;
    }

    private void fireCloseRequest(Component component) {
        int n;
        this.firePropertyChange(PROP_CLOSE, null, component);
        if (this.getTabLayoutPolicy() == 1 && (n = this.getSelectedIndex()) > 0) {
            this.setSelectedIndex(0);
            this.setSelectedIndex(n);
        }
    }

    static void fixGetBoundsAt(Rectangle rectangle) {
        if (rectangle.y < 0) {
            rectangle.y = -rectangle.y;
        }
        if (rectangle.x < 0) {
            rectangle.x = -rectangle.x;
        }
    }

    static int findTabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            Rectangle rectangle = jTabbedPane.getBoundsAt(i);
            if (rectangle == null) continue;
            rectangle = new Rectangle(rectangle);
            CloseButtonTabbedPane.fixGetBoundsAt(rectangle);
            if (!rectangle.contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        try {
            super.processMouseEvent(mouseEvent);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Exceptions.attachLocalizedMessage((Throwable)arrayIndexOutOfBoundsException, (String)"Suppressed AIOOBE bug in BasicTabbedPaneUI");
            Logger.getAnonymousLogger().log(Level.WARNING, null, arrayIndexOutOfBoundsException);
        }
    }

    @Override
    protected void fireStateChanged() {
        block2: {
            try {
                super.fireStateChanged();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (Utilities.isMac()) break block2;
                throw arrayIndexOutOfBoundsException;
            }
        }
    }

    @Override
    public Color getBackgroundAt(int n) {
        if (this.isWindowsLaF() && !this.isWindowsXPLaF()) {
            Color color;
            Color color2 = UIManager.getColor("controlHighlight");
            if (color2.equals(color = UIManager.getColor("control"))) {
                color = new Color(Math.max(color2.getRed() - 12, 0), Math.max(color2.getGreen() - 12, 0), Math.max(color2.getBlue() - 12, 0));
            }
            return n == this.getSelectedIndex() ? color2 : color;
        }
        return super.getBackgroundAt(n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Component) {
            assert (propertyChangeEvent.getPropertyName().equals("noCloseButton"));
            Component component = (Component)propertyChangeEvent.getSource();
            int n = this.indexOfComponent(component);
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setTabComponentAt(n, bl ? null : new ButtonTab());
        }
    }

    private class MyNavigateAction
    extends AbstractAction {
        private final Action orig;

        public MyNavigateAction(Action action) {
            this.orig = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.orig.actionPerformed(actionEvent);
        }

        @Override
        public boolean isEnabled() {
            return CloseButtonTabbedPane.this.getTabCount() > 1;
        }
    }

    class ButtonTab
    extends JPanel {
        JLabel label;

        public ButtonTab() {
            super(new FlowLayout(0, 0, 0));
            this.setOpaque(false);
            this.label = new JLabel(""){
                private String lastText;
                {
                    super(string);
                    this.lastText = null;
                }

                @Override
                public String getText() {
                    String string = "";
                    int n = CloseButtonTabbedPane.this.indexOfTabComponent(ButtonTab.this);
                    if (n >= 0) {
                        string = CloseButtonTabbedPane.this.getTitleAt(n);
                    }
                    if (null != this.lastText && this.lastText.equals(string)) {
                        return this.lastText;
                    }
                    this.lastText = string;
                    if (!super.getText().equals(string)) {
                        this.setText(string);
                    }
                    return string;
                }

                @Override
                public Icon getIcon() {
                    Icon icon;
                    int n = CloseButtonTabbedPane.this.indexOfTabComponent(ButtonTab.this);
                    Icon icon2 = icon = n >= 0 ? CloseButtonTabbedPane.this.getIconAt(n) : null;
                    if (super.getIcon() != icon) {
                        this.setIcon(icon);
                    }
                    return icon;
                }
            };
            this.add(this.label);
            JButton jButton = CloseButtonFactory.createCloseButton();
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CloseButtonTabbedPane.this.indexOfTabComponent(ButtonTab.this);
                    if (n != -1) {
                        CloseButtonTabbedPane.this.fireCloseRequest(CloseButtonTabbedPane.this.getComponentAt(n));
                    }
                }
            });
            this.add(jButton);
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            return CloseButtonTabbedPane.this.sel();
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            return CloseButtonTabbedPane.this.sel();
        }

        @Override
        public Component getFirstComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }

        @Override
        public Component getLastComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }
    }
}

