/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.openide.text.UndoRedoManager;

final class WrapUndoEdit
implements UndoableEdit {
    final UndoRedoManager undoRedoManager;
    private UndoableEdit delegate;

    WrapUndoEdit(UndoRedoManager undoRedoManager, UndoableEdit undoableEdit) {
        assert (undoableEdit != null) : "Delegate is null";
        this.undoRedoManager = undoRedoManager;
        this.delegate = undoableEdit;
    }

    UndoableEdit delegate() {
        return this.delegate;
    }

    void setDelegate(UndoableEdit undoableEdit) {
        this.delegate = undoableEdit;
    }

    @Override
    public void undo() throws CannotUndoException {
        UndoRedoManager.checkLogOp("WrapUndoEdit.undo", this);
        this.undoRedoManager.beforeUndoCheck(this);
        this.delegate.undo();
        this.undoRedoManager.afterUndoCheck(this);
    }

    @Override
    public boolean canUndo() {
        return this.delegate.canUndo();
    }

    @Override
    public void redo() throws CannotRedoException {
        UndoRedoManager.checkLogOp("WrapUndoEdit.redo", this);
        this.undoRedoManager.beforeRedoCheck(this);
        this.delegate.redo();
        this.undoRedoManager.afterRedoCheck(this);
    }

    @Override
    public boolean canRedo() {
        return this.delegate.canRedo();
    }

    @Override
    public void die() {
        UndoRedoManager.checkLogOp("WrapUndoEdit.die", this);
        this.delegate.die();
        this.undoRedoManager.notifyWrapEditDie(this);
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (this.undoRedoManager.isAtSavepoint()) {
            this.undoRedoManager.mergeSaveActionsToLastEdit(this);
            return false;
        }
        WrapUndoEdit wrapUndoEdit = (WrapUndoEdit)undoableEdit;
        boolean bl = this.delegate.addEdit(wrapUndoEdit.delegate);
        return bl;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        if (this.undoRedoManager.isAtSavepoint()) {
            return false;
        }
        WrapUndoEdit wrapUndoEdit = (WrapUndoEdit)undoableEdit;
        boolean bl = this.delegate.replaceEdit(wrapUndoEdit.delegate);
        UndoRedoManager.checkLogOp("WrapUndoEdit.replaceEdit=" + bl, undoableEdit);
        if (bl) {
            this.undoRedoManager.checkReplaceSavepointEdit(wrapUndoEdit, this);
        }
        return bl;
    }

    @Override
    public boolean isSignificant() {
        return this.delegate.isSignificant();
    }

    @Override
    public String getPresentationName() {
        return this.delegate.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        return this.delegate.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        return this.delegate.getRedoPresentationName();
    }
}

