/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import oracle.jrockit.jfr.settings.JSONArray;
import oracle.jrockit.jfr.settings.JSONElement;
import oracle.jrockit.jfr.settings.JSONObject;
import oracle.jrockit.jfr.settings.JSONPrimitive;

@Deprecated
class JSONTokener {
    private int line;
    private int columnStart;
    private int index;
    private Reader reader;
    private char lastChar;
    private boolean useLastChar;

    public JSONTokener(Reader reader) {
        this.reader = reader;
        this.useLastChar = false;
        this.index = 0;
    }

    public JSONTokener(String string) {
        this(new StringReader(string));
    }

    public void back() {
        if (this.useLastChar || this.index <= 0) {
            throw new IllegalStateException("Stepping back two steps not supported");
        }
        --this.index;
        this.useLastChar = true;
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public char next() throws IOException {
        if (this.useLastChar) {
            this.useLastChar = false;
            if (this.lastChar != '\u0000') {
                ++this.index;
            }
            return this.lastChar;
        }
        int n = this.reader.read();
        if (n <= 0) {
            this.lastChar = '\u0000';
            return '\u0000';
        }
        ++this.index;
        if (n == 10) {
            ++this.line;
            this.columnStart = this.index;
        }
        this.lastChar = (char)n;
        return this.lastChar;
    }

    private String next(int n) throws IOException, ParseException {
        int n2;
        char[] cArray = new char[n];
        int n3 = 0;
        if (this.useLastChar) {
            this.useLastChar = false;
            cArray[0] = this.lastChar;
            n3 = 1;
        }
        while (n3 < n && (n2 = this.reader.read(cArray, n3, n - n3)) != -1) {
            n3 += n2;
        }
        this.index += n3;
        if (n3 < n) {
            throw this.syntaxError("Substring bounds error");
        }
        this.lastChar = cArray[n - 1];
        return new String(cArray);
    }

    private void skipTo(int n) throws IOException {
        char c;
        while ((c = this.next()) != n) {
        }
    }

    public char nextClean() throws IOException {
        char c;
        while (true) {
            if ((c = this.next()) == '/') {
                char c2 = this.next();
                if (c2 == '/') {
                    this.skipTo(10);
                    continue;
                }
                if (c2 == '*') {
                    do {
                        this.skipTo(42);
                    } while ((c2 = this.next()) != '/');
                    continue;
                }
                this.back();
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public String nextString(char c) throws IOException, ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        block13: while (true) {
            char c2 = this.next();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c2 = this.next();
                    switch (c2) {
                        case 'b': {
                            stringBuilder.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuilder.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            stringBuilder.append(c2);
                            continue block13;
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
            }
            if (c2 == c) {
                return stringBuilder.toString();
            }
            stringBuilder.append(c2);
        }
    }

    JSONElement nextValue() throws IOException, ParseException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return new JSONPrimitive(this.nextString(c));
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '(': 
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (c > ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            stringBuilder.append(c);
            c = this.next();
        }
        this.back();
        String string = stringBuilder.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value");
        }
        return new JSONPrimitive(JSONTokener.stringToValue(string));
    }

    private static Object stringToValue(String string) {
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        char c = string.charAt(0);
        if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
            if (c == '0') {
                if (string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(string.substring(2), 16));
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(string, 8));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    return Double.valueOf(string);
                }
                Long l = new Long(string);
                if (l == (long)l.intValue()) {
                    return new Integer(l.intValue());
                }
                return l;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public ParseException syntaxError(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.useLastChar && this.lastChar != '\u0000' && this.index > 0) {
            this.back();
        }
        stringBuilder.append(string).append(", line=").append(this.line).append(", column=").append(this.index - this.columnStart);
        stringBuilder.append(" : ");
        for (int i = 0; i < 100; ++i) {
            try {
                char c = this.next();
                if (c == '\u0000') break;
                stringBuilder.append(c);
                continue;
            }
            catch (Exception exception) {
                break;
            }
        }
        return new ParseException(stringBuilder.toString(), this.index);
    }
}

