/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.net.URI;
import java.nio.ByteBuffer;
import oracle.jrockit.jfr.VMJFR;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.settings.EventSetting;

@Deprecated
class NativeEventControl
implements EventControl,
EventDescriptor {
    private long period;
    private long nanoThreshold;
    private final VMJFR vmjfr;
    private final ByteBuffer control;
    private final int offset;
    private final int id;
    private final String name;
    private final String desc;
    private final String path;
    private final URI uri;
    private final boolean hasStartTime;
    private final boolean hasThread;
    private final boolean canHaveStackTrace;
    private final boolean isRequestable;

    NativeEventControl(VMJFR vMJFR, ByteBuffer byteBuffer, int n, int n2, String string, String string2, String string3, URI uRI, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.vmjfr = vMJFR;
        this.control = byteBuffer;
        this.offset = n;
        this.id = n2;
        this.name = string;
        this.desc = string2;
        this.path = string3;
        this.uri = uRI;
        this.hasStartTime = bl;
        this.hasThread = bl2;
        this.canHaveStackTrace = bl3;
        this.isRequestable = bl4;
        this.period = this.isRequestable() ? vMJFR.getPeriod(n2) : 0L;
    }

    @Override
    public void apply(EventSetting eventSetting) {
        this.setEnabled(eventSetting.isEnabled());
        this.setStackTraceEnabled(eventSetting.isStacktraceEnabled());
        this.setThreshold(eventSetting.getThreshold());
        this.setPeriod(eventSetting.getPeriod());
    }

    @Override
    public EventDescriptor getDescriptor() {
        return this;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isRequestable()) {
            if (bl) {
                this.vmjfr.setPeriod(this.id, this.period);
            } else {
                this.vmjfr.setPeriod(this.id, 0L);
            }
        }
        if (this.isEnabled() != bl) {
            this.control.put(this.offset + 9, bl ? (byte)1 : 0);
        }
    }

    @Override
    public void setPeriod(long l) {
        if (this.isRequestable()) {
            if (this.isEnabled()) {
                this.vmjfr.setPeriod(this.id, l);
            }
            this.period = l;
        }
    }

    @Override
    public void setStackTraceEnabled(boolean bl) {
        if (this.hasStackTrace()) {
            this.control.put(this.offset + 8, bl ? (byte)1 : 0);
        }
    }

    @Override
    public void setThreshold(long l) {
        if (this.isTimed()) {
            this.vmjfr.setThreshold(this.id, l);
            this.nanoThreshold = l;
        }
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public long getThresholdTicks() {
        return this.control.getLong(this.offset);
    }

    @Override
    public long getThreshold() {
        return this.nanoThreshold;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean hasStackTrace() {
        return this.canHaveStackTrace;
    }

    @Override
    public boolean hasThread() {
        return this.hasThread;
    }

    @Override
    public boolean isEnabled() {
        return this.control.get(this.offset + 9) != 0;
    }

    @Override
    public boolean isRequestable() {
        return this.isRequestable;
    }

    @Override
    public boolean isStackTraceEnabled() {
        return this.control.get(this.offset + 8) != 0;
    }

    @Override
    public boolean isTimed() {
        return this.hasStartTime;
    }

    @Override
    public boolean hasStartTime() {
        return this.hasStartTime;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isTimed()) {
            stringBuilder.append("{ Timed event id=");
        } else if (this.isRequestable()) {
            stringBuilder.append("{ Requestable event id=");
        } else {
            stringBuilder.append("{ Event id=");
        }
        stringBuilder.append(this.id).append(", name=").append(this.name);
        stringBuilder.append(", uri=").append(this.uri);
        if (this.isEnabled()) {
            stringBuilder.append(", enabled");
        }
        if (this.hasThread) {
            stringBuilder.append(", thread");
        }
        if (this.hasStackTrace()) {
            stringBuilder.append(", stacktrace(").append(this.isStackTraceEnabled() ? "on" : "off").append(')');
        }
        if (this.isTimed()) {
            stringBuilder.append(", threshold=").append(this.getThreshold()).append("ns");
        }
        if (this.isRequestable()) {
            stringBuilder.append(", period=").append(this.getPeriod()).append("ms");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

