/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit;

import com.javafx.tools.doclets.formats.html.HtmlDoclet;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.BuilderFactory;
import com.javafx.tools.doclets.internal.toolkit.util.ClassTree;
import com.javafx.tools.doclets.internal.toolkit.util.PackageListWriter;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.util.StringTokenizer;

public abstract class AbstractDoclet {
    public Configuration configuration;
    private static final String TOOLKIT_DOCLET_NAME = new HtmlDoclet().getClass().getName();

    private boolean isValidDoclet(AbstractDoclet doclet) {
        if (!doclet.getClass().getName().equals(TOOLKIT_DOCLET_NAME)) {
            this.configuration.message.error("doclet.Toolkit_Usage_Violation", TOOLKIT_DOCLET_NAME);
            return false;
        }
        return true;
    }

    public boolean start(AbstractDoclet doclet, RootDoc root) {
        this.configuration = this.configuration();
        this.configuration.root = root;
        if (!this.isValidDoclet(doclet)) {
            return false;
        }
        try {
            doclet.startGeneration(root);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public abstract Configuration configuration();

    private void startGeneration(RootDoc root) throws Exception {
        if (root.classes().length == 0) {
            this.configuration.message.error("doclet.No_Public_Classes_To_Document", new Object[0]);
            return;
        }
        this.configuration.setOptions();
        this.configuration.getDocletSpecificMsg().notice("doclet.build_version", this.configuration.getDocletSpecificBuildDate());
        ClassTree classtree = new ClassTree(this.configuration, this.configuration.nodeprecated);
        this.generateClassFiles(root, classtree);
        if (this.configuration.sourcepath != null && this.configuration.sourcepath.length() > 0) {
            StringTokenizer pathTokens = new StringTokenizer(this.configuration.sourcepath, String.valueOf(File.pathSeparatorChar));
            boolean first = true;
            while (pathTokens.hasMoreTokens()) {
                Util.copyDocFiles(this.configuration, pathTokens.nextToken() + File.separator, "doc-files", first);
                first = false;
            }
        }
        PackageListWriter.generate(this.configuration);
        this.generatePackageFiles(classtree);
        this.generateOtherFiles(root, classtree);
        this.configuration.tagletManager.printReport();
    }

    protected void generateOtherFiles(RootDoc root, ClassTree classtree) throws Exception {
        BuilderFactory builderFactory = this.configuration.getBuilderFactory();
        AbstractBuilder constantsSummaryBuilder = builderFactory.getConstantsSummaryBuider();
        constantsSummaryBuilder.build();
        AbstractBuilder serializedFormBuilder = builderFactory.getSerializedFormBuilder();
        serializedFormBuilder.build();
    }

    protected abstract void generatePackageFiles(ClassTree var1) throws Exception;

    protected abstract void generateClassFiles(ClassDoc[] var1, ClassTree var2);

    protected void generateClassFiles(RootDoc root, ClassTree classtree) {
        this.generateClassFiles(classtree);
        PackageDoc[] packages = root.specifiedPackages();
        for (int i = 0; i < packages.length; ++i) {
            this.generateClassFiles(packages[i].allClasses(), classtree);
        }
    }

    private void generateClassFiles(ClassTree classtree) {
        String[] packageNames = this.configuration.classDocCatalog.packageNames();
        for (int packageNameIndex = 0; packageNameIndex < packageNames.length; ++packageNameIndex) {
            this.generateClassFiles(this.configuration.classDocCatalog.allClasses(packageNames[packageNameIndex]), classtree);
        }
    }
}

