/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.javafx.tools.doclets.formats.html.HtmlDocletWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.javafx.tools.doclets.internal.toolkit.MethodWriter;
import com.javafx.tools.doclets.internal.toolkit.util.ImplementedMethods;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import java.io.IOException;

public class MethodWriterImpl
extends AbstractExecutableMemberWriter
implements MethodWriter,
MemberSummaryWriter {
    public MethodWriterImpl(SubWriterHolderWriter writer, ClassDoc classDoc) {
        super(writer, classDoc);
    }

    public MethodWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    public Content getMemberSummaryHeader(ClassDoc classDoc, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_METHOD_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, classDoc, memberTree);
        return memberTree;
    }

    public Content getMethodDetailsTreeHeader(ClassDoc classDoc, Content memberDetailsTree) {
        memberDetailsTree.addContent(HtmlConstants.START_OF_METHOD_DETAILS);
        Content methodDetailsTree = this.writer.getMemberTreeHeader();
        methodDetailsTree.addContent(this.writer.getMarkerAnchor("method_detail"));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.DETAILS_HEADING, this.writer.methodDetailsLabel);
        methodDetailsTree.addContent(heading);
        return methodDetailsTree;
    }

    public Content getMethodDocTreeHeader(MethodDoc method, Content methodDetailsTree) {
        String erasureAnchor = this.getErasureAnchor((ExecutableMemberDoc)method);
        if (erasureAnchor != null) {
            methodDetailsTree.addContent(this.writer.getMarkerAnchor(erasureAnchor));
        }
        methodDetailsTree.addContent(this.writer.getMarkerAnchor(this.writer.getAnchor((ExecutableMemberDoc)method)));
        Content methodDocTree = this.writer.getMemberTreeHeader();
        HtmlTree heading = new HtmlTree(HtmlConstants.MEMBER_HEADING);
        ((Content)heading).addContent(method.name());
        methodDocTree.addContent(heading);
        return methodDocTree;
    }

    public Content getSignature(MethodDoc method) {
        this.writer.displayLength = 0;
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.writer.addAnnotationInfo((ProgramElementDoc)method, (Content)pre);
        this.addModifiers((MemberDoc)method, pre);
        this.addTypeParameters((ExecutableMemberDoc)method, pre);
        this.addReturnType(method, pre);
        if (this.configuration().linksource) {
            StringContent methodName = new StringContent(method.name());
            this.writer.addSrcLink((ProgramElementDoc)method, methodName, pre);
        } else {
            this.addName(method.name(), pre);
        }
        this.addParameters((ExecutableMemberDoc)method, pre);
        this.addExceptions((ExecutableMemberDoc)method, pre);
        return pre;
    }

    public void addDeprecated(MethodDoc method, Content methodDocTree) {
        this.addDeprecatedInfo((ProgramElementDoc)method, methodDocTree);
    }

    public void addComments(Type holder, MethodDoc method, Content methodDocTree) {
        ClassDoc holderClassDoc = holder.asClassDoc();
        if (method.inlineTags().length > 0) {
            if (holder.asClassDoc().equals(this.classdoc) || !holderClassDoc.isPublic() && !Util.isLinkable(holderClassDoc, this.configuration())) {
                this.writer.addInlineComment((Doc)method, methodDocTree);
            } else {
                RawHtml link = new RawHtml(this.writer.getDocLink(26, holder.asClassDoc(), (MemberDoc)method, holder.asClassDoc().isIncluded() ? holder.typeName() : holder.qualifiedTypeName(), false));
                HtmlTree codelLink = HtmlTree.CODE(link);
                HtmlTree strong = HtmlTree.STRONG(holder.asClassDoc().isClass() ? this.writer.descfrmClassLabel : this.writer.descfrmInterfaceLabel);
                ((Content)strong).addContent(this.writer.getSpace());
                ((Content)strong).addContent(codelLink);
                methodDocTree.addContent(HtmlTree.DIV(HtmlStyle.block, strong));
                this.writer.addInlineComment((Doc)method, methodDocTree);
            }
        }
    }

    public void addTags(MethodDoc method, Content methodDocTree) {
        this.writer.addTagsInfo((Doc)method, methodDocTree);
    }

    public Content getMethodDetails(Content methodDetailsTree) {
        return this.getMemberTree(methodDetailsTree);
    }

    public Content getMethodDoc(Content methodDocTree, boolean isLastContent) {
        return this.getMemberTree(methodDocTree, isLastContent);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public int getMemberKind() {
        return 4;
    }

    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Method_Summary"));
        memberTree.addContent(label);
    }

    public String getTableSummary() {
        return this.configuration().getText("doclet.Member_Table_Summary", this.configuration().getText("doclet.Method_Summary"), this.configuration().getText("doclet.methods"));
    }

    public String getCaption() {
        return this.configuration().getText("doclet.Methods");
    }

    public String[] getSummaryTableHeader(ProgramElementDoc member) {
        String[] header = new String[]{this.writer.getModifierTypeHeader(), this.configuration().getText("doclet.0_and_1", this.configuration().getText("doclet.Method"), this.configuration().getText("doclet.Description"))};
        return header;
    }

    public void addSummaryAnchor(ClassDoc cd, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor("method_summary"));
    }

    public void addInheritedSummaryAnchor(ClassDoc cd, Content inheritedTree) {
        inheritedTree.addContent(this.writer.getMarkerAnchor("methods_inherited_from_class_" + this.configuration().getClassName(cd)));
    }

    public void addInheritedSummaryLabel(ClassDoc cd, Content inheritedTree) {
        RawHtml classLink = new RawHtml(this.writer.getPreQualifiedClassLink(3, cd, false));
        StringContent label = new StringContent(cd.isClass() ? this.configuration().getText("doclet.Methods_Inherited_From_Class") : this.configuration().getText("doclet.Methods_Inherited_From_Interface"));
        HtmlTree labelHeading = HtmlTree.HEADING(HtmlConstants.INHERITED_SUMMARY_HEADING, label);
        ((Content)labelHeading).addContent(this.writer.getSpace());
        ((Content)labelHeading).addContent(classLink);
        inheritedTree.addContent(labelHeading);
    }

    protected void addSummaryType(ProgramElementDoc member, Content tdSummaryType) {
        MethodDoc meth = (MethodDoc)member;
        this.addModifierAndType((ProgramElementDoc)meth, meth.returnType(), tdSummaryType);
    }

    protected static void addOverridden(HtmlDocletWriter writer, Type overriddenType, MethodDoc method, Content dl) {
        if (writer.configuration.nocomment) {
            return;
        }
        ClassDoc holderClassDoc = overriddenType.asClassDoc();
        if (!holderClassDoc.isPublic() && !Util.isLinkable(holderClassDoc, writer.configuration())) {
            return;
        }
        if (overriddenType.asClassDoc().isIncluded() && !method.isIncluded()) {
            return;
        }
        Content label = writer.overridesLabel;
        int context = 28;
        if (method != null) {
            if (overriddenType.asClassDoc().isAbstract() && method.isAbstract()) {
                label = writer.specifiedByLabel;
                context = 27;
            }
            HtmlTree dt = HtmlTree.DT(HtmlTree.STRONG(label));
            dl.addContent(dt);
            RawHtml overriddenTypeLink = new RawHtml(writer.getLink(new LinkInfoImpl(context, overriddenType)));
            HtmlTree codeOverridenTypeLink = HtmlTree.CODE(overriddenTypeLink);
            String name = method.name();
            RawHtml methlink = new RawHtml(writer.getLink(new LinkInfoImpl(3, overriddenType.asClassDoc(), writer.getAnchor((ExecutableMemberDoc)method), name, false)));
            HtmlTree codeMethLink = HtmlTree.CODE(methlink);
            HtmlTree dd = HtmlTree.DD(codeMethLink);
            ((Content)dd).addContent(writer.getSpace());
            ((Content)dd).addContent(writer.getResource("doclet.in_class"));
            ((Content)dd).addContent(writer.getSpace());
            ((Content)dd).addContent(codeOverridenTypeLink);
            dl.addContent(dd);
        }
    }

    protected String parseCodeTag(String tag) {
        if (tag == null) {
            return "";
        }
        String lc = tag.toLowerCase();
        int begin = lc.indexOf("<code>");
        int end = lc.indexOf("</code>");
        if (begin == -1 || end == -1 || end <= begin) {
            return tag;
        }
        return tag.substring(begin + 6, end);
    }

    protected static void addImplementsInfo(HtmlDocletWriter writer, MethodDoc method, Content dl) {
        if (writer.configuration.nocomment) {
            return;
        }
        ImplementedMethods implementedMethodsFinder = new ImplementedMethods(method, writer.configuration);
        MethodDoc[] implementedMethods = implementedMethodsFinder.build();
        for (int i = 0; i < implementedMethods.length; ++i) {
            MethodDoc implementedMeth = implementedMethods[i];
            Type intfac = implementedMethodsFinder.getMethodHolder(implementedMeth);
            RawHtml intfaclink = new RawHtml(writer.getLink(new LinkInfoImpl(27, intfac)));
            HtmlTree codeIntfacLink = HtmlTree.CODE(intfaclink);
            HtmlTree dt = HtmlTree.DT(HtmlTree.STRONG(writer.specifiedByLabel));
            dl.addContent(dt);
            RawHtml methlink = new RawHtml(writer.getDocLink(3, (MemberDoc)implementedMeth, implementedMeth.name(), false));
            HtmlTree codeMethLink = HtmlTree.CODE(methlink);
            HtmlTree dd = HtmlTree.DD(codeMethLink);
            ((Content)dd).addContent(writer.getSpace());
            ((Content)dd).addContent(writer.getResource("doclet.in_interface"));
            ((Content)dd).addContent(writer.getSpace());
            ((Content)dd).addContent(codeIntfacLink);
            dl.addContent(dd);
        }
    }

    protected void addReturnType(MethodDoc method, Content htmltree) {
        Type type = method.returnType();
        if (type != null) {
            RawHtml linkContent = new RawHtml(this.writer.getLink(new LinkInfoImpl(16, type)));
            htmltree.addContent(linkContent);
            htmltree.addContent(this.writer.getSpace());
        }
    }

    protected Content getNavSummaryLink(ClassDoc cd, boolean link) {
        if (link) {
            return this.writer.getHyperLink("", cd == null ? "method_summary" : "methods_inherited_from_class_" + this.configuration().getClassName(cd), this.writer.getResource("doclet.navMethod"));
        }
        return this.writer.getResource("doclet.navMethod");
    }

    protected void addNavDetailLink(boolean link, Content liNav) {
        if (link) {
            liNav.addContent(this.writer.getHyperLink("", "method_detail", this.writer.getResource("doclet.navMethod")));
        } else {
            liNav.addContent(this.writer.getResource("doclet.navMethod"));
        }
    }
}

