/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.AbstractBasicFileAttributeView;
import sun.nio.fs.FileOwnerAttributeViewImpl;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;
import sun.nio.fs.Util;

class UnixFileAttributeViews {
    UnixFileAttributeViews() {
    }

    static Basic createBasicView(UnixPath unixPath, boolean bl) {
        return new Basic(unixPath, bl);
    }

    static Posix createPosixView(UnixPath unixPath, boolean bl) {
        return new Posix(unixPath, bl);
    }

    static Unix createUnixView(UnixPath unixPath, boolean bl) {
        return new Unix(unixPath, bl);
    }

    static FileOwnerAttributeViewImpl createOwnerView(UnixPath unixPath, boolean bl) {
        return new FileOwnerAttributeViewImpl(UnixFileAttributeViews.createPosixView(unixPath, bl));
    }

    static class Basic
    extends AbstractBasicFileAttributeView {
        protected final UnixPath file;
        protected final boolean followLinks;

        Basic(UnixPath unixPath, boolean bl) {
            this.file = unixPath;
            this.followLinks = bl;
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            this.file.checkRead();
            try {
                UnixFileAttributes unixFileAttributes = UnixFileAttributes.get(this.file, this.followLinks);
                return unixFileAttributes.asBasicFileAttributes();
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimes(FileTime fileTime, FileTime fileTime2, FileTime fileTime3) throws IOException {
            if (fileTime == null && fileTime2 == null) {
                return;
            }
            this.file.checkWrite();
            int n = this.file.openForAttributeAccess(this.followLinks);
            try {
                if (fileTime == null || fileTime2 == null) {
                    try {
                        UnixFileAttributes unixFileAttributes = UnixFileAttributes.get(n);
                        if (fileTime == null) {
                            fileTime = unixFileAttributes.lastModifiedTime();
                        }
                        if (fileTime2 == null) {
                            fileTime2 = unixFileAttributes.lastAccessTime();
                        }
                    }
                    catch (UnixException unixException) {
                        unixException.rethrowAsIOException(this.file);
                    }
                }
                long l = fileTime.to(TimeUnit.MICROSECONDS);
                long l2 = fileTime2.to(TimeUnit.MICROSECONDS);
                boolean bl = false;
                try {
                    UnixNativeDispatcher.futimes(n, l2, l);
                }
                catch (UnixException unixException) {
                    if (unixException.errno() == 22 && (l < 0L || l2 < 0L)) {
                        bl = true;
                    }
                    unixException.rethrowAsIOException(this.file);
                }
                if (bl) {
                    if (l < 0L) {
                        l = 0L;
                    }
                    if (l2 < 0L) {
                        l2 = 0L;
                    }
                    try {
                        UnixNativeDispatcher.futimes(n, l2, l);
                    }
                    catch (UnixException unixException) {
                        unixException.rethrowAsIOException(this.file);
                    }
                }
            }
            finally {
                UnixNativeDispatcher.close(n);
            }
        }
    }

    private static class Posix
    extends Basic
    implements PosixFileAttributeView {
        private static final String PERMISSIONS_NAME = "permissions";
        private static final String OWNER_NAME = "owner";
        private static final String GROUP_NAME = "group";
        static final Set<String> posixAttributeNames = Util.newSet(basicAttributeNames, new String[]{"permissions", "owner", "group"});

        Posix(UnixPath unixPath, boolean bl) {
            super(unixPath, bl);
        }

        final void checkReadExtended() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                this.file.checkRead();
                securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        final void checkWriteExtended() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                this.file.checkWrite();
                securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        @Override
        public String name() {
            return "posix";
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            if (string.equals(PERMISSIONS_NAME)) {
                this.setPermissions((Set)object);
                return;
            }
            if (string.equals(OWNER_NAME)) {
                this.setOwner((UserPrincipal)object);
                return;
            }
            if (string.equals(GROUP_NAME)) {
                this.setGroup((GroupPrincipal)object);
                return;
            }
            super.setAttribute(string, object);
        }

        final void addRequestedPosixAttributes(PosixFileAttributes posixFileAttributes, AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder) {
            this.addRequestedBasicAttributes(posixFileAttributes, attributesBuilder);
            if (attributesBuilder.match(PERMISSIONS_NAME)) {
                attributesBuilder.add(PERMISSIONS_NAME, posixFileAttributes.permissions());
            }
            if (attributesBuilder.match(OWNER_NAME)) {
                attributesBuilder.add(OWNER_NAME, posixFileAttributes.owner());
            }
            if (attributesBuilder.match(GROUP_NAME)) {
                attributesBuilder.add(GROUP_NAME, posixFileAttributes.group());
            }
        }

        @Override
        public Map<String, Object> readAttributes(String[] stringArray) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder = AbstractBasicFileAttributeView.AttributesBuilder.create(posixAttributeNames, stringArray);
            UnixFileAttributes unixFileAttributes = this.readAttributes();
            this.addRequestedPosixAttributes(unixFileAttributes, attributesBuilder);
            return attributesBuilder.unmodifiableMap();
        }

        @Override
        public UnixFileAttributes readAttributes() throws IOException {
            this.checkReadExtended();
            try {
                return UnixFileAttributes.get(this.file, this.followLinks);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setMode(int n) throws IOException {
            block6: {
                this.checkWriteExtended();
                try {
                    if (this.followLinks) {
                        UnixNativeDispatcher.chmod(this.file, n);
                        break block6;
                    }
                    int n2 = this.file.openForAttributeAccess(false);
                    try {
                        UnixNativeDispatcher.fchmod(n2, n);
                    }
                    finally {
                        UnixNativeDispatcher.close(n2);
                    }
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                }
            }
        }

        final void setOwners(int n, int n2) throws IOException {
            this.checkWriteExtended();
            try {
                if (this.followLinks) {
                    UnixNativeDispatcher.chown(this.file, n, n2);
                } else {
                    UnixNativeDispatcher.lchown(this.file, n, n2);
                }
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
            }
        }

        @Override
        public void setPermissions(Set<PosixFilePermission> set) throws IOException {
            this.setMode(UnixFileModeAttribute.toUnixMode(set));
        }

        @Override
        public void setOwner(UserPrincipal userPrincipal) throws IOException {
            if (userPrincipal == null) {
                throw new NullPointerException("'owner' is null");
            }
            if (!(userPrincipal instanceof UnixUserPrincipals.User)) {
                throw new ProviderMismatchException();
            }
            if (userPrincipal instanceof UnixUserPrincipals.Group) {
                throw new IOException("'owner' parameter can't be a group");
            }
            int n = ((UnixUserPrincipals.User)userPrincipal).uid();
            this.setOwners(n, -1);
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return this.readAttributes().owner();
        }

        @Override
        public void setGroup(GroupPrincipal groupPrincipal) throws IOException {
            if (groupPrincipal == null) {
                throw new NullPointerException("'owner' is null");
            }
            if (!(groupPrincipal instanceof UnixUserPrincipals.Group)) {
                throw new ProviderMismatchException();
            }
            int n = ((UnixUserPrincipals.Group)groupPrincipal).gid();
            this.setOwners(-1, n);
        }
    }

    private static class Unix
    extends Posix {
        private static final String MODE_NAME = "mode";
        private static final String INO_NAME = "ino";
        private static final String DEV_NAME = "dev";
        private static final String RDEV_NAME = "rdev";
        private static final String NLINK_NAME = "nlink";
        private static final String UID_NAME = "uid";
        private static final String GID_NAME = "gid";
        private static final String CTIME_NAME = "ctime";
        static final Set<String> unixAttributeNames = Util.newSet(posixAttributeNames, new String[]{"mode", "ino", "dev", "rdev", "nlink", "uid", "gid", "ctime"});

        Unix(UnixPath unixPath, boolean bl) {
            super(unixPath, bl);
        }

        @Override
        public String name() {
            return "unix";
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            if (string.equals(MODE_NAME)) {
                this.setMode((Integer)object);
                return;
            }
            if (string.equals(UID_NAME)) {
                this.setOwners((Integer)object, -1);
                return;
            }
            if (string.equals(GID_NAME)) {
                this.setOwners(-1, (Integer)object);
                return;
            }
            super.setAttribute(string, object);
        }

        @Override
        public Map<String, Object> readAttributes(String[] stringArray) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder = AbstractBasicFileAttributeView.AttributesBuilder.create(unixAttributeNames, stringArray);
            UnixFileAttributes unixFileAttributes = this.readAttributes();
            this.addRequestedPosixAttributes(unixFileAttributes, attributesBuilder);
            if (attributesBuilder.match(MODE_NAME)) {
                attributesBuilder.add(MODE_NAME, unixFileAttributes.mode());
            }
            if (attributesBuilder.match(INO_NAME)) {
                attributesBuilder.add(INO_NAME, unixFileAttributes.ino());
            }
            if (attributesBuilder.match(DEV_NAME)) {
                attributesBuilder.add(DEV_NAME, unixFileAttributes.dev());
            }
            if (attributesBuilder.match(RDEV_NAME)) {
                attributesBuilder.add(RDEV_NAME, unixFileAttributes.rdev());
            }
            if (attributesBuilder.match(NLINK_NAME)) {
                attributesBuilder.add(NLINK_NAME, unixFileAttributes.nlink());
            }
            if (attributesBuilder.match(UID_NAME)) {
                attributesBuilder.add(UID_NAME, unixFileAttributes.uid());
            }
            if (attributesBuilder.match(GID_NAME)) {
                attributesBuilder.add(GID_NAME, unixFileAttributes.gid());
            }
            if (attributesBuilder.match(CTIME_NAME)) {
                attributesBuilder.add(CTIME_NAME, unixFileAttributes.ctime());
            }
            return attributesBuilder.unmodifiableMap();
        }
    }
}

