/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class StubRoutines {
    private static AddressField callStubReturnAddressField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("StubRoutines");
        callStubReturnAddressField = type.getAddressField("_call_stub_return_address");
    }

    public boolean returnsToCallStub(Address returnPC) {
        Address addr = callStubReturnAddressField.getValue();
        if (addr == null) {
            return addr == returnPC;
        }
        return ((Object)addr).equals(returnPC);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                StubRoutines.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

