/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.TimestampToken;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class JarSignature {
    public static String BLOB_SIGNATURE = "META-INF/SIGNATURE.BSF";
    private final Signature sig;
    private final X509Certificate[] certChain;
    private final CodeSigner[] codeSigners;
    private final SignerInfo[] signerInfos;

    public static JarSignature load(byte[] rawSignature) throws ParsingException, CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PKCS7 pkcs7 = new PKCS7(rawSignature);
        SignerInfo[] infos = pkcs7.getSignerInfos();
        if (infos == null || infos.length != 1) {
            throw new IllegalArgumentException("BLOB signature currently only support single signer.");
        }
        X509Certificate cert = infos[0].getCertificate(pkcs7);
        PublicKey publicKey = cert.getPublicKey();
        CodeSigner[] signers = JarSignature.extractCodeSigners(infos, pkcs7);
        Signature sig = JarSignature.getSignature(infos[0]);
        sig.initVerify(publicKey);
        return new JarSignature(sig, infos, signers);
    }

    public static JarSignature create(PrivateKey privateKey, X509Certificate[] chain) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature = JarSignature.getSignature(privateKey.getAlgorithm());
        signature.initSign(privateKey);
        return new JarSignature(signature, chain);
    }

    private JarSignature(Signature signature, X509Certificate[] chain) {
        this.certChain = chain;
        this.signerInfos = null;
        this.codeSigners = null;
        this.sig = signature;
    }

    private JarSignature(Signature signature, SignerInfo[] infos, CodeSigner[] signers) {
        this.certChain = null;
        this.signerInfos = infos;
        this.codeSigners = signers;
        this.sig = signature;
    }

    public boolean isValidationMode() {
        return this.certChain == null;
    }

    private static Signature getSignature(String keyAlgorithm) throws NoSuchAlgorithmException {
        if (keyAlgorithm.equalsIgnoreCase("DSA")) {
            return Signature.getInstance("SHA1withDSA");
        }
        if (keyAlgorithm.equalsIgnoreCase("RSA")) {
            return Signature.getInstance("SHA256withRSA");
        }
        if (keyAlgorithm.equalsIgnoreCase("EC")) {
            return Signature.getInstance("SHA256withECDSA");
        }
        throw new IllegalArgumentException("Key algorithm should be either DSA, RSA or EC");
    }

    private static Signature getSignature(SignerInfo info) throws NoSuchAlgorithmException {
        String digestAlgorithm = info.getDigestAlgorithmId().getName();
        String keyAlgorithm = info.getDigestEncryptionAlgorithmId().getName();
        String signatureAlgorithm = JarSignature.makeSigAlg(digestAlgorithm, keyAlgorithm);
        return Signature.getInstance(signatureAlgorithm);
    }

    String getSignatureAlgorithm() throws NoSuchAlgorithmException {
        return this.sig.getAlgorithm();
    }

    AlgorithmId getDigestAlgorithm() throws NoSuchAlgorithmException {
        String name = JarSignature.getDigAlgFromSigAlg(this.sig.getAlgorithm());
        return AlgorithmId.get(name);
    }

    AlgorithmId getKeyAlgorithm() throws NoSuchAlgorithmException {
        String name = JarSignature.getEncAlgFromSigAlg(this.sig.getAlgorithm());
        return AlgorithmId.get(name);
    }

    private static String makeSigAlg(String digAlg, String encAlg) {
        if ((digAlg = digAlg.replace("-", "").toUpperCase(Locale.ENGLISH)).equalsIgnoreCase("SHA")) {
            digAlg = "SHA1";
        }
        if ((encAlg = encAlg.toUpperCase(Locale.ENGLISH)).equals("EC")) {
            encAlg = "ECDSA";
        }
        return digAlg + "with" + encAlg;
    }

    private static String getDigAlgFromSigAlg(String signatureAlgorithm) {
        int with = (signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.ENGLISH)).indexOf("WITH");
        if (with > 0) {
            return signatureAlgorithm.substring(0, with);
        }
        return null;
    }

    private static String getEncAlgFromSigAlg(String signatureAlgorithm) {
        int and;
        signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.ENGLISH);
        int with = signatureAlgorithm.indexOf("WITH");
        String keyAlgorithm = null;
        if (with > 0 && (keyAlgorithm = (and = signatureAlgorithm.indexOf("AND", with + 4)) > 0 ? signatureAlgorithm.substring(with + 4, and) : signatureAlgorithm.substring(with + 4)).equalsIgnoreCase("ECDSA")) {
            keyAlgorithm = "EC";
        }
        return keyAlgorithm;
    }

    public byte[] getEncoded() throws NoSuchAlgorithmException, SignatureException, IOException {
        if (this.isValidationMode()) {
            throw new UnsupportedOperationException("Method is not for validation mode.");
        }
        AlgorithmId digestAlgId = this.getDigestAlgorithm();
        AlgorithmId[] digestAlgIds = new AlgorithmId[]{digestAlgId};
        ContentInfo contentInfo = new ContentInfo(ContentInfo.DATA_OID, null);
        Principal issuerName = this.certChain[0].getIssuerDN();
        BigInteger serialNumber = this.certChain[0].getSerialNumber();
        byte[] signature = this.sig.sign();
        SignerInfo signerInfo = new SignerInfo((X500Name)issuerName, serialNumber, digestAlgId, this.getKeyAlgorithm(), signature);
        SignerInfo[] signerInfos = new SignerInfo[]{signerInfo};
        PKCS7 pkcs7 = new PKCS7(digestAlgIds, contentInfo, this.certChain, signerInfos);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        pkcs7.encodeSignedData(bos);
        return bos.toByteArray();
    }

    public InputStream updateWithZipEntry(String name, InputStream is) throws SignatureException {
        try {
            this.sig.update(name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e);
        }
        return new ValidationStream(is);
    }

    public void update(byte[] v) throws SignatureException {
        this.sig.update(v);
    }

    public boolean isValid() {
        try {
            return this.sig.verify(this.signerInfos[0].getEncryptedDigest());
        }
        catch (Exception e) {
            return false;
        }
    }

    public CodeSigner[] getCodeSigners() {
        return this.codeSigners;
    }

    private static CodeSigner[] extractCodeSigners(SignerInfo[] infos, PKCS7 block) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        ArrayList<CodeSigner> s = new ArrayList<CodeSigner>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        for (int i = 0; i < infos.length; ++i) {
            SignerInfo info = infos[i];
            ArrayList<X509Certificate> chain = info.getCertificateChain(block);
            CertPath certPath = certificateFactory.generateCertPath(chain);
            CodeSigner signer = new CodeSigner(certPath, JarSignature.getTimestamp(info, certificateFactory));
            s.add(signer);
        }
        return s.toArray(new CodeSigner[s.size()]);
    }

    private static Timestamp getTimestamp(SignerInfo info, CertificateFactory certificateFactory) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        PKCS9Attribute timestampTokenAttr;
        Timestamp timestamp = null;
        PKCS9Attributes unsignedAttrs = info.getUnauthenticatedAttributes();
        if (unsignedAttrs != null && (timestampTokenAttr = unsignedAttrs.getAttribute("signatureTimestampToken")) != null) {
            PKCS7 timestampToken = new PKCS7((byte[])timestampTokenAttr.getValue());
            byte[] encodedTimestampTokenInfo = timestampToken.getContentInfo().getData();
            SignerInfo[] tsa = timestampToken.verify(encodedTimestampTokenInfo);
            ArrayList<X509Certificate> chain = tsa[0].getCertificateChain(timestampToken);
            CertPath tsaChain = certificateFactory.generateCertPath(chain);
            TimestampToken timestampTokenInfo = new TimestampToken(encodedTimestampTokenInfo);
            timestamp = new Timestamp(timestampTokenInfo.getDate(), tsaChain);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signJarAsBLOB(InputStreamSource input, ZipOutputStream jos) throws IOException, SignatureException, NoSuchAlgorithmException {
        byte[] copyBuf = new byte[8000];
        ZipInputStream jis = new ZipInputStream(input.getInputStream());
        try {
            ZipEntry e;
            while ((e = jis.getNextEntry()) != null) {
                if (BLOB_SIGNATURE.equals(e.getName()) || e.getName().endsWith("/")) continue;
                JarSignature.readFully(this.updateWithZipEntry(e.getName(), jis));
            }
            byte[] signature = this.getEncoded();
            jis.close();
            jis = new ZipInputStream(input.getInputStream());
            while ((e = jis.getNextEntry()) != null) {
                String upperName;
                boolean isManifestEntry;
                String name = e.getName();
                if (!BLOB_SIGNATURE.equals(name)) {
                    int n;
                    ZipEntry e2 = new ZipEntry(name);
                    e2.setMethod(e.getMethod());
                    e2.setTime(e.getTime());
                    e2.setComment(e.getComment());
                    e2.setExtra(e.getExtra());
                    if (e.getMethod() == 0) {
                        e2.setSize(e.getSize());
                        e2.setCrc(e.getCrc());
                    }
                    jos.putNextEntry(e2);
                    while ((n = jis.read(copyBuf)) != -1) {
                        jos.write(copyBuf, 0, n);
                    }
                    jos.closeEntry();
                }
                if (!(isManifestEntry = "META-INF/MANIFEST.MF".equals(upperName = name.toUpperCase(Locale.ENGLISH)))) continue;
                ZipEntry ze = new ZipEntry(BLOB_SIGNATURE);
                ze.setSize(signature.length);
                ze.setTime(System.currentTimeMillis());
                jos.putNextEntry(ze);
                jos.write(signature);
                jos.closeEntry();
            }
        }
        finally {
            jis.close();
            jos.close();
        }
    }

    private static void readFully(InputStream is) throws IOException {
        byte[] buf = new byte[10000];
        while (is.read(buf) != -1) {
        }
    }

    public static interface InputStreamSource {
        public InputStream getInputStream() throws IOException;
    }

    private class ValidationStream
    extends InputStream {
        InputStream dataStream = null;

        public ValidationStream(InputStream is) {
            this.dataStream = is;
        }

        public int read() throws IOException {
            int v = this.dataStream.read();
            if (v > -1) {
                try {
                    JarSignature.this.sig.update((byte)v);
                }
                catch (SignatureException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return v;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if ((len = this.dataStream.read(b, off, len)) > 0) {
                try {
                    JarSignature.this.sig.update(b, off, len);
                }
                catch (SignatureException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return len;
        }

        public void close() throws IOException {
            this.dataStream.close();
        }
    }
}

