/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.openide.awt.UndoRedo;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class UndoRedoAction
extends AbstractAction
implements ContextAwareAction,
PropertyChangeListener,
ChangeListener,
LookupListener,
Runnable,
HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(UndoRedoAction.class.getName());
    private UndoRedo last = UndoRedo.NONE;
    private final boolean doUndo;
    private final Lookup.Result<UndoRedo.Provider> result;
    private final boolean fallback;
    private PropertyChangeListener weakPCL;
    private ChangeListener weakCL;
    private LookupListener weakLL;

    UndoRedoAction(Lookup lookup, boolean bl, boolean bl2) {
        this.doUndo = bl;
        this.fallback = bl2;
        this.result = lookup.lookupResult(UndoRedo.Provider.class);
    }

    public String toString() {
        return super.toString() + "[undo=" + this.doUndo + ", fallback: " + this.fallback + "]";
    }

    public static Action create(Map<?, ?> map) {
        if (Boolean.TRUE.equals(map.get("redo"))) {
            return new UndoRedoAction(Utilities.actionsGlobalContext(), false, true);
        }
        if (Boolean.TRUE.equals(map.get("undo"))) {
            return new UndoRedoAction(Utilities.actionsGlobalContext(), true, true);
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isEnabled() {
        this.initializeUndoRedo();
        return super.isEnabled();
    }

    void initializeUndoRedo() {
        assert (EventQueue.isDispatchThread());
        if (this.weakLL != null) {
            return;
        }
        String string = this.doUndo ? "org/openide/resources/actions/undo.gif" : "org/openide/resources/actions/redo.gif";
        this.putValue("iconBase", string);
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)string, (boolean)true));
        if (this.fallback) {
            TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
            this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)registry);
            registry.addPropertyChangeListener(this.weakPCL);
        }
        this.weakCL = WeakListeners.change((ChangeListener)this, null);
        this.weakLL = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result);
        this.result.addLookupListener(this.weakLL);
        this.last = UndoRedo.NONE;
        this.run();
    }

    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this);
            return;
        }
        UndoRedo undoRedo = this.getUndoRedo();
        this.last.removeChangeListener(this.weakCL);
        if (this.doUndo) {
            this.setEnabled(undoRedo.canUndo());
        } else {
            this.setEnabled(undoRedo.canRedo());
        }
        this.putValue("Name", this.getName());
        this.last = undoRedo;
        this.last.addChangeListener(this.weakCL);
    }

    private UndoRedo getUndoRedo() {
        UndoRedo.Provider provider;
        assert (EventQueue.isDispatchThread());
        TopComponent topComponent = this.result.allInstances().iterator();
        while (topComponent.hasNext()) {
            provider = (UndoRedo.Provider)topComponent.next();
            UndoRedo undoRedo = provider.getUndoRedo();
            if (undoRedo == null) continue;
            return undoRedo;
        }
        if (this.fallback && (topComponent = WindowManager.getDefault().getRegistry().getActivated()) != null && (provider = topComponent.getUndoRedo()) != null) {
            return provider;
        }
        return UndoRedo.NONE;
    }

    private String getName() {
        assert (EventQueue.isDispatchThread());
        String string = this.doUndo ? this.getUndoRedo().getUndoPresentationName() : this.getUndoRedo().getRedoPresentationName();
        LOG.log(Level.FINE, this.doUndo ? "getUndoRedo().getUndoPresentationName() returns {0}" : "getUndoRedo().getRedoPresentationName() returns {0}", string);
        if (string != null && this.getDefaultSwingText() != null && string.startsWith(this.getDefaultSwingText())) {
            string = string.substring(this.getDefaultSwingText().length()).trim();
        }
        LOG.log(Level.FINE, "Name adapted by SWING_DEFAULT_LABEL is {0}", string);
        String string2 = null;
        string2 = string == null || string.trim().length() == 0 ? NbBundle.getMessage(UndoRedoAction.class, (String)(this.doUndo ? "UndoSimple" : "RedoSimple")) : NbBundle.getMessage(UndoRedoAction.class, (String)(this.doUndo ? "UndoWithParameter" : "RedoWithParameter"), (Object)string);
        LOG.log(Level.FINE, "Result name is {0}", string2);
        return string2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(UndoRedoAction.class);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        UndoRedo undoRedo = this.getUndoRedo();
        if (this.doUndo) {
            try {
                if (undoRedo.canUndo()) {
                    undoRedo.undo();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                Exceptions.printStackTrace((Throwable)cannotUndoException);
            }
        } else {
            try {
                if (undoRedo.canRedo()) {
                    undoRedo.redo();
                }
            }
            catch (CannotRedoException cannotRedoException) {
                Exceptions.printStackTrace((Throwable)cannotRedoException);
            }
        }
        this.run();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.run();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.run();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.run();
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new UndoRedoAction(lookup, this.doUndo, false);
    }

    private String getDefaultSwingText() {
        return this.doUndo ? UIManager.getString("AbstractUndoableEdit.undoText") : UIManager.getString("AbstractUndoableEdit.redoText");
    }
}

