/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingWorker;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.core.ui.sampler.Sampler;
import org.netbeans.core.ui.sampler.SamplesOutputStream;
import org.netbeans.core.ui.sampler.SelfSampleVFS;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SelfSamplerAction
extends AbstractAction
implements AWTEventListener {
    private static final String ACTION_NAME_START = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStart");
    private static final String ACTION_NAME_STOP = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStop");
    private static final String NOT_SUPPORTED = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_NotSupported");
    private static final String SAVE_MSG = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_SavedFile");
    private static final String DEBUG_ARG = "-Xdebug";
    private static final Logger LOGGER = Logger.getLogger(SelfSamplerAction.class.getName());
    private final AtomicReference<Sampler> RUNNING = new AtomicReference();
    private static Boolean debugMode;
    private static String lastReason;
    private static Class defaultDataObject;

    public SelfSamplerAction() {
        this.putValue("Name", ACTION_NAME_START);
        this.putValue("ShortDescription", ACTION_NAME_START);
        this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSampler.png");
        if (System.getProperty(SelfSamplerAction.class.getName() + ".sniff") != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (SamplesOutputStream.isSupported()) {
            Sampler sampler = new InternalSampler("Self Sampler");
            if (this.RUNNING.compareAndSet(null, sampler)) {
                this.putValue("Name", ACTION_NAME_STOP);
                this.putValue("ShortDescription", ACTION_NAME_STOP);
                this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSamplerRunning.png");
                sampler.run();
            } else {
                sampler = this.RUNNING.getAndSet(null);
                if (sampler != null) {
                    final Sampler sampler2 = sampler;
                    this.setEnabled(false);
                    SwingWorker swingWorker = new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            sampler2.actionPerformed(new ActionEvent(this, 0, "show"));
                            return null;
                        }

                        @Override
                        protected void done() {
                            SelfSamplerAction.this.putValue("Name", ACTION_NAME_START);
                            SelfSamplerAction.this.putValue("ShortDescription", ACTION_NAME_START);
                            SelfSamplerAction.this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSampler.png");
                            SelfSamplerAction.this.setEnabled(true);
                        }
                    };
                    swingWorker.execute();
                }
            }
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NOT_SUPPORTED, 1);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 65406) {
            this.actionPerformed(new ActionEvent(this, aWTEvent.getID(), "shortcut"));
            keyEvent.consume();
        }
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object == null && string.startsWith("logger-") && SamplesOutputStream.isSupported() && SelfSamplerAction.isRunMode()) {
            return new InternalSampler(string);
        }
        return object;
    }

    final boolean isProfileMe(Sampler sampler) {
        return sampler == this.RUNNING.get();
    }

    private static synchronized boolean isDebugged() {
        if (debugMode == null) {
            debugMode = Boolean.FALSE;
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            if (list.contains(DEBUG_ARG)) {
                debugMode = Boolean.TRUE;
            }
        }
        return debugMode;
    }

    private static boolean isRunMode() {
        boolean bl = true;
        String string = null;
        if (SelfSamplerAction.isDebugged()) {
            string = "running in debug mode";
            bl = false;
        }
        if (bl) {
            try {
                Class.forName("org.netbeans.lib.profiler.server.ProfilerServer", false, ClassLoader.getSystemClassLoader());
                string = "running under profiler";
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!bl && !string.equals(lastReason)) {
            LOGGER.log(Level.INFO, "Slowness detector disabled - {0}", string);
        }
        lastReason = string;
        return bl;
    }

    static {
        try {
            defaultDataObject = Class.forName("org.openide.loaders.DefaultDataObject");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
    }

    private static final class InternalSampler
    extends Sampler {
        private ProgressHandle progress;

        InternalSampler(String string) {
            super(string);
        }

        @Override
        protected void printStackTrace(Throwable throwable) {
            Exceptions.printStackTrace((Throwable)throwable);
        }

        @Override
        protected void saveSnapshot(byte[] byArray) throws IOException {
            File file = File.createTempFile("selfsampler", ".npss");
            file = FileUtil.normalizeFile((File)file);
            this.writeToFile(file, byArray);
            File file2 = new File(new File(new File(new File(System.getProperty("netbeans.user")), "var"), "log"), "uigestures");
            SelfSampleVFS selfSampleVFS = file2.exists() ? new SelfSampleVFS(new String[]{"selfsampler.npss", "selfsampler.log"}, new File[]{file, file2}) : new SelfSampleVFS(new String[]{"selfsampler.npss"}, new File[]{file});
            FileObject fileObject = selfSampleVFS.findResource("selfsampler.npss");
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (defaultDataObject.isAssignableFrom(dataObject.getClass())) {
                String string = MessageFormat.format(SAVE_MSG, file.getAbsolutePath());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            } else {
                ((OpenCookie)dataObject.getCookie(OpenCookie.class)).open();
            }
        }

        private void writeToFile(File file, byte[] byArray) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        @Override
        protected ThreadMXBean getThreadMXBean() {
            return ManagementFactory.getThreadMXBean();
        }

        @Override
        protected void openProgress(int n) {
            if (EventQueue.isDispatchThread()) {
                return;
            }
            this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SelfSamplerAction.class, (String)"Save_Progress"));
            this.progress.start(n);
        }

        @Override
        protected void closeProgress() {
            if (EventQueue.isDispatchThread()) {
                return;
            }
            this.progress.finish();
            this.progress = null;
        }

        @Override
        protected void progress(int n) {
            if (EventQueue.isDispatchThread()) {
                return;
            }
            if (this.progress != null) {
                this.progress.progress(n);
            }
        }
    }
}

