/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.VoidType;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.jdi.VirtualMachineManagerImpl;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.jvm.hotspot.HotSpotAgent;
import sun.jvm.hotspot.jdi.ArrayReferenceImpl;
import sun.jvm.hotspot.jdi.ArrayTypeImpl;
import sun.jvm.hotspot.jdi.BooleanTypeImpl;
import sun.jvm.hotspot.jdi.BooleanValueImpl;
import sun.jvm.hotspot.jdi.ByteTypeImpl;
import sun.jvm.hotspot.jdi.ByteValueImpl;
import sun.jvm.hotspot.jdi.CharTypeImpl;
import sun.jvm.hotspot.jdi.CharValueImpl;
import sun.jvm.hotspot.jdi.ClassLoaderReferenceImpl;
import sun.jvm.hotspot.jdi.ClassObjectReferenceImpl;
import sun.jvm.hotspot.jdi.ClassTypeImpl;
import sun.jvm.hotspot.jdi.DoubleTypeImpl;
import sun.jvm.hotspot.jdi.DoubleValueImpl;
import sun.jvm.hotspot.jdi.FloatTypeImpl;
import sun.jvm.hotspot.jdi.FloatValueImpl;
import sun.jvm.hotspot.jdi.IntegerTypeImpl;
import sun.jvm.hotspot.jdi.IntegerValueImpl;
import sun.jvm.hotspot.jdi.InterfaceTypeImpl;
import sun.jvm.hotspot.jdi.JNITypeParser;
import sun.jvm.hotspot.jdi.LongTypeImpl;
import sun.jvm.hotspot.jdi.LongValueImpl;
import sun.jvm.hotspot.jdi.MirrorImpl;
import sun.jvm.hotspot.jdi.ObjectReferenceImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.jdi.ShortTypeImpl;
import sun.jvm.hotspot.jdi.ShortValueImpl;
import sun.jvm.hotspot.jdi.StringReferenceImpl;
import sun.jvm.hotspot.jdi.ThreadGroupReferenceImpl;
import sun.jvm.hotspot.jdi.ThreadReferenceImpl;
import sun.jvm.hotspot.jdi.VoidTypeImpl;
import sun.jvm.hotspot.jdi.VoidValueImpl;
import sun.jvm.hotspot.memory.SymbolTable;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class VirtualMachineImpl
extends MirrorImpl
implements PathSearchingVirtualMachine {
    private HotSpotAgent saAgent = new HotSpotAgent();
    private VM saVM;
    private Universe saUniverse;
    private SystemDictionary saSystemDictionary;
    private SymbolTable saSymbolTable;
    private ObjectHeap saObjectHeap;
    VirtualMachineManager vmmgr;
    private final ThreadGroup threadGroupForJDI;
    private BooleanType theBooleanType;
    private ByteType theByteType;
    private CharType theCharType;
    private ShortType theShortType;
    private IntegerType theIntegerType;
    private LongType theLongType;
    private FloatType theFloatType;
    private DoubleType theDoubleType;
    private VoidType theVoidType;
    private VoidValue voidVal;
    private Map typesByID;
    private List typesBySignature;
    private boolean retrievedAllTypes = false;
    private List bootstrapClasses;
    private ArrayList allThreads;
    private ArrayList topLevelGroups;
    final int sequenceNumber;
    private final Map objectsByID = new HashMap();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private Symbol javaLangString;
    private Symbol javaLangThread;
    private Symbol javaLangThreadGroup;
    private Symbol javaLangClass;
    private Symbol javaLangClassLoader;
    private Symbol javaLangThrowable;
    private Symbol javaLangObject;
    private Symbol javaLangCloneable;
    private Symbol javaIoSerializable;
    private Symbol javaLangEnum;
    private String defaultStratum;
    private static Class vmCannotBeModifiedExceptionClass = null;
    private Observer disposeObserver;

    VM saVM() {
        return this.saVM;
    }

    SystemDictionary saSystemDictionary() {
        return this.saSystemDictionary;
    }

    SymbolTable saSymbolTable() {
        return this.saSymbolTable;
    }

    Universe saUniverse() {
        return this.saUniverse;
    }

    ObjectHeap saObjectHeap() {
        return this.saObjectHeap;
    }

    Symbol javaLangObject() {
        return this.javaLangObject;
    }

    Symbol javaLangCloneable() {
        return this.javaLangCloneable;
    }

    Symbol javaIoSerializable() {
        return this.javaIoSerializable;
    }

    Symbol javaLangEnum() {
        return this.javaLangEnum;
    }

    Symbol javaLangThrowable() {
        return this.javaLangThrowable;
    }

    private void initClassNameSymbols() {
        SymbolTable st = this.saSymbolTable();
        this.javaLangString = st.probe("java/lang/String");
        this.javaLangThread = st.probe("java/lang/Thread");
        this.javaLangThreadGroup = st.probe("java/lang/ThreadGroup");
        this.javaLangClass = st.probe("java/lang/Class");
        this.javaLangClassLoader = st.probe("java/lang/ClassLoader");
        this.javaLangThrowable = st.probe("java/lang/Throwable");
        this.javaLangObject = st.probe("java/lang/Object");
        this.javaLangCloneable = st.probe("java/lang/Cloneable");
        this.javaIoSerializable = st.probe("java/io/Serializable");
        this.javaLangEnum = st.probe("java/lang/Enum");
    }

    private void init() {
        this.saVM = VM.getVM();
        this.saUniverse = this.saVM.getUniverse();
        this.saSystemDictionary = this.saVM.getSystemDictionary();
        this.saSymbolTable = this.saVM.getSymbolTable();
        this.saObjectHeap = this.saVM.getObjectHeap();
        this.initClassNameSymbols();
    }

    public static VirtualMachineImpl createVirtualMachineForCorefile(VirtualMachineManager mgr, String javaExecutableName, String coreFileName, int sequenceNumber) throws Exception {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(coreFileName != null, "SA VirtualMachineImpl: core filename = null is not yet implemented");
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(javaExecutableName != null, "SA VirtualMachineImpl: java executable = null is not yet implemented");
        }
        VirtualMachineImpl myvm = new VirtualMachineImpl(mgr, sequenceNumber);
        try {
            myvm.saAgent.attach(javaExecutableName, coreFileName);
            myvm.init();
        }
        catch (Exception ee) {
            myvm.saAgent.detach();
            throw ee;
        }
        return myvm;
    }

    public static VirtualMachineImpl createVirtualMachineForPID(VirtualMachineManager mgr, int pid, int sequenceNumber) throws Exception {
        VirtualMachineImpl myvm = new VirtualMachineImpl(mgr, sequenceNumber);
        try {
            myvm.saAgent.attach(pid);
            myvm.init();
        }
        catch (Exception ee) {
            myvm.saAgent.detach();
            throw ee;
        }
        return myvm;
    }

    public static VirtualMachineImpl createVirtualMachineForServer(VirtualMachineManager mgr, String server, int sequenceNumber) throws Exception {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(server != null, "SA VirtualMachineImpl: DebugServer = null is not yet implemented");
        }
        VirtualMachineImpl myvm = new VirtualMachineImpl(mgr, sequenceNumber);
        try {
            myvm.saAgent.attach(server);
            myvm.init();
        }
        catch (Exception ee) {
            myvm.saAgent.detach();
            throw ee;
        }
        return myvm;
    }

    VirtualMachineImpl(VirtualMachineManager mgr, int sequenceNumber) throws Exception {
        super(null);
        this.vm = this;
        this.sequenceNumber = sequenceNumber;
        this.vmmgr = mgr;
        this.threadGroupForJDI = new ThreadGroup("JDI [" + this.hashCode() + "]");
        ((VirtualMachineManagerImpl)mgr).addVirtualMachine(this);
    }

    void throwNotReadOnlyException(String operation) {
        RuntimeException re = null;
        if (vmCannotBeModifiedExceptionClass == null) {
            try {
                vmCannotBeModifiedExceptionClass = Class.forName("com.sun.jdi.VMCannotBeModifiedException");
            }
            catch (ClassNotFoundException cnfe) {
                vmCannotBeModifiedExceptionClass = UnsupportedOperationException.class;
            }
        }
        try {
            re = (RuntimeException)vmCannotBeModifiedExceptionClass.newInstance();
        }
        catch (Exception exp) {
            re = new RuntimeException(exp.getMessage());
        }
        throw re;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public List classesByName(String className) {
        String signature = JNITypeParser.typeNameToSignature(className);
        if (!this.retrievedAllTypes) {
            this.retrieveAllClasses();
        }
        List list = this.findReferenceTypes(signature);
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List allClasses() {
        ArrayList a;
        if (!this.retrievedAllTypes) {
            this.retrieveAllClasses();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            a = new ArrayList(this.typesBySignature);
        }
        return Collections.unmodifiableList(a);
    }

    List bootstrapClasses() {
        if (this.bootstrapClasses == null) {
            this.bootstrapClasses = new ArrayList();
            List all = this.allClasses();
            for (ReferenceType type : all) {
                if (type.classLoader() != null) continue;
                this.bootstrapClasses.add(type);
            }
        }
        return this.bootstrapClasses;
    }

    private synchronized List findReferenceTypes(String signature) {
        if (this.typesByID == null) {
            return new ArrayList(0);
        }
        String typeName = null;
        typeName = signature.charAt(0) == 'L' ? signature.substring(1, signature.length() - 1) : signature;
        Symbol typeNameSym = this.saSymbolTable().probe(typeName);
        if (typeNameSym == null) {
            return new ArrayList(0);
        }
        Iterator iter = this.typesBySignature.iterator();
        ArrayList<ReferenceTypeImpl> list = new ArrayList<ReferenceTypeImpl>();
        while (iter.hasNext()) {
            ReferenceTypeImpl type = (ReferenceTypeImpl)iter.next();
            if (!typeNameSym.equals(type.typeNameAsSymbol())) continue;
            list.add(type);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAllClasses() {
        final ArrayList saKlasses = new ArrayList();
        SystemDictionary.ClassVisitor visitor = new SystemDictionary.ClassVisitor(){

            @Override
            public void visit(Klass k) {
                for (Klass l = k; l != null; l = l.arrayKlassOrNull()) {
                    if (l instanceof ArrayKlass) {
                        saKlasses.add(l);
                        continue;
                    }
                    int status = l.getClassStatus();
                    if ((status & 2) == 0) continue;
                    saKlasses.add(l);
                }
            }
        };
        this.saSystemDictionary.classesDo(visitor);
        this.saVM.getUniverse().basicTypeClassesDo(visitor);
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (!this.retrievedAllTypes) {
                int count = saKlasses.size();
                for (int ii = 0; ii < count; ++ii) {
                    Klass kk = (Klass)saKlasses.get(ii);
                    ReferenceTypeImpl type = this.referenceType(kk);
                }
                this.retrievedAllTypes = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceTypeImpl referenceType(Klass kk) {
        ReferenceTypeImpl retType = null;
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (this.typesByID != null) {
                retType = (ReferenceTypeImpl)this.typesByID.get(kk);
            }
            if (retType == null) {
                retType = this.addReferenceType(kk);
            }
        }
        return retType;
    }

    private void initReferenceTypes() {
        this.typesByID = new HashMap();
        this.typesBySignature = new ArrayList();
    }

    private synchronized ReferenceTypeImpl addReferenceType(Klass kk) {
        if (this.typesByID == null) {
            this.initReferenceTypes();
        }
        ReferenceTypeImpl newRefType = null;
        if (kk instanceof ObjArrayKlass || kk instanceof TypeArrayKlass) {
            newRefType = new ArrayTypeImpl((VirtualMachine)this, (ArrayKlass)kk);
        } else if (kk instanceof InstanceKlass) {
            newRefType = kk.isInterface() ? new InterfaceTypeImpl((VirtualMachine)this, (InstanceKlass)kk) : new ClassTypeImpl((VirtualMachine)this, (InstanceKlass)kk);
        } else {
            throw new RuntimeException("should not reach here");
        }
        this.typesByID.put(kk, newRefType);
        this.typesBySignature.add(newRefType);
        return newRefType;
    }

    ThreadGroup threadGroupForJDI() {
        return this.threadGroupForJDI;
    }

    public void redefineClasses(Map classToBytes) {
        this.throwNotReadOnlyException("VirtualMachineImpl.redefineClasses()");
    }

    private List getAllThreads() {
        if (this.allThreads == null) {
            this.allThreads = new ArrayList(10);
            for (JavaThread thread = this.saVM.getThreads().first(); thread != null; thread = thread.next()) {
                if (thread.isHiddenFromExternalView()) continue;
                ThreadReferenceImpl myThread = this.threadMirror(thread);
                this.allThreads.add(myThread);
            }
        }
        return this.allThreads;
    }

    public List allThreads() {
        return Collections.unmodifiableList(this.getAllThreads());
    }

    @Override
    public void suspend() {
        this.throwNotReadOnlyException("VirtualMachineImpl.suspend()");
    }

    @Override
    public void resume() {
        this.throwNotReadOnlyException("VirtualMachineImpl.resume()");
    }

    public List topLevelThreadGroups() {
        if (this.topLevelGroups == null) {
            this.topLevelGroups = new ArrayList(1);
            for (ThreadReferenceImpl myThread : this.getAllThreads()) {
                ThreadGroupReference myGroup = myThread.threadGroup();
                ThreadGroupReference myParent = myGroup.parent();
                if (myGroup.parent() != null) continue;
                this.topLevelGroups.add(myGroup);
                break;
            }
        }
        return Collections.unmodifiableList(this.topLevelGroups);
    }

    @Override
    public EventQueue eventQueue() {
        this.throwNotReadOnlyException("VirtualMachine.eventQueue()");
        return null;
    }

    @Override
    public EventRequestManager eventRequestManager() {
        this.throwNotReadOnlyException("VirtualMachineImpl.eventRequestManager()");
        return null;
    }

    @Override
    public BooleanValue mirrorOf(boolean value) {
        return new BooleanValueImpl(this, value);
    }

    @Override
    public ByteValue mirrorOf(byte value) {
        return new ByteValueImpl(this, value);
    }

    @Override
    public CharValue mirrorOf(char value) {
        return new CharValueImpl(this, value);
    }

    @Override
    public ShortValue mirrorOf(short value) {
        return new ShortValueImpl(this, value);
    }

    @Override
    public IntegerValue mirrorOf(int value) {
        return new IntegerValueImpl(this, value);
    }

    @Override
    public LongValue mirrorOf(long value) {
        return new LongValueImpl(this, value);
    }

    @Override
    public FloatValue mirrorOf(float value) {
        return new FloatValueImpl(this, value);
    }

    @Override
    public DoubleValue mirrorOf(double value) {
        return new DoubleValueImpl(this, value);
    }

    @Override
    public StringReference mirrorOf(String value) {
        this.throwNotReadOnlyException("VirtualMachinestop.mirrorOf(String)");
        return null;
    }

    @Override
    public VoidValue mirrorOfVoid() {
        if (this.voidVal == null) {
            this.voidVal = new VoidValueImpl(this);
        }
        return this.voidVal;
    }

    @Override
    public Process process() {
        this.throwNotReadOnlyException("VirtualMachine.process");
        return null;
    }

    void setDisposeObserver(Observer observer) {
        this.disposeObserver = observer;
    }

    private void notifyDispose() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.disposeObserver != null, "null VM.dispose observer");
        }
        this.disposeObserver.update(null, null);
    }

    @Override
    public void dispose() {
        this.saAgent.detach();
        this.notifyDispose();
    }

    @Override
    public void exit(int exitCode) {
        this.throwNotReadOnlyException("VirtualMachine.exit(int)");
    }

    @Override
    public boolean canBeModified() {
        return false;
    }

    @Override
    public boolean canWatchFieldModification() {
        return false;
    }

    @Override
    public boolean canWatchFieldAccess() {
        return false;
    }

    @Override
    public boolean canGetBytecodes() {
        return true;
    }

    @Override
    public boolean canGetSyntheticAttribute() {
        return true;
    }

    @Override
    public boolean canGetOwnedMonitorInfo() {
        return false;
    }

    @Override
    public boolean canGetCurrentContendedMonitor() {
        return false;
    }

    @Override
    public boolean canGetMonitorInfo() {
        return false;
    }

    public boolean canGet1_5LanguageFeatures() {
        return true;
    }

    @Override
    public boolean canUseInstanceFilters() {
        return false;
    }

    @Override
    public boolean canRedefineClasses() {
        return false;
    }

    @Override
    public boolean canAddMethod() {
        return false;
    }

    @Override
    public boolean canUnrestrictedlyRedefineClasses() {
        return false;
    }

    @Override
    public boolean canPopFrames() {
        return false;
    }

    @Override
    public boolean canGetSourceDebugExtension() {
        return false;
    }

    @Override
    public boolean canRequestVMDeathEvent() {
        return false;
    }

    @Override
    public boolean canForceEarlyReturn() {
        return false;
    }

    @Override
    public boolean canGetConstantPool() {
        return true;
    }

    @Override
    public boolean canGetClassFileVersion() {
        return true;
    }

    @Override
    public boolean canGetMethodReturnValues() {
        return false;
    }

    @Override
    public boolean canGetInstanceInfo() {
        return true;
    }

    @Override
    public boolean canUseSourceNameFilters() {
        return false;
    }

    @Override
    public boolean canRequestMonitorEvents() {
        return false;
    }

    @Override
    public boolean canGetMonitorFrameInfo() {
        return true;
    }

    public long[] instanceCounts(List classes) {
        if (!this.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        final long[] retValue = new long[classes.size()];
        final Klass[] klassArray = new Klass[classes.size()];
        boolean allAbstractClasses = true;
        for (int i = 0; i < classes.size(); ++i) {
            ReferenceTypeImpl rti = (ReferenceTypeImpl)classes.get(i);
            klassArray[i] = rti.ref();
            retValue[i] = 0L;
            if (rti.isAbstract() || rti instanceof InterfaceType) continue;
            allAbstractClasses = false;
        }
        if (allAbstractClasses) {
            return retValue;
        }
        final int size = classes.size();
        this.saObjectHeap.iterate(new DefaultHeapVisitor(){

            @Override
            public boolean doObj(Oop oop) {
                for (int i = 0; i < size; ++i) {
                    if (!klassArray[i].equals(oop.getKlass())) continue;
                    int n = i;
                    retValue[n] = retValue[n] + 1L;
                    break;
                }
                return false;
            }
        });
        return retValue;
    }

    private List getPath(String pathName) {
        String cp = this.saVM.getSystemProperty(pathName);
        String pathSep = this.saVM.getSystemProperty("path.separator");
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(cp, pathSep);
        while (st.hasMoreTokens()) {
            al.add(st.nextToken());
        }
        al.trimToSize();
        return al;
    }

    public List classPath() {
        return this.getPath("java.class.path");
    }

    public List bootClassPath() {
        return this.getPath("sun.boot.class.path");
    }

    @Override
    public String baseDirectory() {
        return this.saVM.getSystemProperty("user.dir");
    }

    @Override
    public void setDefaultStratum(String stratum) {
        this.defaultStratum = stratum;
    }

    @Override
    public String getDefaultStratum() {
        return this.defaultStratum;
    }

    @Override
    public String description() {
        return MessageFormat.format(ResourceBundle.getBundle("com.sun.tools.jdi.resources.jdi").getString("version_format"), "" + this.vmmgr.majorInterfaceVersion(), "" + this.vmmgr.minorInterfaceVersion(), this.name());
    }

    @Override
    public String version() {
        return this.saVM.getSystemProperty("java.version");
    }

    @Override
    public String name() {
        StringBuffer sb = new StringBuffer();
        sb.append("JVM version ");
        sb.append(this.version());
        sb.append(" (");
        sb.append(this.saVM.getSystemProperty("java.vm.name"));
        sb.append(", ");
        sb.append(this.saVM.getSystemProperty("java.vm.info"));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this;
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public void setDebugTraceMode(int traceFlags) {
    }

    public boolean canWalkHeap() {
        return true;
    }

    public List allObjects() {
        final ArrayList objects = new ArrayList(0);
        this.saObjectHeap.iterate(new DefaultHeapVisitor(){

            @Override
            public boolean doObj(Oop oop) {
                objects.add(VirtualMachineImpl.this.objectMirror(oop));
                return false;
            }
        });
        return objects;
    }

    public List objectsByType(ReferenceType type) {
        return this.objectsByType(type, true);
    }

    private List objectsByExactType(ReferenceType type) {
        final ArrayList objects = new ArrayList(0);
        final Klass givenKls = ((ReferenceTypeImpl)type).ref();
        this.saObjectHeap.iterate(new DefaultHeapVisitor(){

            @Override
            public boolean doObj(Oop oop) {
                if (givenKls.equals(oop.getKlass())) {
                    objects.add(VirtualMachineImpl.this.objectMirror(oop));
                }
                return false;
            }
        });
        return objects;
    }

    private List objectsBySubType(ReferenceType type) {
        final ArrayList objects = new ArrayList(0);
        final ReferenceType givenType = type;
        this.saObjectHeap.iterate(new DefaultHeapVisitor(){

            @Override
            public boolean doObj(Oop oop) {
                ReferenceTypeImpl curType = VirtualMachineImpl.this.referenceType(oop.getKlass());
                if (curType.isAssignableTo(givenType)) {
                    objects.add(VirtualMachineImpl.this.objectMirror(oop));
                }
                return false;
            }
        });
        return objects;
    }

    public List objectsByType(ReferenceType type, boolean includeSubtypes) {
        Klass kls = ((ReferenceTypeImpl)type).ref();
        if (kls instanceof InstanceKlass) {
            InstanceKlass ik = (InstanceKlass)kls;
            if (ik.isInterface()) {
                if (ik.nofImplementors() == 0L) {
                    return new ArrayList(0);
                }
            } else if (ik.getAccessFlagsObj().isFinal() || ik.getSubklassKlass() == null) {
                includeSubtypes = false;
            }
        } else {
            ArrayTypeImpl arrayType = (ArrayTypeImpl)type;
            try {
                Type componentType = arrayType.componentType();
                if (componentType instanceof PrimitiveType) {
                    includeSubtypes = false;
                }
            }
            catch (ClassNotLoadedException cnle) {
                // empty catch block
            }
        }
        if (includeSubtypes) {
            return this.objectsBySubType(type);
        }
        return this.objectsByExactType(type);
    }

    Type findBootType(String signature) throws ClassNotLoadedException {
        List types = this.allClasses();
        for (ReferenceType type : types) {
            if (type.classLoader() != null || !type.signature().equals(signature)) continue;
            return type;
        }
        JNITypeParser parser = new JNITypeParser(signature);
        throw new ClassNotLoadedException(parser.typeName(), "Type " + parser.typeName() + " not loaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BooleanType theBooleanType() {
        if (this.theBooleanType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theBooleanType == null) {
                    this.theBooleanType = new BooleanTypeImpl(this);
                }
            }
        }
        return this.theBooleanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteType theByteType() {
        if (this.theByteType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theByteType == null) {
                    this.theByteType = new ByteTypeImpl(this);
                }
            }
        }
        return this.theByteType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharType theCharType() {
        if (this.theCharType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theCharType == null) {
                    this.theCharType = new CharTypeImpl(this);
                }
            }
        }
        return this.theCharType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShortType theShortType() {
        if (this.theShortType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theShortType == null) {
                    this.theShortType = new ShortTypeImpl(this);
                }
            }
        }
        return this.theShortType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntegerType theIntegerType() {
        if (this.theIntegerType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theIntegerType == null) {
                    this.theIntegerType = new IntegerTypeImpl(this);
                }
            }
        }
        return this.theIntegerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LongType theLongType() {
        if (this.theLongType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theLongType == null) {
                    this.theLongType = new LongTypeImpl(this);
                }
            }
        }
        return this.theLongType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FloatType theFloatType() {
        if (this.theFloatType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theFloatType == null) {
                    this.theFloatType = new FloatTypeImpl(this);
                }
            }
        }
        return this.theFloatType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DoubleType theDoubleType() {
        if (this.theDoubleType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theDoubleType == null) {
                    this.theDoubleType = new DoubleTypeImpl(this);
                }
            }
        }
        return this.theDoubleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VoidType theVoidType() {
        if (this.theVoidType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theVoidType == null) {
                    this.theVoidType = new VoidTypeImpl(this);
                }
            }
        }
        return this.theVoidType;
    }

    PrimitiveType primitiveTypeMirror(char tag) {
        switch (tag) {
            case 'Z': {
                return this.theBooleanType();
            }
            case 'B': {
                return this.theByteType();
            }
            case 'C': {
                return this.theCharType();
            }
            case 'S': {
                return this.theShortType();
            }
            case 'I': {
                return this.theIntegerType();
            }
            case 'J': {
                return this.theLongType();
            }
            case 'F': {
                return this.theFloatType();
            }
            case 'D': {
                return this.theDoubleType();
            }
        }
        throw new IllegalArgumentException("Unrecognized primitive tag " + tag);
    }

    private void processQueue() {
        Reference ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            SoftObjectReference softRef = (SoftObjectReference)ref;
            this.removeObjectMirror(softRef);
        }
    }

    long getAddressValue(Oop obj) {
        return this.vm.saVM.getDebugger().getAddressValue(obj.getHandle());
    }

    synchronized ObjectReferenceImpl objectMirror(Oop key) {
        this.processQueue();
        if (key == null) {
            return null;
        }
        ObjectReferenceImpl object = null;
        SoftObjectReference ref = (SoftObjectReference)this.objectsByID.get(key);
        if (ref != null) {
            object = ref.object();
        }
        if (object == null) {
            if (key instanceof Instance) {
                Symbol className = key.getKlass().getName();
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(className != null, "Null class name");
                }
                Instance inst = (Instance)key;
                if (className.equals(this.javaLangString)) {
                    object = new StringReferenceImpl((VirtualMachine)this, inst);
                } else if (className.equals(this.javaLangThread)) {
                    object = new ThreadReferenceImpl((VirtualMachine)this, inst);
                } else if (className.equals(this.javaLangThreadGroup)) {
                    object = new ThreadGroupReferenceImpl(this, inst);
                } else if (className.equals(this.javaLangClass)) {
                    object = new ClassObjectReferenceImpl((VirtualMachine)this, inst);
                } else if (className.equals(this.javaLangClassLoader)) {
                    object = new ClassLoaderReferenceImpl((VirtualMachine)this, inst);
                } else {
                    for (Klass kls = key.getKlass().getSuper(); kls != null; kls = kls.getSuper()) {
                        className = kls.getName();
                        if (className.equals(this.javaLangThread)) {
                            object = new ThreadReferenceImpl((VirtualMachine)this, inst);
                            break;
                        }
                        if (className.equals(this.javaLangThreadGroup)) {
                            object = new ThreadGroupReferenceImpl(this, inst);
                            break;
                        }
                        if (!className.equals(this.javaLangClassLoader)) continue;
                        object = new ClassLoaderReferenceImpl((VirtualMachine)this, inst);
                        break;
                    }
                    if (object == null) {
                        object = new ObjectReferenceImpl(this, inst);
                    }
                }
            } else if (key instanceof TypeArray) {
                object = new ArrayReferenceImpl((VirtualMachine)this, (Array)key);
            } else if (key instanceof ObjArray) {
                object = new ArrayReferenceImpl((VirtualMachine)this, (Array)key);
            } else {
                throw new RuntimeException("unexpected object type " + key);
            }
            ref = new SoftObjectReference(key, object, this.referenceQueue);
            this.objectsByID.put(key, ref);
        } else {
            ref.incrementCount();
        }
        return object;
    }

    synchronized void removeObjectMirror(SoftObjectReference ref) {
        this.objectsByID.remove(ref.key());
    }

    StringReferenceImpl stringMirror(Instance id) {
        return (StringReferenceImpl)this.objectMirror(id);
    }

    ArrayReferenceImpl arrayMirror(Array id) {
        return (ArrayReferenceImpl)this.objectMirror(id);
    }

    ThreadReferenceImpl threadMirror(Instance id) {
        return (ThreadReferenceImpl)this.objectMirror(id);
    }

    ThreadReferenceImpl threadMirror(JavaThread jt) {
        return (ThreadReferenceImpl)this.objectMirror(jt.getThreadObj());
    }

    ThreadGroupReferenceImpl threadGroupMirror(Instance id) {
        return (ThreadGroupReferenceImpl)this.objectMirror(id);
    }

    ClassLoaderReferenceImpl classLoaderMirror(Instance id) {
        return (ClassLoaderReferenceImpl)this.objectMirror(id);
    }

    ClassObjectReferenceImpl classObjectMirror(Instance id) {
        return (ClassObjectReferenceImpl)this.objectMirror(id);
    }

    private static class SoftObjectReference
    extends SoftReference {
        int count = 1;
        Object key;

        SoftObjectReference(Object key, ObjectReferenceImpl mirror, ReferenceQueue queue) {
            super(mirror, queue);
            this.key = key;
        }

        int count() {
            return this.count;
        }

        void incrementCount() {
            ++this.count;
        }

        Object key() {
            return this.key;
        }

        ObjectReferenceImpl object() {
            return (ObjectReferenceImpl)this.get();
        }
    }
}

