/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.api.nodes;

import java.lang.reflect.Modifier;
import java.util.Comparator;
import javax.swing.Icon;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.selector.api.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.openide.util.NbBundle;

public class MethodNode
extends SelectorNode {
    private ClientUtils.SourceCodeSelection signature;
    private SourceMethodInfo method;
    private static MethodNameFormatterFactory formatterFactory = MethodNameFormatterFactory.getDefault((MethodNameFormatter)new DefaultMethodNameFormatter(2));
    public static final Comparator<MethodNode> COMPARATOR = new Comparator<MethodNode>(){

        @Override
        public int compare(MethodNode methodNode, MethodNode methodNode2) {
            return methodNode.toString().compareTo(methodNode2.toString());
        }
    };

    public MethodNode(SourceMethodInfo sourceMethodInfo, MethodsNode methodsNode) {
        super(sourceMethodInfo != null ? sourceMethodInfo.getName() : NbBundle.getMessage(MethodNode.class, (String)"LBL_Unknown"), sourceMethodInfo != null ? sourceMethodInfo.getName() : NbBundle.getMessage(MethodNode.class, (String)"LBL_Unknown"), null, SelectorChildren.LEAF, methodsNode);
        this.method = sourceMethodInfo;
        if (sourceMethodInfo != null) {
            this.signature = new ClientUtils.SourceCodeSelection(sourceMethodInfo.getClassName(), sourceMethodInfo.getName(), sourceMethodInfo.getSignature());
            this.updateDisplayName(formatterFactory.getFormatter().formatMethodName(this.signature).toFormatted());
        }
    }

    public final boolean getAllowsChildren() {
        return false;
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    public final Icon getIcon() {
        if (this.method == null) {
            return Icons.getIcon((String)"LanguageIcons.MethodPublic");
        }
        Icon icon = Modifier.isStatic(this.method.getModifiers()) ? (Modifier.isPublic(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.MethodPublicStatic") : (Modifier.isProtected(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.MethodProtectedStatic") : (Modifier.isPrivate(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.MethodPrivateStatic") : Icons.getIcon((String)"LanguageIcons.MethodPackageStatic")))) : (Modifier.isPublic(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.MethodPublic") : (Modifier.isProtected(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.MethodProtected") : (Modifier.isPrivate(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.MethodPrivate") : Icons.getIcon((String)"LanguageIcons.MethodPackage"))));
        return icon;
    }

    @Override
    public final ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }
}

