/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.annotations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class LayerGeneratingProcessor
extends AbstractProcessor {
    private static final String GENERATED_LAYER = "META-INF/generated-layer.xml";
    private static final String PUBLIC_DTD_ID = "-//NetBeans//DTD Filesystem 1.2//EN";
    private static final String NETWORK_DTD_URL = "http://www.netbeans.org/dtds/filesystem-1_2.dtd";
    private static final String LOCAL_DTD_RESOURCE = "/org/openide/filesystems/filesystem1_2.dtd";
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    };
    private static final EntityResolver ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (LayerGeneratingProcessor.PUBLIC_DTD_ID.equals(string)) {
                return new InputSource(LayerGeneratingProcessor.class.getResource(LayerGeneratingProcessor.LOCAL_DTD_RESOURCE).toString());
            }
            return null;
        }
    };
    private static final Map<ProcessingEnvironment, Document> generatedLayerByProcessor = new WeakHashMap<ProcessingEnvironment, Document>();
    private static final Map<ProcessingEnvironment, List<Element>> originatingElementsByProcessor = new WeakHashMap<ProcessingEnvironment, List<Element>>();
    private final List<LayerBuilder> createdBuilders = new LinkedList<LayerBuilder>();

    protected LayerGeneratingProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        boolean bl;
        Messager messager = this.processingEnv.getMessager();
        try {
            bl = this.handleProcess(set, roundEnvironment);
        }
        catch (LayerGenerationException layerGenerationException) {
            if (layerGenerationException.erroneousAnnotationValue != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, layerGenerationException.getLocalizedMessage(), layerGenerationException.erroneousElement, layerGenerationException.erroneousAnnotation, layerGenerationException.erroneousAnnotationValue);
            } else if (layerGenerationException.erroneousAnnotation != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, layerGenerationException.getLocalizedMessage(), layerGenerationException.erroneousElement, layerGenerationException.erroneousAnnotation);
            } else if (layerGenerationException.erroneousElement != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, layerGenerationException.getLocalizedMessage(), layerGenerationException.erroneousElement);
            } else {
                messager.printMessage(Diagnostic.Kind.ERROR, layerGenerationException.getLocalizedMessage());
            }
            return false;
        }
        if (roundEnvironment.processingOver()) {
            Document document = generatedLayerByProcessor.remove(this.processingEnv);
            List<Element> list = originatingElementsByProcessor.remove(this.processingEnv);
            if (document != null && !roundEnvironment.errorRaised()) {
                Element[] elementArray = new Element[]{};
                if (list != null) {
                    elementArray = list.toArray(elementArray);
                }
                try {
                    ByteArrayOutputStream object = new ByteArrayOutputStream();
                    DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
                    assert (dOMImplementationLS != null) : "No DOM 3 LS supported in " + document.getClass().getName();
                    LSOutput lSOutput = dOMImplementationLS.createLSOutput();
                    lSOutput.setEncoding("UTF-8");
                    lSOutput.setByteStream(object);
                    LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
                    String string = "format-pretty-print";
                    if (lSSerializer.getDomConfig().canSetParameter(string, true)) {
                        lSSerializer.getDomConfig().setParameter(string, true);
                    }
                    lSSerializer.write(document, lSOutput);
                    byte[] byArray = object.toByteArray();
                    XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(byArray)), (boolean)true, (boolean)true, (ErrorHandler)ERROR_HANDLER, (EntityResolver)ENTITY_RESOLVER);
                    FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_LAYER, elementArray);
                    OutputStream outputStream = fileObject.openOutputStream();
                    try {
                        outputStream.write(byArray);
                    }
                    finally {
                        outputStream.close();
                    }
                    TreeSet<String> treeSet = new TreeSet<String>();
                    NodeList nodeList = document.getElementsByTagName("file");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        void var19_29;
                        org.w3c.dom.Element element;
                        org.w3c.dom.Element element2 = (org.w3c.dom.Element)nodeList.item(i);
                        String string2 = element2.getAttribute("name");
                        while ((element = (org.w3c.dom.Element)var19_29.getParentNode()).getTagName().equals("folder")) {
                            string2 = element.getAttribute("name") + "/" + string2;
                        }
                        treeSet.add(string2);
                    }
                    for (String string3 : treeSet) {
                        messager.printMessage(Diagnostic.Kind.NOTE, "generated layer entry: " + string3);
                    }
                }
                catch (IOException iOException) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write generated-layer.xml: " + iOException.toString());
                }
                catch (SAXException sAXException) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Refused to write invalid generated-layer.xml: " + sAXException.toString());
                }
            }
            for (LayerBuilder layerBuilder : this.createdBuilders) {
                layerBuilder.close();
            }
            this.createdBuilders.clear();
        }
        return bl;
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws LayerGenerationException;

    protected final LayerBuilder layer(Element ... elementArray) {
        LayerBuilder layerBuilder = new LayerBuilder(this.layerDocument(elementArray), elementArray.length == 1 ? elementArray[0] : null, this.processingEnv);
        this.createdBuilders.add(layerBuilder);
        return layerBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document layerDocument(Element ... elementArray) {
        List<Element> list = originatingElementsByProcessor.get(this.processingEnv);
        if (list == null) {
            list = new ArrayList<Element>();
            originatingElementsByProcessor.put(this.processingEnv, list);
        }
        list.addAll(Arrays.asList(elementArray));
        Document document = generatedLayerByProcessor.get(this.processingEnv);
        if (document == null) {
            try {
                FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_LAYER);
                InputStream inputStream = fileObject.openInputStream();
                try {
                    document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)true, (boolean)true, (ErrorHandler)ERROR_HANDLER, (EntityResolver)ENTITY_RESOLVER);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read generated-layer.xml: " + iOException.toString());
            }
            catch (SAXException sAXException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to parse generated-layer.xml: " + sAXException.toString());
            }
            if (document == null) {
                document = XMLUtil.createDocument((String)"filesystem", null, (String)PUBLIC_DTD_ID, (String)NETWORK_DTD_URL);
            }
            generatedLayerByProcessor.put(this.processingEnv, document);
        }
        return document;
    }
}

