/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RowMultiSetImpl;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;

public abstract class QueryTreeNode
implements Visitable {
    public static final int AUTOINCREMENT_START_INDEX = 0;
    public static final int AUTOINCREMENT_INC_INDEX = 1;
    public static final int AUTOINCREMENT_IS_AUTOINCREMENT_INDEX = 2;
    public static final int AUTOINCREMENT_CREATE_MODIFY = 3;
    private int beginOffset = -1;
    private int endOffset = -1;
    private int nodeType;
    private ContextManager cm;
    private LanguageConnectionContext lcc;
    private GenericConstantActionFactory constantActionFactory;
    boolean isPrivilegeCollectionRequired = true;

    public void setContextManager(ContextManager contextManager) {
        this.cm = contextManager;
    }

    public final ContextManager getContextManager() {
        return this.cm;
    }

    public final NodeFactory getNodeFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getNodeFactory();
    }

    public final GenericConstantActionFactory getGenericConstantActionFactory() {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory genericExecutionFactory = (GenericExecutionFactory)this.getExecutionFactory();
            this.constantActionFactory = genericExecutionFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    public final ExecutionFactory getExecutionFactory() {
        ExecutionFactory executionFactory = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
        return executionFactory;
    }

    protected final ClassFactory getClassFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getClassFactory();
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc == null) {
            this.lcc = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        }
        return this.lcc;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public void setBeginOffset(int n) {
        this.beginOffset = n;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    protected String nodeHeader() {
        return "";
    }

    public static String formatNodeString(String string, int n) {
        return "";
    }

    public void treePrint() {
    }

    public void stackPrint() {
    }

    public void treePrint(int n) {
    }

    private static boolean containsInfo(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\t' || string.charAt(i) == '\n') continue;
            return true;
        }
        return false;
    }

    public static void debugPrint(String string) {
    }

    protected static void debugFlush() {
    }

    public void printSubNodes(int n) {
    }

    public String toString() {
        return "";
    }

    public void printLabel(int n, String string) {
    }

    public boolean referencesSessionSchema() throws StandardException {
        return false;
    }

    final boolean isSessionSchema(SchemaDescriptor schemaDescriptor) {
        return this.isSessionSchema(schemaDescriptor.getSchemaName());
    }

    final boolean isSessionSchema(String string) {
        return "SESSION".equals(string);
    }

    final void disablePrivilegeCollection() {
        this.isPrivilegeCollectionRequired = false;
    }

    public boolean isPrivilegeCollectionRequired() {
        return this.isPrivilegeCollectionRequired;
    }

    protected void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return this.getCompilerContext().getParameterTypes();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return null;
    }

    public void setNodeType(int n) {
        this.nodeType = n;
    }

    protected int getNodeType() {
        return this.nodeType;
    }

    protected boolean isInstanceOf(int n) {
        return this.nodeType == n;
    }

    public final DataDictionary getDataDictionary() {
        return this.getLanguageConnectionContext().getDataDictionary();
    }

    public final DependencyManager getDependencyManager() {
        return this.getDataDictionary().getDependencyManager();
    }

    protected final CompilerContext getCompilerContext() {
        return (CompilerContext)this.getContextManager().getContext("CompilerContext");
    }

    protected final TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.getCompilerContext().getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    public final Visitable accept(Visitor visitor) throws StandardException {
        QueryTreeNode queryTreeNode;
        boolean bl = visitor.visitChildrenFirst(this);
        boolean bl2 = visitor.skipChildren(this);
        if (bl && !bl2 && !visitor.stopTraversal()) {
            this.acceptChildren(visitor);
        }
        Visitable visitable = queryTreeNode = visitor.stopTraversal() ? this : visitor.visit(this);
        if (!(bl || bl2 || visitor.stopTraversal())) {
            this.acceptChildren(visitor);
        }
        return queryTreeNode;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
    }

    protected int getIntProperty(String string, String string2) throws StandardException {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42Y58", (Object)string, (Object)string2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementNode parseStatement(String string, boolean bl) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        CompilerContext compilerContext = languageConnectionContext.pushCompilerContext();
        if (bl) {
            compilerContext.setReliability(0);
        }
        try {
            Parser parser = compilerContext.getParser();
            StatementNode statementNode = parser.parseStatement(string);
            return statementNode;
        }
        finally {
            languageConnectionContext.popCompilerContext(compilerContext);
        }
    }

    protected int getStatementType() {
        return 0;
    }

    public boolean foundString(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public ConstantNode getNullNode(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        int n;
        switch (dataTypeDescriptor.getTypeId().getJDBCTypeId()) {
            case 12: {
                n = 77;
                break;
            }
            case 1: {
                n = 61;
                break;
            }
            case -6: {
                n = 75;
                break;
            }
            case 5: {
                n = 74;
                break;
            }
            case 4: {
                n = 70;
                break;
            }
            case -5: {
                n = 71;
                break;
            }
            case 7: {
                n = 69;
                break;
            }
            case 8: {
                n = 68;
                break;
            }
            case 2: 
            case 3: {
                n = 67;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                n = 76;
                break;
            }
            case -2: {
                n = 58;
                break;
            }
            case -3: {
                n = 59;
                break;
            }
            case -1: {
                n = 73;
                break;
            }
            case 2005: {
                n = 196;
                break;
            }
            case -4: {
                n = 72;
                break;
            }
            case 2004: {
                n = 195;
                break;
            }
            case 2009: {
                n = 199;
                break;
            }
            case 16: {
                n = 38;
                break;
            }
            default: {
                if (dataTypeDescriptor.getTypeId().userType()) {
                    n = 76;
                    break;
                }
                return null;
            }
        }
        ConstantNode constantNode = (ConstantNode)this.getNodeFactory().getNode(n, dataTypeDescriptor.getTypeId(), this.cm);
        constantNode.setType(dataTypeDescriptor.getNullabilityType(true));
        return constantNode;
    }

    public DataValueDescriptor convertDefaultNode(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        return null;
    }

    public void init(Object object) throws StandardException {
    }

    public void init(Object object, Object object2) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) throws StandardException {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14) throws StandardException {
    }

    public TableName makeTableName(String string, String string2) throws StandardException {
        return QueryTreeNode.makeTableName(this.getNodeFactory(), this.getContextManager(), string, string2);
    }

    public static TableName makeTableName(NodeFactory nodeFactory, ContextManager contextManager, String string, String string2) throws StandardException {
        return (TableName)nodeFactory.getNode(34, string, string2, contextManager);
    }

    public boolean isAtomic() throws StandardException {
        return false;
    }

    public Object getCursorInfo() throws StandardException {
        return null;
    }

    protected final TableDescriptor getTableDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        TableDescriptor tableDescriptor;
        if (this.isSessionSchema(schemaDescriptor) && (tableDescriptor = this.getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable(string)) != null) {
            return tableDescriptor;
        }
        if (schemaDescriptor.getUUID() == null) {
            return null;
        }
        TableDescriptor tableDescriptor2 = this.getDataDictionary().getTableDescriptor(string, schemaDescriptor, this.getLanguageConnectionContext().getTransactionCompile());
        if (tableDescriptor2 == null || tableDescriptor2.isSynonymDescriptor()) {
            return null;
        }
        return tableDescriptor2;
    }

    final SchemaDescriptor getSchemaDescriptor(String string) throws StandardException {
        return this.getSchemaDescriptor(string, true);
    }

    final SchemaDescriptor getSchemaDescriptor(String string, boolean bl) throws StandardException {
        Object object;
        SchemaDescriptor schemaDescriptor = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            object = this.getCompilerContext();
            schemaDescriptor = object.getCompilationSchema();
            if (schemaDescriptor == null) {
                schemaDescriptor = this.getLanguageConnectionContext().getDefaultSchema();
                bl2 = true;
                object.setCompilationSchema(schemaDescriptor);
            } else {
                bl3 = true;
            }
            string = schemaDescriptor.getSchemaName();
        }
        object = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor2 = object.getSchemaDescriptor(string, this.getLanguageConnectionContext().getTransactionCompile(), bl);
        if (bl2 || bl3) {
            if (schemaDescriptor2 != null && schemaDescriptor2.getUUID() != null) {
                if (!schemaDescriptor2.getUUID().equals(schemaDescriptor.getUUID())) {
                    if (bl2) {
                        this.getLanguageConnectionContext().setDefaultSchema(schemaDescriptor2);
                    }
                    this.getCompilerContext().setCompilationSchema(schemaDescriptor2);
                }
            } else {
                schemaDescriptor.setUUID(null);
                schemaDescriptor2 = schemaDescriptor;
            }
        }
        return schemaDescriptor2;
    }

    public TableName resolveTableToSynonym(TableName tableName) throws StandardException {
        AliasDescriptor aliasDescriptor;
        Object object;
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = tableName.getTableName();
        String string2 = tableName.getSchemaName();
        boolean bl = false;
        CompilerContext compilerContext = this.getCompilerContext();
        while ((object = this.getSchemaDescriptor(string2, false)) != null && ((SchemaDescriptor)object).getUUID() != null && (aliasDescriptor = dataDictionary.getAliasDescriptor(((SchemaDescriptor)object).getUUID().toString(), string, 'S')) != null) {
            compilerContext.createDependency(aliasDescriptor);
            bl = true;
            SynonymAliasInfo synonymAliasInfo = (SynonymAliasInfo)aliasDescriptor.getAliasInfo();
            string = synonymAliasInfo.getSynonymTable();
            string2 = synonymAliasInfo.getSynonymSchema();
        }
        if (!bl) {
            return null;
        }
        object = new TableName();
        ((TableName)object).init(string2, string);
        return object;
    }

    void verifyClassExist(String string) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        ClassNotFoundException classNotFoundException = null;
        boolean bl = false;
        try {
            bl = classInspector.accessible(string);
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        if (!bl) {
            throw StandardException.newException("42X51", classNotFoundException, (Object)string);
        }
        if (ClassInspector.primitiveType(string)) {
            throw StandardException.newException("42Y37", string);
        }
    }

    public void setRefActionInfo(long l, int[] nArray, String string, boolean bl) {
    }

    void generateAuthorizeCheck(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n) {
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        methodBuilder.callMethod((short)185, null, "getAuthorizer", "org.apache.derby.iapi.sql.conn.Authorizer", 0);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)185, null, "authorize", "void", 2);
    }

    public void checkReliability(String string, int n) throws StandardException {
        if ((this.getCompilerContext().getReliability() & n) != 0) {
            this.throwReliabilityException(string, n);
        }
    }

    public void checkReliability(int n, String string) throws StandardException {
        if ((this.getCompilerContext().getReliability() & n) != 0) {
            String string2 = MessageService.getTextMessage(string);
            this.throwReliabilityException(string2, n);
        }
    }

    public DataTypeDescriptor bindUserType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        if (dataTypeDescriptor.getCatalogType().isRowMultiSet()) {
            return this.bindRowMultiSet(dataTypeDescriptor);
        }
        if (!dataTypeDescriptor.getTypeId().userType()) {
            return dataTypeDescriptor;
        }
        UserDefinedTypeIdImpl userDefinedTypeIdImpl = (UserDefinedTypeIdImpl)dataTypeDescriptor.getTypeId().getBaseTypeId();
        if (userDefinedTypeIdImpl.isBound()) {
            return dataTypeDescriptor;
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(userDefinedTypeIdImpl.getSchemaName());
        char c = 'A';
        String string = userDefinedTypeIdImpl.getUnqualifiedName();
        AliasDescriptor aliasDescriptor = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), string, c);
        if (aliasDescriptor == null) {
            throw StandardException.newException("42X94", (Object)AliasDescriptor.getAliasType(c), (Object)string);
        }
        this.createTypeDependency(aliasDescriptor);
        DataTypeDescriptor dataTypeDescriptor2 = new DataTypeDescriptor(TypeId.getUserDefinedTypeId(schemaDescriptor.getSchemaName(), string, aliasDescriptor.getJavaClassName()), dataTypeDescriptor.isNullable());
        return dataTypeDescriptor2;
    }

    public DataTypeDescriptor bindRowMultiSet(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        if (!dataTypeDescriptor.getCatalogType().isRowMultiSet()) {
            return dataTypeDescriptor;
        }
        RowMultiSetImpl rowMultiSetImpl = (RowMultiSetImpl)dataTypeDescriptor.getTypeId().getBaseTypeId();
        String[] stringArray = rowMultiSetImpl.getColumnNames();
        TypeDescriptor[] typeDescriptorArray = rowMultiSetImpl.getTypes();
        int n = typeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            TypeDescriptor typeDescriptor;
            TypeDescriptor typeDescriptor2 = typeDescriptorArray[i];
            if (!typeDescriptor2.isUserDefinedType()) continue;
            DataTypeDescriptor dataTypeDescriptor2 = DataTypeDescriptor.getType(typeDescriptor2);
            dataTypeDescriptor2 = this.bindUserType(dataTypeDescriptor2);
            typeDescriptorArray[i] = typeDescriptor = dataTypeDescriptor2.getCatalogType();
        }
        return dataTypeDescriptor;
    }

    public void createTypeDependency(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        AliasDescriptor aliasDescriptor = this.getDataDictionary().getAliasDescriptorForUDT(null, dataTypeDescriptor);
        if (aliasDescriptor != null) {
            this.createTypeDependency(aliasDescriptor);
        }
    }

    private void createTypeDependency(AliasDescriptor aliasDescriptor) throws StandardException {
        this.getCompilerContext().createDependency(aliasDescriptor);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredUsagePriv(aliasDescriptor);
        }
    }

    private void throwReliabilityException(String string, int n) throws StandardException {
        String string2;
        if (this.getCompilerContext().getReliability() == 1192) {
            string2 = "42Y84";
        } else if (this.getCompilerContext().getReliability() == 30329) {
            switch (n) {
                case 8192: {
                    string2 = "42XA5";
                    break;
                }
                default: {
                    string2 = "42XA2";
                    break;
                }
            }
        } else {
            string2 = "42Y39";
        }
        throw StandardException.newException(string2, string);
    }

    public int orReliability(int n) {
        CompilerContext compilerContext = this.getCompilerContext();
        int n2 = compilerContext.getReliability();
        compilerContext.setReliability(n2 | n);
        return n2;
    }

    public static void bindOffsetFetch(ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        long l;
        DataValueDescriptor dataValueDescriptor;
        if (valueNode instanceof ConstantNode) {
            dataValueDescriptor = ((ConstantNode)valueNode).getValue();
            l = dataValueDescriptor.getLong();
            if (l < 0L) {
                throw StandardException.newException("2201X", Long.toString(l));
            }
        } else if (valueNode instanceof ParameterNode) {
            valueNode.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(-5), false));
        }
        if (valueNode2 instanceof ConstantNode) {
            dataValueDescriptor = ((ConstantNode)valueNode2).getValue();
            l = dataValueDescriptor.getLong();
            if (l < 1L) {
                throw StandardException.newException("2201W", Long.toString(l));
            }
        } else if (valueNode2 instanceof ParameterNode) {
            valueNode2.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(-5), false));
        }
    }
}

