/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.util.actions.CallableSystemAction;

public abstract class ProfilingAwareAction
extends CallableSystemAction
implements ProfilingStateListener {
    private int lastInstrumentation = 0;
    private int lastProfilingState = 1;

    protected ProfilingAwareAction() {
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public boolean isEnabled() {
        if (!NetBeansProfiler.isInitialized()) {
            return false;
        }
        boolean bl = false;
        this.lastProfilingState = Profiler.getDefault().getProfilingState();
        this.lastInstrumentation = this.lastProfilingState != 1 ? Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
        int[] nArray = this.enabledStates();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.lastProfilingState != nArray[i]) continue;
            bl = true;
            break;
        }
        if (bl && this.requiresInstrumentation()) {
            bl = this.lastInstrumentation != 0;
        }
        return bl;
    }

    public final void instrumentationChanged(int n, int n2) {
        this.updateAction();
    }

    public final void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        this.updateAction();
    }

    public final void threadsMonitoringChanged() {
        this.updateAction();
    }

    protected abstract int[] enabledStates();

    protected final boolean asynchronous() {
        return false;
    }

    protected boolean requiresInstrumentation() {
        return false;
    }

    private void updateAction() {
        if (this.lastProfilingState != Profiler.getDefault().getProfilingState()) {
            boolean bl = this.isEnabled();
            this.firePropertyChange("enabled", !bl, bl);
        } else if (this.lastProfilingState != 1 && this.lastInstrumentation != Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType()) {
            boolean bl = this.isEnabled();
            this.firePropertyChange("enabled", !bl, bl);
        }
    }
}

