/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.openide.util.NbBundle;

public class SnapshotInfoPanel
extends JPanel {
    private static final String DATA_COLLECTED_FROM_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_DataCollectedFromString");
    private static final String SNAPSHOT_TAKEN_AT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SnapshotTakenAtString");
    private static final String FILE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_FileString");
    private static final String NOT_SAVED_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_NotSavedString");
    private static final String FILE_SIZE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_FileSizeString");
    private static final String SETTINGS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SettingsString");
    private static final String SETTINGS_NAME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SettingsNameString");
    private static final String PROFILING_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_ProfilingTypeString");
    private static final String CODE_REGION_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CodeRegionString");
    private static final String PROFILED_CODE_REGION_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_ProfiledCodeRegionString");
    private static final String EXCLUDE_SLEEP_WAIT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_ExcludeSleepWaitString");
    private static final String BUFFER_SIZE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_BufferSizeString");
    private static final String LIMIT_PROFILED_THREADS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_LimitProfiledThreadsString");
    private static final String UNLIMITED_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_UnlimitedString");
    private static final String CPU_ENTIRE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CpuEntireString");
    private static final String CPU_PART_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CpuPartString");
    private static final String MEMORY_ALLOC_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_MemoryAllocString");
    private static final String MEMORY_LIVENESS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_MemoryLivenessString");
    private static final String TRACKING_ALL_INSTANCES_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_TrackingAllInstancesString");
    private static final String TRACK_EVERY_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_TrackEveryString");
    private static final String RECORD_STACK_TRACES_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_RecordStackTracesString");
    private static final String LIMIT_STACK_DEPTH_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_LimitStackDepthString");
    private static final String RUN_GC_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_RunGcString");
    private static final String ROOT_METHODS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_RootMethodsString");
    private static final String CPU_PROFILING_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CpuProfilingTypeString");
    private static final String SAMPLING_PERIOD_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SamplingPeriodString");
    private static final String CPU_TIMER_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CpuTimerString");
    private static final String INSTRUMENTATION_FILTER_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentationFilterString");
    private static final String INSTRUMENTATION_SCHEME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentationSchemeString");
    private static final String INSTRUMENT_METHOD_INVOKE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentMethodInvokeString");
    private static final String INSTRUMENT_NEW_THREADS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentNewThreadsString");
    private static final String INSTRUMENT_GETTERS_SETTERS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentGettersSettersString");
    private static final String INSTRUMENT_EMPTY_METHODS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentEmptyMethodsString");
    private static final String OVERRIDEN_GLOBAL_PROPERTIES_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_OverridenGlobalPropertiesString");
    private static final String WORKING_DIRECTORY_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_WorkingDirectoryString");
    private static final String PROJECT_PLATFORM_NAME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_ProjectPlatformNameString");
    private static final String JAVA_PLATFORM_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_JavaPlatformString");
    private static final String JVM_ARGUMENTS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_JvmArgumentsString");
    private static final String COMM_PORT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CommPortString");
    private static final String YES_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_YesString");
    private static final String NO_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_NoString");
    private static final String ON_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_OnString");
    private static final String OFF_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_OffString");
    private static final String INVALID_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InvalidString");
    private static final String NO_METHODS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_NoMethodsString");
    private static final String METHODS_COUNT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_MethodsCountString");
    private static final String LINES_DEF_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_LinesDefString");
    private static final String INSTRUMENTATION_PROF_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentationProfTypeString");
    private static final String SAMPLED_INSTR_PROF_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SampledInstrProfTypeString");
    private static final String SAMPLED_PROF_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SampledProfTypeString");
    private static final String TOTAL_PROF_SCHEME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_TotalProfSchemeString");
    private static final String EAGER_PROF_SCHEME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_EagerProfSchemeString");
    private static final String LAZY_PROF_SCHEME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_LazyProfSchemeString");
    private static final String INSTANCES_COUNT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstancesCountString");
    private static final String INFO_AREA_ACCESS_NAME = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InfoAreaAccessName");
    private HTMLTextArea infoArea;
    private JScrollPane infoAreaScrollPane;
    private LoadedSnapshot loadedSnapshot;

    public SnapshotInfoPanel(LoadedSnapshot loadedSnapshot) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.infoArea = new HTMLTextArea();
        this.infoArea.getAccessibleContext().setAccessibleName(INFO_AREA_ACCESS_NAME);
        this.infoAreaScrollPane = new JScrollPane((Component)this.infoArea);
        this.add((Component)this.infoAreaScrollPane, "Center");
        this.loadedSnapshot = loadedSnapshot;
        this.updateInfo();
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot((Component)this.infoAreaScrollPane);
        }
        return UIUtils.createScreenshot((Component)this.infoArea);
    }

    public boolean fitsVisibleArea() {
        return !this.infoAreaScrollPane.getVerticalScrollBar().isVisible();
    }

    public void updateInfo() {
        ProfilingSettings profilingSettings = this.loadedSnapshot.getSettings();
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<strong>");
        stringBuffer.append(DATA_COLLECTED_FROM_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(StringUtils.formatFullDate((Date)new Date(this.loadedSnapshot.getSnapshot().getBeginTime())));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(SNAPSHOT_TAKEN_AT_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(StringUtils.formatFullDate((Date)new Date(this.loadedSnapshot.getSnapshot().getTimeTaken())));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(FILE_STRING + " ");
        stringBuffer.append("</strong>");
        File file = this.loadedSnapshot.getFile();
        if (file == null) {
            stringBuffer.append(NOT_SAVED_STRING);
        } else {
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(FILE_SIZE_STRING + " ");
            stringBuffer.append("</strong>");
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(true);
            stringBuffer.append(numberFormat.format(file.length()) + " B");
        }
        stringBuffer.append("<br>");
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(SETTINGS_STRING);
        stringBuffer.append("</strong>");
        stringBuffer.append("<br>");
        stringBuffer.append("<br>");
        stringBuffer.append("<blockquote>");
        stringBuffer.append("<strong>");
        stringBuffer.append(" " + SETTINGS_NAME_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(profilingSettings.getSettingsName());
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(" " + PROFILING_TYPE_STRING + " ");
        stringBuffer.append("</strong>");
        switch (profilingSettings.getProfilingType()) {
            case 32: {
                stringBuffer.append(CODE_REGION_STRING);
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                stringBuffer.append("<strong>");
                stringBuffer.append(PROFILED_CODE_REGION_STRING + " ");
                stringBuffer.append("</strong>");
                stringBuffer.append(this.formatRootMethod(profilingSettings.getCodeFragmentSelection()));
                stringBuffer.append("<br>");
                stringBuffer.append("<strong>");
                stringBuffer.append(EXCLUDE_SLEEP_WAIT_STRING + " ");
                stringBuffer.append("</strong>");
                stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getExcludeWaitTime()));
                stringBuffer.append("<br>");
                stringBuffer.append("<strong>");
                stringBuffer.append(BUFFER_SIZE_STRING + " ");
                stringBuffer.append("</strong>");
                stringBuffer.append(profilingSettings.getCodeRegionCPUResBufSize());
                stringBuffer.append("<br>");
                stringBuffer.append("<strong>");
                stringBuffer.append(LIMIT_PROFILED_THREADS_STRING + " ");
                stringBuffer.append("</strong>");
                if (profilingSettings.getNProfiledThreadsLimit() < 0) {
                    stringBuffer.append(UNLIMITED_STRING);
                } else {
                    stringBuffer.append("" + profilingSettings.getNProfiledThreadsLimit());
                }
                stringBuffer.append("<br>");
                break;
            }
            case 8: {
                stringBuffer.append(CPU_ENTIRE_STRING);
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendCPUText(stringBuffer, profilingSettings);
                break;
            }
            case 16: {
                stringBuffer.append(CPU_PART_STRING);
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendCPUText(stringBuffer, profilingSettings);
                break;
            }
            case 2: {
                stringBuffer.append(MEMORY_ALLOC_STRING);
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendMemoryText(stringBuffer, profilingSettings);
                break;
            }
            case 4: {
                stringBuffer.append(MEMORY_LIVENESS_STRING);
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendMemoryText(stringBuffer, profilingSettings);
            }
        }
        this.appendOverridenGlobalProperties(stringBuffer, profilingSettings);
        stringBuffer.append("</blockquote>");
        stringBuffer.append("<br>");
        this.infoArea.setText(stringBuffer.toString());
    }

    private static String getOnOff(boolean bl) {
        return bl ? ON_STRING : OFF_STRING;
    }

    private static String getYesNo(boolean bl) {
        return bl ? YES_STRING : NO_STRING;
    }

    private String getCPUProfilingScheme(int n) {
        switch (n) {
            case 3: {
                return TOTAL_PROF_SCHEME_STRING;
            }
            case 2: {
                return EAGER_PROF_SCHEME_STRING;
            }
            case 1: {
                return LAZY_PROF_SCHEME_STRING;
            }
        }
        return INVALID_STRING;
    }

    private String getCPUProfilingType(int n) {
        switch (n) {
            case 0: {
                return INSTRUMENTATION_PROF_TYPE_STRING;
            }
            case 1: {
                return SAMPLED_INSTR_PROF_TYPE_STRING;
            }
            case 2: {
                return SAMPLED_INSTR_PROF_TYPE_STRING;
            }
        }
        return INVALID_STRING;
    }

    private void appendCPUText(StringBuffer stringBuffer, ProfilingSettings profilingSettings) {
        stringBuffer.append("<strong>");
        stringBuffer.append(ROOT_METHODS_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(this.formatRootMethods(profilingSettings.getInstrumentationRootMethods()));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(CPU_PROFILING_TYPE_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(this.getCPUProfilingType(profilingSettings.getCPUProfilingType()));
        stringBuffer.append("<br>");
        if (profilingSettings.getCPUProfilingType() == 1) {
            stringBuffer.append("<strong>");
            stringBuffer.append(SAMPLING_PERIOD_STRING + " ");
            stringBuffer.append("</strong>");
            stringBuffer.append(profilingSettings.getSamplingInterval());
            stringBuffer.append(" ms<br>");
        }
        stringBuffer.append("<strong>");
        stringBuffer.append(CPU_TIMER_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getOnOff(profilingSettings.getThreadCPUTimerOn()));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(EXCLUDE_SLEEP_WAIT_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getExcludeWaitTime()));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(LIMIT_PROFILED_THREADS_STRING + " ");
        stringBuffer.append("</strong>");
        if (profilingSettings.getNProfiledThreadsLimit() < 0) {
            stringBuffer.append(UNLIMITED_STRING);
        } else {
            stringBuffer.append("" + profilingSettings.getNProfiledThreadsLimit());
        }
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(INSTRUMENTATION_FILTER_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(profilingSettings.getSelectedInstrumentationFilter().toString());
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(INSTRUMENTATION_SCHEME_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(this.getCPUProfilingScheme(profilingSettings.getInstrScheme()));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(INSTRUMENT_METHOD_INVOKE_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getInstrumentMethodInvoke()));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(INSTRUMENT_NEW_THREADS_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getInstrumentSpawnedThreads()));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(INSTRUMENT_GETTERS_SETTERS_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getInstrumentGetterSetterMethods()));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(INSTRUMENT_EMPTY_METHODS_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getInstrumentEmptyMethods()));
        stringBuffer.append("<br>");
    }

    private void appendMemoryText(StringBuffer stringBuffer, ProfilingSettings profilingSettings) {
        if (profilingSettings.getAllocTrackEvery() == 1) {
            stringBuffer.append("<strong>");
            stringBuffer.append(TRACKING_ALL_INSTANCES_STRING + " ");
            stringBuffer.append("</strong>");
        } else {
            stringBuffer.append("<strong>");
            stringBuffer.append(TRACK_EVERY_STRING + " ");
            stringBuffer.append("</strong>");
            stringBuffer.append(MessageFormat.format(INSTANCES_COUNT_STRING, "" + profilingSettings.getAllocTrackEvery()));
        }
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(RECORD_STACK_TRACES_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getAllocStackTraceLimit() != 0));
        stringBuffer.append("<br>");
        if (profilingSettings.getAllocStackTraceLimit() != 0) {
            stringBuffer.append("<strong>");
            stringBuffer.append(LIMIT_STACK_DEPTH_STRING + " ");
            stringBuffer.append("</strong>");
            if (profilingSettings.getAllocStackTraceLimit() < 0) {
                stringBuffer.append(UNLIMITED_STRING);
            } else {
                stringBuffer.append(profilingSettings.getAllocStackTraceLimit());
            }
            stringBuffer.append("<br>");
        }
        stringBuffer.append("<strong>");
        stringBuffer.append(RUN_GC_STRING + " ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getRunGCOnGetResultsInMemoryProfiling()));
        stringBuffer.append("<br>");
    }

    private void appendOverridenGlobalProperties(StringBuffer stringBuffer, ProfilingSettings profilingSettings) {
        if (profilingSettings.getOverrideGlobalSettings()) {
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(OVERRIDEN_GLOBAL_PROPERTIES_STRING + " ");
            stringBuffer.append("</strong>");
            stringBuffer.append("<br>");
            stringBuffer.append("<blockquote>");
            stringBuffer.append("<strong>");
            stringBuffer.append(WORKING_DIRECTORY_STRING + " ");
            stringBuffer.append("</strong>");
            stringBuffer.append(profilingSettings.getWorkingDir());
            stringBuffer.append("<br>");
            String string = profilingSettings.getJavaPlatformName();
            if (string == null) {
                string = PROJECT_PLATFORM_NAME_STRING;
            }
            stringBuffer.append("<strong>");
            stringBuffer.append(JAVA_PLATFORM_STRING + " ");
            stringBuffer.append("</strong>");
            stringBuffer.append(string);
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(JVM_ARGUMENTS_STRING + " ");
            stringBuffer.append("</strong>");
            stringBuffer.append(profilingSettings.getJVMArgs());
            stringBuffer.append("<br>");
            stringBuffer.append("</blockquote>");
        }
    }

    private String formatRootMethod(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        String string;
        if (sourceCodeSelection.definedViaMethodName()) {
            string = MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(sourceCodeSelection).toFormatted();
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
        } else {
            string = MessageFormat.format(LINES_DEF_STRING, sourceCodeSelection.getClassName(), "" + sourceCodeSelection.getStartLine(), "" + sourceCodeSelection.getEndLine());
        }
        return string;
    }

    private String formatRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        if (sourceCodeSelectionArray == null || sourceCodeSelectionArray.length == 0) {
            return NO_METHODS_STRING;
        }
        if (sourceCodeSelectionArray.length == 1) {
            return this.formatRootMethod(sourceCodeSelectionArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MessageFormat.format(METHODS_COUNT_STRING, "" + sourceCodeSelectionArray.length));
        stringBuffer.append("<br>");
        stringBuffer.append("<blockquote>");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            String string = this.formatRootMethod(sourceCodeSelectionArray[i]);
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append("<br>");
        }
        stringBuffer.append("</blockquote>");
        return stringBuffer.toString();
    }
}

