/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.ClassHistoryDataManager;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.LiveResultsWindowContributor;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CodeRegionLivePanel;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.LiveFlatProfilePanel;
import org.netbeans.lib.profiler.ui.graphs.AllocationsHistoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.LivenessHistoryGraphPanel;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryActionsHandler;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryModels;
import org.netbeans.lib.profiler.ui.memory.LiveAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.LiveLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.Delegate;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class LiveResultsWindow
extends TopComponent
implements ProfilingStateListener,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.LiveResultsWindow");
    private static final String UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsAutomaticallyTooltip");
    private static final String UPDATE_RESULTS_NOW_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsNowTooltip");
    private static final String RUN_GC_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_RunGCTooltip");
    private static final String NO_PROFILING_RESULTS_LABEL_TEXT = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_NoProfilingResultsLabelText");
    private static final String ERROR_DISPLAYING_STACK_TRACES_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingStackTracesMsg");
    private static final String ERROR_DISPLAYING_CALL_GRAPH_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingCallGraphMsg");
    private static final String ERROR_INSTRUMENTING_ROOT_METHOD_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorInstrumentingRootMethodMsg");
    private static final String LIVE_RESULTS_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsTabName");
    private static final String HISTORY_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_HistoryTabName");
    private static final String LIVE_RESULTS_ACCESS_DESCR = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsAccessDescr");
    private static final String LOGGING_CONFIRMATION_CAPTION = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingConfirmationCaption");
    private static final String LOGGING_RESET_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingResetMsg");
    private static final String LOGGING_STOP_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingStopMsg");
    private static final String HELP_CTX_KEY = "LiveResultsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("LiveResultsWindow.HelpCtx");
    private static LiveResultsWindow defaultLiveInstance;
    private static final TargetAppRunner runner;
    private static final Image liveWindowIcon;
    private static final AtomicBoolean resultsDumpForced;
    private CPUResUserActionsHandler cpuActionsHandler;
    private Component lastFocusOwner;
    private EmptyLiveResultsPanel noResultsPanel;
    private JButton runGCButton;
    private JButton updateNowButton;
    private JPanel currentDisplayComponent;
    private JPanel memoryTabPanel;
    private JTabbedPane tabs;
    private JToggleButton autoToggle;
    private JToolBar.Separator graphButtonsSeparator;
    private List<JButton> chartActions = new ArrayList<JButton>();
    private JPanel historyPanel;
    private ClassHistoryDataManager classHistoryManager;
    private ClassHistoryModels classHistoryModels;
    private AllocationsHistoryGraphPanel allocationsHistoryPanel;
    private LivenessHistoryGraphPanel livenessHistoryPanel;
    private JToolBar toolBar;
    private LiveResultsPanel currentDisplay;
    private MemoryResUserActionsHandler memoryActionsHandler;
    private HistoryActionsHandler historyActionsHandler;
    private boolean autoRefresh = true;
    private volatile boolean profilerRunning = false;
    private volatile boolean resultsAvailable = false;
    private volatile boolean resultsAvailableinTA = false;
    private Listener listener;
    private final AtomicLong autoRefreshRequested = new AtomicLong(0L);

    public LiveResultsWindow() {
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                LiveResultsWindow.this.initUI();
                LiveResultsWindow.this.listener = (Listener)Lookup.getDefault().lookup(Listener.class);
                LiveResultsWindow.this.listener.setDelegate(LiveResultsWindow.this);
            }
        });
    }

    private void initUI() {
        this.setName(NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
        this.setIcon(liveWindowIcon);
        this.getAccessibleContext().setAccessibleDescription(LIVE_RESULTS_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.memoryActionsHandler = new MemoryActionsHandler();
        this.historyActionsHandler = new HistoryActionsHandler();
        this.cpuActionsHandler = new CPUActionsHandler();
        this.classHistoryManager = new ClassHistoryDataManager();
        this.classHistoryModels = new ClassHistoryModels(this.classHistoryManager);
        this.toolBar = this.createToolBar();
        this.add(this.toolBar, "North");
        this.noResultsPanel = new EmptyLiveResultsPanel();
        this.noResultsPanel.setLayout(new BorderLayout());
        this.noResultsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel jLabel = new JLabel(NO_PROFILING_RESULTS_LABEL_TEXT);
        jLabel.setFont(jLabel.getFont().deriveFont(14));
        jLabel.setIcon(Icons.getIcon((String)"ProfilerIcons.Monitoring32"));
        jLabel.setIconTextGap(10);
        jLabel.setEnabled(false);
        jLabel.setOpaque(false);
        this.noResultsPanel.add((Component)jLabel, "North");
        this.noResultsPanel.setOpaque(false);
        this.currentDisplay = null;
        this.currentDisplayComponent = this.noResultsPanel;
        this.add(this.noResultsPanel, "Center");
        this.memoryTabPanel = new JPanel(new BorderLayout());
        this.memoryTabPanel.setOpaque(false);
        this.tabs = new JTabbedPane();
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.graphButtonsSeparator = new JToolBar.Separator();
        this.toolBar.add(this.graphButtonsSeparator);
        final int n = this.toolBar.getComponentCount();
        this.memoryTabPanel.add((Component)this.tabs, "Center");
        this.tabs.setTabPlacement(3);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (LiveResultsWindow.this.currentDisplayComponent == LiveResultsWindow.this.memoryTabPanel) {
                    if (LiveResultsWindow.this.tabs.getSelectedComponent() == LiveResultsWindow.this.historyPanel) {
                        for (JButton jButton : LiveResultsWindow.this.chartActions) {
                            LiveResultsWindow.this.toolBar.add((Component)jButton, n);
                        }
                        LiveResultsWindow.this.graphButtonsSeparator.setVisible(true);
                    } else {
                        for (JButton jButton : LiveResultsWindow.this.chartActions) {
                            LiveResultsWindow.this.toolBar.remove(jButton);
                        }
                        LiveResultsWindow.this.graphButtonsSeparator.setVisible(false);
                    }
                    LiveResultsWindow.this.toolBar.invalidate();
                    LiveResultsWindow.this.toolBar.validate();
                    LiveResultsWindow.this.toolBar.repaint();
                }
            }
        });
        this.historyPanel = new JPanel(new BorderLayout());
        this.hideContributors();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public static LiveResultsWindow getDefault() {
        if (!LiveResultsWindow.hasDefault()) {
            defaultLiveInstance = Singleton.INSTANCE;
        }
        return defaultLiveInstance;
    }

    public static void setPaused(boolean bl) {
    }

    public static void closeIfOpened() {
        if (LiveResultsWindow.hasDefault()) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultLiveInstance.isShowing()) {
                        defaultLiveInstance.close();
                    }
                }
            });
        }
    }

    public static boolean hasDefault() {
        return defaultLiveInstance != null;
    }

    public void setAutoRefresh(boolean bl) {
        if (this.autoRefresh != bl) {
            this.autoRefresh = bl;
            this.autoToggle.setSelected(bl);
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPersistenceType() {
        return 2;
    }

    public int getSortingColumn() {
        if (this.currentDisplay == null) {
            return -1;
        }
        return this.currentDisplay.getSortingColumn();
    }

    public boolean getSortingOrder() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.getSortingOrder();
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return UIUtils.createScreenshot((Component)this.historyPanel);
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewImage(bl);
    }

    @Override
    public String getViewName() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return "memory-history-" + this.classHistoryManager.getTrackedClassName();
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewName();
    }

    public void componentActivated() {
        super.componentActivated();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.currentDisplayComponent != null) {
            this.currentDisplayComponent.requestFocus();
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public boolean fitsVisibleArea() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return true;
        }
        return this.currentDisplay != null && this.currentDisplay.fitsVisibleArea();
    }

    public void handleShutdown() {
        this.profilerRunning = false;
        if (this.isShowing()) {
            this.hideContributors();
            this.requestProfilingDataUpdate(false);
        }
    }

    public void handleStartup() {
        this.profilerRunning = true;
    }

    public void handleCleanupBeforeProfiling() {
        this.classHistoryManager.resetClass();
    }

    @Override
    public boolean hasView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    public void ideClosing() {
        this.hideContributors();
    }

    public void instrumentationChanged(int n, int n2) {
        this.requestProfilingDataUpdate(false);
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        this.updateActions(profilingStateEvent.getNewState());
        switch (profilingStateEvent.getNewState()) {
            case 1: {
                this.handleShutdown();
                break;
            }
            case 4: {
                this.handleStartup();
            }
        }
    }

    public boolean refreshLiveResults() {
        if (this.isAutoRefresh() && this.isShowing()) {
            this.requestProfilingDataUpdate(false);
            return true;
        }
        if (NetBeansProfiler.getDefaultNB().processesProfilingPoints()) {
            this.callForceObtainedResultsDump(runner.getProfilerClient(), false);
        }
        return false;
    }

    public void threadsMonitoringChanged() {
    }

    @Override
    public void exportData(int n, ExportDataDumper exportDataDumper) {
        if (this.currentDisplayComponent == this.memoryTabPanel) {
            if (this.tabs.getSelectedComponent() instanceof LiveAllocResultsPanel) {
                ((LiveAllocResultsPanel)this.currentDisplay).exportData(n, exportDataDumper, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
            } else if (this.tabs.getSelectedComponent() instanceof LiveLivenessResultsPanel) {
                ((LiveLivenessResultsPanel)this.currentDisplay).exportData(n, exportDataDumper, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
            }
        } else if (this.currentDisplayComponent instanceof LiveFlatProfilePanel) {
            ((LiveFlatProfilePanel)this.currentDisplay).exportData(n, exportDataDumper, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return false;
    }

    @Override
    public boolean hasExportableView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.currentDisplay) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.hideContributors();
    }

    protected void componentOpened() {
        super.componentOpened();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.updateResultsDisplay();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    void reset() {
        this.resultsAvailable = false;
        if (this.currentDisplay != null) {
            this.currentDisplay.reset();
            this.resetResultsDisplay();
        }
        this.resetContributors();
    }

    private boolean callForceObtainedResultsDump(ProfilerClient profilerClient) {
        return this.callForceObtainedResultsDump(profilerClient, true);
    }

    private boolean callForceObtainedResultsDump(ProfilerClient profilerClient, boolean bl) {
        if (!this.resultsAvailableinTA) {
            return false;
        }
        if (bl) {
            resultsDumpForced.set(true);
        }
        try {
            if (profilerClient.getCurrentInstrType() != 1) {
                profilerClient.forceObtainedResultsDump(true);
            }
            return true;
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            return false;
        }
    }

    private boolean isProfiling() {
        return runner.getProfilerClient().getCurrentInstrType() != 0;
    }

    private static boolean checkIfResultsExist(ProfilerClient profilerClient, int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return LiveResultsWindow.getDefault().resultsAvailable;
            }
            case 1: {
                try {
                    return profilerClient.cpuResultsExist();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    return false;
                }
            }
        }
        return false;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar(){

            @Override
            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)component));
                }
                return super.add(component);
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        jToolBar.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.autoToggle = new JToggleButton(Icons.getIcon((String)"GeneralIcons.UpdateAuto"));
        this.autoToggle.setSelected(true);
        this.autoToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LiveResultsWindow.this.autoRefresh = LiveResultsWindow.this.autoToggle.isSelected();
            }
        });
        this.autoToggle.setToolTipText(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.autoToggle.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.updateNowButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow"));
        this.updateNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.updateNowButton.setToolTipText(UPDATE_RESULTS_NOW_TOOLTIP);
        this.updateNowButton.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_NOW_TOOLTIP);
        this.runGCButton = new JButton(Icons.getIcon((String)"ProfilerIcons.RunGC"));
        this.runGCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    runner.runGC();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    ProfilerDialogs.displayError((String)targetAppOrVMTerminated.getMessage());
                    ProfilerLogger.log((Exception)((Object)targetAppOrVMTerminated));
                }
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.runGCButton.setToolTipText(RUN_GC_TOOLTIP);
        this.runGCButton.getAccessibleContext().setAccessibleName(RUN_GC_TOOLTIP);
        jToolBar.add(this.autoToggle);
        jToolBar.add(this.updateNowButton);
        jToolBar.add(this.runGCButton);
        jToolBar.add(ResetResultsAction.getInstance());
        jToolBar.addSeparator();
        jToolBar.add(((Presenter.Toolbar)SystemAction.get(TakeSnapshotAction.class)).getToolbarPresenter());
        jToolBar.addSeparator();
        jToolBar.add(new ExportAction(this, null));
        jToolBar.add(new SaveViewAction(this));
        return jToolBar;
    }

    private LiveResultsPanel preparePanelForInstrType(int n) {
        CodeRegionLivePanel codeRegionLivePanel = null;
        switch (n) {
            case 5: {
                LiveAllocResultsPanel liveAllocResultsPanel = new LiveAllocResultsPanel(runner, this.memoryActionsHandler, (ClassHistoryActionsHandler)this.historyActionsHandler, this.classHistoryManager);
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)liveAllocResultsPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.historyPanel);
                this.tabs.setEnabledAt(1, false);
                codeRegionLivePanel = liveAllocResultsPanel;
                break;
            }
            case 6: {
                LiveLivenessResultsPanel liveLivenessResultsPanel = new LiveLivenessResultsPanel(runner, this.memoryActionsHandler, (ClassHistoryActionsHandler)this.historyActionsHandler, this.classHistoryManager);
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)liveLivenessResultsPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.historyPanel);
                this.tabs.setEnabledAt(1, false);
                codeRegionLivePanel = liveLivenessResultsPanel;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Lookup.Provider provider = NetBeansProfiler.getDefaultNB().getProfiledProject();
                LiveFlatProfilePanel liveFlatProfilePanel = new LiveFlatProfilePanel(runner, this.cpuActionsHandler);
                for (LiveResultsWindowContributor liveResultsWindowContributor : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
                    liveResultsWindowContributor.addToCpuResults(liveFlatProfilePanel, this.toolBar, runner.getProfilerClient(), provider);
                }
                this.currentDisplayComponent = liveFlatProfilePanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                codeRegionLivePanel = liveFlatProfilePanel;
                break;
            }
            case 1: {
                CodeRegionLivePanel codeRegionLivePanel2 = new CodeRegionLivePanel(runner.getProfilerClient());
                this.currentDisplayComponent = codeRegionLivePanel2;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                codeRegionLivePanel = codeRegionLivePanel2;
                break;
            }
            case 0: {
                throw new IllegalStateException();
            }
        }
        return codeRegionLivePanel;
    }

    private void requestProfilingDataUpdate(final boolean bl) {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!LiveResultsWindow.this.isAutoRefresh() && !bl) {
                    return;
                }
                if (!LiveResultsWindow.this.isProfiling() || !LiveResultsWindow.this.isShowing()) {
                    return;
                }
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.this.autoRefreshRequested.incrementAndGet();
                        LiveResultsWindow.this.callForceObtainedResultsDump(runner.getProfilerClient());
                    }
                });
            }
        });
    }

    private void resetResultsDisplay() {
        if (this.currentDisplayComponent != null && this.currentDisplayComponent != this.noResultsPanel) {
            this.remove(this.currentDisplayComponent);
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            this.add(this.noResultsPanel, "Center");
            for (JButton jButton : this.chartActions) {
                this.toolBar.remove(jButton);
            }
            this.graphButtonsSeparator.setVisible(false);
            this.revalidate();
            this.repaint();
            this.hideContributors();
        }
    }

    private void updateActions(int n) {
        this.runGCButton.setEnabled(n == 4);
        this.updateNowButton.setEnabled(n == 4);
    }

    private void refresh() {
        if (LOGGER.isLoggable(Level.FINE) && this.currentDisplayComponent != null) {
            LOGGER.log(Level.FINE, "refreshing contributors for drilldown: {0}", this.currentDisplayComponent.getClass().getName());
        }
        this.refreshContributors();
        if (this.profilerRunning && this.currentDisplayComponent instanceof LiveFlatProfilePanel) {
            LOGGER.fine("Showing contributors");
            if (this.isVisible()) {
                this.showContributors();
            }
        } else {
            LOGGER.fine("Hiding contributors");
            this.hideContributors();
        }
    }

    private void updateResultsDisplay() {
        if (!this.isShowing()) {
            return;
        }
        if (!this.resultsAvailable) {
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            return;
        }
        int n = runner.getProfilerClient().getCurrentInstrType();
        if (n != 0) {
            boolean bl;
            boolean bl2 = bl = this.currentDisplayComponent != null && this.currentDisplay != null && this.currentDisplay.supports(n);
            if (!bl) {
                if (this.currentDisplayComponent != null) {
                    this.remove(this.currentDisplayComponent);
                }
                if (this.currentDisplay != null) {
                    this.currentDisplay.handleRemove();
                }
                this.currentDisplay = this.preparePanelForInstrType(n);
                this.add(this.currentDisplayComponent, "Center");
                this.revalidate();
                this.repaint();
                CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.this.currentDisplayComponent.requestFocusInWindow();
                    }
                });
            }
            if (this.currentDisplay != null) {
                this.currentDisplay.updateLiveResults();
            }
        }
        this.refresh();
    }

    private void hideContributors() {
        for (LiveResultsWindowContributor liveResultsWindowContributor : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            liveResultsWindowContributor.hide();
        }
    }

    private void showContributors() {
        for (LiveResultsWindowContributor liveResultsWindowContributor : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            liveResultsWindowContributor.show();
        }
    }

    private void refreshContributors() {
        for (LiveResultsWindowContributor liveResultsWindowContributor : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            liveResultsWindowContributor.refresh();
        }
    }

    private void resetContributors() {
        for (LiveResultsWindowContributor liveResultsWindowContributor : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            liveResultsWindowContributor.reset();
        }
    }

    static {
        runner = Profiler.getDefault().getTargetAppRunner();
        liveWindowIcon = Icons.getImage((String)"ProfilerIcons.WindowLiveResults");
        resultsDumpForced = new AtomicBoolean(false);
    }

    private static class Singleton {
        private static final LiveResultsWindow INSTANCE = new LiveResultsWindow();

        private Singleton() {
        }
    }

    private final class HistoryActionsHandler
    implements ClassHistoryActionsHandler {
        private HistoryActionsHandler() {
        }

        public void showClassHistory(int n, final String string) {
            int n2 = LiveResultsWindow.this.classHistoryManager.getTrackedClassID();
            String string2 = LiveResultsWindow.this.classHistoryManager.getTrackedClassName();
            if (n2 != -1 && (n == n2 ? !ProfilerDialogs.displayConfirmationDNSA((String)MessageFormat.format(LOGGING_RESET_MSG, string2), (String)LOGGING_CONFIRMATION_CAPTION, null, (String)"History.historylogging.reset", (boolean)true) : !ProfilerDialogs.displayConfirmationDNSA((String)MessageFormat.format(LOGGING_STOP_MSG, string2), (String)LOGGING_CONFIRMATION_CAPTION, null, (String)"History.historylogging.stop", (boolean)true))) {
                return;
            }
            LiveResultsWindow.this.classHistoryManager.setupClass(n, string);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LiveResultsWindow.this.chartActions.clear();
                    Action[] actionArray = null;
                    if (runner.getProfilerClient().getCurrentInstrType() == 5) {
                        if (LiveResultsWindow.this.allocationsHistoryPanel == null) {
                            LiveResultsWindow.this.allocationsHistoryPanel = AllocationsHistoryGraphPanel.createPanel((ClassHistoryModels)LiveResultsWindow.this.classHistoryModels);
                        }
                        LiveResultsWindow.this.historyPanel.removeAll();
                        LiveResultsWindow.this.historyPanel.add((Component)LiveResultsWindow.this.allocationsHistoryPanel, "Center");
                        actionArray = LiveResultsWindow.this.allocationsHistoryPanel.getActions();
                    } else if (runner.getProfilerClient().getCurrentInstrType() == 6) {
                        if (LiveResultsWindow.this.livenessHistoryPanel == null) {
                            LiveResultsWindow.this.livenessHistoryPanel = LivenessHistoryGraphPanel.createPanel((ClassHistoryModels)LiveResultsWindow.this.classHistoryModels);
                        }
                        LiveResultsWindow.this.historyPanel.removeAll();
                        LiveResultsWindow.this.historyPanel.add((Component)LiveResultsWindow.this.livenessHistoryPanel, "Center");
                        actionArray = LiveResultsWindow.this.livenessHistoryPanel.getActions();
                    }
                    if (actionArray != null) {
                        for (void var5_5 : actionArray) {
                            LiveResultsWindow.this.chartActions.add(new JButton((Action)var5_5));
                        }
                    }
                    Collections.reverse(LiveResultsWindow.this.chartActions);
                    LiveResultsWindow.this.tabs.setEnabledAt(1, true);
                    LiveResultsWindow.this.tabs.setTitleAt(1, NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ClassHistoryTabName", (Object[])new Object[]{string}));
                    LiveResultsWindow.this.tabs.setSelectedIndex(1);
                }
            });
        }
    }

    private static final class MemoryActionsHandler
    implements MemoryResUserActionsHandler {
        private MemoryActionsHandler() {
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            if (string2 == null && string3 == null && (VMUtils.isVMPrimitiveType((String)string) || VMUtils.isPrimitiveType((String)string))) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(string) && "traceVMObjectAlloc".equals(string2)) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                GoToSource.openSource((Lookup.Provider)NetBeansProfiler.getDefaultNB().getProfiledProject(), (String)string, (String)string2, (String)string3);
            }
        }

        public void showStacksForClass(final int n, final int n2, final boolean bl) {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    final LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().takeSnapshot();
                    if (loadedSnapshot != null) {
                        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SnapshotResultsWindow snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot, n2, bl);
                                if (snapshotResultsWindow != null) {
                                    snapshotResultsWindow.displayStacksForClass(n, n2, bl);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(String string, String string2, String string3) {
            ProfilingSettings profilingSettings3;
            Lookup.Provider provider = NetBeansProfiler.getDefaultNB().getProfiledProject();
            ProfilingSettings profilingSettings2 = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)provider).getProfilingSettings();
            ArrayList<ProfilingSettings[]> arrayList = new ArrayList<ProfilingSettings[]>();
            for (ProfilingSettings profilingSettings3 : profilingSettings2) {
                if (!ProfilingSettings.isCPUSettings((int)profilingSettings3.getProfilingType())) continue;
                arrayList.add((ProfilingSettings[])profilingSettings3);
            }
            ProfilingSettings profilingSettings4 = null;
            String string4 = Profiler.getDefault().getLastProfilingSettings().getSettingsName();
            ProfilingSettings profilingSettings5 = arrayList.iterator();
            while (profilingSettings5.hasNext()) {
                profilingSettings3 = (ProfilingSettings)profilingSettings5.next();
                if (!profilingSettings3.getSettingsName().equals(string4)) continue;
                profilingSettings4 = profilingSettings3;
                break;
            }
            if ((profilingSettings5 = IDEUtils.selectSettings(16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), profilingSettings4)) == null) {
                return;
            }
            profilingSettings5.addRootMethod(string, string2, string3);
            if (arrayList.contains(profilingSettings5)) {
                ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettings2, (ProfilingSettings)profilingSettings5, (Lookup.Provider)provider);
            } else {
                profilingSettings3 = new ProfilingSettings[((ProfilingSettings)profilingSettings2).length + 1];
                System.arraycopy(profilingSettings2, 0, profilingSettings3, 0, ((ProfilingSettings[])profilingSettings2).length);
                profilingSettings3[((ProfilingSettings[])profilingSettings2).length] = profilingSettings5;
                ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettings3, (ProfilingSettings)profilingSettings5, (Lookup.Provider)provider);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot cPUResultsSnapshot, int n, int n2, int n3, int n4, boolean bl) {
            throw new IllegalStateException(ERROR_DISPLAYING_CALL_GRAPH_MSG);
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            GoToSource.openSource((Lookup.Provider)NetBeansProfiler.getDefaultNB().getProfiledProject(), (String)string, (String)string2, (String)string3);
        }

        public void viewChanged(int n) {
            if (LiveResultsWindow.this.currentDisplay != null) {
                ((FlatProfilePanel)LiveResultsWindow.this.currentDisplay).prepareResults();
            }
        }
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener,
    MemoryCCTProvider.Listener {
        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean bl) {
            if (!bl) {
                LiveResultsWindow.getDefault().resultsAvailable = true;
                if (resultsDumpForced.getAndSet(false) && LiveResultsWindow.getDefault().autoRefreshRequested.getAndDecrement() > 0L) {
                    CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LiveResultsWindow.getDefault().updateResultsDisplay();
                        }
                    });
                } else {
                    LiveResultsWindow.getDefault().autoRefreshRequested.compareAndSet(-1L, 0L);
                }
            } else {
                resultsDumpForced.set(false);
            }
        }

        public void cctReset() {
            LiveResultsWindow.getDefault().resultsAvailable = false;
        }
    }

    public static final class EmptyLiveResultsPanel
    extends JPanel
    implements LiveResultsPanel {
        public int getSortingColumn() {
            return -1;
        }

        public boolean getSortingOrder() {
            return true;
        }

        public BufferedImage getViewImage(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public String getViewName() {
            return "Empty live results";
        }

        public boolean fitsVisibleArea() {
            return false;
        }

        public void handleRemove() {
        }

        public void handleShutdown() {
        }

        public boolean hasView() {
            return false;
        }

        public void reset() {
        }

        public boolean supports(int n) {
            return true;
        }

        public void updateLiveResults() {
        }
    }

    public static class Listener
    extends Delegate<LiveResultsWindow>
    implements ResultsListener {
        @Override
        public void resultsAvailable() {
            LiveResultsWindow.getDefault().resultsAvailableinTA = true;
        }

        @Override
        public void resultsReset() {
            LiveResultsWindow.getDefault().resultsAvailableinTA = false;
            if (this.getDelegate() != null) {
                ((LiveResultsWindow)this.getDelegate()).reset();
            }
        }
    }
}

