/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.x86;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.x86.X86Frame;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class X86RicochetFrame
extends VMObject {
    private static AddressField senderLinkField;
    private static AddressField savedArgsBaseField;
    private static AddressField exactSenderSPField;
    private static AddressField senderPCField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("MethodHandles::RicochetFrame");
        senderLinkField = type.getAddressField("_sender_link");
        savedArgsBaseField = type.getAddressField("_saved_args_base");
        exactSenderSPField = type.getAddressField("_exact_sender_sp");
        senderPCField = type.getAddressField("_sender_pc");
    }

    static X86RicochetFrame fromFrame(X86Frame f) {
        return new X86RicochetFrame(f.getFP().addOffsetTo(-senderLinkField.getOffset()));
    }

    private X86RicochetFrame(Address addr) {
        super(addr);
    }

    public Address senderLink() {
        return senderLinkField.getValue(this.addr);
    }

    public Address senderLinkAddress() {
        return this.addr.addOffsetTo(senderLinkField.getOffset());
    }

    public Address savedArgsBase() {
        return savedArgsBaseField.getValue(this.addr);
    }

    public Address extendedSenderSP() {
        return this.savedArgsBase();
    }

    public Address exactSenderSP() {
        return exactSenderSPField.getValue(this.addr);
    }

    public Address senderPC() {
        return senderPCField.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                X86RicochetFrame.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

