/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.EqualFlowLayout;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.PopupButton;
import org.netbeans.lib.profiler.ui.components.SnippetPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.actions.HeapDumpAction;
import org.netbeans.modules.profiler.actions.LoadSnapshotAction;
import org.netbeans.modules.profiler.actions.ModifyProfilingAction;
import org.netbeans.modules.profiler.actions.RerunAction;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.RunGCAction;
import org.netbeans.modules.profiler.actions.ShowTelemetryViewAction;
import org.netbeans.modules.profiler.actions.StopAction;
import org.netbeans.modules.profiler.actions.TelemetryOverviewAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.Delegate;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ProfilerControlPanel2
extends TopComponent
implements ProfilingStateListener {
    private static final Logger LOGGER = Logger.getLogger(ProfilerControlPanel2.class.getName());
    private static final String CONTROL_PANEL_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"LAB_ControlPanelName");
    private static final String CONTROLS_SNIPPET_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ControlsSnippetName");
    private static final String STATUS_SNIPPET_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_StatusSnippetName");
    private static final String RESULTS_SNIPPET_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ResultsSnippetName");
    private static final String SNAPSHOTS_SNIPPET_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_SnapshotsSnippetName");
    private static final String VIEW_SNIPPET_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ViewSnippetName");
    private static final String TELEMETRY_SNIPPET_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_TelemetrySnippetName");
    private static final String MODE_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ModeLabelString");
    private static final String TYPE_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_TypeLabelString");
    private static final String CONFIG_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ConfigLabelString");
    private static final String ON_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_OnLabelString");
    private static final String STATUS_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_StatusLabelString");
    private static final String PROFILE_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ProfileLabelString");
    private static final String CPU_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_CpuLabelString");
    private static final String ENTIRE_APP_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_EntireAppLabelString");
    private static final String THIS_COMP_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ThisCompLabelString");
    private static final String RUNNING_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_RunningLabelString");
    private static final String ATTACH_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_AttachLabelString");
    private static final String CODE_FRAGMENT_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_CodeFragmentLabelString");
    private static final String MEMORY_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_MemoryLabelString");
    private static final String MONITOR_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_MonitorLabelString");
    private static final String INACTIVE_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_InactiveLabelString");
    private static final String STARTED_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_StartedLabelString");
    private static final String PAUSED_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_PausedLabelString");
    private static final String STOPPED_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_StoppedLabelString");
    private static final String STARTING_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_StartingLabelString");
    private static final String TELEMETRY_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_TelemetryButtonName");
    private static final String TELEMETRY_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_TelemetryButtonToolTip");
    private static final String THREADS_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ThreadsButtonName");
    private static final String THREADS_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ThreadsButtonToolTip");
    private static final String GLOBAL_COMBO_ITEM_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_GlobalComboItemString");
    private static final String CONFIRM_DELETE_SNAPSHOT_CAPTION = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ConfirmDeleteSnapshotCaption");
    private static final String CONFIRM_DELETE_SNAPSHOT_MSG = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ConfirmDeleteSnapshotMsg");
    private static final String OPEN_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_OpenButtonName");
    private static final String DELETE_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_DeleteButtonName");
    private static final String LOAD_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_LoadButtonName");
    private static final String EXPORT_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ExportButtonName");
    private static final String TAKE_SNAPSHOT_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_TakeSnapshotButtonName");
    private static final String DUMP_HEAP_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_DumpHeapButtonName");
    private static final String TAKE_SNAPSHOT_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_TakeSnapshotButtonToolTip");
    private static final String LIVE_RESULTS_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_LiveResultsButtonName");
    private static final String LIVE_RESULTS_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_LiveResultsButtonToolTip");
    private static final String RESET_RESULTS_BUTTON_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ResetResultsButtonName");
    private static final String RESET_RESULTS_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ResetResultsButtonToolTip");
    private static final String INSTRUMENTED_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_InstrumentedLabelString");
    private static final String FILTER_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_FilterLabelString");
    private static final String THREADS_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ThreadsLabelString");
    private static final String TOTAL_MEMORY_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_TotalMemoryLabelString");
    private static final String USED_MEMORY_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_UsedMemoryLabelString");
    private static final String GC_TIME_LABEL_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_GcTimeLabelString");
    private static final String NO_LINES_CODE_REGION_MSG = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_NoLinesCodeRegionMsg");
    private static final String NO_METHODS_MSG = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_NoMethodsMsg");
    private static final String NO_CLASSES_MSG = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_NoClassesMsg");
    private static final String NOTHING_INSTRUMENTED_MSG = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_NothingInstrumentedMsg");
    private static final String CONTROL_PANEL_TOOLTIP = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ControlPanelToolTip");
    private static final String COMBO_ACCESS_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ComboAccessDescr");
    private static final String LIST_ACCESS_NAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ListAccessName");
    private static final String OPEN_BUTTON_ACCESS_DESCR = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_OpenButtonAccessDescr");
    private static final String DELETE_BUTTON_ACCESS_DESCR = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_DeleteButtonAccessDescr");
    private static final String EXPORT_BUTTON_ACCESS_DESCR = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ExportButtonAccessDescr");
    private static final String LOAD_BUTTON_ACCESS_DESCR = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_LoadButtonAccessDescr");
    private static final String NO_CONFIGURATION_STRING = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_NoConfigurationString");
    private static final String CONTROL_PANEL_ACCESS_DESCR = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_ControlPanelAcessDescr");
    private static final String HEAP_SNAPSHOT_DISPLAYNAME = NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_HeapSnapshotDisplayName");
    private static final String HELP_CTX_KEY = "ProfilerControlPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProfilerControlPanel.HelpCtx");
    private static ProfilerControlPanel2 defaultInstance;
    private static final Image windowIcon;
    private static final Icon cpuIcon;
    private static final Icon fragmentIcon;
    private static final Icon memoryIcon;
    private static final Icon emptyIcon;
    private static final String ID = "profiler_cp";
    private static final Integer EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS;
    private static final Color CP_BACKGROUND_COLOR;
    private final BasicTelemetryPanel basicTelemetrySnippet;
    private final JScrollPane scrollPane;
    private final ResultsSnippetPanel resultsSnippet;
    private final SnapshotsPanel snapshotsSnippet;
    private final SnippetPanel spBasicTelemetry;
    private final SnippetPanel spControls;
    private final SnippetPanel spResults;
    private final SnippetPanel spSnapshots;
    private final SnippetPanel spStatus;
    private final SnippetPanel spView;
    private final StatusPanel statusSnippet;
    private Component lastFocusOwner;
    private boolean initialized = false;
    private Listener listener;

    public ProfilerControlPanel2() {
        this.setName(CONTROL_PANEL_NAME);
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(CONTROL_PANEL_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        ControlsPanel controlsPanel = new ControlsPanel();
        this.statusSnippet = new StatusPanel();
        ViewPanel viewPanel = new ViewPanel();
        this.snapshotsSnippet = new SnapshotsPanel();
        this.resultsSnippet = new ResultsSnippetPanel();
        this.basicTelemetrySnippet = new BasicTelemetryPanel();
        SnippetPanel.Padding padding = new SnippetPanel.Padding();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.spControls = new SnippetPanel(CONTROLS_SNIPPET_NAME, (JComponent)controlsPanel);
        jPanel.add((Component)this.spControls, gridBagConstraints);
        this.spStatus = new SnippetPanel(STATUS_SNIPPET_NAME, (JComponent)this.statusSnippet);
        jPanel.add((Component)this.spStatus, gridBagConstraints);
        this.spResults = new SnippetPanel(RESULTS_SNIPPET_NAME, (JComponent)this.resultsSnippet);
        jPanel.add((Component)this.spResults, gridBagConstraints);
        this.spSnapshots = new SnippetPanel(SNAPSHOTS_SNIPPET_NAME, (JComponent)this.snapshotsSnippet);
        jPanel.add((Component)this.spSnapshots, gridBagConstraints);
        this.spView = new SnippetPanel(VIEW_SNIPPET_NAME, (JComponent)viewPanel);
        jPanel.add((Component)this.spView, gridBagConstraints);
        this.spBasicTelemetry = new SnippetPanel(TELEMETRY_SNIPPET_NAME, (JComponent)this.basicTelemetrySnippet);
        jPanel.add((Component)this.spBasicTelemetry, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)padding, gridBagConstraints);
        this.scrollPane = new JScrollPane(jPanel, 20, 30);
        this.spControls.setBorder((Border)BorderFactory.createMatteBorder(2, 0, 0, 0, CP_BACKGROUND_COLOR));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setBackground(CP_BACKGROUND_COLOR);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        this.add(this.scrollPane, "Center");
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ProfilerControlPanel2.this.scrollPane.getVerticalScrollBar().setBlockIncrement((int)((float)ProfilerControlPanel2.this.scrollPane.getVerticalScrollBar().getModel().getExtent() * 0.95f));
                ProfilerControlPanel2.this.scrollPane.getHorizontalScrollBar().setBlockIncrement((int)((float)ProfilerControlPanel2.this.scrollPane.getHorizontalScrollBar().getModel().getExtent() * 0.95f));
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.listener = (Listener)Lookup.getDefault().lookup(Listener.class);
        this.listener.setDelegate((Object)this);
    }

    public static synchronized ProfilerControlPanel2 getDefault() {
        while (defaultInstance == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    defaultInstance = (ProfilerControlPanel2)WindowManager.getDefault().findTopComponent(ProfilerControlPanel2.ID);
                    if (defaultInstance == null) {
                        defaultInstance = new ProfilerControlPanel2();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
                break;
            }
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                ProfilerLogger.info((String)("InterruptedException in ProfilerControlPanel2.getDefault() [will retry]: " + interruptedException.getMessage()));
            }
            catch (Throwable throwable) {
                ProfilerLogger.severe((String)("Throwable in ProfilerControlPanel2.getDefault(): " + throwable.getMessage()));
                break;
            }
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setProfiledProject(Lookup.Provider provider) {
        this.snapshotsSnippet.setDisplayedProject(provider);
    }

    public String getToolTipText() {
        return CONTROL_PANEL_TOOLTIP;
    }

    public static synchronized void closeIfOpened() {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (defaultInstance != null && defaultInstance.isOpened()) {
                    defaultInstance.close();
                }
            }
        });
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.spControls != null) {
            this.spControls.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public void instrumentationChanged(int n, int n2) {
        this.updateStatus();
    }

    public boolean needsDocking() {
        return WindowManager.getDefault().findMode((TopComponent)this) == null;
    }

    public void open() {
        Mode mode;
        if (this.needsDocking() && (mode = WindowManager.getDefault().findMode("explorer")) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.initialized) {
            this.initialized = true;
            this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        }
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        this.updateStatus();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Integer n;
        super.readExternal(objectInput);
        try {
            n = (Integer)objectInput.readObject();
        }
        catch (Exception exception) {
            ProfilerLogger.severe((String)("Error while deserializing Profiler CP2: " + exception.getMessage()));
            LOGGER.log(Level.WARNING, null, exception);
            return;
        }
        if (n.compareTo(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS) > 0) {
            return;
        }
        this.spControls.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        this.spStatus.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        this.spResults.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        this.spView.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        this.spBasicTelemetry.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        if (n.equals(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS)) {
            this.spSnapshots.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        }
    }

    public void refreshSnapshotsList() {
        if (this.snapshotsSnippet != null) {
            this.snapshotsSnippet.refreshList();
        }
    }

    public void threadsMonitoringChanged() {
        this.updateStatus();
    }

    public void updateStatus() {
        this.statusSnippet.refreshStatus();
        this.resultsSnippet.refreshStatus();
        this.basicTelemetrySnippet.refreshStatus();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS);
        objectOutput.writeObject(this.spControls.isCollapsed());
        objectOutput.writeObject(this.spStatus.isCollapsed());
        objectOutput.writeObject(this.spResults.isCollapsed());
        objectOutput.writeObject(this.spView.isCollapsed());
        objectOutput.writeObject(this.spBasicTelemetry.isCollapsed());
        objectOutput.writeObject(this.spSnapshots.isCollapsed());
    }

    protected String preferredID() {
        return ID;
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowControlPanel");
        cpuIcon = Icons.getIcon((String)"ProfilerIcons.Cpu");
        fragmentIcon = Icons.getIcon((String)"ProfilerIcons.Fragment");
        memoryIcon = Icons.getIcon((String)"ProfilerIcons.Memory");
        emptyIcon = Icons.getIcon((String)"GeneralIcons.Empty");
        EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS = 3;
        CP_BACKGROUND_COLOR = UIUtils.getProfilerResultsBackground();
    }

    private static final class ViewPanel
    extends CPPanel
    implements ActionListener {
        private final JButton threadsButton;
        private final JButton vmTelemetryButton;

        ViewPanel() {
            this.setLayout((LayoutManager)new EqualFlowLayout(0));
            this.setBorder(BorderFactory.createEmptyBorder(7, 10, 12, 10));
            CompoundBorder compoundBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            this.vmTelemetryButton = new JButton(TELEMETRY_BUTTON_NAME, Icons.getIcon((String)"ProfilerIcons.ViewTelemetry32"));
            UIUtils.fixButtonUI((AbstractButton)this.vmTelemetryButton);
            this.vmTelemetryButton.addActionListener(this);
            this.vmTelemetryButton.setContentAreaFilled(false);
            this.vmTelemetryButton.setMargin(new Insets(3, 3, 3, 3));
            this.vmTelemetryButton.setVerticalTextPosition(3);
            this.vmTelemetryButton.setHorizontalTextPosition(0);
            this.vmTelemetryButton.setRolloverEnabled(true);
            this.vmTelemetryButton.setBorder(compoundBorder);
            this.vmTelemetryButton.setToolTipText(TELEMETRY_BUTTON_TOOLTIP);
            this.threadsButton = new JButton(THREADS_BUTTON_NAME, Icons.getIcon((String)"ProfilerIcons.ViewThreads32"));
            UIUtils.fixButtonUI((AbstractButton)this.threadsButton);
            this.threadsButton.addActionListener(this);
            this.threadsButton.setContentAreaFilled(false);
            this.threadsButton.setMargin(new Insets(3, 3, 3, 3));
            this.threadsButton.setVerticalTextPosition(3);
            this.threadsButton.setHorizontalTextPosition(0);
            this.threadsButton.setRolloverEnabled(true);
            this.threadsButton.setBorder(compoundBorder);
            this.threadsButton.setToolTipText(THREADS_BUTTON_TOOLTIP);
            this.add(this.vmTelemetryButton);
            this.add(this.threadsButton);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.vmTelemetryButton) {
                new ShowTelemetryViewAction().actionPerformed(null);
            } else if (actionEvent.getSource() == this.threadsButton) {
                ThreadsWindow.getDefault().showThreads();
            }
        }
    }

    private static final class StatusPanel
    extends CPPanel {
        private final JLabel modeValueLabel;
        private final JLabel onLabel;
        private final JLabel onValueLabel;
        private final JLabel profileValueLabel;
        private final JLabel statusValueLabel;
        private final JLabel typeValueLabel;
        private String configuration = null;
        private String host = null;
        private int count = 0;
        private int mode = -1;
        private int state = -1;

        StatusPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(8, 3, 9, 3));
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(MODE_LABEL_STRING);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            JLabel jLabel2 = new JLabel(TYPE_LABEL_STRING);
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            JLabel jLabel3 = new JLabel(CONFIG_LABEL_STRING);
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            this.onLabel = new JLabel(ON_LABEL_STRING);
            this.onLabel.setFont(this.onLabel.getFont().deriveFont(1));
            JLabel jLabel4 = new JLabel(STATUS_LABEL_STRING);
            jLabel4.setFont(jLabel4.getFont().deriveFont(1));
            this.modeValueLabel = new JLabel(NO_CONFIGURATION_STRING);
            this.typeValueLabel = new JLabel(NO_CONFIGURATION_STRING);
            this.profileValueLabel = new JLabel(NO_CONFIGURATION_STRING);
            this.onValueLabel = new JLabel(NO_CONFIGURATION_STRING);
            this.statusValueLabel = new JLabel(INACTIVE_LABEL_STRING);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)jLabel2, gridBagConstraints);
            this.add((Component)this.typeValueLabel, gridBagConstraints2);
            this.add((Component)jLabel3, gridBagConstraints);
            this.add((Component)this.profileValueLabel, gridBagConstraints2);
            this.add((Component)this.onLabel, gridBagConstraints);
            this.add((Component)this.onValueLabel, gridBagConstraints2);
            this.add((Component)jLabel4, gridBagConstraints);
            this.add((Component)this.statusValueLabel, gridBagConstraints2);
            this.onLabel.setVisible(false);
            this.onValueLabel.setVisible(false);
        }

        void refreshStatus() {
            int n;
            String string;
            ProfilingSettings profilingSettings;
            if (this.mode != Profiler.getDefault().getProfilingMode()) {
                this.mode = Profiler.getDefault().getProfilingMode();
                if (this.mode == 0) {
                    this.modeValueLabel.setText(ATTACH_LABEL_STRING);
                } else {
                    this.modeValueLabel.setText(PROFILE_LABEL_STRING);
                }
            }
            if (!((profilingSettings = Profiler.getDefault().getLastProfilingSettings()) == null || this.configuration != null && this.configuration.equals(profilingSettings.getSettingsName()))) {
                switch (profilingSettings.getProfilingType()) {
                    case 32: {
                        this.typeValueLabel.setText(CODE_FRAGMENT_LABEL_STRING);
                        break;
                    }
                    case 8: 
                    case 16: {
                        this.typeValueLabel.setText(CPU_LABEL_STRING);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.typeValueLabel.setText(MEMORY_LABEL_STRING);
                        break;
                    }
                    case 1: {
                        this.typeValueLabel.setText(MONITOR_LABEL_STRING);
                    }
                }
                this.configuration = profilingSettings.getSettingsName();
                this.profileValueLabel.setText(this.configuration);
            }
            if ((string = Profiler.getDefault().getTargetAppRunner().getProfilerEngineSettings().getRemoteHost()) == null) {
                string = "";
            }
            if (this.host == null || !this.host.equals(string)) {
                this.host = string;
                if ("".equals(this.host)) {
                    this.onValueLabel.setText("");
                    this.onLabel.setVisible(false);
                    this.onValueLabel.setVisible(false);
                } else {
                    this.onValueLabel.setText(this.host);
                    this.onLabel.setVisible(true);
                    this.onValueLabel.setVisible(true);
                }
            }
            if (this.state != (n = Profiler.getDefault().getProfilingState())) {
                this.state = n;
                switch (this.state) {
                    case 1: {
                        this.statusValueLabel.setText(INACTIVE_LABEL_STRING);
                        break;
                    }
                    case 2: {
                        this.statusValueLabel.setText(STARTED_LABEL_STRING);
                        this.count = 1;
                        break;
                    }
                    case 8: {
                        this.statusValueLabel.setText(PAUSED_LABEL_STRING);
                        break;
                    }
                    case 4: {
                        this.statusValueLabel.setText(RUNNING_LABEL_STRING);
                        break;
                    }
                    case 16: {
                        this.statusValueLabel.setText(STOPPED_LABEL_STRING);
                    }
                }
            } else if (this.state == 2) {
                StringBuilder stringBuilder = new StringBuilder(STARTING_LABEL_STRING);
                for (int i = 0; i < this.count; ++i) {
                    stringBuilder.append('.');
                }
                this.statusValueLabel.setText(stringBuilder.toString());
                ++this.count;
                if (this.count == 5) {
                    this.count = 0;
                }
            }
        }
    }

    private static final class SnapshotsPanel
    extends CPPanel
    implements ListSelectionListener,
    ActionListener,
    ChangeListener {
        private DefaultListModel listModel;
        private JButton deleteButton;
        private JButton exportButton;
        private JButton loadButton;
        private JButton openButton;
        private JComboBox combo;
        private JList list;
        private Lookup.Provider displayedProject;
        private boolean internalChange = false;

        SnapshotsPanel() {
            Object object;
            JComponent jComponent;
            Object object2;
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.setLayout(new BorderLayout(6, 6));
            CompoundBorder compoundBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY, Color.GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            LineBorder lineBorder = new LineBorder(Color.LIGHT_GRAY){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    Color color = graphics.getColor();
                    graphics.setColor(this.lineColor);
                    graphics.drawLine(n, n2, n, n4 - 1);
                    graphics.setColor(color);
                }
            };
            this.combo = new JComboBox(new DefaultComboBoxModel());
            this.combo.setRenderer(new ProjectNameRenderer());
            this.combo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
            this.combo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
            ComboBoxUI comboBoxUI = this.combo.getUI();
            if (comboBoxUI instanceof BasicComboBoxUI) {
                object2 = (BasicComboBoxUI)comboBoxUI;
                jComponent = null;
                try {
                    object = BasicComboBoxUI.class.getDeclaredField("arrowButton");
                    ((Field)object).setAccessible(true);
                    jComponent = (JButton)((Field)object).get(object2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (jComponent != null) {
                    jComponent.setBackground(CP_BACKGROUND_COLOR);
                    jComponent.setBorder(BorderFactory.createCompoundBorder(lineBorder, BorderFactory.createEmptyBorder(0, ((AbstractButton)jComponent).getIconTextGap(), 0, ((AbstractButton)jComponent).getIconTextGap())));
                }
            }
            this.combo.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            this.combo.setBackground(CP_BACKGROUND_COLOR);
            this.combo.addActionListener(this);
            ProjectUtilities.addOpenProjectsListener((ChangeListener)this);
            this.listModel = new DefaultListModel();
            this.list = new JList(this.listModel);
            this.list.getAccessibleContext().setAccessibleName(LIST_ACCESS_NAME);
            this.list.setVisibleRowCount(8);
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (bl && jList.isEnabled()) {
                        this.setForeground(jList.isFocusOwner() ? jList.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
                        this.setBackground(jList.isFocusOwner() ? jList.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
                    } else if (!jList.isEnabled()) {
                        this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                        this.setBackground(UIManager.getColor("TextField.inactiveBackground"));
                    } else {
                        this.setForeground(jList.getForeground());
                        this.setBackground(jList.getBackground());
                    }
                    if (object instanceof FileObject) {
                        FileObject fileObject = (FileObject)object;
                        if (fileObject.getExt().equalsIgnoreCase("hprof")) {
                            jLabel.setIcon(memoryIcon);
                            String string = fileObject.getName();
                            Set set = WindowManager.getDefault().getRegistry().getOpened();
                            for (TopComponent topComponent : set) {
                                Object object2 = topComponent.getClientProperty((Object)"HeapDumpFileName");
                                if (object2 == null || !FileUtil.toFile((FileObject)fileObject).equals(new File(object2.toString()))) continue;
                                jLabel.setFont(jLabel.getFont().deriveFont(1));
                                break;
                            }
                            if (string.startsWith("heapdump-")) {
                                String string2 = string.substring("heapdump-".length(), string.length());
                                try {
                                    long l = Long.parseLong(string2);
                                    jLabel.setText(MessageFormat.format(HEAP_SNAPSHOT_DISPLAYNAME, StringUtils.formatUserDate((Date)new Date(l))));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    jLabel.setText(MessageFormat.format(HEAP_SNAPSHOT_DISPLAYNAME, string));
                                }
                            } else {
                                jLabel.setText(MessageFormat.format(HEAP_SNAPSHOT_DISPLAYNAME, string));
                            }
                        } else {
                            LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
                            if (loadedSnapshot != null) {
                                ResultsSnapshot resultsSnapshot = loadedSnapshot.getSnapshot();
                                jLabel.setFont(jLabel.getFont().deriveFont(1));
                                jLabel.setText(StringUtils.formatUserDate((Date)new Date(resultsSnapshot.getTimeTaken())));
                                switch (loadedSnapshot.getType()) {
                                    case 1: {
                                        jLabel.setIcon(cpuIcon);
                                        break;
                                    }
                                    case 2: {
                                        jLabel.setIcon(fragmentIcon);
                                        break;
                                    }
                                    case 4: 
                                    case 8: {
                                        jLabel.setIcon(memoryIcon);
                                    }
                                }
                            } else {
                                String string = fileObject.getName();
                                if (string.startsWith("snapshot-")) {
                                    String string3 = string.substring("snapshot-".length(), string.length());
                                    try {
                                        long l = Long.parseLong(string3);
                                        jLabel.setText(StringUtils.formatUserDate((Date)new Date(l)));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        jLabel.setText(string);
                                    }
                                } else {
                                    jLabel.setText(string);
                                }
                                int n2 = ResultsManager.getDefault().getSnapshotType(fileObject);
                                switch (n2) {
                                    case 1: {
                                        jLabel.setIcon(cpuIcon);
                                        break;
                                    }
                                    case 2: {
                                        jLabel.setIcon(fragmentIcon);
                                        break;
                                    }
                                    case 4: 
                                    case 8: {
                                        jLabel.setIcon(memoryIcon);
                                    }
                                }
                            }
                        }
                    } else {
                        jLabel.setText(object.toString());
                    }
                    return jLabel;
                }
            });
            this.list.addListSelectionListener(this);
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        SnapshotsPanel.this.openSelectedSnapshots();
                    } else if (keyEvent.getKeyCode() == 127) {
                        final FileObject[] fileObjectArray = SnapshotsPanel.this.getSelectedSnapshotFiles();
                        if (ProfilerDialogs.displayConfirmation((String)CONFIRM_DELETE_SNAPSHOT_MSG, (String)CONFIRM_DELETE_SNAPSHOT_CAPTION)) {
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    SnapshotsPanel.this.deleteSnapshots(fileObjectArray);
                                    SnapshotsPanel.this.refreshList();
                                }
                            });
                        }
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                        SnapshotsPanel.this.openSelectedSnapshots();
                    }
                }
            });
            this.add((Component)this.combo, "North");
            object2 = new JScrollPane(this.list, 20, 31);
            ((JComponent)object2).setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            ((JComponent)object2).setPreferredSize(new Dimension(1, ((JComponent)object2).getPreferredSize().height));
            this.add((Component)object2, "Center");
            this.openButton = new JButton(OPEN_BUTTON_NAME);
            UIUtils.fixButtonUI((AbstractButton)this.openButton);
            this.openButton.setContentAreaFilled(false);
            this.openButton.setMargin(new Insets(3, 3, 3, 3));
            this.openButton.setRolloverEnabled(true);
            this.openButton.setBorder(compoundBorder);
            this.openButton.addActionListener(this);
            this.openButton.getAccessibleContext().setAccessibleDescription(OPEN_BUTTON_ACCESS_DESCR);
            this.deleteButton = new JButton(DELETE_BUTTON_NAME);
            UIUtils.fixButtonUI((AbstractButton)this.deleteButton);
            this.deleteButton.setContentAreaFilled(false);
            this.deleteButton.setMargin(new Insets(3, 3, 3, 3));
            this.deleteButton.setRolloverEnabled(true);
            this.deleteButton.setBorder(compoundBorder);
            this.deleteButton.addActionListener(this);
            this.deleteButton.getAccessibleContext().setAccessibleDescription(DELETE_BUTTON_ACCESS_DESCR);
            this.loadButton = new JButton(LOAD_BUTTON_NAME);
            UIUtils.fixButtonUI((AbstractButton)this.loadButton);
            this.loadButton.setContentAreaFilled(false);
            this.loadButton.setMargin(new Insets(3, 3, 3, 3));
            this.loadButton.setRolloverEnabled(true);
            this.loadButton.setBorder(compoundBorder);
            this.loadButton.addActionListener(this);
            this.loadButton.getAccessibleContext().setAccessibleDescription(LOAD_BUTTON_ACCESS_DESCR);
            this.exportButton = new JButton(EXPORT_BUTTON_NAME);
            UIUtils.fixButtonUI((AbstractButton)this.exportButton);
            this.exportButton.setContentAreaFilled(false);
            this.exportButton.setMargin(new Insets(3, 3, 3, 3));
            this.exportButton.setRolloverEnabled(true);
            this.exportButton.setBorder(compoundBorder);
            this.exportButton.addActionListener(this);
            this.exportButton.getAccessibleContext().setAccessibleDescription(EXPORT_BUTTON_ACCESS_DESCR);
            jComponent = new JPanel();
            jComponent.setOpaque(false);
            jComponent.setLayout(new GridBagLayout());
            object = new GridBagConstraints();
            ((GridBagConstraints)object).fill = 2;
            ((GridBagConstraints)object).weightx = 1.0;
            ((GridBagConstraints)object).insets = new Insets(0, 0, 4, 0);
            ((GridBagConstraints)object).gridwidth = 0;
            jComponent.add((Component)this.openButton, object);
            jComponent.add((Component)this.deleteButton, object);
            jComponent.add((Component)this.exportButton, object);
            jComponent.add((Component)this.loadButton, object);
            ((GridBagConstraints)object).weighty = 1.0;
            ((GridBagConstraints)object).fill = 1;
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jComponent.add((Component)jPanel, object);
            this.add((Component)jComponent, "East");
            this.updateButtons();
            this.updateCombo();
            this.setDisplayedProject(ProjectUtilities.getMainProject());
        }

        public void setDisplayedProject(Lookup.Provider provider) {
            this.displayedProject = provider;
            this.list.clearSelection();
            this.refreshList();
            this.internalChange = true;
            if (provider == null) {
                this.combo.setSelectedItem(GLOBAL_COMBO_ITEM_STRING);
            } else {
                this.combo.setSelectedItem(provider);
            }
            this.internalChange = false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.openButton) {
                this.openSelectedSnapshots();
            } else if (actionEvent.getSource() == this.deleteButton) {
                final FileObject[] fileObjectArray = this.getSelectedSnapshotFiles();
                if (ProfilerDialogs.displayConfirmation((String)CONFIRM_DELETE_SNAPSHOT_MSG, (String)CONFIRM_DELETE_SNAPSHOT_CAPTION)) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotsPanel.this.deleteSnapshots(fileObjectArray);
                            SnapshotsPanel.this.refreshList();
                        }
                    });
                }
            } else if (actionEvent.getSource() == this.loadButton) {
                new LoadSnapshotAction().loadSnapshotOrHeapdump();
            } else if (actionEvent.getSource() == this.exportButton) {
                ResultsManager.getDefault().exportSnapshots(this.getSelectedSnapshotFiles());
            } else if (actionEvent.getSource() == this.combo && !this.internalChange) {
                Object object = this.combo.getSelectedItem();
                if (object instanceof Lookup.Provider) {
                    this.setDisplayedProject((Lookup.Provider)object);
                } else {
                    this.setDisplayedProject(null);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.updateCombo();
        }

        public void snapshotLoaded(LoadedSnapshot loadedSnapshot) {
            this.refreshList();
        }

        public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
            SnapshotResultsWindow.closeWindow(loadedSnapshot);
            this.refreshList();
        }

        public void snapshotSaved(LoadedSnapshot loadedSnapshot) {
            int n;
            if (SnapshotResultsWindow.hasSnapshotWindow(loadedSnapshot)) {
                SnapshotResultsWindow.get(loadedSnapshot).updateTitle();
            }
            this.refreshList();
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)loadedSnapshot.getFile()));
            if (fileObject != null && (n = this.listModel.indexOf(fileObject)) != -1) {
                this.list.ensureIndexIsVisible(n);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateButtons();
        }

        private FileObject[] getSelectedSnapshotFiles() {
            Object[] objectArray = this.list.getSelectedValues();
            FileObject[] fileObjectArray = new FileObject[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                fileObjectArray[i] = (FileObject)objectArray[i];
            }
            return fileObjectArray;
        }

        private void deleteSnapshots(FileObject[] fileObjectArray) {
            boolean bl = true;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject = fileObjectArray[i];
                try {
                    DataObject.find((FileObject)fileObject).delete();
                    continue;
                }
                catch (Throwable throwable) {
                    bl = false;
                    throwable.printStackTrace();
                }
            }
            if (!bl) {
                ProfilerDialogs.displayError((String)NbBundle.getMessage(ProfilerControlPanel2.class, (String)"ProfilerControlPanel2_SnapshotsNotDeletedMsg"));
            }
        }

        private LoadedSnapshot[] loadSelectedSnapshots() {
            FileObject[] fileObjectArray = this.getSelectedSnapshotFiles();
            return ResultsManager.getDefault().loadSnapshots(fileObjectArray);
        }

        private void openSelectedSnapshots() {
            FileObject[] fileObjectArray = this.getSelectedSnapshotFiles();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                final FileObject fileObject = fileObjectArray[i];
                String string = fileObject.getExt();
                SnapshotResultsWindow snapshotResultsWindow = null;
                if (string.equalsIgnoreCase("nps")) {
                    LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().loadSnapshot(fileObject);
                    if (loadedSnapshot != null) {
                        snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot);
                        snapshotResultsWindow.open();
                    }
                } else if (string.equalsIgnoreCase("hprof")) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ResultsManager.getDefault().openSnapshot(fileObject);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    });
                }
                if (snapshotResultsWindow == null) continue;
                snapshotResultsWindow.requestActive();
            }
        }

        private void refreshList() {
            final Object[] objectArray = this.list.getSelectedValues();
            SwingWorker swingWorker = new SwingWorker(){
                private final List modelElements = new ArrayList();

                protected void doInBackground() {
                    FileObject[] fileObjectArray = ResultsManager.getDefault().listSavedSnapshots(SnapshotsPanel.this.displayedProject, null);
                    this.modelElements.addAll(Arrays.asList(fileObjectArray));
                    FileObject[] fileObjectArray2 = ResultsManager.getDefault().listSavedHeapdumps(SnapshotsPanel.this.displayedProject, null);
                    this.modelElements.addAll(Arrays.asList(fileObjectArray2));
                }

                protected void done() {
                    DefaultListModel defaultListModel = new DefaultListModel();
                    for (Object e : this.modelElements) {
                        defaultListModel.addElement(e);
                    }
                    SnapshotsPanel.this.list.setModel(defaultListModel);
                    SnapshotsPanel.this.listModel.removeAllElements();
                    SnapshotsPanel.this.listModel = defaultListModel;
                    SnapshotsPanel.this.list.setEnabled(true);
                    for (Object object : objectArray) {
                        int n = SnapshotsPanel.this.listModel.indexOf(object);
                        if (n == -1) continue;
                        SnapshotsPanel.this.list.addSelectionInterval(n, n);
                    }
                }

                protected void nonResponding() {
                    CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SnapshotsPanel.this.list.setEnabled(false);
                            SnapshotsPanel.this.listModel.addElement(NbBundle.getMessage(ProfilerControlPanel2.class, (String)"MSG_Loading_Progress"));
                        }
                    });
                }
            };
            swingWorker.execute();
        }

        private void updateButtons() {
            this.openButton.setEnabled(this.list.getSelectedIndices().length > 0);
            this.deleteButton.setEnabled(this.list.getSelectedIndices().length > 0);
            this.exportButton.setEnabled(this.list.getSelectedIndices().length > 0);
        }

        private void updateCombo() {
            Lookup.Provider[] providerArray = ProjectUtilities.getSortedProjects((Lookup.Provider[])ProjectUtilities.getOpenedProjects());
            ArrayList<Object> arrayList = new ArrayList<Object>(providerArray.length + 1);
            arrayList.addAll(Arrays.asList(providerArray));
            arrayList.add(0, GLOBAL_COMBO_ITEM_STRING);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.combo.getModel();
            defaultComboBoxModel.removeAllElements();
            for (Object e : arrayList) {
                defaultComboBoxModel.addElement(e);
            }
            if (this.displayedProject != null && defaultComboBoxModel.getIndexOf(this.displayedProject) != -1) {
                this.internalChange = true;
                this.combo.setSelectedItem(this.displayedProject);
                this.internalChange = false;
            } else {
                Lookup.Provider provider = ProjectUtilities.getMainProject();
                this.setDisplayedProject(provider);
            }
        }
    }

    private static final class ResultsSnippetPanel
    extends CPPanel
    implements ActionListener {
        private static final int CPU = 1;
        private static final int MEMORY = 2;
        private static final int FRAGMENT = 3;
        private static final Icon TAKE_SNAPSHOT_CPU_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotCpu32");
        private static final Icon TAKE_SNAPSHOT_MEMORY_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotMemory32");
        private static final Icon TAKE_SNAPSHOT_FRAGMENT_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotFragment32");
        private static final Icon LIVE_RESULTS_CPU_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsCpu32");
        private static final Icon LIVE_RESULTS_MEMORY_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsMemory32");
        private static final Icon LIVE_RESULTS_FRAGMENT_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsFragment32");
        private final JButton resetResultsButton;
        private final JButton takeCPUSnapshotButton;
        private final JButton takeFragmentSnapshotButton;
        private final JButton takeMemorySnapshotButton;
        private final JPanel centerPanel;
        private JButton liveResultsButton;
        private LoadedSnapshot lastSnapshot;
        private int displayedIcon = 1;

        ResultsSnippetPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(7, 10, 12, 10));
            CompoundBorder compoundBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            this.takeCPUSnapshotButton = new JButton(TAKE_SNAPSHOT_BUTTON_NAME, TAKE_SNAPSHOT_CPU_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeCPUSnapshotButton);
            this.takeCPUSnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeCPUSnapshotButton.getIcon()).getImage()))));
            this.takeCPUSnapshotButton.addActionListener(this);
            this.takeCPUSnapshotButton.setContentAreaFilled(false);
            this.takeCPUSnapshotButton.setMargin(new Insets(3, 3, 3, 3));
            this.takeCPUSnapshotButton.setVerticalTextPosition(3);
            this.takeCPUSnapshotButton.setHorizontalTextPosition(0);
            this.takeCPUSnapshotButton.setRolloverEnabled(true);
            this.takeCPUSnapshotButton.setBorder(compoundBorder);
            this.takeCPUSnapshotButton.setToolTipText(TAKE_SNAPSHOT_BUTTON_TOOLTIP);
            this.takeMemorySnapshotButton = new PopupButton(new String[]{TAKE_SNAPSHOT_BUTTON_NAME, DUMP_HEAP_BUTTON_NAME}, new ImageIcon[]{(ImageIcon)TAKE_SNAPSHOT_MEMORY_ICON});
            UIUtils.fixButtonUI((AbstractButton)this.takeMemorySnapshotButton);
            this.takeMemorySnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeMemorySnapshotButton.getIcon()).getImage()))));
            this.takeMemorySnapshotButton.addActionListener(this);
            this.takeMemorySnapshotButton.setContentAreaFilled(false);
            this.takeMemorySnapshotButton.setMargin(new Insets(3, 3, 3, 3));
            this.takeMemorySnapshotButton.setVerticalTextPosition(3);
            this.takeMemorySnapshotButton.setHorizontalTextPosition(0);
            this.takeMemorySnapshotButton.setRolloverEnabled(true);
            this.takeMemorySnapshotButton.setBorder(compoundBorder);
            this.takeMemorySnapshotButton.setToolTipText(TAKE_SNAPSHOT_BUTTON_TOOLTIP);
            this.takeFragmentSnapshotButton = new JButton(TAKE_SNAPSHOT_BUTTON_NAME, TAKE_SNAPSHOT_FRAGMENT_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeFragmentSnapshotButton);
            this.takeFragmentSnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeFragmentSnapshotButton.getIcon()).getImage()))));
            this.takeFragmentSnapshotButton.addActionListener(this);
            this.takeFragmentSnapshotButton.setContentAreaFilled(false);
            this.takeFragmentSnapshotButton.setMargin(new Insets(3, 3, 3, 3));
            this.takeFragmentSnapshotButton.setVerticalTextPosition(3);
            this.takeFragmentSnapshotButton.setHorizontalTextPosition(0);
            this.takeFragmentSnapshotButton.setRolloverEnabled(true);
            this.takeFragmentSnapshotButton.setBorder(compoundBorder);
            this.takeFragmentSnapshotButton.setToolTipText(TAKE_SNAPSHOT_BUTTON_TOOLTIP);
            this.liveResultsButton = new JButton(LIVE_RESULTS_BUTTON_NAME, LIVE_RESULTS_CPU_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.liveResultsButton);
            this.liveResultsButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.liveResultsButton.getIcon()).getImage()))));
            this.liveResultsButton.addActionListener(this);
            this.liveResultsButton.setContentAreaFilled(false);
            this.liveResultsButton.setMargin(new Insets(3, 3, 3, 3));
            this.liveResultsButton.setVerticalTextPosition(3);
            this.liveResultsButton.setHorizontalTextPosition(0);
            this.liveResultsButton.setRolloverEnabled(true);
            this.liveResultsButton.setBorder(compoundBorder);
            this.liveResultsButton.setToolTipText(LIVE_RESULTS_BUTTON_TOOLTIP);
            this.displayedIcon = 1;
            this.resetResultsButton = new JButton(ResetResultsAction.getInstance()){

                @Override
                public void setIcon(Icon icon) {
                    super.setIcon(icon);
                    this.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.getIcon()).getImage()))));
                }
            };
            UIUtils.fixButtonUI((AbstractButton)this.resetResultsButton);
            this.resetResultsButton.setText(RESET_RESULTS_BUTTON_NAME);
            this.resetResultsButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.resetResultsButton.getIcon()).getImage()))));
            this.resetResultsButton.setMargin(new Insets(3, 8, 3, 8));
            this.resetResultsButton.setContentAreaFilled(false);
            this.resetResultsButton.setVerticalTextPosition(0);
            this.resetResultsButton.setHorizontalTextPosition(4);
            this.resetResultsButton.setRolloverEnabled(true);
            this.resetResultsButton.setBorder(compoundBorder);
            this.resetResultsButton.setToolTipText(RESET_RESULTS_BUTTON_TOOLTIP);
            JPanel jPanel = new JPanel();
            this.centerPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.resetResultsButton, "West");
            this.centerPanel.setOpaque(false);
            this.centerPanel.setLayout((LayoutManager)new EqualFlowLayout(0));
            this.centerPanel.add(this.takeCPUSnapshotButton);
            this.centerPanel.add(this.liveResultsButton);
            this.add((Component)this.centerPanel, "Center");
            this.add((Component)jPanel, "South");
            this.refreshStatus();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.takeCPUSnapshotButton || actionEvent.getSource() == this.takeFragmentSnapshotButton) {
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ResultsManager.getDefault().takeSnapshot();
                    }
                });
            } else if (actionEvent.getSource() == this.takeMemorySnapshotButton) {
                if (TAKE_SNAPSHOT_BUTTON_NAME.equals(actionEvent.getActionCommand())) {
                    ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ResultsManager.getDefault().takeSnapshot();
                        }
                    });
                } else {
                    ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((HeapDumpAction)SharedClassObject.findObject(HeapDumpAction.class, (boolean)true)).dumpToProject();
                        }
                    });
                }
            } else if (actionEvent.getSource() == this.liveResultsButton) {
                LiveResultsWindow.getDefault().open();
                LiveResultsWindow.getDefault().requestActive();
                LiveResultsWindow.getDefault().refreshLiveResults();
            }
        }

        public void refreshStatus() {
            int n;
            this.updateResultsButtons();
            int n2 = Profiler.getDefault().getProfilingState();
            int n3 = n2 != 1 ? Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
            switch (n3) {
                case 1: {
                    n = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            if (this.displayedIcon != n) {
                this.displayedIcon = n;
                this.centerPanel.remove(this.centerPanel.getComponent(0));
                if (n == 1) {
                    this.centerPanel.add((Component)this.takeCPUSnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_CPU_ICON);
                } else if (n == 2) {
                    this.centerPanel.add((Component)this.takeMemorySnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_MEMORY_ICON);
                } else {
                    this.centerPanel.add((Component)this.takeFragmentSnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_FRAGMENT_ICON);
                }
                this.liveResultsButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.liveResultsButton.getIcon()).getImage()))));
            }
        }

        public void resultsAvailable() {
            this.updateResultsButtons();
        }

        public void resultsReset() {
            this.updateResultsButtons();
        }

        private void updateResultsButtons() {
            int n = Profiler.getDefault().getProfilingState();
            int n2 = n != 1 ? Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
            boolean bl = n == 8 || n == 4;
            bl = bl && n2 != 0;
            this.liveResultsButton.setEnabled(bl);
            boolean bl2 = ResultsManager.getDefault().resultsAvailable();
            this.takeCPUSnapshotButton.setEnabled(bl && bl2);
            this.takeMemorySnapshotButton.setEnabled(bl && bl2);
            this.takeFragmentSnapshotButton.setEnabled(bl && bl2);
        }

        public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
            if (this.lastSnapshot == loadedSnapshot) {
                this.lastSnapshot = null;
            }
        }

        public void snapshotTaken(LoadedSnapshot loadedSnapshot) {
            this.lastSnapshot = loadedSnapshot;
            if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                int n = LiveResultsWindow.hasDefault() ? LiveResultsWindow.getDefault().getSortingColumn() : -1;
                boolean bl = LiveResultsWindow.hasDefault() ? LiveResultsWindow.getDefault().getSortingOrder() : false;
                ResultsManager.getDefault().openSnapshot(loadedSnapshot, n, bl);
            }
            if (ProfilerIDESettings.getInstance().getAutoSaveSnapshot()) {
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot);
            }
        }
    }

    private static final class ProjectNameRenderer
    extends DefaultListCellRenderer {
        private Renderer renderer = new Renderer();
        private boolean firstFontSet = false;

        private ProjectNameRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.renderer.setComponentOrientation(jLabel.getComponentOrientation());
            this.renderer.setFontEx(jLabel.getFont());
            this.renderer.setOpaque(jLabel.isOpaque());
            this.renderer.setForeground(jLabel.getForeground());
            this.renderer.setBackground(jLabel.getBackground());
            this.renderer.setEnabled(jLabel.isEnabled());
            this.renderer.setBorder(jLabel.getBorder());
            if (object != null && object instanceof Lookup.Provider) {
                Lookup.Provider provider = (Lookup.Provider)object;
                this.renderer.setText(ProjectUtilities.getDisplayName((Lookup.Provider)provider));
                this.renderer.setIcon(ProjectUtilities.getIcon((Lookup.Provider)provider));
                if (ProjectUtilities.getMainProject() == object) {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(1));
                } else {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(0));
                }
            } else {
                this.renderer.setText(jLabel.getText());
                this.renderer.setIcon(emptyIcon);
            }
            return this.renderer;
        }

        private static class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    private static final class ControlsPanel
    extends CPPanel {
        ControlsPanel() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            CompoundBorder compoundBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            JButton jButton = new JButton((Action)SystemAction.get(RerunAction.class));
            jButton.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton);
            jButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton.getIcon()).getImage()))));
            jButton.setContentAreaFilled(false);
            jButton.setMargin(new Insets(3, 3, 3, 3));
            jButton.setRolloverEnabled(true);
            jButton.setBorder(compoundBorder);
            this.add(jButton);
            JButton jButton2 = new JButton(StopAction.getInstance()){

                @Override
                public void setText(String string) {
                }

                @Override
                public void setIcon(Icon icon) {
                    super.setIcon(icon);
                    this.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.getIcon()).getImage()))));
                }
            };
            UIUtils.fixButtonUI((AbstractButton)jButton2);
            jButton2.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton2.getIcon()).getImage()))));
            jButton2.setContentAreaFilled(false);
            jButton2.setMargin(new Insets(3, 3, 3, 3));
            jButton2.setRolloverEnabled(true);
            jButton2.setBorder(compoundBorder);
            this.add(jButton2);
            JButton jButton3 = new JButton(ResetResultsAction.getInstance());
            jButton3.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton3);
            jButton3.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton3.getIcon()).getImage()))));
            jButton3.setContentAreaFilled(false);
            jButton3.setMargin(new Insets(3, 3, 3, 3));
            jButton3.setRolloverEnabled(true);
            jButton3.setBorder(compoundBorder);
            this.add(jButton3);
            JButton jButton4 = new JButton((Action)SystemAction.get(RunGCAction.class));
            jButton4.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton4);
            jButton4.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton4.getIcon()).getImage()))));
            jButton4.setContentAreaFilled(false);
            jButton4.setMargin(new Insets(3, 3, 3, 3));
            jButton4.setRolloverEnabled(true);
            jButton4.setBorder(compoundBorder);
            this.add(jButton4);
            JButton jButton5 = new JButton((Action)SystemAction.get(ModifyProfilingAction.class));
            jButton5.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton5);
            jButton5.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton5.getIcon()).getImage()))));
            jButton5.setContentAreaFilled(false);
            jButton5.setMargin(new Insets(3, 3, 3, 3));
            jButton5.setRolloverEnabled(true);
            jButton5.setBorder(compoundBorder);
            this.add(jButton5);
            JButton jButton6 = new JButton(TelemetryOverviewAction.getInstance());
            jButton6.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton6);
            jButton6.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton6.getIcon()).getImage()))));
            jButton6.setContentAreaFilled(false);
            jButton6.setMargin(new Insets(3, 3, 3, 3));
            jButton6.setRolloverEnabled(true);
            jButton6.setBorder(compoundBorder);
            this.add(jButton6);
        }
    }

    private static class CPPanel
    extends JPanel {
        CPPanel() {
            this.setOpaque(true);
            this.setBackground(CP_BACKGROUND_COLOR);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
    }

    private static final class BasicTelemetryPanel
    extends CPPanel {
        private final JLabel instrFilterValueLabel;
        private final JLabel instrValueLabel;
        private final JLabel relTimeValueLabel;
        private final JLabel threadsValueLabel;
        private final JLabel totalMemValueLabel;
        private final JLabel typeValueLabel;
        private final JLabel usedMemValueLabel;
        private final NumberFormat intFormat;
        private final NumberFormat percentFormat = NumberFormat.getPercentInstance();
        private String savedInstrFilterText = "";
        private String savedInstrText = "";
        private boolean inactive = true;

        BasicTelemetryPanel() {
            this.percentFormat.setMinimumFractionDigits(1);
            this.percentFormat.setMaximumIntegerDigits(2);
            this.intFormat = NumberFormat.getIntegerInstance();
            this.intFormat.setGroupingUsed(true);
            this.setBorder(BorderFactory.createEmptyBorder(8, 3, 9, 3));
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(INSTRUMENTED_LABEL_STRING);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            JLabel jLabel2 = new JLabel(FILTER_LABEL_STRING);
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            JLabel jLabel3 = new JLabel(THREADS_LABEL_STRING);
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            JLabel jLabel4 = new JLabel(TYPE_LABEL_STRING);
            jLabel4.setFont(jLabel4.getFont().deriveFont(1));
            JLabel jLabel5 = new JLabel(TOTAL_MEMORY_LABEL_STRING);
            jLabel5.setFont(jLabel5.getFont().deriveFont(1));
            JLabel jLabel6 = new JLabel(USED_MEMORY_LABEL_STRING);
            jLabel6.setFont(jLabel6.getFont().deriveFont(1));
            JLabel jLabel7 = new JLabel(GC_TIME_LABEL_STRING);
            jLabel7.setFont(jLabel7.getFont().deriveFont(1));
            this.instrValueLabel = new JLabel(this.savedInstrText);
            this.instrFilterValueLabel = new JLabel("");
            this.threadsValueLabel = new JLabel("");
            this.typeValueLabel = new JLabel("");
            this.totalMemValueLabel = new JLabel("");
            this.usedMemValueLabel = new JLabel("");
            this.relTimeValueLabel = new JLabel("");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)jLabel, gridBagConstraints);
            this.add((Component)this.instrValueLabel, gridBagConstraints2);
            this.add((Component)jLabel2, gridBagConstraints);
            this.add((Component)this.instrFilterValueLabel, gridBagConstraints2);
            this.add((Component)jLabel3, gridBagConstraints);
            this.add((Component)this.threadsValueLabel, gridBagConstraints2);
            this.add((Component)jLabel5, gridBagConstraints);
            this.add((Component)this.totalMemValueLabel, gridBagConstraints2);
            this.add((Component)jLabel6, gridBagConstraints);
            this.add((Component)this.usedMemValueLabel, gridBagConstraints2);
            this.add((Component)jLabel7, gridBagConstraints);
            this.add((Component)this.relTimeValueLabel, gridBagConstraints2);
        }

        void refreshStatus() {
            int n = Profiler.getDefault().getProfilingState();
            TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
            String string = "";
            if (n != 1) {
                int n2 = targetAppRunner.getProfilingSessionStatus().currentInstrType;
                switch (n2) {
                    case 1: {
                        string = MessageFormat.format(NO_LINES_CODE_REGION_MSG, targetAppRunner.getProfilingSessionStatus().instrEndLine - targetAppRunner.getProfilingSessionStatus().instrStartLine);
                        break;
                    }
                    case 3: 
                    case 4: {
                        int n3 = targetAppRunner.getProfilingSessionStatus().getNInstrMethods();
                        if (n3 > 0) {
                            --n3;
                        }
                        string = MessageFormat.format(NO_METHODS_MSG, n3);
                        break;
                    }
                    case 5: 
                    case 6: {
                        int n4 = targetAppRunner.getProfilingSessionStatus().getNInstrClasses();
                        string = MessageFormat.format(NO_CLASSES_MSG, n4);
                        break;
                    }
                    case 0: 
                    case 2: {
                        string = NOTHING_INSTRUMENTED_MSG;
                    }
                }
            }
            if (this.savedInstrText == null || !this.savedInstrText.equals(string)) {
                this.savedInstrText = string;
                this.instrValueLabel.setText(this.savedInstrText);
            }
            String string2 = "";
            switch (n) {
                case 1: {
                    if (this.inactive) {
                        return;
                    }
                    this.inactive = true;
                    this.threadsValueLabel.setText("");
                    this.totalMemValueLabel.setText("");
                    this.usedMemValueLabel.setText("");
                    this.relTimeValueLabel.setText("");
                    this.typeValueLabel.setText("");
                    break;
                }
                default: {
                    this.inactive = false;
                    MonitoredData monitoredData = Profiler.getDefault().getVMTelemetryManager().getLastData();
                    if (monitoredData != null) {
                        this.threadsValueLabel.setText("" + this.intFormat.format(monitoredData.getNUserThreads() + monitoredData.getNSystemThreads()));
                        this.totalMemValueLabel.setText("" + this.intFormat.format(monitoredData.getTotalMemory()) + " B");
                        this.usedMemValueLabel.setText("" + this.intFormat.format(monitoredData.getTotalMemory() - monitoredData.getFreeMemory()) + " B");
                        this.relTimeValueLabel.setText("" + this.percentFormat.format((float)monitoredData.getRelativeGCTimeInPerMil() / 1000.0f));
                        this.typeValueLabel.setText("");
                        string2 = Profiler.getDefault().getLastProfilingSettings().getSelectedInstrumentationFilter().toString();
                        break;
                    }
                    this.threadsValueLabel.setText("");
                    this.totalMemValueLabel.setText("");
                    this.usedMemValueLabel.setText("");
                    this.relTimeValueLabel.setText("");
                    this.typeValueLabel.setText("");
                }
            }
            if (this.savedInstrFilterText == null || !this.savedInstrFilterText.equals(string2)) {
                this.savedInstrFilterText = string2;
                this.instrFilterValueLabel.setText(this.savedInstrFilterText);
            }
        }
    }

    public static final class WhiteFilter
    extends RGBImageFilter {
        private final float[] hsv = new float[3];

        public WhiteFilter() {
            this.canFilterIndexColorModel = true;
        }

        public static Image createDisabledImage(Image image) {
            WhiteFilter whiteFilter = new WhiteFilter();
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), whiteFilter);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 24 & 0xFF;
            if (n4 <= 1) {
                return n3;
            }
            Color.RGBtoHSB(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 >> 0 & 0xFF, this.hsv);
            this.hsv[1] = 0.0f;
            return Color.HSBtoRGB(this.hsv[0], this.hsv[1], this.hsv[2]) + ((n4 /= 2) << 24);
        }
    }

    public static final class VerticalLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = container.getWidth() - insets.left - insets.right;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!component.isVisible()) continue;
                int n4 = component.getPreferredSize().height;
                if (i == componentArray.length - 1 && n2 + n4 < container.getHeight() - insets.bottom) {
                    n4 = container.getHeight() - insets.bottom - n2;
                }
                component.setBounds(n, n2, n3, n4);
                n2 += n4;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension(container.getInsets().left + container.getInsets().right, container.getInsets().top + container.getInsets().bottom);
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getMinimumSize();
                n = Math.max(n, dimension2.width);
                n2 += dimension2.height;
            }
            dimension.width += n;
            dimension.height += n2;
            return dimension;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(container.getInsets().left + container.getInsets().right, container.getInsets().top + container.getInsets().bottom);
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                n = Math.max(n, dimension2.width);
                n2 += dimension2.height;
            }
            dimension.width += n;
            dimension.height += n2;
            return dimension;
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    public static final class Listener
    extends Delegate<ProfilerControlPanel2>
    implements SnapshotsListener,
    ResultsListener {
        @Override
        public void resultsAvailable() {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.resultsAvailable();
            }
        }

        @Override
        public void resultsReset() {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.resultsReset();
            }
        }

        @Override
        public void snapshotLoaded(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotLoaded(loadedSnapshot);
            }
        }

        @Override
        public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.snapshotRemoved(loadedSnapshot);
            }
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotRemoved(loadedSnapshot);
            }
        }

        @Override
        public void snapshotSaved(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotSaved(loadedSnapshot);
            }
        }

        @Override
        public void snapshotTaken(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.snapshotTaken(loadedSnapshot);
            }
        }
    }
}

