/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

public class DirectedGraph<N, E> {
    private Collection<N> nodes;
    private Collection<Vertex> rootVertices;
    private Collection<Vertex> vertices;
    private Collection<E> edges;
    private Map<N, Vertex> vertexMap;
    private Map<E, Edge> edgeMap;
    private GraphScene scene;
    private UniversalGraph<N, E> uGraph;

    protected DirectedGraph(UniversalGraph<N, E> universalGraph, GraphScene graphScene) {
        this.uGraph = universalGraph;
        this.scene = graphScene;
        this.nodes = universalGraph.getNodes();
        this.edges = universalGraph.getEdges();
        this.vertexMap = new HashMap<N, Vertex>();
        this.edgeMap = new LinkedHashMap<E, Edge>();
        this.rootVertices = new ArrayList<Vertex>();
        this.vertices = new ArrayList<Vertex>();
    }

    public static <N, E> DirectedGraph createGraph(UniversalGraph<N, E> universalGraph, GraphScene graphScene) {
        DirectedGraph<N, E> directedGraph = new DirectedGraph<N, E>(universalGraph, graphScene);
        directedGraph.createGraph();
        return directedGraph;
    }

    protected void createGraph() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        for (Object object5 : this.edges) {
            object4 = this.uGraph.getEdgeSource(object5);
            object3 = this.uGraph.getEdgeTarget(object5);
            object2 = this.getVertex(object4);
            object = this.getVertex(object3);
            Edge edge = this.createEdge((Vertex)object2, (Vertex)object, object5);
            ((Vertex)object2).addOutgoingEdge(edge);
            ((Vertex)object).addIncomingEdge(edge);
            ((Vertex)object2).addUpperNeighbor((Vertex)object);
            ((Vertex)object).addLowerNeighbor((Vertex)object2);
        }
        for (Object object5 : this.nodes) {
            object4 = this.getVertex(object5);
            object3 = this.scene.findWidget(object5);
            if (object3 == null) continue;
            object2 = ((Widget)object3).getBounds();
            object = new Dimension(((Rectangle)object2).width, ((Rectangle)object2).height);
            ((Vertex)object4).setSize((Dimension)object);
        }
        this.findRootVertices();
    }

    private Vertex getVertex(N n) {
        Vertex vertex = this.vertexMap.get(n);
        if (vertex == null) {
            vertex = this.createVertex(n);
            this.vertexMap.put(n, vertex);
        }
        return vertex;
    }

    protected Vertex createVertex(N n) {
        return new Vertex<N>(n);
    }

    protected Edge createEdge(Vertex vertex, Vertex vertex2, E e) {
        return new Edge<E>(vertex, vertex2, e);
    }

    private Edge getEdge(Vertex vertex, Vertex vertex2, E e) {
        Edge edge = this.edgeMap.get(e);
        if (edge == null) {
            edge = this.createEdge(vertex, vertex2, e);
            this.edgeMap.put(e, edge);
        }
        return edge;
    }

    public Collection<Vertex> getVertices() {
        return this.vertexMap.values();
    }

    public Collection<Vertex> getRootVertices() {
        return this.rootVertices;
    }

    private void findRootVertices() {
        for (Vertex vertex : this.vertexMap.values()) {
            Collection<Vertex> collection = vertex.getUpperNeighbors();
            if (collection.size() != 0) continue;
            this.rootVertices.add(vertex);
        }
    }

    public DummyVertex insertDummyVertex(Edge edge, DummyVertex.Type type) {
        Edge edge2 = edge;
        if (edge instanceof DummyEdge) {
            edge2 = ((DummyEdge)edge).getOriginalEdge();
        }
        DummyVertex dummyVertex = this.createDummyVertex(edge2, type);
        this.vertices.add(dummyVertex);
        Vertex vertex = edge.getSource();
        Vertex vertex2 = edge.getTarget();
        vertex.removeOutgoingEdge(edge);
        vertex.removeLowerNeighbor(vertex2);
        vertex.addLowerNeighbor(dummyVertex);
        dummyVertex.addUpperNeighbor(vertex2);
        DummyEdge dummyEdge = this.createDummyEdge(vertex, dummyVertex, edge2);
        vertex.addOutgoingEdge(dummyEdge);
        dummyVertex.addIncomingEdge(dummyEdge);
        vertex2.removeIncomingEdge(edge);
        vertex2.removeUpperNeighbor(vertex);
        vertex2.addUpperNeighbor(dummyVertex);
        dummyVertex.addLowerNeighbor(vertex2);
        dummyEdge = this.createDummyEdge(dummyVertex, vertex2, edge2);
        vertex2.addIncomingEdge(dummyEdge);
        dummyVertex.addOutgoingEdge(dummyEdge);
        return dummyVertex;
    }

    protected DummyVertex createDummyVertex(Edge edge, DummyVertex.Type type) {
        return new DummyVertex(edge, type);
    }

    public DummyEdge addDummyEdge(Vertex vertex, Vertex vertex2) {
        DummyEdge dummyEdge = this.createDummyEdge(vertex, vertex2, null);
        vertex.addOutgoingEdge(dummyEdge);
        vertex2.addIncomingEdge(dummyEdge);
        vertex.addLowerNeighbor(vertex2);
        vertex2.addUpperNeighbor(vertex);
        return dummyEdge;
    }

    protected DummyEdge createDummyEdge(Vertex vertex, Vertex vertex2, Edge edge) {
        return new DummyEdge(vertex, vertex2, edge);
    }

    private void printGraph() {
        for (Vertex vertex : this.getRootVertices()) {
            System.out.println("root vertex = " + vertex);
        }
        for (Vertex vertex : this.getVertices()) {
            System.out.println("vertex = " + vertex);
            Collection<Vertex> collection = vertex.getUpperNeighbors();
            for (Vertex vertex2 : collection) {
                System.out.println("\tupper neighbor = " + vertex2);
            }
            collection = vertex.getLowerNeighbors();
            for (Vertex vertex2 : collection) {
                System.out.println("\tlower neighbor = " + vertex2);
            }
        }
    }

    public static class DummyEdge
    extends Edge {
        private Edge originalEdge;

        public DummyEdge(Vertex vertex, Vertex vertex2, Edge edge) {
            super(vertex, vertex2, null);
            this.originalEdge = edge;
        }

        public DummyEdge(Vertex vertex, Vertex vertex2) {
            this(vertex, vertex2, null);
        }

        public void setOriginalEdge(Edge edge) {
            this.originalEdge = edge;
        }

        public Edge getOriginalEdge() {
            return this.originalEdge;
        }

        public String toString() {
            return "dummy " + super.toString();
        }
    }

    public static class DummyVertex
    extends Vertex {
        private static int counter = 0;
        private Edge originalEdge;
        private Type type;
        private int index;

        public DummyVertex(Edge edge, Type type) {
            super(null);
            this.originalEdge = edge;
            this.type = type;
            this.index = --counter;
        }

        public DummyVertex(Type type) {
            this(null, type);
        }

        public void setOriginalEdge(Edge edge) {
            this.originalEdge = edge;
        }

        public Edge getOriginalEdge() {
            return this.originalEdge;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return "dummy vertex " + this.index;
        }

        public static enum Type {
            CROSSING,
            HYPEREDGE,
            BEND,
            TEMPORARY;

        }
    }

    public static class Edge<E> {
        private Vertex source;
        private Vertex target;
        private E edgeDE;

        public Edge(Vertex vertex, Vertex vertex2, E e) {
            this.source = vertex;
            this.target = vertex2;
            this.edgeDE = e;
        }

        public Vertex getSource() {
            return this.source;
        }

        public Vertex getTarget() {
            return this.target;
        }

        public E getEdgeDesignElement() {
            return this.edgeDE;
        }
    }

    public static class Vertex<N> {
        private N nodeDE;
        private ArrayList<Vertex> upperNeighbors;
        private ArrayList<Vertex> lowerNeighbors;
        private Collection<Edge> incomingEdges;
        private Collection<Edge> outgoingEdges;
        private int number = -1;
        private int x;
        private int y;
        private Object vertexData;
        private Dimension size = new Dimension(0, 0);

        public Vertex(N n) {
            this.nodeDE = n;
            this.upperNeighbors = new ArrayList();
            this.lowerNeighbors = new ArrayList();
            this.incomingEdges = new ArrayList<Edge>();
            this.outgoingEdges = new ArrayList<Edge>();
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension dimension) {
            this.size = dimension;
        }

        public N getNodeDesignElement() {
            return this.nodeDE;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int n) {
            this.number = n;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }

        public void addLowerNeighbor(Vertex vertex) {
            if (!this.lowerNeighbors.contains(vertex)) {
                this.lowerNeighbors.add(vertex);
            }
        }

        public void removeLowerNeighbor(Vertex vertex) {
            this.lowerNeighbors.remove(vertex);
        }

        public void replaceLowerNeighbor(Vertex vertex, Vertex vertex2) {
            this.lowerNeighbors.set(this.lowerNeighbors.indexOf(vertex), vertex2);
        }

        public Collection<Vertex> getLowerNeighbors() {
            return Collections.unmodifiableCollection(this.lowerNeighbors);
        }

        public void addUpperNeighbor(Vertex vertex) {
            if (!this.upperNeighbors.contains(vertex)) {
                this.upperNeighbors.add(vertex);
            }
        }

        public void removeUpperNeighbor(Vertex vertex) {
            this.upperNeighbors.remove(vertex);
        }

        public void replaceUpperNeighbor(Vertex vertex, Vertex vertex2) {
            this.upperNeighbors.set(this.upperNeighbors.indexOf(vertex), vertex2);
        }

        public Collection<Vertex> getUpperNeighbors() {
            return Collections.unmodifiableCollection(this.upperNeighbors);
        }

        public Collection<Edge> getOutgoingEdges() {
            return this.outgoingEdges;
        }

        public void addOutgoingEdge(Edge edge) {
            if (!this.outgoingEdges.contains(edge)) {
                this.outgoingEdges.add(edge);
            }
        }

        public Collection<Edge> getIncomingEdges() {
            return this.incomingEdges;
        }

        public void removeOutgoingEdge(Edge edge) {
            this.outgoingEdges.remove(edge);
        }

        public void addIncomingEdge(Edge edge) {
            if (!this.incomingEdges.contains(edge)) {
                this.incomingEdges.add(edge);
            }
        }

        public void removeIncomingEdge(Edge edge) {
            this.incomingEdges.remove(edge);
        }

        public Edge getEdgeToLowerNeighbor(Vertex vertex) {
            Collection<Edge> collection = vertex.getOutgoingEdges();
            for (Edge edge : collection) {
                if (edge.getTarget() != vertex) continue;
                return edge;
            }
            return this.getEdgeToUpperNeighbor(vertex);
        }

        public Edge getEdgeToUpperNeighbor(Vertex vertex) {
            Collection<Edge> collection = vertex.getIncomingEdges();
            for (Edge edge : collection) {
                if (edge.getSource() != vertex) continue;
                return edge;
            }
            return this.getEdgeToLowerNeighbor(vertex);
        }

        public void setVertexData(Object object) {
            this.vertexData = object;
        }

        public Object getVertexData() {
            return this.vertexData;
        }

        public String toString() {
            return super.toString() + " : " + this.nodeDE;
        }
    }
}

