/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public final class SessionManager {
    public static final String PROP_OPEN = "session_open";
    public static final String PROP_CLOSE = "session_close";
    public static final String LAYER_SESSION = "session";
    public static final String LAYER_INSTALL = "install";
    private static SessionManager sm = null;
    private SystemFileSystem systemFS;
    private HashMap<String, FileSystem> layers = new HashMap();
    private transient ArrayList<PropertyChangeListener> propertyChangeListeners;

    private SessionManager() {
    }

    public static SessionManager getDefault() {
        if (sm == null) {
            sm = new SessionManager();
        }
        return sm;
    }

    public FileSystem create(File file, File file2, File[] fileArray) throws PropertyVetoException, IOException {
        this.systemFS = SystemFileSystem.create(file, file2, fileArray);
        this.layers.put(LAYER_INSTALL, (FileSystem)this.systemFS.getInstallationLayer());
        this.layers.put(LAYER_SESSION, (FileSystem)this.systemFS.getUserLayer());
        return this.systemFS;
    }

    public void close() {
        this.firePropertyChange(PROP_CLOSE);
        this.waitForLocks();
    }

    public FileSystem getLayer(String string) {
        return this.layers.get(string);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ArrayList();
        }
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners != null) {
            this.propertyChangeListeners.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String string) {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            if (this.propertyChangeListeners == null || this.propertyChangeListeners.size() == 0) {
                return;
            }
            arrayList = (ArrayList)this.propertyChangeListeners.clone();
        }
        object = new PropertyChangeEvent(this, string, null, null);
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                ((PropertyChangeListener)arrayList.get(i)).propertyChange((PropertyChangeEvent)object);
                continue;
            }
            catch (RuntimeException runtimeException) {
                Exceptions.printStackTrace((Throwable)runtimeException);
            }
        }
    }

    private void waitForLocks() {
        int n;
        try {
            for (n = 50; LocalFileSystemEx.hasLocks() && 0 < n; --n) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (LocalFileSystemEx.hasLocks()) {
            String[] stringArray = LocalFileSystemEx.getLocks();
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("Settings saving ");
            stringBuilder.append(n == 0 ? "timeout!" : "interrupted!");
            stringBuilder.append("\nList of pending locks:\n");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append("\n");
            }
            System.err.println(stringBuilder.toString());
        }
    }
}

