/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.util;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisibleMemberMap {
    private boolean noVisibleMembers = true;
    public static final int INNERCLASSES = 0;
    public static final int ENUM_CONSTANTS = 1;
    public static final int FIELDS = 2;
    public static final int CONSTRUCTORS = 3;
    public static final int METHODS = 4;
    public static final int ANNOTATION_TYPE_MEMBER_OPTIONAL = 5;
    public static final int ANNOTATION_TYPE_MEMBER_REQUIRED = 6;
    public static final int PROPERTIES = 7;
    public static final int NUM_MEMBER_TYPES = 8;
    public static final String STARTLEVEL = "start";
    private final List<ClassDoc> visibleClasses = new ArrayList<ClassDoc>();
    private final Map<Object, Map<ProgramElementDoc, String>> memberNameMap = new HashMap<Object, Map<ProgramElementDoc, String>>();
    private final Map<ClassDoc, ClassMembers> classMap = new HashMap<ClassDoc, ClassMembers>();
    private final ClassDoc classdoc;
    private final int kind;
    private final boolean nodepr;
    private static final Map<ClassDoc, ProgramElementDoc[]> propertiesCache = new HashMap<ClassDoc, ProgramElementDoc[]>();
    private static final Set<String> doneMethods = new HashSet<String>();
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.javafx.tools.doclets.internal.toolkit.resources.doclets");

    public VisibleMemberMap(ClassDoc classdoc, int kind, boolean nodepr) {
        this.classdoc = classdoc;
        this.nodepr = nodepr;
        this.kind = kind;
        new ClassMembers(classdoc, STARTLEVEL).build();
    }

    public List<ClassDoc> getVisibleClassesList() {
        this.sort(this.visibleClasses);
        return this.visibleClasses;
    }

    private List<ProgramElementDoc> getInheritedPackagePrivateMethods(Configuration configuration) {
        ArrayList<ProgramElementDoc> results = new ArrayList<ProgramElementDoc>();
        for (ClassDoc currentClass : this.visibleClasses) {
            if (currentClass == this.classdoc || !currentClass.isPackagePrivate() || Util.isLinkable(currentClass, configuration)) continue;
            results.addAll(this.getMembersFor(currentClass));
        }
        return results;
    }

    public List<ProgramElementDoc> getLeafClassMembers(Configuration configuration) {
        List<ProgramElementDoc> result = this.getMembersFor(this.classdoc);
        result.addAll(this.getInheritedPackagePrivateMethods(configuration));
        return result;
    }

    public List<ProgramElementDoc> getMembersFor(ClassDoc cd) {
        ClassMembers clmembers = this.classMap.get(cd);
        if (clmembers == null) {
            return new ArrayList<ProgramElementDoc>();
        }
        return clmembers.getMembers();
    }

    private void sort(List<ClassDoc> list) {
        ArrayList<ClassDoc> classes = new ArrayList<ClassDoc>();
        ArrayList<ClassDoc> interfaces = new ArrayList<ClassDoc>();
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc cd = list.get(i);
            if (cd.isClass()) {
                classes.add(cd);
                continue;
            }
            interfaces.add(cd);
        }
        list.clear();
        list.addAll(classes);
        list.addAll(interfaces);
    }

    private void fillMemberLevelMap(List<ProgramElementDoc> list, String level) {
        for (int i = 0; i < list.size(); ++i) {
            Object key = this.getMemberKey(list.get(i));
            Map<ProgramElementDoc, String> memberLevelMap = this.memberNameMap.get(key);
            if (memberLevelMap == null) {
                memberLevelMap = new HashMap<ProgramElementDoc, String>();
                this.memberNameMap.put(key, memberLevelMap);
            }
            memberLevelMap.put(list.get(i), level);
        }
    }

    private void purgeMemberLevelMap(List<ProgramElementDoc> list, String level) {
        for (int i = 0; i < list.size(); ++i) {
            Object key = this.getMemberKey(list.get(i));
            Map<ProgramElementDoc, String> memberLevelMap = this.memberNameMap.get(key);
            if (!level.equals(memberLevelMap.get(list.get(i)))) continue;
            memberLevelMap.remove(list.get(i));
        }
    }

    public boolean noVisibleMembers() {
        if (Configuration.javafxJavadoc) {
            return false;
        }
        return this.noVisibleMembers;
    }

    private ClassMember getClassMember(MethodDoc member) {
        for (Object key : this.memberNameMap.keySet()) {
            if (key instanceof String || !((ClassMember)key).isEqual(member)) continue;
            return (ClassMember)key;
        }
        return new ClassMember((ProgramElementDoc)member);
    }

    private Object getMemberKey(ProgramElementDoc doc) {
        if (doc.isConstructor()) {
            return doc.name() + ((ExecutableMemberDoc)doc).signature();
        }
        if (doc.isMethod()) {
            return this.getClassMember((MethodDoc)doc);
        }
        if (doc.isField() || doc.isEnumConstant() || doc.isAnnotationTypeElement()) {
            return doc.name();
        }
        String classOrIntName = doc.name();
        classOrIntName = classOrIntName.indexOf(46) != 0 ? classOrIntName.substring(classOrIntName.lastIndexOf(46), classOrIntName.length()) : classOrIntName;
        return "clint" + classOrIntName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassMembers {
        private ClassDoc mappingClass;
        private List<ProgramElementDoc> members = new ArrayList<ProgramElementDoc>();
        private String level;
        private final Pattern pattern = Pattern.compile("[sg]et\\p{Upper}.*");

        public List<ProgramElementDoc> getMembers() {
            return this.members;
        }

        private ClassMembers(ClassDoc mappingClass, String level) {
            this.mappingClass = mappingClass;
            this.level = level;
            if (VisibleMemberMap.this.classMap.containsKey(mappingClass) && level.startsWith(((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)mappingClass)).level)) {
                VisibleMemberMap.this.purgeMemberLevelMap(this.getClassMembers(mappingClass, false), ((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)mappingClass)).level);
                VisibleMemberMap.this.classMap.remove(mappingClass);
                VisibleMemberMap.this.visibleClasses.remove(mappingClass);
            }
            if (!VisibleMemberMap.this.classMap.containsKey(mappingClass)) {
                VisibleMemberMap.this.classMap.put(mappingClass, this);
                VisibleMemberMap.this.visibleClasses.add(mappingClass);
            }
        }

        private void build() {
            if (VisibleMemberMap.this.kind == 3) {
                this.addMembers(this.mappingClass);
            } else {
                this.mapClass();
            }
        }

        private void mapClass() {
            ClassDoc superclass;
            this.addMembers(this.mappingClass);
            ClassDoc[] interfaces = this.mappingClass.interfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String locallevel = this.level + 1;
                ClassMembers cm = new ClassMembers(interfaces[i], locallevel);
                cm.mapClass();
            }
            if (this.mappingClass.isClass() && (superclass = this.mappingClass.superclass()) != null && !this.mappingClass.equals(superclass)) {
                ClassMembers cm = new ClassMembers(superclass, this.level + "c");
                cm.mapClass();
            }
        }

        private void addMembers(ClassDoc fromClass) {
            List<ProgramElementDoc> cdmembers = this.getClassMembers(fromClass, true);
            ArrayList<ProgramElementDoc> incllist = new ArrayList<ProgramElementDoc>();
            for (int i = 0; i < cdmembers.size(); ++i) {
                ProgramElementDoc pgmelem = cdmembers.get(i);
                if (this.found(this.members, pgmelem) || !this.memberIsVisible(pgmelem) || this.isOverridden(pgmelem, this.level) || this.isTreatedAsPrivate(pgmelem)) continue;
                incllist.add(pgmelem);
            }
            if (incllist.size() > 0) {
                VisibleMemberMap.this.noVisibleMembers = false;
            }
            this.members.addAll(incllist);
            VisibleMemberMap.this.fillMemberLevelMap(this.getClassMembers(fromClass, false), this.level);
        }

        private boolean isTreatedAsPrivate(ProgramElementDoc pgmelem) {
            if (!Configuration.javafxJavadoc) {
                return false;
            }
            if (pgmelem.isPrivate() || pgmelem.isPackagePrivate()) {
                return true;
            }
            Tag[] aspTags = pgmelem.tags("@treatAsPrivate");
            boolean result = aspTags != null && aspTags.length > 0;
            return result;
        }

        private boolean memberIsVisible(ProgramElementDoc pgmdoc) {
            if (pgmdoc.containingClass().equals(VisibleMemberMap.this.classdoc)) {
                return true;
            }
            if (pgmdoc.isPrivate()) {
                return false;
            }
            if (pgmdoc.isPackagePrivate()) {
                return pgmdoc.containingClass().containingPackage().equals(VisibleMemberMap.this.classdoc.containingPackage());
            }
            return true;
        }

        private List<ProgramElementDoc> getClassMembers(ClassDoc cd, boolean filter) {
            if (cd.isEnum() && VisibleMemberMap.this.kind == 3) {
                return Arrays.asList(new ProgramElementDoc[0]);
            }
            FieldDoc[] members = null;
            switch (VisibleMemberMap.this.kind) {
                case 5: {
                    members = cd.isAnnotationType() ? this.filter((AnnotationTypeDoc)cd, false) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 6: {
                    members = cd.isAnnotationType() ? this.filter((AnnotationTypeDoc)cd, true) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 0: {
                    members = cd.innerClasses(filter);
                    break;
                }
                case 1: {
                    members = cd.enumConstants();
                    break;
                }
                case 2: {
                    members = cd.fields(filter);
                    break;
                }
                case 3: {
                    members = cd.constructors();
                    break;
                }
                case 4: {
                    members = cd.methods(filter);
                    this.checkOnPropertiesTags((MethodDoc[])members);
                    break;
                }
                case 7: {
                    members = this.properties(cd, filter);
                    break;
                }
                default: {
                    members = new ProgramElementDoc[]{};
                }
            }
            if (VisibleMemberMap.this.nodepr) {
                return Util.excludeDeprecatedMembersAsList((ProgramElementDoc[])members);
            }
            return Arrays.asList(members);
        }

        private AnnotationTypeElementDoc[] filter(AnnotationTypeDoc doc, boolean required) {
            AnnotationTypeElementDoc[] members = doc.elements();
            ArrayList<AnnotationTypeElementDoc> targetMembers = new ArrayList<AnnotationTypeElementDoc>();
            for (int i = 0; i < members.length; ++i) {
                if ((!required || members[i].defaultValue() != null) && (required || members[i].defaultValue() == null)) continue;
                targetMembers.add(members[i]);
            }
            return targetMembers.toArray(new AnnotationTypeElementDoc[0]);
        }

        private boolean found(List<ProgramElementDoc> list, ProgramElementDoc elem) {
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc pgmelem = list.get(i);
                if (!Util.matches(pgmelem, elem)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridden(ProgramElementDoc pgmdoc, String level) {
            Map memberLevelMap = (Map)VisibleMemberMap.this.memberNameMap.get(VisibleMemberMap.this.getMemberKey(pgmdoc));
            if (memberLevelMap == null) {
                return false;
            }
            String mappedlevel2 = null;
            for (String mappedlevel2 : memberLevelMap.values()) {
                if (!mappedlevel2.equals(VisibleMemberMap.STARTLEVEL) && (!level.startsWith(mappedlevel2) || level.equals(mappedlevel2))) continue;
                return true;
            }
            return false;
        }

        private ProgramElementDoc[] properties(ClassDoc cd, boolean filter) {
            MethodDoc[] allMethods = cd.methods(filter);
            FieldDoc[] allFields = cd.fields();
            if (propertiesCache.containsKey(cd)) {
                return (ProgramElementDoc[])propertiesCache.get(cd);
            }
            ArrayList<MethodDoc> result = new ArrayList<MethodDoc>();
            for (MethodDoc propertyMethod : allMethods) {
                if (!this.isPropertyMethod(propertyMethod)) continue;
                MethodDoc getter = this.getterForField(allMethods, propertyMethod);
                MethodDoc setter = this.setterForField(allMethods, propertyMethod);
                FieldDoc field = this.fieldForProperty(allFields, propertyMethod);
                this.updateCommentIfNotSet((MemberDoc)field, propertyMethod, false);
                this.updateCommentIfNotSet((MemberDoc)propertyMethod, getter, true);
                this.updateCommentIfNotSet((MemberDoc)propertyMethod, setter, true);
                if (!doneMethods.contains(propertyMethod.toString())) {
                    doneMethods.add(propertyMethod.toString());
                    String rawCommentText = propertyMethod.getRawCommentText();
                    StringBuilder sb = new StringBuilder(rawCommentText);
                    if (!(null == getter || rawCommentText != null && rawCommentText.contains("@see #" + getter.name()))) {
                        sb.append("\n @see #").append(getter.name()).append("() ");
                    }
                    if (!(null == setter || rawCommentText != null && rawCommentText.contains("@see #" + setter.name()))) {
                        String typeName = setter.parameters()[0].typeName();
                        if ((typeName = typeName.split("<")[0]).contains(".")) {
                            typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
                        }
                        sb.append("\n @see #").append(setter.name());
                        if (setter.parameters()[0].type().asTypeVariable() == null) {
                            sb.append("(").append(typeName).append(")");
                        }
                        sb.append(" \n");
                    }
                    propertyMethod.setRawCommentText(sb.toString());
                }
                result.add(propertyMethod);
            }
            ProgramElementDoc[] resultAray = result.toArray(new ProgramElementDoc[result.size()]);
            propertiesCache.put(cd, resultAray);
            return resultAray;
        }

        private void updateCommentIfNotSet(MemberDoc source, MethodDoc target, boolean getterOrSetter) {
            if (null == target || null == source) {
                return;
            }
            String actualTargetRawCommentText = target.getRawCommentText();
            if (null == actualTargetRawCommentText || 0 == actualTargetRawCommentText.length()) {
                String commentText = "";
                if (getterOrSetter) {
                    String targetName = target.name();
                    if (targetName.startsWith("set")) {
                        commentText = commentText + MessageFormat.format(resourceBundle.getString("doclet.PropertySetterWithName"), this.propertyNameFromMethodName(targetName));
                    }
                    if (targetName.startsWith("get") || targetName.startsWith("is")) {
                        commentText = commentText + MessageFormat.format(resourceBundle.getString("doclet.PropertyGetterWithName"), this.propertyNameFromMethodName(targetName));
                    }
                    if (source.commentText() != null && !source.commentText().isEmpty()) {
                        commentText = commentText + "\n @propertyDescription ";
                    }
                }
                commentText = commentText + source.commentText();
                Tag[] tags = source.tags("@defaultValue");
                if (tags != null) {
                    for (Tag tag : tags) {
                        commentText = commentText + "\n" + tag.name() + " " + tag.text();
                    }
                }
                target.setRawCommentText(commentText);
            }
        }

        private String propertyNameFromMethodName(String name) {
            String propertyName;
            if (name.startsWith("get") || name.startsWith("set")) {
                propertyName = name.substring(3);
            } else if (name.startsWith("is")) {
                propertyName = name.substring(2);
            } else {
                return "";
            }
            return propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
        }

        private MethodDoc getterForField(MethodDoc[] methods, MethodDoc propertyMethod) {
            String propertyMethodName = propertyMethod.name();
            String fieldName = propertyMethodName.substring(0, propertyMethodName.lastIndexOf("Property"));
            String fieldNameUppercased = "" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String fieldTypeName = propertyMethod.returnType().toString();
            String getterName = "boolean".equals(fieldTypeName) || fieldTypeName.endsWith("BooleanProperty") ? "is" + fieldNameUppercased : "get" + fieldNameUppercased;
            for (MethodDoc methodDoc : methods) {
                if (!getterName.equals(methodDoc.name()) || 0 != methodDoc.parameters().length || !methodDoc.isPublic() && !methodDoc.isProtected()) continue;
                return methodDoc;
            }
            return null;
        }

        private MethodDoc setterForField(MethodDoc[] methods, MethodDoc propertyMethod) {
            String propertyMethodName = propertyMethod.name();
            String fieldName = propertyMethodName.substring(0, propertyMethodName.lastIndexOf("Property"));
            String fieldNameUppercased = "" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String setter = "set" + fieldNameUppercased;
            for (MethodDoc methodDoc : methods) {
                if (!setter.equals(methodDoc.name()) || 1 != methodDoc.parameters().length || !"void".equals(methodDoc.returnType().simpleTypeName()) || !methodDoc.isPublic() && !methodDoc.isProtected()) continue;
                return methodDoc;
            }
            return null;
        }

        private FieldDoc fieldForProperty(FieldDoc[] fields, MethodDoc property) {
            for (FieldDoc field : fields) {
                String fieldName = field.name();
                String propertyName = fieldName + "Property";
                if (!propertyName.equals(property.name())) continue;
                return field;
            }
            return null;
        }

        private boolean isPropertyMethod(MethodDoc method) {
            if (!method.name().endsWith("Property")) {
                return false;
            }
            if (!this.memberIsVisible((ProgramElementDoc)method)) {
                return false;
            }
            if (this.pattern.matcher(method.name()).matches()) {
                return false;
            }
            return 0 == method.parameters().length && !"void".equals(method.returnType().simpleTypeName());
        }

        private void checkOnPropertiesTags(MethodDoc[] members) {
            block0: for (MethodDoc methodDoc : members) {
                for (Tag tag : methodDoc.tags()) {
                    String tagName = tag.name();
                    if (!tagName.equals("@propertySetter") && !tagName.equals("@propertyGetter") && !tagName.equals("@propertyDescription")) continue;
                    if (this.isPropertyGetterOrSetter(members, methodDoc)) continue block0;
                    System.out.println(methodDoc.containingClass().qualifiedName() + ": " + resourceBundle.getString("doclet.javafx_tag_misuse"));
                    continue block0;
                }
            }
        }

        private boolean isPropertyGetterOrSetter(MethodDoc[] members, MethodDoc methodDoc) {
            boolean found = false;
            String propertyName = this.propertyNameFromMethodName(methodDoc.name());
            if (!propertyName.isEmpty()) {
                String propertyMethodName = propertyName + "Property";
                for (MethodDoc member : members) {
                    if (!member.name().equals(propertyMethodName)) continue;
                    found = true;
                    break;
                }
            }
            return found;
        }
    }

    private class ClassMember {
        private Set<ProgramElementDoc> members = new HashSet<ProgramElementDoc>();

        public ClassMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public void addMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public boolean isEqual(MethodDoc member) {
            for (MethodDoc methodDoc : this.members) {
                if (!Util.executableMembersEqual((ExecutableMemberDoc)member, (ExecutableMemberDoc)methodDoc)) continue;
                this.members.add((ProgramElementDoc)member);
                return true;
            }
            return false;
        }
    }
}

