/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.IOException;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.preferences.PropertiesStorage;
import org.openide.ErrorManager;
import org.openide.util.EditableProperties;
import org.openide.util.RequestProcessor;

public abstract class NbPreferences
extends AbstractPreferences
implements ChangeListener {
    private static Preferences USER_ROOT;
    private static Preferences SYSTEM_ROOT;
    EditableProperties properties;
    FileStorage fileStorage;
    private static final RequestProcessor RP;
    final RequestProcessor.Task flushTask = RP.create(new Runnable(){

        @Override
        public void run() {
            NbPreferences.this.fileStorage.runAtomic(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = NbPreferences.this.lock;
                    synchronized (object) {
                        try {
                            NbPreferences.this.flushSpi();
                        }
                        catch (BackingStoreException backingStoreException) {
                            ErrorManager.getDefault().notify((Throwable)backingStoreException);
                        }
                    }
                }
            });
        }
    }, true);

    static Preferences userRootImpl() {
        if (USER_ROOT == null) {
            USER_ROOT = new UserPreferences();
        }
        assert (USER_ROOT != null);
        return USER_ROOT;
    }

    static Preferences systemRootImpl() {
        if (SYSTEM_ROOT == null) {
            SYSTEM_ROOT = new SystemPreferences();
        }
        assert (SYSTEM_ROOT != null);
        return SYSTEM_ROOT;
    }

    private NbPreferences(boolean bl) {
        super(null, "");
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.fileStorage.attachChangeListener(this);
    }

    private NbPreferences(NbPreferences nbPreferences, String string) {
        super(nbPreferences, string);
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.newNode = !this.fileStorage.existsNode();
        this.fileStorage.attachChangeListener(this);
    }

    @Override
    protected final String getSpi(String string) {
        return this.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.properties().getProperty(string);
        }
    }

    @Override
    protected final String[] childrenNamesSpi() throws BackingStoreException {
        return this.fileStorage.childrenNames();
    }

    @Override
    protected final String[] keysSpi() throws BackingStoreException {
        return this.getKeysSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeysSpi() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            return this.properties().keySet().toArray(new String[0]);
        }
    }

    @Override
    protected final void putSpi(String string, String string2) {
        this.putProperty(string, string2);
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putProperty(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.properties().put(string, string2);
        }
    }

    @Override
    public void put(String string, String string2) {
        String string3 = this.getSpi(string);
        if (string2.equals(string3)) {
            return;
        }
        try {
            super.put(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().contains("too long")) {
                this.putSpi(string, string2);
            }
            throw illegalArgumentException;
        }
    }

    @Override
    protected final void removeSpi(String string) {
        this.removeProperty(string);
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperty(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.properties().remove((Object)string);
        }
    }

    @Override
    protected final void removeNodeSpi() throws BackingStoreException {
        try {
            this.fileStorage.removeNode();
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    private void asyncInvocationOfFlushSpi() {
        if (!this.fileStorage.isReadOnly()) {
            this.flushTask.schedule(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.fileStorage.save(this.properties());
            }
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.properties != null) {
            try {
                this.putAllProperties(this.fileStorage.load(), true);
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
    }

    private EditableProperties properties() {
        if (this.properties == null) {
            this.properties = new EditableProperties(true);
            try {
                this.putAllProperties(this.fileStorage.load(), false);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAllProperties(EditableProperties editableProperties, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (bl) {
                this.properties().clear();
            }
            this.properties().putAll((Map)editableProperties);
        }
    }

    @Override
    public final void removeNode() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        this.clearProperties();
        super.removeNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProperties() {
        Object object = this.lock;
        synchronized (object) {
            this.properties().clear();
        }
    }

    @Override
    public final void flush() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        super.flush();
    }

    @Override
    public final void sync() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        this.flushTask.waitFinished();
        super.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.properties = null;
        }
    }

    protected abstract FileStorage getFileStorage(String var1);

    static {
        RP = new RequestProcessor();
    }

    static interface FileStorage {
        public boolean isReadOnly();

        public String[] childrenNames();

        public boolean existsNode();

        public void removeNode() throws IOException;

        public void markModified();

        public EditableProperties load() throws IOException;

        public void save(EditableProperties var1) throws IOException;

        public void runAtomic(Runnable var1);

        public void attachChangeListener(ChangeListener var1);
    }

    private static final class SystemPreferences
    extends NbPreferences {
        private SystemPreferences() {
            super(false);
        }

        private SystemPreferences(NbPreferences nbPreferences, String string) {
            super(nbPreferences, string);
        }

        @Override
        protected AbstractPreferences childSpi(String string) {
            return new SystemPreferences(this, string);
        }

        @Override
        protected FileStorage getFileStorage(String string) {
            return PropertiesStorage.instanceReadOnly(this.absolutePath());
        }
    }

    public static class UserPreferences
    extends NbPreferences {
        public UserPreferences() {
            super(true);
        }

        private UserPreferences(NbPreferences nbPreferences, String string) {
            super(nbPreferences, string);
        }

        @Override
        protected AbstractPreferences childSpi(String string) {
            return new UserPreferences(this, string);
        }

        @Override
        protected FileStorage getFileStorage(String string) {
            return PropertiesStorage.instance(this.absolutePath());
        }
    }
}

