/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;

public class NbinstURLMapper
extends URLMapper {
    public static final String PROTOCOL = "nbinst";
    private static final Logger LOG = Logger.getLogger(NbinstURLMapper.class.getName());

    public FileObject[] getFileObjects(URL uRL) {
        return PROTOCOL.equals(uRL.getProtocol()) ? NbinstURLMapper.decodeURL(uRL) : null;
    }

    public URL getURL(FileObject fileObject, int n) {
        return null;
    }

    static FileObject[] decodeURL(URL uRL) {
        assert (uRL != null);
        try {
            URI uRI = new URI(uRL.toExternalForm());
            String string = uRI.getScheme();
            if (PROTOCOL.equals(string)) {
                String string2 = uRI.getAuthority();
                String string3 = uRI.getPath();
                if (string3.length() > 0) {
                    String string4 = string3.substring(1).replaceFirst("/$", "");
                    File file = InstalledFileLocator.getDefault().locate(string4, string2, false);
                    if (file != null) {
                        try {
                            FileObject fileObject = URLMapper.findFileObject((URL)file.toURI().toURL());
                            if (fileObject != null) {
                                return new FileObject[]{fileObject};
                            }
                            LOG.log(Level.WARNING, "could find no FileObject for {0}", file);
                        }
                        catch (MalformedURLException malformedURLException) {
                            LOG.log(Level.WARNING, null, malformedURLException);
                        }
                    }
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.log(Level.WARNING, null, uRISyntaxException);
        }
        return null;
    }
}

