/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.WrapUndoEdit;

final class UndoRedoManager
extends UndoRedo.Manager {
    private static final Logger LOG = Logger.getLogger(UndoRedoManager.class.getName());
    static final UndoableEdit SAVEPOINT = new SpecialEdit();
    static final UndoableEdit BEGIN_COMMIT_GROUP = new SpecialEdit();
    static final UndoableEdit END_COMMIT_GROUP = new SpecialEdit();
    static final UndoableEdit MARK_COMMIT_GROUP = new SpecialEdit();
    CloneableEditorSupport support;
    UndoableEdit savepointEdit;
    boolean beforeSavepoint;
    private CompoundEdit saveActionsEdit;
    private boolean performingSaveActions;
    private boolean callNotifyUnmodified;
    private int buildUndoGroup;
    private CompoundEdit undoGroup;
    private int needsNestingCommit;

    public UndoRedoManager(CloneableEditorSupport cloneableEditorSupport) {
        this.support = cloneableEditorSupport;
        super.setLimit(1000);
    }

    void setPerformingSaveActions(boolean bl) {
        this.commitUndoGroup();
        if (bl != this.performingSaveActions) {
            this.performingSaveActions = bl;
            if (bl) {
                this.clearSaveActionsEdit();
                this.saveActionsEdit = new CompoundEdit();
                UndoRedoManager.checkLogOp("    NEW-saveActionsEdit", this.saveActionsEdit);
            } else {
                this.saveActionsEdit.end();
                UndoRedoManager.checkLogOp("    COMPLETED-saveActionsEdit", this.saveActionsEdit);
            }
        }
    }

    void markSavepoint() {
        this.commitUndoGroup();
        this.savepointEdit = SAVEPOINT;
    }

    boolean isAtSavepoint() {
        return this.savepointEdit == SAVEPOINT;
    }

    private void markSavepointAndUnmodified() {
        this.markSavepoint();
        this.callNotifyUnmodified = true;
    }

    private void checkCallNotifyUnmodified() {
        if (this.callNotifyUnmodified) {
            this.callNotifyUnmodified = false;
            if (this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }
    }

    void mergeSaveActionsToLastEdit(WrapUndoEdit wrapUndoEdit) {
        if (this.saveActionsEdit != null) {
            UndoRedoManager.checkLogOp("    mergeSaveActionsToLastEdit-lastWrapEdit", wrapUndoEdit);
            CompoundEdit compoundEdit = new CompoundEdit();
            compoundEdit.addEdit(wrapUndoEdit.delegate());
            compoundEdit.addEdit(this.saveActionsEdit);
            compoundEdit.end();
            wrapUndoEdit.setDelegate(compoundEdit);
            this.saveActionsEdit = null;
            UndoRedoManager.checkLogOp("    compoundEdit", compoundEdit);
        }
    }

    void beforeUndoCheck(WrapUndoEdit wrapUndoEdit) {
        if (this.isAtSavepoint()) {
            UndoRedoManager.checkLogOp("beforeUndoCheck-atSavepoint", wrapUndoEdit);
            if (this.saveActionsEdit != null) {
                UndoRedoManager.checkLogOp("    saveActionsEdit.undo()", this.saveActionsEdit);
                this.saveActionsEdit.undo();
            }
        }
    }

    void afterUndoCheck(WrapUndoEdit wrapUndoEdit) {
        if (this.isAtSavepoint()) {
            UndoRedoManager.checkLogOp("afterUndoCheck-atSavepoint", wrapUndoEdit);
            this.beforeSavepoint = true;
            this.savepointEdit = wrapUndoEdit;
        } else if (this.savepointEdit == wrapUndoEdit) {
            if (this.saveActionsEdit != null) {
                UndoRedoManager.checkLogOp("    saveActionsEdit.redo()", this.saveActionsEdit);
                this.saveActionsEdit.redo();
            }
            UndoRedoManager.checkLogOp("afterUndoCheck-becomesSavepoint-markUnmodified", wrapUndoEdit);
            assert (!this.beforeSavepoint) : "Expected to be behind savepoint";
            this.markSavepointAndUnmodified();
        }
    }

    void beforeRedoCheck(WrapUndoEdit wrapUndoEdit) {
        if (this.isAtSavepoint()) {
            UndoRedoManager.checkLogOp("beforeRedoCheck-atSavepoint", wrapUndoEdit);
            if (this.saveActionsEdit != null) {
                UndoRedoManager.checkLogOp("    saveActionsEdit.undo()", this.saveActionsEdit);
                this.saveActionsEdit.undo();
            }
        }
    }

    void afterRedoCheck(WrapUndoEdit wrapUndoEdit) {
        if (this.isAtSavepoint()) {
            UndoRedoManager.checkLogOp("afterRedoCheck-atSavepoint", wrapUndoEdit);
            this.beforeSavepoint = false;
            this.savepointEdit = wrapUndoEdit;
        } else if (this.savepointEdit == wrapUndoEdit) {
            if (this.saveActionsEdit != null) {
                UndoRedoManager.checkLogOp("    saveActionsEdit.redo()", this.saveActionsEdit);
                this.saveActionsEdit.redo();
            }
            UndoRedoManager.checkLogOp("afterRedoCheck-becomesSavepoint", wrapUndoEdit);
            assert (this.beforeSavepoint) : "Expected to be before savepoint";
            this.markSavepointAndUnmodified();
        }
    }

    void checkReplaceSavepointEdit(WrapUndoEdit wrapUndoEdit, WrapUndoEdit wrapUndoEdit2) {
        if (this.savepointEdit == wrapUndoEdit) {
            UndoRedoManager.checkLogOp("checkReplaceSavepointEdit-replacedSavepointEdit", wrapUndoEdit);
            this.savepointEdit = wrapUndoEdit2;
        }
    }

    void notifyWrapEditDie(UndoableEdit undoableEdit) {
        if (undoableEdit == this.savepointEdit) {
            UndoRedoManager.checkLogOp("notifyWrapEditDie-savepoint-die", undoableEdit);
            this.savepointEdit = null;
            this.clearSaveActionsEdit();
        }
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.isInProgress()) {
            return false;
        }
        if (undoableEdit == BEGIN_COMMIT_GROUP) {
            this.beginUndoGroup();
            return true;
        }
        if (undoableEdit == END_COMMIT_GROUP) {
            this.endUndoGroup();
            return true;
        }
        if (undoableEdit == MARK_COMMIT_GROUP) {
            this.commitUndoGroup();
            return true;
        }
        if (this.needsNestingCommit > 0) {
            this.commitUndoGroup();
        }
        if (this.buildUndoGroup > 0) {
            if (this.undoGroup == null) {
                this.undoGroup = new CompoundEdit();
            }
            return this.undoGroup.addEdit(undoableEdit);
        }
        return this.addEditImpl(undoableEdit);
    }

    private boolean addEditImpl(UndoableEdit undoableEdit) {
        assert (undoableEdit != null) : "Cannot add null edit";
        if (this.performingSaveActions) {
            UndoRedoManager.checkLogOp("addEdit-performingSaveActions", undoableEdit);
            boolean bl = this.saveActionsEdit.addEdit(undoableEdit);
            if (!bl) {
                throw new IllegalStateException("Cannot add to saveActionsEdit");
            }
            return bl;
        }
        WrapUndoEdit wrapUndoEdit = new WrapUndoEdit(this, undoableEdit);
        boolean bl = super.addEdit((UndoableEdit)wrapUndoEdit);
        if (this.isAtSavepoint()) {
            UndoRedoManager.checkLogOp("addEdit-atSavepoint", wrapUndoEdit);
            this.beforeSavepoint = false;
            this.savepointEdit = wrapUndoEdit;
            if (bl && this.edits.size() == 1) {
                this.clearSaveActionsEdit();
            }
        } else {
            UndoRedoManager.checkLogOp("addEdit", wrapUndoEdit);
        }
        return bl;
    }

    public void redo() throws CannotRedoException {
        StyledDocument styledDocument = this.support.getDocument();
        if (styledDocument == null) {
            throw new CannotRedoException();
        }
        new DocLockedRun(0, styledDocument);
        this.checkCallNotifyUnmodified();
    }

    public void undo() throws CannotUndoException {
        StyledDocument styledDocument = this.support.getDocument();
        if (styledDocument == null) {
            throw new CannotUndoException();
        }
        new DocLockedRun(1, styledDocument);
        this.checkCallNotifyUnmodified();
    }

    public boolean canRedo() {
        return (UndoRedoManager)this.new DocLockedRun((int)2, (StyledDocument)this.support.getDocument(), (int)0, (boolean)true).booleanResult;
    }

    public boolean canUndo() {
        return (UndoRedoManager)this.new DocLockedRun((int)3, (StyledDocument)this.support.getDocument(), (int)0, (boolean)true).booleanResult;
    }

    public int getLimit() {
        return (UndoRedoManager)this.new DocLockedRun((int)4, (StyledDocument)this.support.getDocument()).intResult;
    }

    public void discardAllEdits() {
        new DocLockedRun(5, this.support.getDocument());
    }

    private void clearSaveActionsEdit() {
        if (this.saveActionsEdit != null) {
            UndoRedoManager.checkLogOp("    saveActionsEdit-die", this.saveActionsEdit);
            this.saveActionsEdit.die();
            this.saveActionsEdit = null;
        }
    }

    public void setLimit(int n) {
        new DocLockedRun(6, this.support.getDocument(), n);
    }

    public boolean canUndoOrRedo() {
        return (UndoRedoManager)this.new DocLockedRun((int)7, (StyledDocument)this.support.getDocument(), (int)0, (boolean)true).booleanResult;
    }

    public String getUndoOrRedoPresentationName() {
        if (this.support.isDocumentReady()) {
            return (UndoRedoManager)this.new DocLockedRun((int)8, (StyledDocument)this.support.getDocument(), (int)0, (boolean)true).stringResult;
        }
        return "";
    }

    public String getRedoPresentationName() {
        if (this.support.isDocumentReady()) {
            return (UndoRedoManager)this.new DocLockedRun((int)9, (StyledDocument)this.support.getDocument(), (int)0, (boolean)true).stringResult;
        }
        return "";
    }

    public String getUndoPresentationName() {
        if (this.support.isDocumentReady()) {
            return (UndoRedoManager)this.new DocLockedRun((int)10, (StyledDocument)this.support.getDocument(), (int)0, (boolean)true).stringResult;
        }
        return "";
    }

    public void undoOrRedo() throws CannotUndoException, CannotRedoException {
        super.undoOrRedo();
    }

    private void beginUndoGroup() {
        if (this.undoGroup != null) {
            ++this.needsNestingCommit;
        }
        LOG.log(Level.FINE, "beginUndoGroup: nesting {0}", this.buildUndoGroup);
        ++this.buildUndoGroup;
    }

    private void endUndoGroup() {
        --this.buildUndoGroup;
        LOG.log(Level.FINE, "endUndoGroup: nesting {0}", this.buildUndoGroup);
        if (this.buildUndoGroup < 0) {
            LOG.log(Level.INFO, null, new Exception("endUndoGroup without beginUndoGroup"));
            this.buildUndoGroup = 0;
        }
        if (this.needsNestingCommit <= 0) {
            this.commitUndoGroup();
        }
        if (--this.needsNestingCommit < 0) {
            this.needsNestingCommit = 0;
        }
    }

    private void commitUndoGroup() {
        if (this.undoGroup == null) {
            return;
        }
        this.needsNestingCommit = 0;
        this.undoGroup.end();
        this.addEditImpl(this.undoGroup);
        this.undoGroup = null;
    }

    static String editToString(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof WrapUndoEdit) {
            return UndoRedoManager.toStringTerse(undoableEdit) + "->" + UndoRedoManager.toStringTerse(((WrapUndoEdit)undoableEdit).delegate());
        }
        return UndoRedoManager.toStringTerse(undoableEdit);
    }

    static String toStringTerse(Object object) {
        if (object != null) {
            String string = object.getClass().getName();
            return string.substring(string.lastIndexOf(46) + 1) + "@" + System.identityHashCode(object);
        }
        return "null";
    }

    static void checkLogOp(String string, UndoableEdit undoableEdit) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(string + ": " + UndoRedoManager.editToString(undoableEdit) + '\n');
        }
    }

    private static class SpecialEdit
    extends CompoundEdit {
        public SpecialEdit() {
            this.end();
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public boolean canUndo() {
            return true;
        }
    }

    private final class DocLockedRun
    implements Runnable {
        private final int type;
        boolean booleanResult;
        int intResult;
        String stringResult;

        public DocLockedRun(int n, StyledDocument styledDocument) {
            this(n, styledDocument, 0);
        }

        public DocLockedRun(int n, StyledDocument styledDocument, int n2) {
            this(n, styledDocument, n2, false);
        }

        public DocLockedRun(int n, StyledDocument styledDocument, int n2, boolean bl) {
            this.type = n;
            this.intResult = n2;
            if (!bl && styledDocument instanceof NbDocument.WriteLockable) {
                ((NbDocument.WriteLockable)((Object)styledDocument)).runAtomic(this);
            } else if (bl && styledDocument != null) {
                styledDocument.render(this);
            } else {
                this.run();
            }
        }

        @Override
        public void run() {
            switch (this.type) {
                case 0: {
                    if (UndoRedoManager.this.undoGroup != null) {
                        throw new CannotRedoException();
                    }
                    UndoRedoManager.super.redo();
                    break;
                }
                case 1: {
                    UndoRedoManager.this.commitUndoGroup();
                    UndoRedoManager.super.undo();
                    break;
                }
                case 2: {
                    this.booleanResult = UndoRedoManager.this.undoGroup != null ? false : UndoRedoManager.super.canRedo();
                    break;
                }
                case 3: {
                    this.booleanResult = UndoRedoManager.this.undoGroup != null ? true : UndoRedoManager.super.canUndo();
                    break;
                }
                case 4: {
                    this.intResult = UndoRedoManager.super.getLimit();
                    break;
                }
                case 5: {
                    if (LOG.isLoggable(Level.FINE)) {
                        int n = UndoRedoManager.this.edits != null ? UndoRedoManager.this.edits.size() : 0;
                        LOG.fine("discardAllEdits(): savepoint=" + UndoRedoManager.this.isAtSavepoint() + ", editsSize=" + n + "\n");
                    }
                    UndoRedoManager.this.commitUndoGroup();
                    UndoRedoManager.this.clearSaveActionsEdit();
                    UndoRedoManager.super.discardAllEdits();
                    break;
                }
                case 6: {
                    UndoRedoManager.super.setLimit(this.intResult);
                    break;
                }
                case 7: {
                    UndoRedoManager.super.canUndoOrRedo();
                    break;
                }
                case 8: {
                    this.stringResult = UndoRedoManager.super.getUndoOrRedoPresentationName();
                    break;
                }
                case 9: {
                    this.stringResult = UndoRedoManager.this.undoGroup != null ? UndoRedoManager.this.undoGroup.getRedoPresentationName() : UndoRedoManager.super.getRedoPresentationName();
                    break;
                }
                case 10: {
                    this.stringResult = UndoRedoManager.this.undoGroup != null ? UndoRedoManager.this.undoGroup.getUndoPresentationName() : UndoRedoManager.super.getUndoPresentationName();
                    break;
                }
                case 11: {
                    UndoRedoManager.super.undoOrRedo();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + this.type);
                }
            }
        }
    }
}

