/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jrockit.jfr.client;

import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.client.FlightRecorderClient;
import com.oracle.jrockit.jfr.management.FlightRecordingMBean;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

@Deprecated
public class FlightRecordingClient
implements FlightRecordingMBean {
    protected final FlightRecorderClient client;
    protected final FlightRecordingMBean mbean;
    protected final ObjectName objectName;

    FlightRecordingClient(FlightRecorderClient flightRecorderClient, FlightRecordingMBean flightRecordingMBean, ObjectName objectName) {
        this.client = flightRecorderClient;
        this.objectName = objectName;
        this.mbean = flightRecordingMBean;
    }

    protected FlightRecordingClient(FlightRecordingClient flightRecordingClient) {
        this(flightRecordingClient.client, flightRecordingClient.mbean, flightRecordingClient.objectName);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public boolean isDestinationCompressed() {
        return this.mbean.isDestinationCompressed();
    }

    @Override
    public void setDestinationCompressed(boolean bl) {
        this.mbean.setDestinationCompressed(bl);
    }

    @Override
    public void copyTo(String string, boolean bl) throws IllegalStateException, IOException {
        this.mbean.copyTo(string, bl);
    }

    @Override
    public void close() {
        this.mbean.close();
    }

    @Override
    public void closeStream(long l) throws IOException, IllegalArgumentException {
        this.mbean.closeStream(l);
    }

    @Override
    public String getDestination() {
        return this.mbean.getDestination();
    }

    @Override
    public long getDuration() {
        return this.mbean.getDuration();
    }

    @Override
    public void addEventDefaults(List<CompositeData> list) throws OpenDataException {
        this.mbean.addEventDefaults(list);
    }

    @Override
    public List<CompositeData> getEventDefaults() throws OpenDataException {
        return this.mbean.getEventDefaults();
    }

    @Override
    public void setEventDefaults(List<CompositeData> list) throws OpenDataException {
        this.mbean.setEventDefaults(list);
    }

    @Override
    public List<CompositeData> getEventSettings() throws OpenDataException {
        return this.mbean.getEventSettings();
    }

    @Override
    public long getId() {
        return this.mbean.getId();
    }

    @Override
    public long getMaxAge() {
        return this.mbean.getMaxAge();
    }

    @Override
    public long getMaxSize() {
        return this.mbean.getMaxSize();
    }

    @Override
    public String getName() {
        return this.mbean.getName();
    }

    @Override
    public long getDataSize() {
        return this.mbean.getDataSize();
    }

    @Override
    public CompositeData getOptions() throws OpenDataException {
        return this.mbean.getOptions();
    }

    @Override
    public long getPeriod(int n) throws NoSuchEventException {
        return this.mbean.getPeriod(n);
    }

    @Override
    public Date getStartTime() {
        return this.mbean.getStartTime();
    }

    @Override
    public long getThreshold(int n) throws NoSuchEventException {
        return this.mbean.getThreshold(n);
    }

    @Override
    public boolean isEventEnabled(int n) throws NoSuchEventException {
        return this.mbean.isEventEnabled(n);
    }

    @Override
    public boolean isRunning() {
        return this.mbean.isRunning();
    }

    @Override
    public boolean isStackTraceEnabled(int n) throws NoSuchEventException {
        return this.mbean.isStackTraceEnabled(n);
    }

    @Override
    public boolean isStarted() {
        return this.mbean.isStarted();
    }

    @Override
    public boolean isStopped() {
        return this.mbean.isStopped();
    }

    @Override
    public long openStream() throws IOException {
        return this.mbean.openStream();
    }

    @Override
    public long openStream(Date date, Date date2) throws IOException {
        return this.mbean.openStream(date, date2);
    }

    @Override
    public ObjectName cloneRecording(String string, boolean bl) throws IOException {
        return this.mbean.cloneRecording(string, bl);
    }

    public FlightRecordingClient cloneRecordingObject(String string, boolean bl) throws IOException {
        try {
            return this.client.cloneRecordingObject(this.objectName, string, bl);
        }
        catch (NoSuchRecordingException noSuchRecordingException) {
            throw new InternalError();
        }
    }

    @Override
    public void copyTo(String string) throws IllegalStateException, IOException {
        this.mbean.copyTo(string);
    }

    @Override
    public byte[] readStream(long l) throws IOException, IllegalArgumentException {
        return this.mbean.readStream(l);
    }

    @Override
    public void setDestination(String string) throws IOException {
        this.mbean.setDestination(string);
    }

    @Override
    public void setDuration(long l) {
        this.mbean.setDuration(l);
    }

    @Override
    public void setEventEnabled(int n, boolean bl) throws NoSuchEventException {
        this.mbean.setEventEnabled(n, bl);
    }

    @Override
    public void setEventSettings(List<CompositeData> list) throws OpenDataException {
        this.mbean.setEventSettings(list);
    }

    @Override
    public void setMaxAge(long l) {
        this.mbean.setMaxAge(l);
    }

    @Override
    public void setMaxSize(long l) {
        this.mbean.setMaxSize(l);
    }

    @Override
    public void setOptions(CompositeData compositeData) throws OpenDataException {
        this.mbean.setOptions(compositeData);
    }

    @Override
    public void setPeriod(int n, long l) throws NoSuchEventException {
        this.mbean.setPeriod(n, l);
    }

    @Override
    public void setStackTraceEnabled(int n, boolean bl) throws NoSuchEventException {
        this.mbean.setStackTraceEnabled(n, bl);
    }

    @Override
    public void setStartTime(Date date) {
        this.mbean.setStartTime(date);
    }

    @Override
    public void setThreshold(int n, long l) throws NoSuchEventException {
        this.mbean.setThreshold(n, l);
    }

    @Override
    public void start() {
        this.mbean.start();
    }

    @Override
    public void stop() throws IOException {
        this.mbean.stop();
    }

    public InputStream openStreamObject() throws IOException {
        final long l = this.openStream();
        return new InputStream(){
            private byte[] bytes;
            private int pos;
            private int count;

            @Override
            public void close() throws IOException {
                super.close();
                FlightRecordingClient.this.closeStream(l);
            }

            private boolean fill() throws IOException {
                if (this.pos >= this.count) {
                    this.bytes = FlightRecordingClient.this.readStream(l);
                    if (this.bytes == null) {
                        return false;
                    }
                    this.pos = 0;
                    this.count = this.bytes.length;
                }
                return true;
            }

            @Override
            public int read() throws IOException {
                if (!this.fill()) {
                    return -1;
                }
                return this.bytes[this.pos++] & 0xFF;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (byArray == null) {
                    throw new NullPointerException();
                }
                if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return 0;
                }
                if (!this.fill()) {
                    return -1;
                }
                int n3 = Math.min(this.count - this.pos, n2);
                System.arraycopy(this.bytes, this.pos, byArray, n, n3);
                this.pos += n3;
                return n3;
            }
        };
    }

    public InputStream openUncompressedStreamObject() throws IOException {
        return new GZIPInputStream(this.openStreamObject());
    }

    public String toString() {
        long l;
        long l2;
        long l3;
        Date date;
        Date date2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.objectName);
        String string = this.getDestination();
        if (string != null) {
            stringBuilder.append(", destination=").append(string);
        }
        if ((date2 = this.getStartTime()) != null) {
            stringBuilder.append(", start=").append(date2);
        }
        if ((date = this.getDataStartTime()) != null) {
            stringBuilder.append(", dataStartTime=").append(date);
        }
        if ((date = this.getDataEndTime()) != null) {
            stringBuilder.append(", dataEndTime=").append(date);
        }
        if ((l3 = this.getDuration()) != 0L) {
            stringBuilder.append(", duration=").append(l3);
        }
        if ((l2 = this.getMaxAge()) != 0L) {
            stringBuilder.append(", maxAge=").append(l2);
        }
        if ((l = this.getMaxSize()) != 0L) {
            stringBuilder.append(", maxSize=").append(l);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isToDisk() {
        return this.mbean.isToDisk();
    }

    @Override
    public void setToDisk(boolean bl) {
        this.mbean.setToDisk(bl);
    }

    @Override
    public Date getDataEndTime() {
        return this.mbean.getDataEndTime();
    }

    @Override
    public Date getDataStartTime() {
        return this.mbean.getDataStartTime();
    }
}

