/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class ActionsTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private boolean firstTimeExpand = true;
    private Cursor dragMoveCursor = DragSource.DefaultMoveDrop;
    private Cursor dragNoDropCursor = DragSource.DefaultMoveNoDrop;

    public ActionsTree(Node node) {
        super((TreeModel)new NodeTreeModel(node));
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.setShowsRootHandles(true);
        this.expandAll();
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 2, this);
    }

    private void expandAll() {
        int n;
        int n2 = 0;
        do {
            n = this.getRowCount();
            this.expandRow(n2);
        } while (n != this.getRowCount() || ++n2 < this.getRowCount());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath treePath = this.getPathForLocation(dragGestureEvent.getDragOrigin().x, dragGestureEvent.getDragOrigin().y);
        if (null != treePath) {
            Object object = treePath.getLastPathComponent();
            if (this.getModel().isLeaf(object)) {
                try {
                    Node node = Visualizer.findNode((Object)object);
                    Transferable transferable = node.drag();
                    dragGestureEvent.getDragSource().addDragSourceListener(this);
                    dragGestureEvent.startDrag(this.dragNoDropCursor, transferable);
                }
                catch (IOException iOException) {
                    Logger.getLogger(ActionsTree.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
        }
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(this.dragNoDropCursor);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 2) != 0) {
            dragSourceContext.setCursor(this.dragMoveCursor);
        } else {
            dragSourceContext.setCursor(this.dragNoDropCursor);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.dragOver(dragSourceDragEvent);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }
}

